import mutations from './mutations';
import { 
  signInWithEmailAndPassword, 
  signInWithPopup, 
  GoogleAuthProvider, 
  FacebookAuthProvider,
  signOut, 
  createUserWithEmailAndPassword,
  onAuthStateChanged
} from 'firebase/auth';
import { notification } from 'ant-design-vue';
import { db, auth } from '@/config/database/firebase';

const loginNotificationError = err => {
  notification.error({
    message: err,
  });
};

const state = () => ({
  data: null,
  loading: false,
  isLogout: false,
  isLogin: false,
  error: false,
  isSignUpError: false,
  isSignUpLoading: false,
  uid: false,
});

const actions = {
  async firebaseAuthLogin({ commit }, { data }) {
    try {
      await commit('firebaseLoginBegin');
      await signInWithEmailAndPassword(auth, data.username, data.password);
      onAuthStateChanged(auth, user => {
        user = user ? user : {};
        commit('firebaseLoginSuccess', user.uid ? user.uid : false);
      });
    } catch (err) {
      loginNotificationError(err.message);
      await commit('firebaseLoginErr', err);
    }
  },

  async firebaseAuthLoginWithGoogle({ commit }) {
    const provider = new GoogleAuthProvider();
    try {
      await commit('firebaseLoginBegin');
      const result = await signInWithPopup(auth, provider);
      console.log(result);
      await commit('firebaseLoginSuccess', result);
    } catch (err) {
      await commit('firebaseLoginErr', err);
    }
  },

  async firebaseAuthLoginWithFacebook({ commit }) {
    const provider = new FacebookAuthProvider();
    try {
      await commit('firebaseLoginBegin');
      const result = await signInWithPopup(auth, provider);
      await commit('firebaseLoginSuccess', result);
    } catch (err) {
      await commit('firebaseLoginErr', err);
    }
  },

  async firebaseAuthGetUid({ commit }) {
    try {
      await commit('firebaseLoginBegin');
      onAuthStateChanged(auth, async user => {
        user = user ? user : {};
        await commit('firebaseLoginSuccess', user.uid ? user.uid : false);
      });
    } catch (err) {
      await commit('firebaseLoginErr', err);
    }
  },

  async firebaseAuthLogout({ commit }, logOutRoot) {
    try {
      await commit('firebaseLogOutBegin');
      await signOut(auth);
      await commit('firebaseLogOutSuccess', false);
      await logOutRoot();
    } catch (err) {
      await commit('firebaseLogOutErr', err);
    }
  },

  async firebaseAuthSignUp({ commit }, newUser) {
    try {
      await commit('firebaseSignUpBegin');
      const resp = await createUserWithEmailAndPassword(auth, newUser.email, newUser.password);
      await db
        .collection('users')
        .doc(resp.user.uid)
        .set({
          ...newUser,
        });
      await commit('firebaseSignUpSuccess', resp.user.uid);
    } catch (err) {
      loginNotificationError(err.message);
      await commit('firebaseSignUpErr', err);
    }
  },
};

export default {
  namespaced: false,
  state,
  actions,
  mutations,
};
