import { ag as ensure_array_like, ad as attr_class, ae as stringify, aa as escape_html, a2 as head, af as spread_props } from "../../../../../chunks/index2.js";
import "clsx";
import { a as Col, C as Container, R as Row } from "../../../../../chunks/Row.js";
import "../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbOne } from "../../../../../chunks/BreadcrumbOne.js";
import { B as Button } from "../../../../../chunks/Button.js";
import { C as Card } from "../../../../../chunks/Card.js";
import { C as CardBody } from "../../../../../chunks/CardBody.js";
const pricingData = [
  {
    priceTag: "Free Forever",
    priceTagBg: "dark",
    priceValue: "Free",
    pricePrefix: "",
    priceSuffix: "",
    priceTagline: "For Individuals",
    featureList: [
      {
        icon: "check",
        content: "100MB File size"
      },
      {
        icon: "check",
        content: "2 Active Projects"
      },
      {
        icon: "check",
        content: "Limited Boards"
      },
      {
        icon: "check",
        content: "Basic Project Management"
      }
    ],
    priceBtnType: "light",
    priceBtnContent: "Current Plan",
    btnOutlined: true
  },
  {
    priceTag: "Basic Plan",
    priceTagBg: "primary",
    priceValue: "19",
    pricePrefix: "$",
    priceSuffix: "Per Month",
    priceTagline: "For 2 Users",
    featureList: [
      {
        icon: "check",
        content: "100GB File size"
      },
      {
        icon: "check",
        content: "300 Active Projects"
      },
      {
        icon: "check",
        content: "Limited Boards"
      },
      {
        icon: "check",
        content: "Basic Project Management"
      },
      {
        icon: "check",
        content: "Custom Post Types"
      }
    ],
    priceBtnType: "primary",
    priceBtnContent: "Get Started",
    btnOutlined: false
  },
  {
    priceTag: "Business",
    priceTagBg: "secondary",
    priceValue: "39",
    pricePrefix: "$",
    priceSuffix: "Per Month",
    priceTagline: "For 10 Users",
    featureList: [
      {
        icon: "check",
        content: "500GB File size"
      },
      {
        icon: "check",
        content: "500 Active Projects"
      },
      {
        icon: "check",
        content: "Limited Boards"
      },
      {
        icon: "check",
        content: "Basic Project Management"
      },
      {
        icon: "check",
        content: "Custom Post Types"
      },
      {
        icon: "check",
        content: "Subtasks"
      }
    ],
    priceBtnType: "secondary",
    priceBtnContent: "Get Started",
    btnOutlined: false
  },
  {
    priceTag: "Enterprise",
    priceTagBg: "success",
    priceValue: "79",
    pricePrefix: "$",
    priceSuffix: "Per Month",
    priceTagline: "For 50 Users",
    featureList: [
      {
        icon: "check",
        content: "750GB File size"
      },
      {
        icon: "check",
        content: "800 Active Projects"
      },
      {
        icon: "check",
        content: "Unlimited Boards"
      },
      {
        icon: "check",
        content: "Basic Project Management"
      },
      {
        icon: "check",
        content: "Custom Post Types"
      },
      {
        icon: "check",
        content: "Subtasks"
      }
    ],
    priceBtnType: "success",
    priceBtnContent: "Get Started",
    btnOutlined: false
  }
];
function Pricing($$renderer) {
  $$renderer.push(`<!--[-->`);
  const each_array = ensure_array_like(pricingData);
  for (let $$index_1 = 0, $$length = each_array.length; $$index_1 < $$length; $$index_1++) {
    let data = each_array[$$index_1];
    Col($$renderer, {
      xxl: 3,
      sm: 6,
      class: "mb-30",
      children: ($$renderer2) => {
        Card($$renderer2, {
          class: "h-100",
          children: ($$renderer3) => {
            CardBody($$renderer3, {
              class: "p-30",
              children: ($$renderer4) => {
                $$renderer4.push(`<div class="pricing d-flex align-items-center"><span${attr_class(` pricing__tag color-${stringify(data.priceTagBg)} order-bg-opacity-${stringify(data.priceTagBg)} rounded-pill `, "svelte-n9ix9s")}>${escape_html(data.priceTag)}</span></div> <div class="pricing__price rounded svelte-n9ix9s"><p class="pricing_value color-dark d-flex align-items-center text-capitalize fw-600 mb-1 svelte-n9ix9s"><sup class="svelte-n9ix9s">${escape_html(data.pricePrefix)}</sup> ${escape_html(data.priceValue)} <small class="pricing_user svelte-n9ix9s">${escape_html(data.priceSuffix)}</small></p> <p class="pricing_subtitle mb-0 svelte-n9ix9s">${escape_html(data.priceTagline)}</p></div> <div class="pricing__features svelte-n9ix9s"><ul class="svelte-n9ix9s"><!--[-->`);
                const each_array_1 = ensure_array_like(data.featureList);
                for (let $$index = 0, $$length2 = each_array_1.length; $$index < $$length2; $$index++) {
                  let item = each_array_1[$$index];
                  $$renderer4.push(`<li class="svelte-n9ix9s"><span${attr_class(`uil uil-${stringify(item.icon)}`, "svelte-n9ix9s")}></span>${escape_html(item.content)}</li>`);
                }
                $$renderer4.push(`<!--]--></ul></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!----> <div class="price_action d-flex pb-30 ps-30">`);
            Button($$renderer3, {
              color: data.priceBtnType,
              outline: data.btnOutlined,
              class: `btn-squared text-capitalize px-30 ${stringify(data.btnOutlined ? "color-light" : "")} fw-500`,
              children: ($$renderer4) => {
                $$renderer4.push(`<!---->${escape_html(data.priceBtnContent)}`);
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!----></div>`);
          },
          $$slots: { default: true }
        });
      },
      $$slots: { default: true }
    });
  }
  $$renderer.push(`<!--]-->`);
}
function _page($$renderer) {
  const breadcrumbData = {
    pageTitle: "Pricing Tables",
    bcItem: "Pages",
    bcItemActive: "Pricing"
  };
  head("mvo8qo", $$renderer, ($$renderer2) => {
    $$renderer2.title(($$renderer3) => {
      $$renderer3.push(`<title>Pricing</title>`);
    });
  });
  $$renderer.push(`<div class="component-page mb-25">`);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              BreadcrumbOne($$renderer4, spread_props([breadcrumbData]));
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Pricing($$renderer3);
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
export {
  _page as default
};
