import { ag as ensure_array_like, ad as attr_class, ac as attr, aa as escape_html, ae as stringify, a2 as head, af as spread_props } from "../../../../../chunks/index2.js";
import "clsx";
import { C as Container, R as Row, a as Col } from "../../../../../chunks/Row.js";
import "../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbOne } from "../../../../../chunks/BreadcrumbOne.js";
function Gallery($$renderer) {
  const galleryData = [
    {
      img: "1.png",
      title: "Snow Covered Mountain",
      category: "Web Design",
      keyword: "webDesign"
    },
    {
      img: "2.png",
      title: "Raven demons over the",
      category: "UI Design",
      keyword: "uiDesign"
    },
    {
      img: "3.png",
      title: "Sit et dolores stet",
      category: "Wireframe",
      keyword: "wireframe"
    },
    {
      img: "4.png",
      title: "Et sed gubergren aliquyam",
      category: "Presentation",
      keyword: "presentation"
    },
    {
      img: "5.png",
      title: "Lorem et ipsum invidunt",
      category: "Web Design",
      keyword: "webDesign"
    },
    {
      img: "6.png",
      title: "Vero dolores rebum aliquyam",
      category: "Presentation",
      keyword: "presentation"
    },
    {
      img: "7.png",
      title: "Rebum sadipscing eos lore",
      category: "Wireframe",
      keyword: "wireframe"
    },
    {
      img: "8.png",
      title: "Et sadipscing lorem set",
      category: "Web Design",
      keyword: "webDesign"
    },
    {
      img: "9.png",
      title: "Det stet eirmod eirmod",
      category: "UI Design",
      keyword: "uiDesign"
    },
    {
      img: "10.png",
      title: "Dolor eos lorem sea justo",
      category: "Presentation",
      keyword: "presentation"
    },
    {
      img: "11.png",
      title: "Accusam et stet clita est",
      category: "Wireframe",
      keyword: "wireframe"
    },
    {
      img: "2.png",
      title: "Invidunt rebum tempor dolor",
      category: "Presentation",
      keyword: "presentation"
    }
  ];
  const categories = [
    { category: "All", keyword: "all" },
    { category: "Web Design", keyword: "webDesign" },
    { category: "UI Design", keyword: "uiDesign" },
    { category: "Wireframe", keyword: "wireframe" },
    { category: "Presentation", keyword: "presentation" }
  ];
  let selected = "all";
  $$renderer.push(`<div class="gallery-filter mb-sm-50 mb-30 svelte-1pj37d4"><ul class="gallery-filter__nav w-100 px-sm-25 px-15 bg-white d-flex flex-wrap radius-xl svelte-1pj37d4"><!--[-->`);
  const each_array = ensure_array_like(categories);
  for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
    let item = each_array[$$index];
    $$renderer.push(`<li${attr_class("filter-controls nav-link active svelte-1pj37d4", void 0, { "active": selected === item.keyword })}${attr("data-name", item.keyword)}>${escape_html(item.category)}</li>`);
  }
  $$renderer.push(`<!--]--></ul> <div class="gallery-filter__wrap"><div class="gallery-filter__container svelte-1pj37d4"><!--[-->`);
  const each_array_1 = ensure_array_like(galleryData);
  for (let $$index_1 = 0, $$length = each_array_1.length; $$index_1 < $$length; $$index_1++) {
    let item = each_array_1[$$index_1];
    {
      $$renderer.push("<!--[-->");
      $$renderer.push(`<div class="show filter-item filter-item--style svelte-1pj37d4"><div class="card"><div class="gc"><div class="gc__img"><img${attr("src", `/img/gallery/${stringify(item.img)}`)} alt="img" class="w-100 radius-xl"/></div> <div class="card-body px-25 py-20"><div class="gc__title svelte-1pj37d4"><p class="svelte-1pj37d4">${escape_html(item.title)}</p> <span class="svelte-1pj37d4">${escape_html(item.category)}</span></div></div></div></div></div>`);
    }
    $$renderer.push(`<!--]-->`);
  }
  $$renderer.push(`<!--]--></div></div></div>`);
}
function _page($$renderer) {
  const breadcrumbData = {
    pageTitle: "Gallery",
    bcItem: "Pages",
    bcItemActive: "Gallery"
  };
  head("167rt4w", $$renderer, ($$renderer2) => {
    $$renderer2.title(($$renderer3) => {
      $$renderer3.push(`<title>Gallery</title>`);
    });
  });
  $$renderer.push(`<div class="component-page mb-25">`);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              BreadcrumbOne($$renderer4, spread_props([breadcrumbData]));
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              Gallery($$renderer4);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
export {
  _page as default
};
