import { a2 as head, af as spread_props, ag as ensure_array_like, aa as escape_html, ae as stringify } from "../../../../../chunks/index2.js";
import { A as Accordion, a as AccordionItem } from "../../../../../chunks/AccordionItem.js";
import "clsx";
import { C as Card } from "../../../../../chunks/Card.js";
import { C as CardBody } from "../../../../../chunks/CardBody.js";
import { C as CardHeader } from "../../../../../chunks/CardHeader.js";
import { C as Container, R as Row, a as Col } from "../../../../../chunks/Row.js";
import "../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbOne } from "../../../../../chunks/BreadcrumbOne.js";
const changelogData = [
  {
    id: 4,
    date: "September 30, 2025",
    version: "2.0.0",
    "new": [
      "Upgraded to Svelte 5.39.6 (Major version)",
      "Upgraded to Vite 7.1.7 (Major version)",
      "Replaced xlsx with exceljs for better security",
      "Added improved Excel import/export functionality"
    ],
    fixed: [
      "Fixed all critical and high security vulnerabilities (reduced from 15 to 4)",
      "Fixed nested anchor tag issues for Svelte 5 compatibility",
      "Fixed table structure with proper tbody tags",
      "Fixed event handler syntax (ondragover to on:dragover)",
      "Fixed DraggableList hover state type",
      "Resolved all breaking changes from major updates"
    ],
    updated: [
      "Updated @sveltejs/adapter-auto from 3.2.1 to 6.1.0",
      "Updated @sveltejs/kit from 2.5.10 to 2.43.5",
      "Updated @sveltejs/vite-plugin-svelte from 3.1.1 to 6.2.1",
      "Updated svelte-preprocess from 5.1.4 to 6.0.3",
      "Updated @sveltestrap/sveltestrap from 6.2.7 to 7.1.0",
      "Updated apexcharts from 3.49.1 to 5.3.5",
      "Updated axios from 1.7.2 to 1.12.2 (security fix)",
      "Updated eslint from 9.3.0 to 9.36.0",
      "Updated eslint-config-prettier from 9.1.0 to 10.1.8",
      "Updated prettier from 3.2.5 to 3.6.2",
      "Updated prettier-plugin-svelte from 3.2.3 to 3.4.0",
      "Updated sass from 1.77.2 to 1.93.2",
      "Updated swiper from 11.1.3 to 12.0.2",
      "Updated svelte-range-slider-pips from 2.3.1 to 4.0.7",
      "Updated all FontAwesome packages to 7.0.1",
      "Updated all FullCalendar packages to 6.1.19",
      "Updated bootstrap from 5.3.3 to 5.3.8",
      "Updated chart.js from 4.4.3 to 4.5.0",
      "Updated yup from 1.4.0 to 1.7.1",
      "Updated Chart.js configuration with border display false and grid lineWidth 0.5",
      "All packages updated to their latest stable versions"
    ]
  },
  {
    id: 3,
    date: "April 11, 2023",
    version: "1.1.1",
    "new": [
      "Added 2 New App Page"
    ],
    fixed: [
      "Minor Style issues"
    ],
    updated: [
      "Svg Issue Fixed"
    ]
  },
  {
    id: 2,
    date: "Jan 08, 2023",
    version: "1.1.0",
    "new": [
      "Added 5 New Home Page"
    ],
    fixed: [
      "Minor Style issues"
    ],
    updated: false
  },
  {
    id: 1,
    date: "Dec 19, 2022",
    version: "1.0.0",
    "new": [
      "Initial Release"
    ],
    fixed: false,
    updated: false
  }
];
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const latestChanges = changelogData.slice(0, 1);
    const allChanges = changelogData.slice(1);
    const breadcrumbData = {
      pageTitle: "Changelog",
      bcItem: "Pages",
      bcItemActive: "Changelog"
    };
    head("11it854", $$renderer2, ($$renderer3) => {
      $$renderer3.title(($$renderer4) => {
        $$renderer4.push(`<title>Changelog</title>`);
      });
    });
    $$renderer2.push(`<div class="component-page mb-25">`);
    Container($$renderer2, {
      fluid: true,
      children: ($$renderer3) => {
        Row($$renderer3, {
          children: ($$renderer4) => {
            Col($$renderer4, {
              lg: 12,
              children: ($$renderer5) => {
                BreadcrumbOne($$renderer5, spread_props([breadcrumbData]));
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              lg: 9,
              class: "changelog-19 d-block",
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="changelog mb-30">`);
                Card($$renderer5, {
                  children: ($$renderer6) => {
                    CardHeader($$renderer6, {
                      children: ($$renderer7) => {
                        $$renderer7.push(`<!--[-->`);
                        const each_array = ensure_array_like(latestChanges);
                        for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
                          let item = each_array[$$index];
                          $$renderer7.push(`<div class="changelog__title"><span class="v-num">Version ${escape_html(item.version)}</span> <span class="sign">-</span> <span class="rl-date">${escape_html(item.date)}</span></div>`);
                        }
                        $$renderer7.push(`<!--]-->`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    CardBody($$renderer6, {
                      class: "p-30",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<!--[-->`);
                        const each_array_1 = ensure_array_like(latestChanges);
                        for (let $$index_4 = 0, $$length = each_array_1.length; $$index_4 < $$length; $$index_4++) {
                          let item = each_array_1[$$index_4];
                          $$renderer7.push(`<div class="version-list mb-30">`);
                          if (item.new) {
                            $$renderer7.push("<!--[-->");
                            $$renderer7.push(`<div class="version-list__single"><div class="version-list__top"><span class="badge badge-round badge-success badge-lg">New</span></div> <ul class="version-success"><!--[-->`);
                            const each_array_2 = ensure_array_like(item.new);
                            for (let $$index_1 = 0, $$length2 = each_array_2.length; $$index_1 < $$length2; $$index_1++) {
                              let newItems = each_array_2[$$index_1];
                              $$renderer7.push(`<li>${escape_html(newItems)}</li>`);
                            }
                            $$renderer7.push(`<!--]--></ul></div>`);
                          } else {
                            $$renderer7.push("<!--[!-->");
                          }
                          $$renderer7.push(`<!--]--> `);
                          if (item.fixed) {
                            $$renderer7.push("<!--[-->");
                            $$renderer7.push(`<div class="version-list__single"><div class="version-list__top"><span class="badge badge-round badge-info badge-lg">Fixed</span></div> <ul class="version-info"><!--[-->`);
                            const each_array_3 = ensure_array_like(item.fixed);
                            for (let $$index_2 = 0, $$length2 = each_array_3.length; $$index_2 < $$length2; $$index_2++) {
                              let fixedItems = each_array_3[$$index_2];
                              $$renderer7.push(`<li>${escape_html(fixedItems)}</li>`);
                            }
                            $$renderer7.push(`<!--]--></ul></div>`);
                          } else {
                            $$renderer7.push("<!--[!-->");
                          }
                          $$renderer7.push(`<!--]--> `);
                          if (item.updated) {
                            $$renderer7.push("<!--[-->");
                            $$renderer7.push(`<div class="version-list__single"><div class="version-list__top"><span class="badge badge-round badge-primary badge-lg">Updated</span></div> <ul class="version-success"><!--[-->`);
                            const each_array_4 = ensure_array_like(item.updated);
                            for (let $$index_3 = 0, $$length2 = each_array_4.length; $$index_3 < $$length2; $$index_3++) {
                              let updatedItems = each_array_4[$$index_3];
                              $$renderer7.push(`<li>${escape_html(updatedItems)}</li>`);
                            }
                            $$renderer7.push(`<!--]--></ul></div>`);
                          } else {
                            $$renderer7.push("<!--[!-->");
                          }
                          $$renderer7.push(`<!--]--></div>`);
                        }
                        $$renderer7.push(`<!--]--> `);
                        Accordion($$renderer7, {
                          children: ($$renderer8) => {
                            $$renderer8.push(`<!--[-->`);
                            const each_array_5 = ensure_array_like(allChanges);
                            for (let $$index_8 = 0, $$length = each_array_5.length; $$index_8 < $$length; $$index_8++) {
                              let data = each_array_5[$$index_8];
                              AccordionItem($$renderer8, {
                                header: `${stringify(data.version)} - ${stringify(data.date)}`,
                                children: ($$renderer9) => {
                                  $$renderer9.push(`<div class="version-list">`);
                                  if (data.new) {
                                    $$renderer9.push("<!--[-->");
                                    $$renderer9.push(`<div class="version-list__single"><div class="version-list__top"><span class="badge badge-round badge-success badge-lg">New</span></div> <ul class="version-success"><!--[-->`);
                                    const each_array_6 = ensure_array_like(data.new);
                                    for (let $$index_5 = 0, $$length2 = each_array_6.length; $$index_5 < $$length2; $$index_5++) {
                                      let newItems = each_array_6[$$index_5];
                                      $$renderer9.push(`<li>${escape_html(newItems)}</li>`);
                                    }
                                    $$renderer9.push(`<!--]--></ul></div>`);
                                  } else {
                                    $$renderer9.push("<!--[!-->");
                                  }
                                  $$renderer9.push(`<!--]--> `);
                                  if (data.fixed) {
                                    $$renderer9.push("<!--[-->");
                                    $$renderer9.push(`<div class="version-list__single"><div class="version-list__top"><span class="badge badge-round badge-info badge-lg">Fixed</span></div> <ul class="version-success"><!--[-->`);
                                    const each_array_7 = ensure_array_like(data.fixed);
                                    for (let $$index_6 = 0, $$length2 = each_array_7.length; $$index_6 < $$length2; $$index_6++) {
                                      let fixedItems = each_array_7[$$index_6];
                                      $$renderer9.push(`<li>${escape_html(fixedItems)}</li>`);
                                    }
                                    $$renderer9.push(`<!--]--></ul></div>`);
                                  } else {
                                    $$renderer9.push("<!--[!-->");
                                  }
                                  $$renderer9.push(`<!--]--> `);
                                  if (data.updated) {
                                    $$renderer9.push("<!--[-->");
                                    $$renderer9.push(`<div class="version-list__single"><div class="version-list__top"><span class="badge badge-round badge-primary badge-lg">Updated</span></div> <ul class="version-success"><!--[-->`);
                                    const each_array_8 = ensure_array_like(data.updated);
                                    for (let $$index_7 = 0, $$length2 = each_array_8.length; $$index_7 < $$length2; $$index_7++) {
                                      let updatedItems = each_array_8[$$index_7];
                                      $$renderer9.push(`<li>${escape_html(updatedItems)}</li>`);
                                    }
                                    $$renderer9.push(`<!--]--></ul></div>`);
                                  } else {
                                    $$renderer9.push("<!--[!-->");
                                  }
                                  $$renderer9.push(`<!--]--></div>`);
                                },
                                $$slots: { default: true }
                              });
                            }
                            $$renderer8.push(`<!--]-->`);
                          },
                          $$slots: { default: true }
                        });
                        $$renderer7.push(`<!---->`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!---->`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              lg: 3,
              class: "changelog-5 d-block",
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="changeLog-history mb-30">`);
                Card($$renderer5, {
                  children: ($$renderer6) => {
                    CardHeader($$renderer6, {
                      class: "py-20 px-20",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<div class="changelog-history__title text-uppercase">CHANGELOG</div> <div class="changelog-history__titleExtra"></div>`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    CardBody($$renderer6, {
                      class: "p-25",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<h4 class="history-title">VERSION HISTORY</h4> <ul class="v-history-list"><!--[-->`);
                        const each_array_9 = ensure_array_like(changelogData);
                        for (let $$index_9 = 0, $$length = each_array_9.length; $$index_9 < $$length; $$index_9++) {
                          let data = each_array_9[$$index_9];
                          $$renderer7.push(`<li><span class="version-name">Version ${escape_html(data.version)}</span><span class="version-date">${escape_html(data.date)}</span></li>`);
                        }
                        $$renderer7.push(`<!--]--></ul>`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!---->`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></div>`);
  });
}
export {
  _page as default
};
