import { a6 as fallback, aa as escape_html, a9 as bind_props, a2 as head, af as spread_props } from "../../../../../../chunks/index2.js";
import "clsx";
import { a as Col, C as Container, R as Row } from "../../../../../../chunks/Row.js";
import "../../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbOne } from "../../../../../../chunks/BreadcrumbOne.js";
import { C as Chartjs } from "../../../../../../chunks/Chartjs.js";
/* empty css                                                                   */
import { d as doughnutData } from "../../../../../../chunks/dashboardChartContent.js";
import { t as totalChartData } from "../../../../../../chunks/totalSaleChart.js";
import { C as Card } from "../../../../../../chunks/Card.js";
import { C as CardBody } from "../../../../../../chunks/CardBody.js";
import { C as CardHeader } from "../../../../../../chunks/CardHeader.js";
function DoughnutChart($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let height = fallback($$props["height"], 479);
    let labels = fallback(
      $$props["labels"],
      () => [
        "Jan",
        "Feb",
        "Mar",
        "Apr",
        "May",
        "Jun",
        "Jul",
        "Aug",
        "Sep",
        "Oct",
        "Nov",
        "Dec"
      ],
      true
    );
    let datasets = fallback(
      $$props["datasets"],
      () => [
        {
          data: [20, 60, 50, 45, 50, 60, 70, 40, 45, 35, 25, 30],
          borderColor: "#001737",
          borderWidth: 1,
          fill: false
        },
        {
          data: [10, 40, 30, 40, 60, 55, 45, 35, 30, 20, 15, 20],
          borderColor: "#1ce1ac",
          borderWidth: 1,
          fill: false
        }
      ],
      true
    );
    let id = fallback($$props["id"], "myChart");
    let className = fallback($$props["className"], "myChart");
    let legend = fallback($$props["legend"], () => ({ display: false, labels: { display: false } }), true);
    let layout = fallback($$props["layout"], () => ({}), true);
    let elements = fallback(
      $$props["elements"],
      () => ({
        line: {
          tension: 0.5,
          borderCapStyle: "round",
          borderJoinStyle: "round",
          capBezierPoints: true
        },
        point: { radius: 0, z: 5 }
      }),
      true
    );
    let scales = fallback($$props["scales"], () => ({ y: { display: false }, x: { display: false } }), true);
    let tooltip = fallback($$props["tooltip"], () => ({}), true);
    let options = fallback($$props["options"], () => ({}), true);
    $$renderer2.push(`<div class="doughnutchart-inner"><div class="doughnutchart-inner-text">`);
    if (datasets[0].centerText === "") {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<span class="doughnutchart-inner-content">${escape_html(datasets[0].data.reduce((a, b) => a + b, 0))}%</span>`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<span class="doughnutchart-inner-content">${escape_html(datasets[0].centerText)}</span>`);
    }
    $$renderer2.push(`<!--]--> <span class="doughnutchart-inner-label">${escape_html(datasets[0].centerTextLabel)}</span></div> `);
    Chartjs($$renderer2, {
      type: "doughnut",
      height,
      labels,
      datasets,
      id,
      className,
      legend,
      layout,
      elements,
      scales,
      tooltip,
      options
    });
    $$renderer2.push(`<!----></div>`);
    bind_props($$props, {
      height,
      labels,
      datasets,
      id,
      className,
      legend,
      layout,
      elements,
      scales,
      tooltip,
      options
    });
  });
}
function Chartjs_1($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let salesGrowthset, chartScales, barChartStacked, responsive, lineChartDataset, lineChartLayout, pieChartHeight, pieChartData, doughnutDatasets;
    let { salesGrowth } = doughnutData;
    let currentTab = "today";
    let doughnutLabels = ["Revenue", "Sales", "Products"];
    let salesOverviewData = null;
    let primaryColor;
    let primaryColorRGB;
    let infoColor;
    let infoColorRGB;
    let colorWarning;
    const height = 188;
    const tooltip = {
      callbacks: {
        label(t) {
          const dstLabel = t.dataset.label;
          const { formattedValue } = t;
          return `  ${formattedValue} ${dstLabel}`;
        },
        labelColor(t) {
          return {
            backgroundColor: t.dataset.hoverBackgroundColor,
            borderColor: "transparent"
          };
        }
      }
    };
    const linetooltip = {
      usePointStyle: true,
      callbacks: {
        label(t) {
          const dstLabel = t.dataset.label;
          const { formattedValue } = t;
          return `  ${formattedValue} ${dstLabel}`;
        },
        labelColor(t) {
          return {
            backgroundColor: t.dataset.hoverBackgroundColor,
            borderColor: "transparent"
          };
        }
      }
    };
    const options = { indexAxis: "y" };
    let pieChartScales = { y: { display: false }, x: { display: false } };
    let pieChartOptions = {
      maintainAspectRatio: false,
      hoverOffset: 3,
      responsive: false,
      borderColor: "#fff",
      plugins: { legend: { display: false }, labels: { display: false } },
      animation: { animateScale: true, animateRotate: true }
    };
    let pieChartDataStats = [
      {
        icons: ["facebook"],
        labels: ["Facebook"],
        revenue: [4621],
        color: "#8231D3"
      },
      {
        icons: ["twitter"],
        labels: ["Twitter"],
        revenue: [4245],
        color: "#00AAFF"
      },
      {
        icons: ["google"],
        labels: ["Google"],
        revenue: [12112],
        color: "#5840FF"
      }
    ];
    let pieChartLabels = [];
    let pieChartRevenues = [];
    let pieChartColors = [];
    pieChartDataStats.forEach((elm) => {
      pieChartLabels.push(elm.labels);
      pieChartRevenues.push(elm.revenue);
      pieChartColors.push(elm.color);
    });
    let pieChartTooltip = {
      backgroundColor: "#FFF",
      titleFontSize: 16,
      titleFontColor: "#0066ff",
      bodyFontColor: "#000",
      bodyFontSize: 14,
      displayColors: false,
      callbacks: {
        title(t) {
          console.log(t);
        }
      }
    };
    const doughnutOptions = {
      cutout: 62,
      borderWidth: 2,
      maintainAspectRatio: false,
      responsive: false,
      borderColor: "#fff",
      plugins: { legend: { display: false }, labels: { display: false } },
      animation: { animateScale: true, animateRotate: true }
    };
    salesGrowthset = [
      {
        axis: "y",
        data: salesGrowth[currentTab].orders,
        backgroundColor: `rgba(${primaryColorRGB},0.5)`,
        hoverBackgroundColor: primaryColor,
        label: "Target",
        total: "8,550",
        prefix: "$",
        growthRate: "25",
        growthStatus: "up",
        labelType: "primary",
        maxBarThickness: 18,
        barThickness: 20
      },
      {
        axis: "y",
        data: salesGrowth[currentTab].sales,
        backgroundColor: `rgba(${infoColorRGB},0.5)`,
        hoverBackgroundColor: infoColor,
        label: "Total Sales",
        total: "5,550",
        prefix: "$",
        growthRate: "15",
        growthStatus: "down",
        labelType: "info",
        maxBarThickness: 18,
        barThickness: 20
      }
    ];
    chartScales = {
      y: {
        grid: {
          color: "#E3E6EF",
          borderDash: [3, 3],
          zeroLineColor: "#E3E6EF",
          zeroLineWidth: 1,
          zeroLineBorderDash: [3, 3],
          drawTicks: false,
          drawBorder: false,
          borderWidth: 0
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474",
          max: Math.max(...salesGrowth[currentTab].sales),
          stepSize: 20,
          padding: 15,
          callback(value, index, ticks) {
            return value + "k";
          }
        }
      },
      x: {
        grid: {
          display: true,
          zeroLineWidth: 0,
          drawTicks: true,
          drawBorder: false,
          zeroLineColor: "#E3E6EF",
          color: "transparent",
          z: 1
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474"
        }
      }
    };
    barChartStacked = {
      y: {
        stacked: true,
        grid: {
          color: "#E3E6EF",
          borderDash: [3, 3],
          zeroLineColor: "#E3E6EF",
          zeroLineWidth: 1,
          zeroLineBorderDash: [3, 3],
          drawTicks: false,
          drawBorder: false,
          borderWidth: 0
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474",
          max: Math.max(...salesGrowth[currentTab].sales),
          stepSize: 20,
          padding: 15,
          callback(value, index, ticks) {
            return value + "k";
          }
        }
      },
      x: {
        stacked: true,
        grid: {
          display: true,
          zeroLineWidth: 0,
          drawTicks: true,
          drawBorder: false,
          zeroLineColor: "#E3E6EF",
          color: "transparent",
          z: 1
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474"
        }
      }
    };
    responsive = [];
    lineChartDataset = [
      {
        data: totalChartData.orders,
        backgroundColor: `rgba(${primaryColorRGB},0.5)`,
        hoverBackgroundColor: primaryColor,
        borderColor: primaryColor,
        label: "Orders",
        total: "8,550",
        prefix: "$",
        growthRate: "25",
        growthStatus: "up",
        labelType: "primary",
        maxBarThickness: 10,
        barThickness: 12
      },
      {
        data: totalChartData.sales,
        backgroundColor: `rgba(${infoColorRGB},0.5)`,
        hoverBackgroundColor: infoColor,
        borderColor: infoColor,
        label: "Sales",
        total: "5,550",
        prefix: "$",
        growthRate: "15",
        growthStatus: "down",
        labelType: "info",
        maxBarThickness: 10,
        barThickness: 12
      }
    ];
    lineChartLayout = { padding: { left: 0, right: 0, top: 0, bottom: 0 } };
    pieChartHeight = 250;
    pieChartData = [
      {
        label: "Revenue Generated",
        data: pieChartRevenues,
        backgroundColor: pieChartColors
      }
    ];
    doughnutDatasets = [
      {
        data: salesOverviewData,
        backgroundColor: [colorWarning, infoColor, primaryColor],
        centerText: "$7.9K",
        centerTextLabel: "Revenue"
      }
    ];
    Col($$renderer2, {
      lg: 6,
      class: "mb-4",
      children: ($$renderer3) => {
        Card($$renderer3, {
          children: ($$renderer4) => {
            CardHeader($$renderer4, {
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->Bar Chart`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            CardBody($$renderer4, {
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="parentContainer">`);
                Chartjs($$renderer5, {
                  class: "salesChart",
                  id: "salesChart",
                  labels: salesGrowth[currentTab].labels,
                  datasets: salesGrowthset,
                  type: "bar",
                  tooltip,
                  scales: chartScales,
                  responsive,
                  height: 188
                });
                $$renderer5.push(`<!----></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----> `);
    Col($$renderer2, {
      lg: 6,
      class: "mb-4",
      children: ($$renderer3) => {
        Card($$renderer3, {
          children: ($$renderer4) => {
            CardHeader($$renderer4, {
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->Horizontal Chart`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            CardBody($$renderer4, {
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="parentContainer">`);
                Chartjs($$renderer5, {
                  className: "salesChart",
                  id: "salesChart2",
                  labels: salesGrowth[currentTab].labels,
                  datasets: salesGrowthset,
                  type: "bar",
                  tooltip,
                  scales: chartScales,
                  responsive,
                  height: 188,
                  options
                });
                $$renderer5.push(`<!----></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----> `);
    Col($$renderer2, {
      lg: 6,
      class: "mb-4",
      children: ($$renderer3) => {
        Card($$renderer3, {
          children: ($$renderer4) => {
            CardHeader($$renderer4, {
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->Bar Chart Stacked`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            CardBody($$renderer4, {
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="parentContainer">`);
                Chartjs($$renderer5, {
                  className: "salesChart",
                  id: "salesChartStacked",
                  labels: salesGrowth[currentTab].labels,
                  datasets: salesGrowthset,
                  type: "bar",
                  tooltip,
                  scales: barChartStacked,
                  responsive,
                  height: 188
                });
                $$renderer5.push(`<!----></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----> `);
    Col($$renderer2, {
      lg: 6,
      class: "mb-4",
      children: ($$renderer3) => {
        Card($$renderer3, {
          children: ($$renderer4) => {
            CardHeader($$renderer4, {
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->Line Chart`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            CardBody($$renderer4, {
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="parentContainer">`);
                Chartjs($$renderer5, {
                  className: "totalLineCharts",
                  id: "totalLineCharts",
                  labels: totalChartData.labels,
                  datasets: lineChartDataset,
                  type: "line",
                  scales: chartScales,
                  tooltip: linetooltip,
                  layout: lineChartLayout,
                  height
                });
                $$renderer5.push(`<!----></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----> `);
    Col($$renderer2, {
      lg: 6,
      class: "mb-4",
      children: ($$renderer3) => {
        Card($$renderer3, {
          children: ($$renderer4) => {
            CardHeader($$renderer4, {
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->Pie Chart`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            CardBody($$renderer4, {
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="parentContainer d-flex justify-content-center">`);
                Chartjs($$renderer5, {
                  type: "pie",
                  className: "pieChart",
                  id: "pieChart",
                  labels: pieChartLabels,
                  options: pieChartOptions,
                  scales: pieChartScales,
                  datasets: pieChartData,
                  tooltip: pieChartTooltip,
                  height: pieChartHeight
                });
                $$renderer5.push(`<!----></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----> `);
    Col($$renderer2, {
      lg: 6,
      class: "mb-4",
      children: ($$renderer3) => {
        Card($$renderer3, {
          children: ($$renderer4) => {
            CardHeader($$renderer4, {
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->Doughnut Chart`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            CardBody($$renderer4, {
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="parentContainer d-flex justify-content-center">`);
                DoughnutChart($$renderer5, {
                  type: "doughnut",
                  id: "salesOverviewChart",
                  className: "salesOverview",
                  labels: doughnutLabels,
                  datasets: doughnutDatasets,
                  options: doughnutOptions,
                  tooltip: pieChartTooltip,
                  height: "250"
                });
                $$renderer5.push(`<!----></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!---->`);
  });
}
function _page($$renderer) {
  const breadcrumbData = {
    pageTitle: "Chartjs",
    bcItem: "Pages",
    bcItemActive: "Chartjs"
  };
  head("10vl7qc", $$renderer, ($$renderer2) => {
    $$renderer2.title(($$renderer3) => {
      $$renderer3.push(`<title>Chartjs</title>`);
    });
  });
  $$renderer.push(`<div class="component-page mb-25">`);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              BreadcrumbOne($$renderer4, spread_props([breadcrumbData]));
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Chartjs_1($$renderer3);
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
export {
  _page as default
};
