import { ag as ensure_array_like, aa as escape_html, ae as stringify, a2 as head, af as spread_props } from "../../../../../chunks/index2.js";
import "clsx";
import { C as Container, R as Row, a as Col } from "../../../../../chunks/Row.js";
import "../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbOne } from "../../../../../chunks/BreadcrumbOne.js";
import { B as Button } from "../../../../../chunks/Button.js";
import { C as Card } from "../../../../../chunks/Card.js";
import { C as CardBody } from "../../../../../chunks/CardBody.js";
import { C as CardHeader } from "../../../../../chunks/CardHeader.js";
function Typography($$renderer) {
  const buttonColors = [
    {
      color: "primary",
      colorName: "Primary",
      colorCode: "#8231D3",
      hoverColor: "#6726A8"
    },
    {
      color: "secondary",
      colorName: "Secondary",
      colorCode: "#5840FF",
      hoverColor: "#3520C8"
    },
    {
      color: "success",
      colorName: "Success",
      colorCode: "#01B81A",
      hoverColor: "#0D811D"
    },
    {
      color: "info",
      colorName: "Info",
      colorCode: "#00AAFF",
      hoverColor: "#0787C7"
    },
    {
      color: "warning",
      colorName: "Warning",
      colorCode: "#FA8B0C",
      hoverColor: "#D9790A"
    },
    {
      color: "danger",
      colorName: "Danger",
      colorCode: "#FF0F0F",
      hoverColor: "#CB0000"
    },
    {
      color: "dark",
      colorName: "Dark",
      colorCode: "#0A0A0A",
      hoverColor: "#272525"
    },
    {
      color: "gray",
      colorName: "Gray",
      colorCode: "#404040",
      hoverColor: "#585858"
    },
    {
      color: "light",
      colorName: "Light",
      colorCode: "#747474",
      hoverColor: "#747474"
    },
    {
      color: "lighten",
      colorName: "Extra Light",
      colorCode: "#A0A0A0",
      hoverColor: "#A0A0A0"
    }
  ];
  const buttonHoverColors = buttonColors.slice(0, 8);
  $$renderer.push(`<div class="dashboard-base">`);
  Card($$renderer, {
    class: "card-md mb-30 shadow1",
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        class: "border-bottom-0  p-sm-30",
        children: ($$renderer3) => {
          $$renderer3.push(`<h5 class="fw-500">Theme colors</h5>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        class: "pt-0 px-30 pb-35",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="buttons-list d-flex flex-wrap"><!--[-->`);
          const each_array = ensure_array_like(buttonColors);
          for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
            let item = each_array[$$index];
            if (item.color === "light") {
              $$renderer3.push("<!--[-->");
              $$renderer3.push(`<div class="text-center">`);
              Button($$renderer3, {
                color: item.color,
                size: "default",
                class: "btn-squared radius-xs fs-15 fw-400 px-30 bg-light text-white text-capitalize",
                children: ($$renderer4) => {
                  $$renderer4.push(`<!---->${escape_html(item.colorName)}`);
                },
                $$slots: { default: true }
              });
              $$renderer3.push(`<!----> <span class="fs-14 fw-400 color-dark">${escape_html(item.colorCode)}</span></div>`);
            } else {
              $$renderer3.push("<!--[!-->");
              $$renderer3.push(`<div class="text-center">`);
              Button($$renderer3, {
                color: item.color,
                size: "default",
                class: "btn-squared radius-xs fs-15 fw-400  text-white text-capitalize",
                children: ($$renderer4) => {
                  $$renderer4.push(`<!---->${escape_html(item.colorName)}`);
                },
                $$slots: { default: true }
              });
              $$renderer3.push(`<!----> <span class="fs-14 fw-400 color-dark">${escape_html(item.colorCode)}</span></div>`);
            }
            $$renderer3.push(`<!--]-->`);
          }
          $$renderer3.push(`<!--]--></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----> `);
  Card($$renderer, {
    class: "card-md mb-30 shadow1",
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        class: "border-bottom-0  p-sm-30",
        children: ($$renderer3) => {
          $$renderer3.push(`<h5 class="fw-500">Hover colors</h5>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        class: "pt-0 px-30 pb-35",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="buttons-list d-flex flex-wrap"><!--[-->`);
          const each_array_1 = ensure_array_like(buttonHoverColors);
          for (let $$index_1 = 0, $$length = each_array_1.length; $$index_1 < $$length; $$index_1++) {
            let item = each_array_1[$$index_1];
            $$renderer3.push(`<div class="text-center">`);
            Button($$renderer3, {
              size: "default",
              class: `btn-${stringify(item.color)}-hover btn-squared radius-xs fs-15 fw-400`,
              children: ($$renderer4) => {
                $$renderer4.push(`<!---->${escape_html(item.colorName)}`);
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!----> <span class="fs-14 fw-400 color-dark">${escape_html(item.hoverColor)}</span></div>`);
          }
          $$renderer3.push(`<!--]--></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----> `);
  Card($$renderer, {
    class: "card-md mb-30 shadow1",
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        class: "border-bottom-0 p-sm-30",
        children: ($$renderer3) => {
          $$renderer3.push(`<h5 class="fw-500">Gradient colors</h5>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        class: "pt-0 px-30 pb-30",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="d-flex flex-wrap m-n10"><div class="gradient-color-name gradient1 py-35 px-20 color-white radius-xl m-10"><span class="me-sm-40 me-0 fs-15">#8231D3</span> <span class="ms-40 fs-15">#5840FF</span></div></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----> `);
  Card($$renderer, {
    class: "card-md mb-30 shadow1",
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        class: "border-bottom-0  p-sm-30",
        children: ($$renderer3) => {
          $$renderer3.push(`<h5 class="fw-500">Border colors</h5>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        class: "pt-0 px-30 pb-30",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="d-flex flex-wrap m-n15"><div class="d-flex align-items-center justify-content-between py-15 px-20 border-color radius-xs m-15"><span class="fs-15 fw-400 color-gray me-sm-50 me-20">Border color 1</span> <span class="fs-14 fw-500 color-dark ms-sm-50">#F1F2F6</span></div> <div class="d-flex align-item-center justify-content-between py-15 px-20 b-light radius-xs m-15"><span class="fs-15 fw-400 color-gray me-sm-50 me-20">Border color 2</span> <span class="fs-14 fw-500 color-dark ms-sm-50">#E3E6EF</span></div> <div class="d-flex align-item-center justify-content-between py-15 px-20 b-deep radius-xs m-15"><span class="fs-15 fw-400 color-gray me-sm-50 me-20">Border color 3</span> <span class="fs-14 fw-500 color-dark ms-sm-50">#C6D0DC</span></div></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----> `);
  Card($$renderer, {
    class: "card-md mb-30 shadow1",
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        class: "border-bottom-0  p-sm-30",
        children: ($$renderer3) => {
          $$renderer3.push(`<h5 class="fw-500">Background gray colors</h5>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        class: "pt-0 px-30 pb-30",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="d-flex flex-wrap m-n15"><div class="d-flex align-items-center justify-content-between py-15 px-20 bg-normal radius-xs m-15"><span class="fs-15 fw-400 color-gray me-sm-50 me-20 pe-sm-30">Bg color 1</span> <span class="fs-14 fw-500 color-dark ms-sm-50">#F8F9FB</span></div> <div class="d-flex align-item-center justify-content-between py-15 px-20 bg-lighter radius-xs m-15"><span class="fs-15 fw-400 color-gray me-sm-50 me-20 pe-sm-30">Bg color 2</span> <span class="fs-14 fw-500 color-dark ms-sm-50">#F4F5F7</span></div> <div class="d-flex align-item-center justify-content-between py-15 px-20 bg-deep radius-xs m-15"><span class="fs-15 fw-400 color-gray me-sm-50 me-20 pe-sm-30">Bg color 3</span> <span class="fs-14 fw-500 color-dark ms-sm-50">#EFF0F3</span></div></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----> `);
  Card($$renderer, {
    class: "card-md mb-30 shadow1",
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        class: "border-bottom-0  p-sm-30",
        children: ($$renderer3) => {
          $$renderer3.push(`<h5 class="fw-500">butttons</h5>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        class: "pt-0 px-30 pb-30",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="buttons-list d-flex flex-wrap align-items-end mb-45">`);
          Button($$renderer3, {
            color: "primary",
            size: "xs",
            class: "btn-squared btn-shadow-primary",
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->Extra small`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Button($$renderer3, {
            color: "primary",
            size: "sm",
            class: "btn-squared btn-shadow-primary",
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->Small`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Button($$renderer3, {
            color: "primary",
            size: "default",
            class: "btn-squared btn-shadow-primary",
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->Normal`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Button($$renderer3, {
            color: "primary",
            size: "lg",
            class: "btn-squared btn-shadow-primary",
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->Large Button`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----></div> <div class="buttons-list d-flex flex-wrap align-items-end mb-45">`);
          Button($$renderer3, {
            color: "primary",
            outline: true,
            size: "xs",
            class: "btn-squared",
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->Extra small`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Button($$renderer3, {
            color: "primary",
            outline: true,
            size: "sm",
            class: "btn-squared",
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->Small`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Button($$renderer3, {
            color: "primary",
            outline: true,
            size: "default",
            class: "btn-squared btn-outline-primary ",
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->Normal`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Button($$renderer3, {
            color: "primary",
            outline: true,
            size: "lg",
            class: "btn-squared",
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->Large Button`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----></div> <div class="buttons-list d-flex flex-wrap align-items-end">`);
          Button($$renderer3, {
            color: "primary",
            size: "",
            class: "btn-squared btn-transparent-primary",
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->Extra small`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Button($$renderer3, {
            color: "primary",
            size: "",
            class: "btn-squared btn-transparent-primary",
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->Small`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Button($$renderer3, {
            color: "primary",
            size: "",
            class: "btn-squared btn-transparent-primary",
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->Normal`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Button($$renderer3, {
            color: "primary",
            size: "",
            class: "btn-squared btn-transparent-primary",
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->Large Button`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----> `);
  Card($$renderer, {
    class: "card-md mb-30 shadow1",
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        class: "border-bottom-0  p-sm-30",
        children: ($$renderer3) => {
          $$renderer3.push(`<h5 class="fw-500">Typography <small class="color-secondary fs-16 fw-500">Jost</small></h5>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        class: "pt-0 px-30",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="d-flex flex-wrap"><div class="table-responsive"><table class="table table-borderless mb-0 w-80"><tbody><tr><th><div class="h1">h1. Default Heading</div></th><td class="type-info color-primary">Font Size - 30 px</td><td class="type-info color-secondary">Font weight - 600</td><td class="type-info color-success">Line height - 38 px</td></tr><tr><th><div class="h2">h2. Default Heading</div></th><td class="type-info color-primary">Font Size - 24 px</td><td class="type-info color-secondary">Font weight - 600</td><td class="type-info color-success">Line height - 30 px</td></tr><tr><th><div class="h3">h3. Default Heading</div></th><td class="type-info color-primary">Font Size - 22 px</td><td class="type-info color-secondary">Font weight - 600</td><td class="type-info color-success">Line height - 27 px</td></tr><tr><th><div class="h4">h4. Default Heading</div></th><td class="type-info color-primary">Font Size - 20 px</td><td class="type-info color-secondary">Font weight - 600</td><td class="type-info color-success">Line height - 24 px</td></tr><tr><th><div class="h5">h5. Default Heading</div></th><td class="type-info color-primary">Font Size - 18 px</td><td class="type-info color-secondary">Font weight - 600</td><td class="type-info color-success">Line height - 22 px</td></tr></tbody></table></div></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----> `);
  Card($$renderer, {
    class: "card-md shadow1 pt-30 pb-10",
    children: ($$renderer2) => {
      $$renderer2.push(`<div class="border-bottom-0 px-30 pb-1"><h5>Body Text Normal</h5></div> `);
      CardBody($$renderer2, {
        class: "pt-0 px-30",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="d-flex flex-wrap mb-2"><span class="text-normal color-primary">Font Size - 15px<span class="color-secondary mx-15">Font weight - 400</span> <span class="color-success">Line height - 26px</span></span></div> <p class="text-normal">Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor
				invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam
				et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est
				Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed
				diam nonumy eirmod</p>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> <div class="border-bottom-0 px-30 pb-1"><h5>Body Text small</h5></div> `);
      CardBody($$renderer2, {
        class: "pt-0 px-30",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="d-flex flex-wrap mb-2"><span class="text-normal color-primary">Font Size - 14px<span class="color-secondary mx-15">Font weight - 400</span> <span class="color-success">Line height - 24px</span></span></div> <p class="text-small mb-0">Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor
				invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam
				et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est
				Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed
				diam nonumy eirmod</p>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> <div class="border-bottom-0 px-30 pb-1"><h5>Body Text Big</h5></div> `);
      CardBody($$renderer2, {
        class: "pt-0 px-30",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="d-flex flex-wrap mb-2"><span class="text-normal color-primary">Font Size - 16px<span class="color-secondary mx-15">Font weight - 400</span> <span class="color-success">Line height - 27px</span></span></div> <p class="text-small mb-0">Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor
				invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam
				et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est
				Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed
				diam nonumy eirmod</p>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
function _page($$renderer) {
  const breadcrumbData = {
    pageTitle: "Typography",
    bcItem: "Dashboard",
    bcItemActive: "Typography"
  };
  head("1kyidl1", $$renderer, ($$renderer2) => {
    $$renderer2.title(($$renderer3) => {
      $$renderer3.push(`<title>Typography</title>`);
    });
  });
  $$renderer.push(`<div class="component-page mb-25">`);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 9,
            class: ["offset-lg-1"],
            children: ($$renderer4) => {
              BreadcrumbOne($$renderer4, spread_props([breadcrumbData]));
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            lg: 9,
            class: ["offset-lg-1"],
            children: ($$renderer4) => {
              Typography($$renderer4);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
export {
  _page as default
};
