import { a4 as sanitize_props, a5 as rest_props, a6 as fallback, a0 as slot, a7 as attributes, a9 as bind_props, a2 as head, af as spread_props } from "../../../../../chunks/index2.js";
import "clsx";
import { a as Col, C as Container, R as Row } from "../../../../../chunks/Row.js";
import "../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbOne } from "../../../../../chunks/BreadcrumbOne.js";
import { C as Card } from "../../../../../chunks/Card.js";
import { C as CardBody } from "../../../../../chunks/CardBody.js";
import { C as CardHeader } from "../../../../../chunks/CardHeader.js";
import "flatpickr";
function Flatpickr($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, [
    "value",
    "formattedValue",
    "element",
    "dateFormat",
    "options",
    "input",
    "flatpickr"
  ]);
  $$renderer.component(($$renderer2) => {
    let value = fallback($$props["value"], void 0);
    let formattedValue = fallback($$props["formattedValue"], "");
    let element = fallback($$props["element"], void 0);
    let dateFormat = fallback($$props["dateFormat"], void 0);
    let options = fallback($$props["options"], () => ({}), true);
    let input = fallback($$props["input"], void 0);
    let fp = fallback($$props["flatpickr"], void 0);
    $$renderer2.push(`<!--[-->`);
    slot($$renderer2, $$props, "default", {}, () => {
      $$renderer2.push(`<input${attributes({ ...$$restProps }, void 0, void 0, void 0, 4)}/>`);
    });
    $$renderer2.push(`<!--]-->`);
    bind_props($$props, {
      value,
      formattedValue,
      element,
      dateFormat,
      options,
      input,
      flatpickr: fp
    });
  });
}
function TimePicker($$renderer) {
  let value;
  const options = { enableTime: true, noCalendar: true, dateFormat: "H:i" };
  let $$settled = true;
  let $$inner_renderer;
  function $$render_inner($$renderer2) {
    Col($$renderer2, {
      lg: 6,
      children: ($$renderer3) => {
        Card($$renderer3, {
          children: ($$renderer4) => {
            CardHeader($$renderer4, {
              children: ($$renderer5) => {
                $$renderer5.push(`<h6>Time Picker</h6>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            CardBody($$renderer4, {
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="time-picker-wrap">`);
                Flatpickr($$renderer5, {
                  options,
                  name: "time",
                  class: "form-control form-control-lg bg-transparent",
                  get value() {
                    return value;
                  },
                  set value($$value) {
                    value = $$value;
                    $$settled = false;
                  }
                });
                $$renderer5.push(`<!----> <span class="uil uil-clock"></span></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
      },
      $$slots: { default: true }
    });
  }
  do {
    $$settled = true;
    $$inner_renderer = $$renderer.copy();
    $$render_inner($$inner_renderer);
  } while (!$$settled);
  $$renderer.subsume($$inner_renderer);
}
function _page($$renderer) {
  const breadcrumbData = {
    pageTitle: "Time Picker",
    bcItem: "Dashboard",
    bcItemActive: "Time Picker"
  };
  head("1n6zsr7", $$renderer, ($$renderer2) => {
    $$renderer2.title(($$renderer3) => {
      $$renderer3.push(`<title>Time Picker</title>`);
    });
  });
  $$renderer.push(`<div class="component-page mb-25">`);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              BreadcrumbOne($$renderer4, spread_props([breadcrumbData]));
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          TimePicker($$renderer3);
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
export {
  _page as default
};
