import { a6 as fallback, ad as attr_class, ae as stringify, aa as escape_html, a9 as bind_props, a2 as head, af as spread_props } from "../../../../../chunks/index2.js";
import "clsx";
import { a as Col, C as Container, R as Row } from "../../../../../chunks/Row.js";
import "../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbOne } from "../../../../../chunks/BreadcrumbOne.js";
import { g as getNotificationsContext, N as Notifications } from "../../../../../chunks/Notifications.js";
import { B as Button } from "../../../../../chunks/Button.js";
import { C as Card } from "../../../../../chunks/Card.js";
import { C as CardBody } from "../../../../../chunks/CardBody.js";
import { C as CardHeader } from "../../../../../chunks/CardHeader.js";
function CustomNotification($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let notification = fallback($$props["notification"], () => ({}), true);
    let onRemove = fallback($$props["onRemove"], null);
    $$renderer2.push(`<div${attr_class(`notification-wrapper notification-wrapper notification-wrapper--${stringify(notification.type)}`)}><div class="message-wrapper__content"><h6>`);
    if (notification.icon !== "") {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<span class="message-wrapper__icon"><i${attr_class(`la la-${stringify(notification.icon)}`)}></i></span>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> ${escape_html(notification.heading)}</h6> <span class="message-wrapper__text"><p>${escape_html(notification.description)}</p></span> <button><i class="la la-times"></i></button></div></div>`);
    bind_props($$props, { notification, onRemove });
  });
}
function NotificationTemplate($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const { addNotification } = getNotificationsContext();
    Col($$renderer2, {
      lg: 6,
      children: ($$renderer3) => {
        Card($$renderer3, {
          class: "card-default card-md mb-4",
          children: ($$renderer4) => {
            CardHeader($$renderer4, {
              class: "py-20",
              children: ($$renderer5) => {
                $$renderer5.push(`<h6>Basic</h6>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            CardBody($$renderer4, {
              children: ($$renderer5) => {
                Button($$renderer5, {
                  color: "primary",
                  size: "sm",
                  class: "btn-squired notification-modal-box__btn fw-500",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->Open the Notification Box`);
                  },
                  $$slots: { default: true }
                });
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        Card($$renderer3, {
          class: "card-default card-md mb-4",
          children: ($$renderer4) => {
            CardHeader($$renderer4, {
              class: "py-20",
              children: ($$renderer5) => {
                $$renderer5.push(`<h6>Duration</h6>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            CardBody($$renderer4, {
              children: ($$renderer5) => {
                Button($$renderer5, {
                  color: "primary",
                  size: "sm",
                  class: "btn-squired notification-modal-box__btn fw-500",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->Open the Notification Box`);
                  },
                  $$slots: { default: true }
                });
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        Card($$renderer3, {
          class: "card-default card-md mb-4",
          children: ($$renderer4) => {
            CardHeader($$renderer4, {
              class: "py-20",
              children: ($$renderer5) => {
                $$renderer5.push(`<h6>Custom Close</h6>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            CardBody($$renderer4, {
              children: ($$renderer5) => {
                Button($$renderer5, {
                  color: "primary",
                  size: "sm",
                  class: "btn-squired notification-modal-box__btn fw-500",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->Open the Notification Box`);
                  },
                  $$slots: { default: true }
                });
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----> `);
    Col($$renderer2, {
      lg: 6,
      children: ($$renderer3) => {
        Card($$renderer3, {
          class: "card-default card-md mb-4",
          children: ($$renderer4) => {
            CardHeader($$renderer4, {
              class: "py-20",
              children: ($$renderer5) => {
                $$renderer5.push(`<h6>With Icon</h6>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            CardBody($$renderer4, {
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="button-group">`);
                Button($$renderer5, {
                  color: "light",
                  outline: true,
                  size: "sm",
                  class: "btn-squired notification-modal-box__btn fw-500",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->Info`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                Button($$renderer5, {
                  color: "light",
                  outline: true,
                  size: "sm",
                  class: "btn-squired notification-modal-box__btn fw-500",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->Success`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                Button($$renderer5, {
                  color: "light",
                  outline: true,
                  size: "sm",
                  class: "btn-squired notification-modal-box__btn fw-500",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->Error`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                Button($$renderer5, {
                  color: "light",
                  outline: true,
                  size: "sm",
                  class: "btn-squired notification-modal-box__btn fw-500",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->Warning`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        Card($$renderer3, {
          class: "card-default card-md mb-4",
          children: ($$renderer4) => {
            CardHeader($$renderer4, {
              class: "py-20",
              children: ($$renderer5) => {
                $$renderer5.push(`<h6>Position</h6>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            CardBody($$renderer4, {
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="button-group d-flex flex-wrap justify-content-sm-start justify-content-center">`);
                Button($$renderer5, {
                  color: "light",
                  outline: true,
                  size: "sm",
                  class: "btn-squired notification-modal-box__btn fw-500",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->Top Left`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                Button($$renderer5, {
                  color: "light",
                  outline: true,
                  size: "sm",
                  class: "btn-squired notification-modal-box__btn fw-500",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->Top Center`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                Button($$renderer5, {
                  color: "light",
                  outline: true,
                  size: "sm",
                  class: "btn-squired notification-modal-box__btn fw-500",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->Top Right`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                Button($$renderer5, {
                  color: "light",
                  outline: true,
                  size: "sm",
                  class: "btn-squired notification-modal-box__btn fw-500",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->Bottom Left`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                Button($$renderer5, {
                  color: "light",
                  outline: true,
                  size: "sm",
                  class: "btn-squired notification-modal-box__btn fw-500",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->Bottom Center`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                Button($$renderer5, {
                  color: "light",
                  outline: true,
                  size: "sm",
                  class: "btn-squired notification-modal-box__btn fw-500",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->Bottom Right`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!---->`);
  });
}
function Notifications_1($$renderer) {
  Notifications($$renderer, {
    item: CustomNotification,
    children: ($$renderer2) => {
      NotificationTemplate($$renderer2);
    },
    $$slots: { default: true }
  });
}
function _page($$renderer) {
  const breadcrumbData = {
    pageTitle: "Notifications",
    bcItem: "Dashboard",
    bcItemActive: "Notifications"
  };
  head("ohfei6", $$renderer, ($$renderer2) => {
    $$renderer2.title(($$renderer3) => {
      $$renderer3.push(`<title>Notifications</title>`);
    });
  });
  $$renderer.push(`<div class="component-page mb-25">`);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              BreadcrumbOne($$renderer4, spread_props([breadcrumbData]));
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Notifications_1($$renderer3);
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
export {
  _page as default
};
