import { ad as attr_class, aa as escape_html, ae as stringify, a9 as bind_props, af as spread_props, a2 as head } from "../../../../../chunks/index2.js";
import "clsx";
import { a as Col, C as Container, R as Row } from "../../../../../chunks/Row.js";
import "../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbOne } from "../../../../../chunks/BreadcrumbOne.js";
import { B as Button } from "../../../../../chunks/Button.js";
import { C as Card } from "../../../../../chunks/Card.js";
import { C as CardBody } from "../../../../../chunks/CardBody.js";
import { C as CardHeader } from "../../../../../chunks/CardHeader.js";
import { M as Modal, a as ModalBody } from "../../../../../chunks/Modal.js";
import { M as ModalFooter } from "../../../../../chunks/ModalFooter.js";
import { M as ModalHeader } from "../../../../../chunks/ModalHeader.js";
import { h as html } from "../../../../../chunks/html.js";
function ModalTemplate($$renderer, $$props) {
  let isOpen = $$props["isOpen"];
  let toggle = $$props["toggle"];
  let borderless = $$props["borderless"];
  let modalBg = $$props["modalBg"];
  let header = $$props["header"];
  let headerContent = $$props["headerContent"];
  let modalContent = $$props["modalContent"];
  let footer = $$props["footer"];
  let icon = $$props["icon"];
  let buttonOne = $$props["buttonOne"];
  let buttonOneClass = $$props["buttonOneClass"];
  let buttonOneText = $$props["buttonOneText"];
  let buttonTwo = $$props["buttonTwo"];
  let buttonTwoClass = $$props["buttonTwoClass"];
  let buttonTwoText = $$props["buttonTwoText"];
  let infoType = $$props["infoType"];
  Modal($$renderer, {
    isOpen,
    toggle,
    class: `${stringify(modalBg)} ${stringify(borderless)} ${stringify(infoType !== void 0 ? infoType : "")}`,
    size: "xl",
    children: ($$renderer2) => {
      if (header) {
        $$renderer2.push("<!--[-->");
        ModalHeader($$renderer2, {
          toggle,
          children: ($$renderer3) => {
            if (icon !== "") {
              $$renderer3.push("<!--[-->");
              $$renderer3.push(`<i${attr_class(`uil uil-${stringify(icon)}`)}></i>`);
            } else {
              $$renderer3.push("<!--[!-->");
            }
            $$renderer3.push(`<!--]--> ${escape_html(headerContent)}`);
          },
          $$slots: { default: true }
        });
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> `);
      ModalBody($$renderer2, {
        children: ($$renderer3) => {
          if (modalContent !== "") {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<i${attr_class(`uil uil-${stringify(icon)}`)}></i> ${html(modalContent)}`);
          } else {
            $$renderer3.push("<!--[!-->");
            $$renderer3.push(`<p>Some contents...</p> <p>Some contents...</p> <p>Some contents...</p>`);
          }
          $$renderer3.push(`<!--]-->`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      if (footer) {
        $$renderer2.push("<!--[-->");
        ModalFooter($$renderer2, {
          children: ($$renderer3) => {
            if (buttonOne !== "") {
              $$renderer3.push("<!--[-->");
              Button($$renderer3, {
                color: buttonOne,
                class: buttonOneClass,
                children: ($$renderer4) => {
                  $$renderer4.push(`<!---->${escape_html(buttonOneText)}`);
                },
                $$slots: { default: true }
              });
            } else {
              $$renderer3.push("<!--[!-->");
            }
            $$renderer3.push(`<!--]--> `);
            if (buttonTwo !== "") {
              $$renderer3.push("<!--[-->");
              Button($$renderer3, {
                color: buttonTwo,
                class: buttonTwoClass,
                children: ($$renderer4) => {
                  $$renderer4.push(`<!---->${escape_html(buttonTwoText)}`);
                },
                $$slots: { default: true }
              });
            } else {
              $$renderer3.push("<!--[!-->");
            }
            $$renderer3.push(`<!--]-->`);
          },
          $$slots: { default: true }
        });
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]-->`);
    },
    $$slots: { default: true }
  });
  bind_props($$props, {
    isOpen,
    toggle,
    borderless,
    modalBg,
    header,
    headerContent,
    modalContent,
    footer,
    icon,
    buttonOne,
    buttonOneClass,
    buttonOneText,
    buttonTwo,
    buttonTwoClass,
    buttonTwoText,
    infoType
  });
}
function Modals($$renderer) {
  let open = false;
  let modalBg;
  let modalContents = {};
  const toggle = () => {
    modalContents = {
      header: true,
      headerContent: "Basic Title",
      modalContent: "",
      footer: true,
      icon: "",
      buttonOne: "primary",
      buttonOneText: "Save Changes",
      buttonTwo: "secondary",
      buttonTwoText: "Close"
    };
    open = !open;
    modalBg = "modal-bg-normal";
  };
  Col($$renderer, {
    lg: 6,
    children: ($$renderer2) => {
      Card($$renderer2, {
        class: "card-default card-md mb-4",
        children: ($$renderer3) => {
          CardHeader($$renderer3, {
            children: ($$renderer4) => {
              $$renderer4.push(`<h6>Basic</h6>`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          CardBody($$renderer3, {
            children: ($$renderer4) => {
              Button($$renderer4, {
                color: "primary",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->Open Modal`);
                },
                $$slots: { default: true }
              });
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      Card($$renderer2, {
        class: "card-default card-md mb-4",
        children: ($$renderer3) => {
          CardHeader($$renderer3, {
            children: ($$renderer4) => {
              $$renderer4.push(`<h6>Confirmation modal dialog</h6>`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          CardBody($$renderer3, {
            children: ($$renderer4) => {
              $$renderer4.push(`<div class="modal-btn-group d-flex align-items-center justify-content-sm-start justify-content-center">`);
              Button($$renderer4, {
                color: "light",
                outline: true,
                class: "btn-outline-lighten__height",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->Confirm`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              Button($$renderer4, {
                color: "light",
                outline: true,
                class: "btn-outline-lighten__height",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->Delete`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----></div>`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----> `);
  ModalTemplate($$renderer, spread_props([{ isOpen: open, toggle }, modalContents, { modalBg }]));
  $$renderer.push(`<!----> `);
  Col($$renderer, {
    lg: 6,
    children: ($$renderer2) => {
      Card($$renderer2, {
        class: "card-default card-md mb-4",
        children: ($$renderer3) => {
          CardHeader($$renderer3, {
            children: ($$renderer4) => {
              $$renderer4.push(`<h6>Color Modal</h6>`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          CardBody($$renderer3, {
            children: ($$renderer4) => {
              $$renderer4.push(`<div class="modal-btn-group d-flex align-items-center flex-wrap justify-content-sm-start justify-content-center">`);
              Button($$renderer4, {
                color: "primary",
                size: "sm",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->Primary`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              Button($$renderer4, {
                color: "success",
                size: "sm",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->Success`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              Button($$renderer4, {
                color: "danger",
                size: "sm",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->Danger`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              Button($$renderer4, {
                color: "warning",
                size: "sm",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->Warning`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----></div>`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      Card($$renderer2, {
        class: "card-default card-md mb-4",
        children: ($$renderer3) => {
          CardHeader($$renderer3, {
            children: ($$renderer4) => {
              $$renderer4.push(`<h6>Info Modal</h6>`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          CardBody($$renderer3, {
            children: ($$renderer4) => {
              $$renderer4.push(`<div class="modal-btn-group d-flex align-items-center flex-wrap justify-content-sm-start justify-content-center">`);
              Button($$renderer4, {
                color: "light",
                outline: true,
                class: "btn-outline-lighten__height",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->Info`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              Button($$renderer4, {
                color: "light",
                outline: true,
                class: "btn-outline-lighten__height",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->Success`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              Button($$renderer4, {
                color: "light",
                outline: true,
                class: "btn-outline-lighten__height",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->Error`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              Button($$renderer4, {
                color: "light",
                outline: true,
                class: "btn-outline-lighten__height",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->Warning`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----></div>`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!---->`);
}
function _page($$renderer) {
  const breadcrumbData = {
    pageTitle: "Modals",
    bcItem: "Dashboard",
    bcItemActive: "Modals"
  };
  head("g60gq", $$renderer, ($$renderer2) => {
    $$renderer2.title(($$renderer3) => {
      $$renderer3.push(`<title>Modals</title>`);
    });
  });
  $$renderer.push(`<div class="component-page mb-25">`);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              BreadcrumbOne($$renderer4, spread_props([breadcrumbData]));
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Modals($$renderer3);
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
export {
  _page as default
};
