import { a6 as fallback, ad as attr_class, ae as stringify, aa as escape_html, a9 as bind_props, a2 as head, af as spread_props } from "../../../../../chunks/index2.js";
import "clsx";
import { a as Col, C as Container, R as Row } from "../../../../../chunks/Row.js";
import "../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbOne } from "../../../../../chunks/BreadcrumbOne.js";
import { g as getNotificationsContext, N as Notifications } from "../../../../../chunks/Notifications.js";
import { B as Button } from "../../../../../chunks/Button.js";
import { C as Card } from "../../../../../chunks/Card.js";
import { C as CardBody } from "../../../../../chunks/CardBody.js";
import { C as CardHeader } from "../../../../../chunks/CardHeader.js";
function CustomMessage($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let notification = fallback($$props["notification"], () => ({}), true);
    let onRemove = fallback($$props["onRemove"], null);
    $$renderer2.push(`<div${attr_class(`message-wrapper message-wrapper--${stringify(notification.type)}`)}><div class="message-wrapper__content"><span class="message-wrapper__icon"><i${attr_class(`uil uil-${stringify(notification.icon)}`)}></i></span> <span class="message-wrapper__text"><p>${escape_html(notification.description)}</p></span> <button><i class="la la-times"></i></button></div></div>`);
    bind_props($$props, { notification, onRemove });
  });
}
function MessageTemplate($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const { addNotification } = getNotificationsContext();
    Col($$renderer2, {
      lg: 6,
      children: ($$renderer3) => {
        Card($$renderer3, {
          class: "card-default card-md mb-4",
          children: ($$renderer4) => {
            CardHeader($$renderer4, {
              class: "py-20",
              children: ($$renderer5) => {
                $$renderer5.push(`<h6>Basic</h6>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            CardBody($$renderer4, {
              children: ($$renderer5) => {
                Button($$renderer5, {
                  color: "primary",
                  size: "lg",
                  class: "btn-squired btn-shadow-primary btn-message",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->Display Normal Message`);
                  },
                  $$slots: { default: true }
                });
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        Card($$renderer3, {
          class: "card-default card-md mb-4",
          children: ($$renderer4) => {
            CardHeader($$renderer4, {
              class: "py-20",
              children: ($$renderer5) => {
                $$renderer5.push(`<h6>Other types of message</h6>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            CardBody($$renderer4, {
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="button-group flex-wrap justify-content-sm-start justify-content-center">`);
                Button($$renderer5, {
                  color: "light",
                  size: "lg",
                  outline: true,
                  class: "btn-squired btn-message",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->Success`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                Button($$renderer5, {
                  color: "light",
                  size: "lg",
                  outline: true,
                  class: "btn-squired btn-message",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->Warning`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                Button($$renderer5, {
                  color: "light",
                  size: "lg",
                  outline: true,
                  class: "btn-squired btn-message",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->Error`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----> `);
    Col($$renderer2, {
      lg: 6,
      children: ($$renderer3) => {
        Card($$renderer3, {
          class: "card-default card-md mb-4",
          children: ($$renderer4) => {
            CardHeader($$renderer4, {
              class: "py-20",
              children: ($$renderer5) => {
                $$renderer5.push(`<h6>Customize</h6>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            CardBody($$renderer4, {
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="d-flex flex-wrap justify-content-sm-start justify-content-center">`);
                Button($$renderer5, {
                  color: "light",
                  size: "lg",
                  outline: true,
                  class: "btn-squired btn-message",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->Customize display Duration`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        Card($$renderer3, {
          class: "card-default card-md mb-4",
          children: ($$renderer4) => {
            CardHeader($$renderer4, {
              class: "py-20",
              children: ($$renderer5) => {
                $$renderer5.push(`<h6>Loading</h6>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            CardBody($$renderer4, {
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="d-flex flex-wrap justify-content-sm-start justify-content-center">`);
                Button($$renderer5, {
                  color: "light",
                  size: "lg",
                  outline: true,
                  class: "btn-squired btn-message",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->Display a loading indicator`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!---->`);
  });
}
function Message($$renderer) {
  Notifications($$renderer, {
    item: CustomMessage,
    children: ($$renderer2) => {
      MessageTemplate($$renderer2);
    },
    $$slots: { default: true }
  });
}
function _page($$renderer) {
  const breadcrumbData = {
    pageTitle: "Message",
    bcItem: "Dashboard",
    bcItemActive: "Message"
  };
  head("133iez7", $$renderer, ($$renderer2) => {
    $$renderer2.title(($$renderer3) => {
      $$renderer3.push(`<title>Message</title>`);
    });
  });
  $$renderer.push(`<div class="component-page mb-25">`);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              BreadcrumbOne($$renderer4, spread_props([breadcrumbData]));
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Message($$renderer3);
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
export {
  _page as default
};
