import { a4 as sanitize_props, a5 as rest_props, a6 as fallback, a7 as attributes, a8 as clsx, a9 as bind_props, a0 as slot, aa as escape_html, ac as attr, ao as sanitize_slots, ag as ensure_array_like, a2 as head, af as spread_props } from "../../../../../chunks/index2.js";
import "clsx";
import { a as Col, R as Row, C as Container } from "../../../../../chunks/Row.js";
import { c as classnames, b as browserEvent } from "../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbOne } from "../../../../../chunks/BreadcrumbOne.js";
import { B as Button } from "../../../../../chunks/Button.js";
import { C as Card } from "../../../../../chunks/Card.js";
import { C as CardBody } from "../../../../../chunks/CardBody.js";
import { C as CardHeader } from "../../../../../chunks/CardHeader.js";
import { I as InlineContainer, P as Portal } from "../../../../../chunks/Portal.js";
function OffcanvasBackdrop($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, ["class", "isOpen", "fade"]);
  $$renderer.component(($$renderer2) => {
    let classes;
    let className = fallback($$props["class"], "");
    let isOpen = fallback($$props["isOpen"], false);
    let fade = fallback($$props["fade"], true);
    classes = classnames(className, "offcanvas-backdrop");
    if (isOpen) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div${attributes({ role: "presentation", ...$$restProps, class: clsx(classes) }, void 0, { fade })}></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]-->`);
    bind_props($$props, { class: className, isOpen, fade });
  });
}
function OffcanvasBody($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, ["class"]);
  $$renderer.component(($$renderer2) => {
    let classes;
    let className = fallback($$props["class"], "");
    classes = classnames(className, "offcanvas-body");
    $$renderer2.push(`<div${attributes({ ...$$restProps, class: clsx(classes) })}><!--[-->`);
    slot($$renderer2, $$props, "default", {}, null);
    $$renderer2.push(`<!--]--></div>`);
    bind_props($$props, { class: className });
  });
}
function OffcanvasHeader($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, ["class", "content", "closeAriaLabel", "toggle"]);
  $$renderer.component(($$renderer2) => {
    let classes;
    let className = fallback($$props["class"], "");
    let content = fallback($$props["content"], void 0);
    let closeAriaLabel = fallback($$props["closeAriaLabel"], "Close");
    let toggle = fallback($$props["toggle"], void 0);
    classes = classnames(className, "offcanvas-header");
    $$renderer2.push(`<div${attributes({ ...$$restProps, class: clsx(classes) })}><h5 class="offcanvas-title">`);
    if (content) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`${escape_html(content)}`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<!--[-->`);
      slot($$renderer2, $$props, "default", {}, null);
      $$renderer2.push(`<!--]-->`);
    }
    $$renderer2.push(`<!--]--></h5> <!--[-->`);
    slot($$renderer2, $$props, "close", {}, () => {
      if (typeof toggle === "function") {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<button${attr("aria-label", closeAriaLabel)} class="btn-close" type="button"></button>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]-->`);
    });
    $$renderer2.push(`<!--]--></div>`);
    bind_props($$props, { class: className, content, closeAriaLabel, toggle });
  });
}
function Offcanvas($$renderer, $$props) {
  const $$slots = sanitize_slots($$props);
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, [
    "class",
    "backdrop",
    "body",
    "container",
    "fade",
    "header",
    "isOpen",
    "keyboard",
    "placement",
    "scroll",
    "sm",
    "md",
    "lg",
    "xl",
    "xxl",
    "style",
    "theme",
    "toggle"
  ]);
  $$renderer.component(($$renderer2) => {
    let classes, outer;
    let className = fallback($$props["class"], "");
    let backdrop = fallback($$props["backdrop"], true);
    let body = fallback($$props["body"], true);
    let container = fallback($$props["container"], "body");
    let fade = fallback($$props["fade"], true);
    let header = fallback($$props["header"], "");
    let isOpen = fallback($$props["isOpen"], false);
    let keyboard = fallback($$props["keyboard"], true);
    let placement = fallback($$props["placement"], "start");
    let scroll = fallback($$props["scroll"], false);
    let sm = fallback($$props["sm"], false);
    let md = fallback($$props["md"], false);
    let lg = fallback($$props["lg"], false);
    let xl = fallback($$props["xl"], false);
    let xxl = fallback($$props["xxl"], false);
    let style = fallback($$props["style"], "");
    let theme = fallback($$props["theme"], null);
    let toggle = fallback($$props["toggle"], void 0);
    let isTransitioning = false;
    let removeEscListener;
    if (isOpen && toggle && typeof window !== "undefined") {
      removeEscListener = browserEvent(document, "keydown", (event) => {
        if (event.key && event.key === "Escape" && keyboard) {
          toggle();
        }
      });
    }
    if (!isOpen && removeEscListener) {
      removeEscListener();
    }
    classes = classnames(
      {
        offcanvas: !sm && !md && !lg && !xl && !xxl,
        "offcanvas-sm": sm,
        "offcanvas-md": md,
        "offcanvas-lg": lg,
        "offcanvas-xl": xl,
        "offcanvas-xxl": xxl,
        show: isOpen
      },
      `offcanvas-${placement}`,
      className
    );
    outer = container === "inline" ? InlineContainer : Portal;
    $$renderer2.push("<!---->");
    outer?.($$renderer2, {
      children: ($$renderer3) => {
        $$renderer3.push(`<div${attributes({
          ...$$restProps,
          "aria-hidden": !isOpen ? true : void 0,
          "aria-modal": isOpen ? true : void 0,
          class: clsx(classes),
          role: isOpen ? "dialog" : void 0,
          "data-bs-theme": theme,
          style: `visibility: ${isOpen || isTransitioning ? "visible" : "hidden"};${style}`,
          tabindex: "-1"
        })}>`);
        if (toggle || header || $$slots.header) {
          $$renderer3.push("<!--[-->");
          OffcanvasHeader($$renderer3, {
            toggle,
            children: ($$renderer4) => {
              if (header) {
                $$renderer4.push("<!--[-->");
                $$renderer4.push(`${escape_html(header)}`);
              } else {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]--> <!--[-->`);
              slot($$renderer4, $$props, "header", {}, null);
              $$renderer4.push(`<!--]-->`);
            },
            $$slots: { default: true }
          });
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--> `);
        if (body) {
          $$renderer3.push("<!--[-->");
          OffcanvasBody($$renderer3, {
            children: ($$renderer4) => {
              $$renderer4.push(`<!--[-->`);
              slot($$renderer4, $$props, "default", {}, null);
              $$renderer4.push(`<!--]-->`);
            },
            $$slots: { default: true }
          });
        } else {
          $$renderer3.push("<!--[!-->");
          $$renderer3.push(`<!--[-->`);
          slot($$renderer3, $$props, "default", {}, null);
          $$renderer3.push(`<!--]-->`);
        }
        $$renderer3.push(`<!--]--></div> `);
        if (backdrop) {
          $$renderer3.push("<!--[-->");
          OffcanvasBackdrop($$renderer3, { fade, isOpen });
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]-->`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!---->`);
    bind_props($$props, {
      class: className,
      backdrop,
      body,
      container,
      fade,
      header,
      isOpen,
      keyboard,
      placement,
      scroll,
      sm,
      md,
      lg,
      xl,
      xxl,
      style,
      theme,
      toggle
    });
  });
}
function Drawer($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let open = false;
    let endOpen = false;
    let bottomOpen = false;
    let topOpen = false;
    const toggle = () => open = !open;
    const toggleEnd = () => endOpen = !endOpen;
    const toggleBottom = () => bottomOpen = !bottomOpen;
    const toggleTop = () => topOpen = !topOpen;
    let userInfo = false;
    const toggleUserInfo = () => userInfo = !userInfo;
    let userAccount = false;
    const toggleUserAccount = () => userAccount = !userAccount;
    let multiDrawer = false;
    const toggleMultiDrawer = () => multiDrawer = !multiDrawer;
    let multiDrawerChild = false;
    const toggleMultiDrawerChild = () => multiDrawerChild = !multiDrawerChild;
    const personalData = [
      { label: "Full Name", text: "Lily Bett" },
      { label: "Account", text: "user@example.com" },
      { label: "City", text: "Toronto" },
      { label: "Country", text: "Canada" },
      { label: "Birthday", text: "October 26, 2022" },
      { label: "Website", text: "-" },
      {
        label: "Message",
        text: "Make things as simple as possible but no simpler."
      }
    ];
    const companyData = [
      { label: "Position", text: "Software Engineer" },
      { label: "Responsibilities", text: "Coding" },
      { label: "Department", text: "XTech" },
      { label: "Supervisor", text: "Jhon Smith" },
      { label: "Joined on", text: "February 10, 2015" },
      { label: "Website", text: "-" },
      {
        label: "Skills",
        text: "C / C + +, data structures, software engineering, operating systems, computer networks, databases, compiler theory, computer architecture, Microcomputer Principle and Interface Technology, Computer English, Java, ASP, etc."
      }
    ];
    const contactData = [
      { label: "Email", text: "user@companymail.com" },
      { label: "Phone Number", text: "+123 456 7890" },
      { label: "Github", text: "github.com/profile/user" }
    ];
    Col($$renderer2, {
      lg: 6,
      children: ($$renderer3) => {
        Card($$renderer3, {
          class: "card-default card-md mb-4",
          children: ($$renderer4) => {
            CardHeader($$renderer4, {
              children: ($$renderer5) => {
                $$renderer5.push(`<h6>Basic</h6>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            CardBody($$renderer4, {
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="drawer-btn">`);
                Button($$renderer5, {
                  color: "primary",
                  size: "default",
                  class: "btn-squared",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->Open`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        Card($$renderer3, {
          class: "card-default card-md mb-4",
          children: ($$renderer4) => {
            CardHeader($$renderer4, {
              children: ($$renderer5) => {
                $$renderer5.push(`<h6>Preview draw</h6>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            CardBody($$renderer4, {
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="drawer-profile-box"><div class="drawer-profile-box__single d-flex justify-content-between align-items-center"><div class="profile-author media align-items-center"><img src="/img/tm4.png" alt="authorImg"/> <div class="profile-text media-body"><span class="author-name">David</span> <p class="author-title">Progresser XTech</p></div></div> <a href="#">View Profile</a></div> <div class="drawer-profile-box__single d-flex justify-content-between align-items-center"><div class="profile-author media align-items-center"><img src="/img/tm4.png" alt="authorImg"/> <div class="profile-text media-body"><span class="author-name">David</span> <p class="author-title">Progresser XTech</p></div></div> <a href="#">View Profile</a></div></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----> `);
    Col($$renderer2, {
      lg: 6,
      children: ($$renderer3) => {
        Card($$renderer3, {
          class: "card-default card-md mb-4",
          children: ($$renderer4) => {
            CardHeader($$renderer4, {
              children: ($$renderer5) => {
                $$renderer5.push(`<h6>Custom Placement</h6>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            CardBody($$renderer4, {
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="drawer-placement-wrap d-flex align-items-center svelte-17u0q6k"><div class="buttons-list d-flex svelte-17u0q6k">`);
                Button($$renderer5, {
                  color: "primary",
                  size: "sm",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->Left`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                Button($$renderer5, {
                  color: "success",
                  size: "sm",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->Top`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                Button($$renderer5, {
                  color: "danger",
                  size: "sm",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->Right`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                Button($$renderer5, {
                  color: "warning",
                  size: "sm",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->Bottom`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----></div></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        Card($$renderer3, {
          class: "card-default card-md mb-4",
          children: ($$renderer4) => {
            CardHeader($$renderer4, {
              children: ($$renderer5) => {
                $$renderer5.push(`<h6>Submit form in drawer</h6>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            CardBody($$renderer4, {
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="drawer-btn d-flex justify-content-center">`);
                Button($$renderer5, {
                  color: "primary",
                  size: "default",
                  class: "btn-squared",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->+ New account`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        Card($$renderer3, {
          class: "card-default card-md mb-4",
          children: ($$renderer4) => {
            CardHeader($$renderer4, {
              children: ($$renderer5) => {
                $$renderer5.push(`<h6>Multi-level drawer</h6>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            CardBody($$renderer4, {
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="drawer-btn d-flex justify-content-center">`);
                Button($$renderer5, {
                  color: "primary",
                  size: "default",
                  class: "btn-squared",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->Open Drawer`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----> <div class="drawer-basic-wrap">`);
    Offcanvas($$renderer2, {
      isOpen: open,
      toggle,
      header: "Start",
      placement: "start",
      class: "drawer-basic"
    });
    $$renderer2.push(`<!----> `);
    Offcanvas($$renderer2, {
      isOpen: endOpen,
      toggle: toggleEnd,
      placement: "end",
      header: "Right",
      class: "drawer-basic"
    });
    $$renderer2.push(`<!----> `);
    Offcanvas($$renderer2, {
      isOpen: topOpen,
      toggle: toggleTop,
      placement: "top",
      header: "Top",
      class: "drawer-basic"
    });
    $$renderer2.push(`<!----> `);
    Offcanvas($$renderer2, {
      isOpen: bottomOpen,
      toggle: toggleBottom,
      placement: "bottom",
      header: "Bottom",
      class: "drawer-basic"
    });
    $$renderer2.push(`<!----> `);
    Offcanvas($$renderer2, {
      isOpen: userAccount,
      toggle: toggleUserAccount,
      placement: "end",
      header: "Create a new account",
      class: "drawer-account",
      children: ($$renderer3) => {
        $$renderer3.push(`<div class="dm-drawer__body p-15 py-10"><div class="drawer-content"><div class="drawer-account-form form-basic"><form action="#">`);
        Row($$renderer3, {
          children: ($$renderer4) => {
            Col($$renderer4, {
              lg: 6,
              class: "form-group",
              children: ($$renderer5) => {
                $$renderer5.push(`<label for="username">Name</label> <input type="text" name="name" id="username" class="form-control form-control-sm" placeholder="Please Enter Your Name"/>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              lg: 6,
              class: "form-group",
              children: ($$renderer5) => {
                $$renderer5.push(`<label for="url">Url</label> <input type="url" name="name" id="url" class="form-control form-control-sm" placeholder="Please Enter URL"/>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              lg: 6,
              class: "form-group",
              children: ($$renderer5) => {
                $$renderer5.push(`<label for="owner">Owner</label> <select name="url" id="owner" class="form-control-sm form-control form-select">`);
                $$renderer5.option({ value: "" }, ($$renderer6) => {
                  $$renderer6.push(`Jack Ma`);
                });
                $$renderer5.option({ value: "" }, ($$renderer6) => {
                  $$renderer6.push(`Tom liu`);
                });
                $$renderer5.push(`</select>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              lg: 6,
              class: "form-group",
              children: ($$renderer5) => {
                $$renderer5.push(`<label for="type">Type</label> <select name="url" id="type" class="form-control-sm form-control form-select">`);
                $$renderer5.option({ value: "" }, ($$renderer6) => {
                  $$renderer6.push(`Jack Ma`);
                });
                $$renderer5.option({ value: "" }, ($$renderer6) => {
                  $$renderer6.push(`Tom liu`);
                });
                $$renderer5.push(`</select>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              lg: 6,
              class: "form-group",
              children: ($$renderer5) => {
                $$renderer5.push(`<label for="approver">Approver</label> <select name="url" id="approver" class="form-control-sm form-control form-select">`);
                $$renderer5.option({ value: "" }, ($$renderer6) => {
                  $$renderer6.push(`Jack Ma`);
                });
                $$renderer5.option({ value: "" }, ($$renderer6) => {
                  $$renderer6.push(`Tom liu`);
                });
                $$renderer5.push(`</select>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              lg: 6,
              class: "form-group",
              children: ($$renderer5) => {
                $$renderer5.push(`<label for="datepicker">DateTime</label> <input type="text" name="name" id="datepicker" class="form-control form-control-sm" placeholder="Please Enter URL"/>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              lg: 12,
              class: "form-group",
              children: ($$renderer5) => {
                $$renderer5.push(`<label for="description">Discription</label> <textarea name="description" id="description" class="form-control form-control-sm" placeholder="PLease Enter Url Description"></textarea>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----></form></div></div></div>`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----> `);
    Offcanvas($$renderer2, {
      isOpen: userInfo,
      toggle: toggleUserInfo,
      placement: "end",
      header: "Right",
      class: "dm-drawer drawer-profile",
      children: ($$renderer3) => {
        $$renderer3.push(`<div class="dm-drawer__body"><div class="drawer-content"><h6>User Profile</h6> <div class="profile-info-box"><div class="profile-info-box__single"><h6>Personal</h6> <div class="profile-info d-flex flex-wrap"><!--[-->`);
        const each_array = ensure_array_like(personalData);
        for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
          let item = each_array[$$index];
          $$renderer3.push(`<div class="profile-info__single"><span class="profile-info__label">${escape_html(item.label)}:</span> <span class="profile-info__text">${escape_html(item.text)}</span></div>`);
        }
        $$renderer3.push(`<!--]--></div></div> <div class="profile-info-box__single"><h6>Company</h6> <div class="profile-info d-flex flex-wrap"><!--[-->`);
        const each_array_1 = ensure_array_like(companyData);
        for (let $$index_1 = 0, $$length = each_array_1.length; $$index_1 < $$length; $$index_1++) {
          let item = each_array_1[$$index_1];
          $$renderer3.push(`<div class="profile-info__single"><span class="profile-info__label">${escape_html(item.label)}:</span> <span class="profile-info__text">${escape_html(item.text)}</span></div>`);
        }
        $$renderer3.push(`<!--]--></div></div> <div class="profile-info-box__single"><h6>Conact</h6> <div class="profile-info d-flex flex-wrap"><!--[-->`);
        const each_array_2 = ensure_array_like(contactData);
        for (let $$index_2 = 0, $$length = each_array_2.length; $$index_2 < $$length; $$index_2++) {
          let item = each_array_2[$$index_2];
          $$renderer3.push(`<div class="profile-info__single"><span class="profile-info__label">${escape_html(item.label)}:</span> <span class="profile-info__text">${escape_html(item.text)}</span></div>`);
        }
        $$renderer3.push(`<!--]--></div></div></div></div></div>`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----> `);
    Offcanvas($$renderer2, {
      isOpen: multiDrawer,
      toggle: toggleMultiDrawer,
      placement: "end",
      header: "Two-level Drawer",
      class: "dm-drawer drawer-multiple",
      children: ($$renderer3) => {
        $$renderer3.push(`<div class="custom-drawer__body p-15 py-10"><div class="drawer-content"><p>Some Content</p> `);
        Button($$renderer3, {
          color: "primary",
          size: "dafault",
          class: "btn-squared",
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->Two Lavel Drawer`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----></div></div>`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----> `);
    Offcanvas($$renderer2, {
      isOpen: multiDrawerChild,
      toggle: toggleMultiDrawerChild,
      header: "Two-level Drawer 2",
      placement: "end",
      children: ($$renderer3) => {
        $$renderer3.push(`<div class="custom-drawer__body"><div class="drawer-content"><p>Some Content</p></div></div>`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></div>`);
  });
}
function _page($$renderer) {
  const breadcrumbData = {
    pageTitle: "Drawer",
    bcItem: "Dashboard",
    bcItemActive: "Drawer"
  };
  head("l64hrp", $$renderer, ($$renderer2) => {
    $$renderer2.title(($$renderer3) => {
      $$renderer3.push(`<title>Drawer</title>`);
    });
  });
  $$renderer.push(`<div class="component-page mb-25">`);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              BreadcrumbOne($$renderer4, spread_props([breadcrumbData]));
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Drawer($$renderer3);
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
export {
  _page as default
};
