import { ag as ensure_array_like, ad as attr_class, ac as attr, ae as stringify, aa as escape_html, a2 as head, af as spread_props } from "../../../../../chunks/index2.js";
import "clsx";
import { C as Container, R as Row, a as Col } from "../../../../../chunks/Row.js";
import "../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbOne } from "../../../../../chunks/BreadcrumbOne.js";
import { C as Card } from "../../../../../chunks/Card.js";
import { C as CardBody } from "../../../../../chunks/CardBody.js";
import { C as CardHeader } from "../../../../../chunks/CardHeader.js";
const DraggableListData = [
  {
    id: "1",
    name: "Kellie Marquot",
    company: "Shipment Marquot",
    orders: "121",
    amount: "84398.75",
    date: "January 20, 2023",
    img: "tm1.png"
  },
  {
    id: "2",
    name: "Robert Clinton",
    company: "Shipment Marquot",
    orders: "324",
    amount: "84399.75",
    date: "January 20, 2023",
    img: "tm2.png"
  },
  {
    id: "3",
    name: "Chris Joe",
    company: "Shipment Marquot",
    orders: "546",
    amount: "84400.75",
    date: "January 20, 2023",
    img: "tm3.png"
  },
  {
    id: "4",
    name: "Jack Kalis",
    company: "Shipment Marquot",
    orders: "435",
    amount: "84401.75",
    date: "January 20, 2023",
    img: "tm4.png"
  },
  {
    id: "5",
    name: "Black Smith",
    company: "Shipment Marquot",
    orders: "677",
    amount: "84402.75",
    date: "January 20, 2023",
    img: "tm5.png"
  },
  {
    id: "6",
    name: "Aftab Ahmed",
    company: "Shipment Marquot",
    orders: "768",
    amount: "84403.75",
    date: "January 20, 2023",
    img: "tm6.png"
  },
  {
    id: "7",
    name: "Daniel White",
    company: "Shipment Marquot",
    orders: "345",
    amount: "84404.75",
    date: "January 20, 2023",
    img: "tm7.png"
  },
  {
    id: "8",
    name: "Chris john",
    company: "Shipment Marquot",
    orders: "546",
    amount: "84405.75",
    date: "January 20, 2023",
    img: "tm8.png"
  },
  {
    id: "9",
    name: "David Manal",
    company: "Shipment Marquot",
    orders: "678",
    amount: "84406.75",
    date: "January 20, 2023",
    img: "tm9.png"
  }
];
function DraggableList($$renderer) {
  let tableData = DraggableListData;
  let hovering = false;
  Card($$renderer, {
    class: "mb-25",
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        children: ($$renderer3) => {
          $$renderer3.push(`<h6>Draggable List</h6>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        class: "pt-0 pb-0",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="drag-drop-wrap svelte-t1wf20"><div class="drag-drop table-responsive-lg w-100 mb-30 svelte-t1wf20"><table class="table mb-0 table-basic svelte-t1wf20"><tbody><!--[-->`);
          const each_array = ensure_array_like(tableData);
          for (let index = 0, $$length = each_array.length; index < $$length; index++) {
            let item = each_array[index];
            $$renderer3.push(`<tr${attr_class("draggable-item svelte-t1wf20", void 0, { "is-active": hovering === index })}${attr("draggable", true)}><td class="svelte-t1wf20"><div class="item d-flex align-items-center svelte-t1wf20"><img class="svg" alt="" src="/img/svg/move.svg"/> <div class="item-info d-flex align-items-center svelte-t1wf20"><img${attr("src", `/img/${stringify(item.img)}`)} alt="authorImg" class="svelte-t1wf20"/> <div class="item_title svelte-t1wf20"><h6 class="svelte-t1wf20"><a href="#" class="svelte-t1wf20">${escape_html(item.name)}</a></h6></div></div></div></td><td class="svelte-t1wf20">${escape_html(item.company)}</td><td class="svelte-t1wf20">${escape_html(item.orders)}</td><td class="svelte-t1wf20">$${escape_html(item.amount)}</td><td class="svelte-t1wf20"><span class="date svelte-t1wf20">${escape_html(item.date)}</span></td><td class="svelte-t1wf20"><div class="table-actions"><a href="#"><img class="svg" alt="" src="/img/svg/edit.svg"/></a> <a href="#"><img class="svg" alt="" src="/img/svg/trash-2.svg"/></a></div></td></tr>`);
          }
          $$renderer3.push(`<!--]--></tbody></table></div></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
}
function _page($$renderer) {
  const breadcrumbData = {
    pageTitle: "Draggable List",
    bcItem: "Dashboard",
    bcItemActive: "Draggable List"
  };
  head("1k2sby", $$renderer, ($$renderer2) => {
    $$renderer2.title(($$renderer3) => {
      $$renderer3.push(`<title>Draggable List</title>`);
    });
  });
  $$renderer.push(`<div class="component-page mb-25">`);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              BreadcrumbOne($$renderer4, spread_props([breadcrumbData]));
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              DraggableList($$renderer4);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
export {
  _page as default
};
