import { a4 as sanitize_props, a5 as rest_props, af as spread_props, a0 as slot, ag as ensure_array_like, aa as escape_html, ae as stringify, a2 as head } from "../../../../../chunks/index2.js";
import "clsx";
import { R as Row, a as Col, C as Container } from "../../../../../chunks/Row.js";
import "../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbOne } from "../../../../../chunks/BreadcrumbOne.js";
import { B as Button } from "../../../../../chunks/Button.js";
import { D as Dropdown, a as DropdownToggle, b as DropdownMenu } from "../../../../../chunks/DropdownToggle.js";
import { B as ButtonGroup } from "../../../../../chunks/ButtonGroup.js";
import { C as Card } from "../../../../../chunks/Card.js";
import { C as CardBody } from "../../../../../chunks/CardBody.js";
import { C as CardHeader } from "../../../../../chunks/CardHeader.js";
function ButtonDropdown($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, []);
  Dropdown($$renderer, spread_props([
    $$restProps,
    {
      group: true,
      children: ($$renderer2) => {
        $$renderer2.push(`<!--[-->`);
        slot($$renderer2, $$props, "default", {}, null);
        $$renderer2.push(`<!--]-->`);
      },
      $$slots: { default: true }
    }
  ]));
}
function Buttons($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const buttonColors = [
      "primary",
      "secondary",
      "success",
      "info",
      "warning",
      "danger",
      "dark",
      "light",
      "white"
    ];
    Row($$renderer2, {
      children: ($$renderer3) => {
        Col($$renderer3, {
          lg: 6,
          children: ($$renderer4) => {
            Card($$renderer4, {
              class: "card-default card-md mb-4",
              children: ($$renderer5) => {
                CardHeader($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<h6>Basic</h6>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                CardBody($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<div class="buttons-list d-flex flex-wrap"><!--[-->`);
                    const each_array = ensure_array_like(buttonColors);
                    for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
                      let color = each_array[$$index];
                      Button($$renderer6, {
                        color,
                        class: "btn-default btn-squared radius-xs fs-15 fw-400 text-capitalize",
                        children: ($$renderer7) => {
                          $$renderer7.push(`<!---->${escape_html(color.charAt(0).toUpperCase() + color.slice(1))}`);
                        },
                        $$slots: { default: true }
                      });
                    }
                    $$renderer6.push(`<!--]--></div>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!---->`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Card($$renderer4, {
              class: "card-default card-md mb-4",
              children: ($$renderer5) => {
                CardHeader($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<h6>Light Color</h6>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                CardBody($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<div class="buttons-list d-flex flex-wrap"><!--[-->`);
                    const each_array_1 = ensure_array_like(buttonColors);
                    for (let $$index_1 = 0, $$length = each_array_1.length; $$index_1 < $$length; $$index_1++) {
                      let color = each_array_1[$$index_1];
                      Button($$renderer6, {
                        color,
                        class: `btn-default btn-squared btn-transparent-${stringify(color)} radius-xs fs-15 fw-400 text-capitalize`,
                        children: ($$renderer7) => {
                          $$renderer7.push(`<!---->${escape_html(color.charAt(0).toUpperCase() + color.slice(1))}`);
                        },
                        $$slots: { default: true }
                      });
                    }
                    $$renderer6.push(`<!--]--></div>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!---->`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Card($$renderer4, {
              class: "card-default card-md mb-4",
              children: ($$renderer5) => {
                CardHeader($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<h6>Rounded</h6>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                CardBody($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<div class="buttons-list d-flex flex-wrap"><!--[-->`);
                    const each_array_2 = ensure_array_like(buttonColors);
                    for (let $$index_2 = 0, $$length = each_array_2.length; $$index_2 < $$length; $$index_2++) {
                      let color = each_array_2[$$index_2];
                      Button($$renderer6, {
                        color,
                        class: "btn-default btn-rounded radius-xs fs-15 fw-400 text-capitalize",
                        children: ($$renderer7) => {
                          $$renderer7.push(`<!---->${escape_html(color.charAt(0).toUpperCase() + color.slice(1))}`);
                        },
                        $$slots: { default: true }
                      });
                    }
                    $$renderer6.push(`<!--]--></div>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!---->`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Card($$renderer4, {
              class: "card-default card-md mb-4",
              children: ($$renderer5) => {
                CardHeader($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<h6>Icon</h6>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                CardBody($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<div class="buttons-list d-flex flex-wrap">`);
                    Button($$renderer6, {
                      color: "primary",
                      class: "btn-default btn-squared radius-xs fs-15 fw-400 text-capitalize",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/> Default`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      color: "primary",
                      class: "btn-default btn-squared btn-transparent-primary radius-xs fs-15 fw-400 text-capitalize",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/> Default`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      outline: true,
                      color: "primary",
                      class: "btn-default btn-squared radius-xs fs-15 fw-400 text-capitalize",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/> Default`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      outline: true,
                      color: "light",
                      class: "btn-default btn-squared radius-xs fs-15 fw-400 text-capitalize",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/> Default`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      color: "light",
                      class: "btn-default btn-squared radius-xs fs-15 fw-400 text-capitalize",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/> Default`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      color: "white",
                      class: "btn-default btn-squared btn-shadow-white radius-xs fs-15 fw-400 text-capitalize",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/> Default`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      color: "primary",
                      class: "btn-icon btn-squared radius-xs fs-15 fw-400 text-capitalize",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/>`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      outline: true,
                      color: "primary",
                      class: "btn-icon btn-squared radius-xs fs-15 fw-400 text-capitalize",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/>`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      color: "light",
                      class: "btn-icon btn-squared radius-xs fs-15 fw-400 text-capitalize",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/>`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      color: "light",
                      outline: true,
                      class: "btn-icon btn-squared radius-xs fs-15 fw-400 text-capitalize",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/>`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----></div>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!---->`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Card($$renderer4, {
              class: "card-default card-md mb-4",
              children: ($$renderer5) => {
                CardHeader($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<h6>Size</h6>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                CardBody($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<div class="buttons-list d-flex flex-wrap align-items-end">`);
                    Button($$renderer6, {
                      color: "primary",
                      size: "lg",
                      class: "btn-squared radius-xs fs-15 fw-400 text-capitalize",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<!---->Large Buton`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      color: "secondary",
                      size: "default",
                      class: "btn-squared radius-xs fs-15 fw-400 text-capitalize",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<!---->Default`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      color: "success",
                      size: "sm",
                      class: "btn-squared radius-xs fs-15 fw-400 text-capitalize",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<!---->Small`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      color: "info",
                      size: "xs",
                      class: "btn-squared radius-xs fs-15 fw-400 text-capitalize",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<!---->Extra Small`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----></div>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!---->`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Card($$renderer4, {
              class: "card-default card-md mb-4",
              children: ($$renderer5) => {
                CardHeader($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<h6>Multiple Buttons</h6>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                CardBody($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<div class="buttons-list d-flex flex-wrap align-items-end">`);
                    Button($$renderer6, {
                      color: "primary",
                      class: "btn-default btn-squared radius-xs fs-15 fw-400 text-capitalize",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<!---->Primary`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      color: "secondary",
                      class: "btn-default btn-squared radius-xs fs-15 fw-400 text-capitalize",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<!---->Secondary`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    ButtonDropdown($$renderer6, {
                      children: ($$renderer7) => {
                        DropdownToggle($$renderer7, {
                          class: "radius-xs fs-15 fw-400 text-capitalize",
                          color: "light",
                          children: ($$renderer8) => {
                            $$renderer8.push(`<!---->Actions <i class="la la-angle-down"></i>`);
                          },
                          $$slots: { default: true }
                        });
                        $$renderer7.push(`<!----> `);
                        DropdownMenu($$renderer7, {
                          children: ($$renderer8) => {
                            $$renderer8.push(`<a class="dropdown-item" href="#">Btn Action One</a> <a class="dropdown-item" href="#">Btn Action Two</a> <a class="dropdown-item" href="#">Btn Action Three</a>`);
                          },
                          $$slots: { default: true }
                        });
                        $$renderer7.push(`<!---->`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----></div>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!---->`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Card($$renderer4, {
              class: "card-default card-md mb-4",
              children: ($$renderer5) => {
                CardHeader($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<h6>Group Button</h6>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                CardBody($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<div class="buttons-block"><h6>Basic</h6> <div class="button-inline-list my-n2">`);
                    ButtonGroup($$renderer6, {
                      class: "custom-button-group btn-group-normal my-2",
                      children: ($$renderer7) => {
                        Button($$renderer7, {
                          class: "fs-15 fw-400 text-capitalize",
                          color: "light",
                          size: "xs",
                          outline: true,
                          active: true,
                          children: ($$renderer8) => {
                            $$renderer8.push(`<!---->Today`);
                          },
                          $$slots: { default: true }
                        });
                        $$renderer7.push(`<!----> `);
                        Button($$renderer7, {
                          class: "fs-15 fw-400 text-capitalize",
                          color: "light",
                          size: "xs",
                          outline: true,
                          children: ($$renderer8) => {
                            $$renderer8.push(`<!---->Week`);
                          },
                          $$slots: { default: true }
                        });
                        $$renderer7.push(`<!----> `);
                        Button($$renderer7, {
                          class: "fs-15 fw-400 text-capitalize",
                          color: "light",
                          size: "xs",
                          outline: true,
                          children: ($$renderer8) => {
                            $$renderer8.push(`<!---->Month`);
                          },
                          $$slots: { default: true }
                        });
                        $$renderer7.push(`<!----> `);
                        Button($$renderer7, {
                          class: "fs-15 fw-400 text-capitalize",
                          color: "light",
                          size: "xs",
                          outline: true,
                          children: ($$renderer8) => {
                            $$renderer8.push(`<!---->Year`);
                          },
                          $$slots: { default: true }
                        });
                        $$renderer7.push(`<!---->`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    ButtonGroup($$renderer6, {
                      class: "custom-button-group btn-group-normal my-2",
                      children: ($$renderer7) => {
                        Button($$renderer7, {
                          class: "fs-15 fw-400 text-capitalize",
                          color: "light",
                          size: "xs",
                          outline: true,
                          children: ($$renderer8) => {
                            $$renderer8.push(`<!---->Cancel`);
                          },
                          $$slots: { default: true }
                        });
                        $$renderer7.push(`<!----> `);
                        Button($$renderer7, {
                          class: "fs-15 fw-400 text-capitalize",
                          color: "light",
                          size: "xs",
                          outline: true,
                          children: ($$renderer8) => {
                            $$renderer8.push(`<!---->Ok`);
                          },
                          $$slots: { default: true }
                        });
                        $$renderer7.push(`<!---->`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    ButtonGroup($$renderer6, {
                      class: "custom-button-group btn-group-solid my-2",
                      children: ($$renderer7) => {
                        Button($$renderer7, {
                          class: "fs-15 fw-400 text-capitalize",
                          color: "light",
                          size: "xs",
                          outline: true,
                          children: ($$renderer8) => {
                            $$renderer8.push(`<!---->Left`);
                          },
                          $$slots: { default: true }
                        });
                        $$renderer7.push(`<!----> `);
                        Button($$renderer7, {
                          class: "fs-15 fw-400 text-capitalize",
                          color: "light",
                          size: "xs",
                          outline: true,
                          children: ($$renderer8) => {
                            $$renderer8.push(`<!---->Middle`);
                          },
                          $$slots: { default: true }
                        });
                        $$renderer7.push(`<!----> `);
                        Button($$renderer7, {
                          class: "fs-15 fw-400 text-capitalize",
                          color: "light",
                          size: "xs",
                          outline: true,
                          children: ($$renderer8) => {
                            $$renderer8.push(`<!---->Right`);
                          },
                          $$slots: { default: true }
                        });
                        $$renderer7.push(`<!---->`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----></div></div> <div class="buttons-block mt-30"><h6>With Icon</h6> <div class="button-inline-list">`);
                    ButtonGroup($$renderer6, {
                      class: "custom-button-group btn-group-withIcon my-2",
                      children: ($$renderer7) => {
                        Button($$renderer7, {
                          class: "fs-15 fw-400 text-capitalize",
                          color: "primary",
                          size: "xs",
                          active: true,
                          children: ($$renderer8) => {
                            $$renderer8.push(`<img class="svg" alt="" src="/img/svg/chevron-left.svg"/> Go Back`);
                          },
                          $$slots: { default: true }
                        });
                        $$renderer7.push(`<!----> `);
                        Button($$renderer7, {
                          class: "fs-15 fw-400 text-capitalize",
                          color: "primary",
                          size: "xs",
                          children: ($$renderer8) => {
                            $$renderer8.push(`<!---->Go Forward <img class="svg" alt="" src="/img/svg/chevron-right.svg"/>`);
                          },
                          $$slots: { default: true }
                        });
                        $$renderer7.push(`<!---->`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----></div></div>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!---->`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Card($$renderer4, {
              class: "card-default card-md mb-4",
              children: ($$renderer5) => {
                CardHeader($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<h6>Block</h6>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                CardBody($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<div class="buttons-list">`);
                    Button($$renderer6, {
                      block: true,
                      color: "primary",
                      size: "lg",
                      class: "btn-squared   radius-xs fs-15 fw-400 text-capitalize",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<!---->Large Button`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      block: true,
                      color: "secondary",
                      size: "default",
                      class: "btn-squared   radius-xs fs-15 fw-400 text-capitalize",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<!---->Default`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      block: true,
                      color: "success",
                      size: "sm",
                      class: "btn-squared   radius-xs fs-15 fw-400 text-capitalize",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<!---->Small`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      block: true,
                      color: "info",
                      size: "xs",
                      class: "btn-squared   radius-xs fs-15 fw-400 text-capitalize",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<!---->Extra Small`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----></div>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!---->`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        Col($$renderer3, {
          lg: 6,
          children: ($$renderer4) => {
            Card($$renderer4, {
              class: "card-default card-md mb-4",
              children: ($$renderer5) => {
                CardHeader($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<h6>Outline</h6>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                CardBody($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<div class="buttons-list d-flex flex-wrap"><!--[-->`);
                    const each_array_3 = ensure_array_like(buttonColors);
                    for (let $$index_3 = 0, $$length = each_array_3.length; $$index_3 < $$length; $$index_3++) {
                      let color = each_array_3[$$index_3];
                      Button($$renderer6, {
                        size: "default",
                        color,
                        outline: true,
                        class: "btn-squared radius-xs fs-15 fw-400 text-capitalize",
                        children: ($$renderer7) => {
                          $$renderer7.push(`<!---->${escape_html(color.charAt(0).toUpperCase() + color.slice(1))}`);
                        },
                        $$slots: { default: true }
                      });
                    }
                    $$renderer6.push(`<!--]--> `);
                    Button($$renderer6, {
                      size: "default",
                      outline: true,
                      class: "btn-squared color-dashed btn-outline-dashed radius-xs fs-15 fw-400 text-capitalize",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<!---->Dashed`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----></div>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!---->`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Card($$renderer4, {
              class: "card-default card-md mb-4",
              children: ($$renderer5) => {
                CardHeader($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<h6>Shadow</h6>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                CardBody($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<div class="buttons-list d-flex flex-wrap"><!--[-->`);
                    const each_array_4 = ensure_array_like(buttonColors);
                    for (let $$index_4 = 0, $$length = each_array_4.length; $$index_4 < $$length; $$index_4++) {
                      let color = each_array_4[$$index_4];
                      Button($$renderer6, {
                        color,
                        size: "default",
                        class: `radius-xs fs-15 fw-400 text-capitalize btn-squared btn-shadow-${stringify(color)}`,
                        children: ($$renderer7) => {
                          $$renderer7.push(`<!---->${escape_html(color.charAt(0).toUpperCase() + color.slice(1))}`);
                        },
                        $$slots: { default: true }
                      });
                    }
                    $$renderer6.push(`<!--]--></div>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!---->`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Card($$renderer4, {
              class: "card-default card-md mb-4",
              children: ($$renderer5) => {
                CardHeader($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<h6>Rounded Outline</h6>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                CardBody($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<div class="buttons-list d-flex flex-wrap"><!--[-->`);
                    const each_array_5 = ensure_array_like(buttonColors);
                    for (let $$index_5 = 0, $$length = each_array_5.length; $$index_5 < $$length; $$index_5++) {
                      let color = each_array_5[$$index_5];
                      Button($$renderer6, {
                        color,
                        outline: true,
                        size: "default",
                        class: "radius-xs fs-15 fw-400 text-capitalize btn-rounded",
                        children: ($$renderer7) => {
                          $$renderer7.push(`<!---->${escape_html(color.charAt(0).toUpperCase() + color.slice(1))}`);
                        },
                        $$slots: { default: true }
                      });
                    }
                    $$renderer6.push(`<!--]--> `);
                    Button($$renderer6, {
                      outline: true,
                      size: "default",
                      class: "radius-xs fs-15 fw-400 text-capitalize btn-rounded color-dashed btn-outline-dashed",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<!---->Dashed`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----></div>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!---->`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Card($$renderer4, {
              class: "card-default card-md mb-4",
              children: ($$renderer5) => {
                CardHeader($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<h6>Rounded with Icon</h6>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                CardBody($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<div class="buttons-list d-flex flex-wrap">`);
                    Button($$renderer6, {
                      color: "primary",
                      size: "default",
                      class: "radius-xs fs-15 fw-400 text-capitalize btn-rounded",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/> Default`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      color: "primary",
                      size: "default",
                      class: "radius-xs fs-15 fw-400 text-capitalize btn-rounded btn-transparent-primary",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/> Default`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      color: "primary",
                      outline: true,
                      size: "default",
                      class: "radius-xs fs-15 fw-400 text-capitalize btn-rounded",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/> Default`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      color: "light",
                      outline: true,
                      size: "default",
                      class: "radius-xs fs-15 fw-400 text-capitalize btn-rounded",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/> Default`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      color: "light",
                      size: "default",
                      class: "radius-xs fs-15 fw-400 text-capitalize btn-rounded",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/> Default`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      color: "white",
                      size: "default",
                      class: "radius-xs fs-15 fw-400 text-capitalize btn-squared btn-shadow-white",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/> Default`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      color: "primary",
                      class: "radius-xs fs-15 fw-400 text-capitalize btn-icon btn-circle",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/>`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      color: "primary",
                      outline: true,
                      class: "radius-xs fs-15 fw-400 text-capitalize btn-icon btn-circle",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/>`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      color: "light",
                      class: "radius-xs fs-15 fw-400 text-capitalize btn-icon btn-circle",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/>`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      color: "light",
                      outline: true,
                      class: "radius-xs fs-15 fw-400 text-capitalize btn-icon btn-circle",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/>`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----></div>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!---->`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Card($$renderer4, {
              class: "card-default card-md mb-4",
              children: ($$renderer5) => {
                CardHeader($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<h6>Disabled</h6>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                CardBody($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<div class="buttons-list d-flex flex-wrap align-items-end mb-1">`);
                    Button($$renderer6, {
                      color: "primary",
                      size: "default",
                      class: "radius-xs fs-15 fw-400 text-capitalize btn-squared",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<!---->Primary`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      color: "primary",
                      size: "default",
                      class: "radius-xs fs-15 fw-400 text-capitalize btn-squared",
                      disabled: true,
                      children: ($$renderer7) => {
                        $$renderer7.push(`<!---->Primary (Disabled)`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----></div> <div class="buttons-list d-flex flex-wrap align-items-end">`);
                    Button($$renderer6, {
                      outline: true,
                      color: "dark",
                      size: "default",
                      class: "radius-xs fs-15 fw-400 text-capitalize btn-squared",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<!---->Dark`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      outline: true,
                      color: "dark",
                      size: "default",
                      class: "radius-xs fs-15 fw-400 text-capitalize btn-squared",
                      disabled: true,
                      children: ($$renderer7) => {
                        $$renderer7.push(`<!---->Dark (Disabled)`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----></div>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!---->`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Card($$renderer4, {
              class: "card-default card-md mb-4",
              children: ($$renderer5) => {
                CardHeader($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<h6>Loading</h6>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                CardBody($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<div class="buttons-list d-flex flex-wrap">`);
                    Button($$renderer6, {
                      color: "primary",
                      size: "default",
                      class: "radius-xs fs-15 fw-400 text-capitalize btn-squared",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/> Default`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      color: "primary",
                      size: "default",
                      class: "radius-xs fs-15 fw-400 text-capitalize btn-squared btn-transparent-primary",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/> Default`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      outline: true,
                      color: "primary",
                      size: "default",
                      class: "radius-xs fs-15 fw-400 text-capitalize btn-squared",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/> Default`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      outline: true,
                      color: "light",
                      size: "default",
                      class: "radius-xs fs-15 fw-400 text-capitalize btn-squared",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/> Default`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      color: "light",
                      size: "default",
                      class: "radius-xs fs-15 fw-400 text-capitalize btn-squared",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/> Default`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      color: "white",
                      size: "default",
                      class: "radius-xs fs-15 fw-400 text-capitalize btn-squared btn-shadow-white",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/> Default`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      color: "primary",
                      class: "radius-xs fs-15 fw-400 text-capitalize btn-squared btn-icon",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/>`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      outline: true,
                      color: "primary",
                      class: "radius-xs fs-15 fw-400 text-capitalize btn-squared btn-icon",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/>`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      color: "light",
                      class: "radius-xs fs-15 fw-400 text-capitalize btn-squared btn-icon",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/>`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      outline: true,
                      color: "light",
                      size: "default",
                      class: "radius-xs fs-15 fw-400 text-capitalize btn-squared btn-icon",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/>`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----></div>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!---->`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Card($$renderer4, {
              class: "card-default card-md mb-4",
              children: ($$renderer5) => {
                CardHeader($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<h6>Button Ghost</h6>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                CardBody($$renderer5, {
                  class: "gradient1",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<div class="buttons-list d-flex flex-wrap">`);
                    Button($$renderer6, {
                      color: "ghost",
                      size: "default",
                      class: "radius-xs fs-15 fw-400 text-capitalize btn-squared",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<!---->Primary`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      color: "ghost",
                      size: "default",
                      class: "radius-xs fs-15 fw-400 text-capitalize btn-squared",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<!---->Secondary`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Button($$renderer6, {
                      color: "ghost",
                      size: "default",
                      class: "radius-xs fs-15 fw-400 text-capitalize btn-squared",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<img class="svg" alt="" src="/img/svg/layers.svg"/> Default`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----></div>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!---->`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
function _page($$renderer) {
  const breadcrumbData = {
    pageTitle: "Buttons",
    bcItem: "Dashboard",
    bcItemActive: "Buttons"
  };
  head("1qz9xwx", $$renderer, ($$renderer2) => {
    $$renderer2.title(($$renderer3) => {
      $$renderer3.push(`<title>Buttons</title>`);
    });
  });
  $$renderer.push(`<div class="component-page mb-25">`);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              BreadcrumbOne($$renderer4, spread_props([breadcrumbData]));
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              Buttons($$renderer4);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
export {
  _page as default
};
