import { a4 as sanitize_props, a5 as rest_props, a6 as fallback, a7 as attributes, a8 as clsx, ad as attr_class, aa as escape_html, a0 as slot, a9 as bind_props, a2 as head, af as spread_props } from "../../../../../chunks/index2.js";
import "clsx";
import { R as Row, a as Col, C as Container } from "../../../../../chunks/Row.js";
import { c as classnames } from "../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbOne } from "../../../../../chunks/BreadcrumbOne.js";
import { C as Card } from "../../../../../chunks/Card.js";
import { C as CardBody } from "../../../../../chunks/CardBody.js";
import { C as CardHeader } from "../../../../../chunks/CardHeader.js";
function Breadcrumb($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, ["class", "content", "divider", "listClassName", "style"]);
  $$renderer.component(($$renderer2) => {
    let listClasses, styles;
    let className = fallback($$props["class"], "");
    let content = fallback($$props["content"], "");
    let divider = fallback($$props["divider"], "");
    let listClassName = fallback($$props["listClassName"], "");
    let style = fallback($$props["style"], "");
    listClasses = classnames("breadcrumb", listClassName);
    styles = divider ? `--bs-breadcrumb-divider: '${divider}'; ${style || ""}` : style;
    $$renderer2.push(`<nav${attributes({ style: styles, ...$$restProps, class: clsx(className) })}><ol${attr_class(clsx(listClasses))}>`);
    if (content) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`${escape_html(content)}`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<!--[-->`);
      slot($$renderer2, $$props, "default", {}, null);
      $$renderer2.push(`<!--]-->`);
    }
    $$renderer2.push(`<!--]--></ol></nav>`);
    bind_props($$props, { class: className, content, divider, listClassName, style });
  });
}
function BreadcrumbItem($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, ["class", "active", "content"]);
  $$renderer.component(($$renderer2) => {
    let classes;
    let className = fallback($$props["class"], "");
    let active = fallback($$props["active"], false);
    let content = fallback($$props["content"], "");
    classes = classnames(className, active ? "active" : false, "breadcrumb-item");
    $$renderer2.push(`<li${attributes({
      ...$$restProps,
      class: clsx(classes),
      "aria-current": active ? "page" : void 0
    })}>`);
    if (content) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`${escape_html(content)}`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<!--[-->`);
      slot($$renderer2, $$props, "default", {}, null);
      $$renderer2.push(`<!--]-->`);
    }
    $$renderer2.push(`<!--]--></li>`);
    bind_props($$props, { class: className, active, content });
  });
}
function Breadcrumbs($$renderer) {
  Row($$renderer, {
    children: ($$renderer2) => {
      Col($$renderer2, {
        lg: 6,
        children: ($$renderer3) => {
          Card($$renderer3, {
            class: "card-default card-md mb-4",
            children: ($$renderer4) => {
              CardHeader($$renderer4, {
                children: ($$renderer5) => {
                  $$renderer5.push(`<h6>Bootstrap Default</h6>`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              CardBody($$renderer4, {
                children: ($$renderer5) => {
                  Breadcrumb($$renderer5, {
                    children: ($$renderer6) => {
                      BreadcrumbItem($$renderer6, {
                        children: ($$renderer7) => {
                          $$renderer7.push(`<a href="#home">Home</a>`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!----> `);
                      BreadcrumbItem($$renderer6, {
                        children: ($$renderer7) => {
                          $$renderer7.push(`<a href="#library">Library</a>`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!----> `);
                      BreadcrumbItem($$renderer6, {
                        active: true,
                        children: ($$renderer7) => {
                          $$renderer7.push(`<!---->Data`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!---->`);
                    },
                    $$slots: { default: true }
                  });
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!---->`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Card($$renderer3, {
            class: "card-default card-md mb-4",
            children: ($$renderer4) => {
              CardHeader($$renderer4, {
                children: ($$renderer5) => {
                  $$renderer5.push(`<h6>Custom Basic</h6>`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              CardBody($$renderer4, {
                children: ($$renderer5) => {
                  $$renderer5.push(`<ul class="custom-breadcrumb nav"><li class="custom-breadcrumb__item"><a href="#">Home</a> <span class="breadcrumb__seperator"><span class="la la-slash"></span></span></li> <li class="custom-breadcrumb__item"><a href="#">Application Center</a> <span class="breadcrumb__seperator"><span class="la la-slash"></span></span></li> <li class="custom-breadcrumb__item"><a href="#">Application list</a> <span class="breadcrumb__seperator"><span class="la la-slash"></span></span></li> <li class="custom-breadcrumb__item"><span>An Application</span></li></ul>`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!---->`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Card($$renderer3, {
            class: "card-default card-md mb-4",
            children: ($$renderer4) => {
              CardHeader($$renderer4, {
                children: ($$renderer5) => {
                  $$renderer5.push(`<h6>Breadcrumb with dropdown menu</h6>`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              CardBody($$renderer4, {
                children: ($$renderer5) => {
                  $$renderer5.push(`<ul class="custom-breadcrumb nav"><li class="custom-breadcrumb__item"><a href="#">Home</a> <span class="breadcrumb__seperator"><span class="la la-slash"></span></span></li> <li class="custom-breadcrumb__item"><a href="#">Application Center</a> <span class="breadcrumb__seperator"><span class="la la-slash"></span></span></li> <li class="custom-breadcrumb__item"><div class="dropdown dropdown-hover"><a href="#" data-bs-toggle="dropdown">General</a> <span class="breadcrumb__seperator"><span class="la la-slash"></span></span> <div class="dropdown-default"><a class="dropdown-item" href="#">Item One</a> <a class="dropdown-item" href="#">Item Two</a> <a class="dropdown-item" href="#">Item Three</a></div></div></li> <li class="custom-breadcrumb__item"><span>An Application</span></li></ul>`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!---->`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      Col($$renderer2, {
        lg: 6,
        children: ($$renderer3) => {
          Card($$renderer3, {
            class: "card-default card-md mb-4",
            children: ($$renderer4) => {
              CardHeader($$renderer4, {
                children: ($$renderer5) => {
                  $$renderer5.push(`<h6>Custom Basic with icon</h6>`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              CardBody($$renderer4, {
                children: ($$renderer5) => {
                  $$renderer5.push(`<ul class="custom-breadcrumb nav"><li class="custom-breadcrumb__item"><a href="#"><span class="la la-home"></span></a> <span class="breadcrumb__seperator"><span class="la la-slash"></span></span></li> <li class="custom-breadcrumb__item"><a href="#">Application Center</a> <span class="breadcrumb__seperator"><span class="la la-slash"></span></span></li> <li class="custom-breadcrumb__item"><span>An Application</span></li></ul>`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!---->`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Card($$renderer3, {
            class: "card-default card-md mb-4",
            children: ($$renderer4) => {
              CardHeader($$renderer4, {
                children: ($$renderer5) => {
                  $$renderer5.push(`<h6>Configuring the Separator</h6>`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              CardBody($$renderer4, {
                children: ($$renderer5) => {
                  $$renderer5.push(`<ul class="custom-breadcrumb nav"><li class="custom-breadcrumb__item"><a href="#">Home</a> <span class="breadcrumb__seperator"><span class="la la-angle-right"></span></span></li> <li class="custom-breadcrumb__item"><a href="#">Application Center</a> <span class="breadcrumb__seperator"><span class="la la-angle-right"></span></span></li> <li class="custom-breadcrumb__item"><a href="#">Application list</a> <span class="breadcrumb__seperator"><span class="la la-angle-right"></span></span></li> <li class="custom-breadcrumb__item"><span>An Application</span></li></ul>`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!---->`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Card($$renderer3, {
            class: "card-default card-md mb-4",
            children: ($$renderer4) => {
              CardHeader($$renderer4, {
                children: ($$renderer5) => {
                  $$renderer5.push(`<h6>Configuring the Separator</h6>`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              CardBody($$renderer4, {
                children: ($$renderer5) => {
                  $$renderer5.push(`<ul class="custom-breadcrumb nav"><li class="custom-breadcrumb__item"><a href="#" class="me-1">Location :</a></li> <li class="custom-breadcrumb__item"><a href="#">Application Center</a> <span class="breadcrumb__seperator"><span class="la la-angle-right"></span></span></li> <li class="custom-breadcrumb__item"><a href="#">Application list</a> <span class="breadcrumb__seperator"><span class="la la-angle-right"></span></span></li> <li class="custom-breadcrumb__item"><span>An Application</span></li></ul>`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!---->`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
}
function _page($$renderer) {
  const breadcrumbData = {
    pageTitle: "Breadcrumbs",
    bcItem: "Dashboard",
    bcItemActive: "Breadcrumbs"
  };
  head("1q5snsk", $$renderer, ($$renderer2) => {
    $$renderer2.title(($$renderer3) => {
      $$renderer3.push(`<title>Breadcrumbs</title>`);
    });
  });
  $$renderer.push(`<div class="component-page mb-25">`);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              BreadcrumbOne($$renderer4, spread_props([breadcrumbData]));
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              Breadcrumbs($$renderer4);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
export {
  _page as default
};
