import { ad as attr_class, ac as attr, aa as escape_html, a9 as bind_props, ae as stringify, a8 as clsx, a2 as head, af as spread_props, ag as ensure_array_like } from "../../../../../chunks/index2.js";
import "clsx";
import { C as Container, R as Row, a as Col } from "../../../../../chunks/Row.js";
import "../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbOne } from "../../../../../chunks/BreadcrumbOne.js";
import { o as overviewCardData } from "../../../../../chunks/overviewCard.js";
import { C as Card } from "../../../../../chunks/Card.js";
import { C as CardBody } from "../../../../../chunks/CardBody.js";
import { C as CardHeader } from "../../../../../chunks/CardHeader.js";
import { C as Chartjs } from "../../../../../chunks/Chartjs.js";
import { a as customTooltips, c as chartLinearGradient } from "../../../../../chunks/utilities.js";
import { P as ProfitGrowth, S as SalesOverview } from "../../../../../chunks/SalesOverview.js";
import { b as bestSellersData } from "../../../../../chunks/table-data.js";
import { A as ActiveUsers } from "../../../../../chunks/ActiveUsers.js";
import { T as TopProducts_1, L as LatestTransection } from "../../../../../chunks/LatestTransection.js";
function OverviewCards($$renderer, $$props) {
  let type = $$props["type"];
  let icon = $$props["icon"];
  let total = $$props["total"];
  let prefix = $$props["prefix"];
  let suffix = $$props["suffix"];
  let label = $$props["label"];
  let growth = $$props["growth"];
  let growthRate = $$props["growthRate"];
  $$renderer.push(`<div class="overview-content overview-content3 bg-none"><div class="d-flex align-items-center"><div${attr_class(`revenue-chart-box__Icon me-25 bg-${stringify(type)} color-white`)}><img class="svg" alt=""${attr("src", `/img/svg/${icon}`)}/></div> <div class="d-flex align-items-start flex-wrap"><div class="me-10"><h1>${escape_html(prefix + total + suffix)}</h1> <p class="mt-1 mb-0">${escape_html(label)}</p></div> <div class="ap-po-details bg-none"><span${attr_class(`growth-status ${stringify(growth === "upward" ? "color-success" : "color-danger")}`)}>`);
  if (growth === "upward") {
    $$renderer.push("<!--[-->");
    $$renderer.push(`<span class="uil uil-arrow-up"></span>`);
  } else {
    $$renderer.push("<!--[!-->");
    $$renderer.push(`<span class="uil uil-arrow-down"></span>`);
  }
  $$renderer.push(`<!--]--> <strong>${escape_html(growthRate)}%</strong></span></div></div></div></div>`);
  bind_props($$props, { type, icon, total, prefix, suffix, label, growth, growthRate });
}
function MonthlyEarning($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let salesRevenueDatasets;
    let primaryColor;
    let primaryColorRGB;
    let revenue = "today";
    const tooltip = {
      callbacks: {
        title() {
          return `Total Revenue`;
        },
        label(t) {
          const { formattedValue, dataset } = t;
          return `${formattedValue}k ${dataset.label}`;
        }
      }
    };
    let salesRevenue = {
      today: {
        users: [0, 10, 36, 25, 50, 40, 55, 40, 75, 35, 40, 35],
        labels: [
          "2hr",
          "4hr",
          "6hr",
          "8hr",
          "10hr",
          "12hr",
          "14hr",
          "16hr",
          "18hr",
          "20hr",
          "22hr",
          "24hr"
        ]
      },
      week: {
        users: [40, 30, 35, 20, 25, 40, 35],
        labels: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]
      },
      months: {
        users: [45, 20, 35, 32, 50, 45, 55, 71, 36, 65, 55, 75],
        labels: [
          "Jan",
          "Feb",
          "Mar",
          "App",
          "May",
          "Jun",
          "Jul",
          "Aug",
          "Sep",
          "Nov",
          "Oct",
          "Dec"
        ]
      }
    };
    const scales = {
      y: {
        border: { display: false },
        grid: {
          color: "#E3E6EF",
          borderDash: [3, 3],
          zeroLineColor: "#E3E6EF",
          zeroLineWidth: 1,
          zeroLineBorderDash: [3, 3],
          drawTicks: false,
          drawBorder: false,
          borderWidth: 0
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474",
          Min: 50,
          Max: 80,
          stepSize: 20,
          padding: 15,
          callback(label) {
            return `${label}k`;
          }
        }
      },
      x: {
        border: { display: false },
        grid: {
          display: true,
          zeroLineWidth: 0,
          drawTicks: true,
          drawBorder: false,
          zeroLineColor: "#E3E6EF",
          color: "transparent",
          z: 1
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474"
        }
      }
    };
    let tooltipss = { custom: customTooltips, ...tooltip };
    salesRevenueDatasets = [
      {
        data: salesRevenue[revenue].users,
        borderColor: primaryColor,
        borderWidth: 3,
        fill: true,
        backgroundColor: () => chartLinearGradient(document.getElementById("ninjadash-sales-revenue"), 300, {
          start: `rgba(${primaryColorRGB},0.5)`,
          end: "rgba(255,255,255,0.4)"
        }),
        label: "Current period",
        pointStyle: "circle",
        pointRadius: "0",
        hoverRadius: "6",
        pointBorderColor: "#fff",
        pointBackgroundColor: primaryColor,
        hoverBorderWidth: 2,
        amount: "$7,596",
        amountClass: "current-amount",
        lineTension: 0.5
      }
    ];
    Card($$renderer2, {
      class: "earning-report border-0 h-100",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "border-0",
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>Earning Reports</h6> <div class="card-extra"><ul class="card-tab-links nav"><li><a href="#"${attr_class(clsx("active"))}>Today</a></li> <li><a href="#"${attr_class(clsx(""))}>Week</a></li> <li><a href="#"${attr_class(clsx(""))}>Month</a></li></ul></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="chartLine-po-details__time justify-content-center"><h3>$8,550</h3> <span class="color-success"><i class="uil uil-arrow-up"></i> <strong>25.36</strong></span></div> <div class="wp-chart">`);
            {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<div class="parentContainer">`);
              Chartjs($$renderer4, {
                type: "line",
                id: "ninjadash-sales-revenue",
                className: "ninjadash-sales-revenue",
                labels: salesRevenue[revenue].labels,
                datasets: salesRevenueDatasets,
                scales,
                tooltip: tooltipss,
                height: 108
              });
              $$renderer4.push(`<!----></div>`);
            }
            $$renderer4.push(`<!--]--></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
function ActiveUsers_1($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let users = bestSellersData.activeUserData;
    let period = "today";
    let dataPeriod = users[period];
    Card($$renderer2, {
      class: "border-0 px-25 total-active-user",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "px-0 border-0",
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>Active Users</h6> <div class="card-extra"><ul class="card-tab-links nav"><li><a href="#"${attr_class(clsx("active"))}>Today</a></li> <li><a href="#"${attr_class(clsx(""))}>Week</a></li> <li><a href="#"${attr_class(clsx(""))}>Month</a></li></ul></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          class: "p-0",
          children: ($$renderer4) => {
            ActiveUsers($$renderer4, { dataPeriod });
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const overviewDataSorted = overviewCardData.slice(4, 8);
    const breadcrumbData = {
      pageTitle: "Demo Three",
      bcItem: "Dashboard",
      bcItemActive: "Demo Three"
    };
    head("67utad", $$renderer2, ($$renderer3) => {
      $$renderer3.title(($$renderer4) => {
        $$renderer4.push(`<title>Home Three</title>`);
      });
    });
    $$renderer2.push(`<div class="demo3 mb-25">`);
    Container($$renderer2, {
      fluid: true,
      children: ($$renderer3) => {
        Row($$renderer3, {
          children: ($$renderer4) => {
            Col($$renderer4, {
              lg: 12,
              children: ($$renderer5) => {
                BreadcrumbOne($$renderer5, spread_props([breadcrumbData]));
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 7,
              class: "mb-25",
              children: ($$renderer5) => {
                MonthlyEarning($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 5,
              class: "mb-25",
              children: ($$renderer5) => {
                ProfitGrowth($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 12,
              lg: 6,
              class: "mb-25",
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="ap-po-details ap-po-details--3 h-100 radius-xl d-flex"><!--[-->`);
                const each_array = ensure_array_like(overviewDataSorted);
                for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
                  let item = each_array[$$index];
                  OverviewCards($$renderer5, spread_props([item]));
                }
                $$renderer5.push(`<!--]--></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 4,
              lg: 6,
              class: "mb-25",
              children: ($$renderer5) => {
                SalesOverview($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 4,
              class: "mb-25",
              children: ($$renderer5) => {
                TopProducts_1($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 4,
              class: "mb-25",
              children: ($$renderer5) => {
                LatestTransection($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 12,
              class: "mb-25",
              children: ($$renderer5) => {
                ActiveUsers_1($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></div>`);
  });
}
export {
  _page as default
};
