import { ad as attr_class, a8 as clsx, ag as ensure_array_like, ae as stringify, aa as escape_html, ac as attr, a2 as head } from "../../../../../chunks/index2.js";
import "clsx";
import { R as Row, a as Col, C as Container } from "../../../../../chunks/Row.js";
import "../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { M as MembersProgress, E as Events, e as eventData, B as BlogCard, P as PageHeaderBanner, C as Calendar, K as KnowledgeBase } from "../../../../../chunks/BlogCard.js";
import { C as Card } from "../../../../../chunks/Card.js";
import { C as CardBody } from "../../../../../chunks/CardBody.js";
import { C as CardHeader } from "../../../../../chunks/CardHeader.js";
import { C as Chartjs } from "../../../../../chunks/Chartjs.js";
import { d as doughnutData } from "../../../../../chunks/dashboardChartContent.js";
import { b as bestSellersData } from "../../../../../chunks/table-data.js";
import { C as CardExtra } from "../../../../../chunks/CardExtra.js";
function UserOverview($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let userOverviewDataset;
    let { userOverviewData } = doughnutData;
    let currentTab = "today";
    let colorPrimaryRGB;
    let colorInfoRGB;
    const tooltip = {
      callbacks: {
        label(t) {
          const dstLabel = t.dataset.label;
          const { formattedValue } = t;
          return `  ${formattedValue} ${dstLabel}`;
        },
        labelColor(t) {
          return {
            backgroundColor: t.dataset.hoverBackgroundColor,
            borderColor: "transparent"
          };
        }
      }
    };
    const scales = {
      y: {
        beginAtZero: true,
        border: { display: false },
        grid: {
          color: "#485e9029",
          borderDash: [3, 3],
          zeroLineColor: "#485e9029",
          zeroLineWidth: 1,
          zeroLineBorderDash: [3, 3],
          drawTicks: false,
          drawBorder: false,
          borderWidth: 0
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474",
          max: Math.max(...userOverviewData[currentTab].gained),
          padding: 15,
          stepSize: Math.floor(Math.max(...userOverviewData[currentTab].gained) / 5),
          callback(value, index, ticks) {
            return value + "k";
          }
        }
      },
      x: {
        // need hide zero line for this chart
        border: { display: false },
        grid: {
          display: true,
          zeroLineWidth: 0,
          drawTicks: true,
          drawBorder: false,
          zeroLineColor: "#485e9029",
          color: "transparent",
          z: 1
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474"
        }
      }
    };
    userOverviewDataset = [
      {
        data: userOverviewData[currentTab].target,
        backgroundColor: `rgba(${colorPrimaryRGB}, 0.5)`,
        hoverBackgroundColor: `rgb(${colorPrimaryRGB})`,
        label: "Target",
        maxBarThickness: 10,
        barThickness: 12,
        total: "8,550",
        prefix: "$",
        growthRate: "25",
        growthStatus: "up",
        borderRadius: 2,
        labelType: "primary"
      },
      {
        data: userOverviewData[currentTab].gained,
        backgroundColor: `rgba(${colorInfoRGB}, 0.5)`,
        hoverBackgroundColor: `rgb(${colorInfoRGB})`,
        label: "Gained",
        maxBarThickness: 10,
        barThickness: 12,
        total: "5,550",
        prefix: "$",
        growthRate: "15",
        growthStatus: "down",
        borderRadius: 2,
        labelType: "info"
      }
    ];
    Card($$renderer2, {
      class: "border-0 user-overview h-100",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "border-bottom-0",
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>Users Overview</h6> <div class="card-extra"><ul class="card-tab-links nav"><li><a href="#"${attr_class(clsx("active"))}>Today</a></li> <li><a href="#"${attr_class(clsx(""))}>Week</a></li> <li><a href="#"${attr_class(clsx(""))}>year</a></li></ul></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="cashflow-chart"><div class="label-detailed"><!--[-->`);
            const each_array = ensure_array_like(userOverviewDataset);
            for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
              let item = each_array[$$index];
              $$renderer4.push(`<div class="label-detailed__single"><span${attr_class(`label-detailed__type label-detailed__type--${stringify(item.labelType)}`)}>${escape_html(item.label)}</span> <strong class="label-detailed__total">${escape_html(item.prefix + item.total)}</strong> <span${attr_class(`label-detailed__status ${stringify(item.growthStatus === "up" ? "color-success" : "color-danger")}`)}>`);
              if (item.growthStatus === "up") {
                $$renderer4.push("<!--[-->");
                $$renderer4.push(`<img class="svg" alt="" src="/img/svg/arrow-success-up.svg"/>`);
              } else {
                $$renderer4.push("<!--[!-->");
                $$renderer4.push(`<img class="svg" alt="" src="/img/svg/arrow-danger-down.svg"/>`);
              }
              $$renderer4.push(`<!--]--> <strong>${escape_html(item.growthRate)}%</strong></span></div>`);
            }
            $$renderer4.push(`<!--]--></div> `);
            {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<div class="parentContainer">`);
              Chartjs($$renderer4, {
                className: "userChart",
                id: "userCharts",
                labels: userOverviewData[currentTab].labels,
                datasets: userOverviewDataset,
                type: "bar",
                tooltip,
                scales,
                height: 104
              });
              $$renderer4.push(`<!----></div>`);
            }
            $$renderer4.push(`<!--]--></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
function MemberProgress($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const membersProgress = bestSellersData.memberProgressData;
    let period = "today";
    let dataPeriod = membersProgress[period];
    Card($$renderer2, {
      class: "border-0 px-25 pb-15 h-100",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "px-0 border-0",
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>Members Progress</h6> <div class="card-extra"><ul class="card-tab-links nav"><li><a href="#"${attr_class(clsx("active"))}>Today</a></li> <li><a href="#"${attr_class(clsx(""))}>Week</a></li> <li><a href="#"${attr_class(clsx(""))}>Year</a></li></ul></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          class: "p-0",
          children: ($$renderer4) => {
            MembersProgress($$renderer4, { dataPeriod });
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
function UpcomingEvents($$renderer) {
  const upcomingEvents = eventData;
  let period = "today";
  let dataPeriod = upcomingEvents[period];
  Card($$renderer, {
    class: "border-0 px-25 pb-10 project-task-list--event",
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        class: "px-0 border-0",
        children: ($$renderer3) => {
          $$renderer3.push(`<h6>Upcoming Events</h6> <div class="card-extra"><ul class="card-tab-links nav"><li><a href="#"${attr_class(clsx("active"))}>Today</a></li> <li><a href="#"${attr_class(clsx(""))}>Week</a></li> <li><a href="#"${attr_class(clsx(""))}>Year</a></li></ul></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        class: "p-0",
        children: ($$renderer3) => {
          Events($$renderer3, { dataPeriod });
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
}
function Timeline($$renderer) {
  let timelineContent = [
    {
      type: "primary",
      title: "Create a services site",
      date: "2015-09-01",
      posted: "17 mins ago"
    },
    {
      type: "secondary",
      title: "Solve initial network problems",
      date: "2015-09-05",
      posted: "2 hours ago"
    },
    {
      type: "success",
      title: "Technical testing",
      date: "2015-05-02",
      posted: "3 hours ago"
    },
    {
      type: "info",
      title: "Network problems being solved",
      date: "2016-03-12",
      posted: "4 hours ago"
    },
    {
      type: "warning",
      title: "Technical testing",
      date: "2015-03-07",
      posted: "5 hours ago"
    },
    {
      type: "danger",
      title: "Network problems being solved",
      date: "2022-06-25",
      posted: "7 hours ago"
    }
  ];
  Card($$renderer, {
    class: "border-0 card-timeline h-100",
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        class: "border-0",
        children: ($$renderer3) => {
          $$renderer3.push(`<h6>Timeline</h6> `);
          CardExtra($$renderer3);
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        class: "pb-30 pt-1 mt-n10",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="card-timeline-body"><ul><!--[-->`);
          const each_array = ensure_array_like(timelineContent);
          for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
            let item = each_array[$$index];
            $$renderer3.push(`<li><div class="card-timeline-body__left"><div class="card-timeline-body__title"><span class="timeline-line"></span> <span${attr_class(`badge-dot badge-dot--big dot-${stringify(item.type)}`)}></span> <p>${escape_html(item.title)}<span>${escape_html(item.date)}</span></p></div></div> <div class="card-timeline-body__right"><div class="card-timeline-body__time"><span>${escape_html(item.posted)}</span></div></div></li>`);
          }
          $$renderer3.push(`<!--]--></ul></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
}
function Inbox($$renderer) {
  const inboxData = [
    {
      id: 1,
      user: {
        fName: "Shane",
        lName: "Watson",
        msg: "We are looking a full stack developer",
        img: "/img/inbox-1.png"
      },
      time: "9:00 AM"
    },
    {
      id: 2,
      user: {
        fName: "Chris",
        lName: "Dohan",
        msg: "Well done, great work ",
        img: "/img/inbox-2.png"
      },
      time: "9:30 AM"
    },
    {
      id: 3,
      user: {
        fName: "Robert",
        lName: "Clinton",
        msg: "Tonight we are going to submit new...",
        img: "/img/inbox-3.png"
      },
      time: "9:30 AM"
    },
    {
      id: 4,
      user: {
        fName: "Daniel",
        lName: "White",
        msg: "Please send me final file",
        img: "/img/inbox-1.png"
      },
      time: "9:30 AM"
    },
    {
      id: 5,
      user: {
        fName: "Black",
        lName: "Smith",
        msg: "Good luck Tom",
        img: "/img/inbox-2.png"
      },
      time: "9:30 AM"
    }
  ];
  Card($$renderer, {
    class: "border-0 card-inbox",
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        class: "border-0",
        children: ($$renderer3) => {
          $$renderer3.push(`<h6>Inbox</h6> `);
          CardExtra($$renderer3);
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        class: "pb-40 pt-0",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="card-inbox-members svelte-14lattv"><ul class="svelte-14lattv"><!--[-->`);
          const each_array = ensure_array_like(inboxData);
          for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
            let item = each_array[$$index];
            $$renderer3.push(`<li class="svelte-14lattv"><div class="card-inbox-members__left svelte-14lattv"><img class="rounded-circle svelte-14lattv"${attr("src", item.user.img)} alt=""/> <div class="card-inbox-members__title svelte-14lattv"><h6 class="svelte-14lattv">${escape_html(item.user.fName)} ${escape_html(item.user.lName)}</h6> <div class="card-inbox-members__title--online svelte-14lattv">${escape_html(item.user.msg)}</div></div></div> <div class="card-inbox-member__right"><div class="card-inbox-member__time svelte-14lattv"><span class="svelte-14lattv">${escape_html(item.time)}</span></div></div></li>`);
          }
          $$renderer3.push(`<!--]--></ul></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
}
function Blogs($$renderer) {
  let blogData = [
    {
      thumbnail: "/img/bg2.png",
      postedOn: "15 March 2021",
      title: "The Ultimate Glossary of Terms",
      excerpt: "There are many variations of passages of majority have suffered alteration in some form",
      authorImg: "/img/alex-suprun.png",
      authorName: "Machel Bold",
      likes: "15 K",
      comments: "75"
    },
    {
      thumbnail: "/img/bg3.png",
      postedOn: "12 February 2021",
      title: "Multiple Dashboard Design Idea",
      excerpt: "There are many variations of passages of majority have suffered alteration in some form",
      authorImg: "/img/alex-suprun.png",
      authorName: "Alex Kery",
      likes: "11 K",
      comments: "85"
    },
    {
      thumbnail: "/img/bg4.png",
      postedOn: "23 January 2021",
      title: "How to Create a Niche Based",
      excerpt: "There are many variations of passages of majority have suffered alteration in some form",
      authorImg: "/img/alex-suprun.png",
      authorName: "Jordan Smeth",
      likes: "21 K",
      comments: "67"
    }
  ];
  Row($$renderer, {
    children: ($$renderer2) => {
      $$renderer2.push(`<!--[-->`);
      const each_array = ensure_array_like(blogData);
      for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
        let content = each_array[$$index];
        Col($$renderer2, {
          xxl: 4,
          md: 6,
          class: "mb-25",
          children: ($$renderer3) => {
            BlogCard($$renderer3, { content });
          },
          $$slots: { default: true }
        });
      }
      $$renderer2.push(`<!--]-->`);
    },
    $$slots: { default: true }
  });
}
function _page($$renderer) {
  let withoutHeader = "withoutHeader";
  let cardClass = "bg-dark-area";
  let imgPath = "/img/demo5-banner.png";
  let title = "Welcome To Demo Dashboard";
  head("ukn5k", $$renderer, ($$renderer2) => {
    $$renderer2.title(($$renderer3) => {
      $$renderer3.push(`<title>Home Ten</title>`);
    });
  });
  $$renderer.push(`<div class="demo5">`);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            xxl: 12,
            class: "mt-25 mb-25",
            children: ($$renderer4) => {
              PageHeaderBanner($$renderer4, { cardClass, imgPath, title });
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            xxl: 8,
            class: "mb-25",
            children: ($$renderer4) => {
              UserOverview($$renderer4);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            xxl: 4,
            class: "mb-25",
            children: ($$renderer4) => {
              Calendar($$renderer4, { withoutHeader });
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            xl: 6,
            class: "mb-25",
            children: ($$renderer4) => {
              MemberProgress($$renderer4);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            xl: 6,
            class: "mb-25",
            children: ($$renderer4) => {
              UpcomingEvents($$renderer4);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            xxl: 4,
            lg: 6,
            class: "mb-25",
            children: ($$renderer4) => {
              KnowledgeBase($$renderer4);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            xxl: 4,
            lg: 6,
            class: "mb-25",
            children: ($$renderer4) => {
              Timeline($$renderer4);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            xxl: 4,
            class: "mb-25",
            children: ($$renderer4) => {
              Inbox($$renderer4);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            xxl: 12,
            class: "mb-25",
            children: ($$renderer4) => {
              Blogs($$renderer4);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
export {
  _page as default
};
