import { a6 as fallback, ag as ensure_array_like, aa as escape_html, a9 as bind_props, ad as attr_class, a8 as clsx, a2 as head, af as spread_props } from "../../../../../chunks/index2.js";
import "clsx";
import { R as Row, a as Col, C as Container } from "../../../../../chunks/Row.js";
import "../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbOne } from "../../../../../chunks/BreadcrumbOne.js";
import { O as OverviewCards } from "../../../../../chunks/OverviewCards.js";
import { o as overviewCardData } from "../../../../../chunks/overviewCard.js";
import { t as totalChartData$2 } from "../../../../../chunks/totalCurrentPeriodMonth.js";
import { C as Chartjs } from "../../../../../chunks/Chartjs.js";
import { C as Card } from "../../../../../chunks/Card.js";
import { C as CardBody } from "../../../../../chunks/CardBody.js";
import { C as CardHeader } from "../../../../../chunks/CardHeader.js";
import { C as CardExtra } from "../../../../../chunks/CardExtra.js";
import { V as VectorMap } from "../../../../../chunks/VectorMap.js";
import { s as salesData$1 } from "../../../../../chunks/salesByLocation2.js";
import { d as doughnutData } from "../../../../../chunks/dashboardChartContent.js";
import { T as TopSellingProduct } from "../../../../../chunks/TopSellingProduct.js";
import { B as BrowserState } from "../../../../../chunks/BrowserState.js";
function TotalLineChartMonth($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let totalChartDataset, scales, layout;
    let primaryColor;
    let primaryColorRGB;
    const tooltip = {
      usePointStyle: true,
      callbacks: {
        label(context) {
          let label = context.dataset.label || "";
          if (label) {
            label += ": ";
          }
          if (context.parsed.y !== null) {
            label += new Intl.NumberFormat().format(context.parsed.y);
          }
          return `<span class="data-label">${label}k</span>`;
        }
      }
    };
    totalChartDataset = [
      {
        data: totalChartData$2.orders,
        backgroundColor: `rgba(${primaryColorRGB},0.5)`,
        hoverBackgroundColor: primaryColor,
        borderColor: primaryColor,
        label: "Current Period",
        total: "8,550",
        prefix: "$",
        growthRate: "25",
        growthStatus: "up",
        labelType: "primary",
        borderWidth: 3,
        hoverRadius: "6",
        pointBackgroundColor: primaryColor,
        pointRadius: 0,
        pointHoverRadius: 6,
        pointHitRadius: 30,
        pointStyle: "circle",
        pointHoverBorderWidth: 2
      }
    ];
    scales = {
      y: {
        border: { display: false },
        beginAtZero: true,
        grid: {
          color: "#485e9029",
          borderDash: [3, 3],
          zeroLineColor: "#485e9029",
          zeroLineWidth: 1,
          zeroLineBorderDash: [3, 3],
          drawTicks: false,
          drawBorder: false,
          zeroLineWidth: 3,
          borderWidth: 0
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474",
          padding: 15,
          max: 80,
          min: 0,
          stepSize: 20,
          callback(value) {
            return `${value}k`;
          }
        }
      },
      x: {
        border: { display: false },
        grid: {
          display: true,
          zeroLineWidth: 2,
          zeroLineColor: "transparent",
          color: "transparent",
          z: 1,
          tickMarkLength: 10,
          drawTicks: true,
          drawBorder: false
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474"
        }
      }
    };
    layout = { padding: { left: -13, right: -10, top: 0, bottom: 0 } };
    Card($$renderer2, {
      class: "border-0 chartLine-po-details",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "border-0 px-25 pt-25 pb-30",
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="chartLine-po-details__overview-content w-100 svelte-si9tsq"><div class="chartLine-po-details__content d-flex flex-wrap justify-content-between"><div class="chartLine-po-details__titlebar svelte-si9tsq"><h1 class="svelte-si9tsq">Total Sales</h1> <p class="svelte-si9tsq">(Last 10 months)</p></div></div> <div class="chartLine-po-details__time svelte-si9tsq"><h5>$8,550</h5> <span class="color-success svelte-si9tsq"><i class="uil uil-arrow-up"></i> <strong class="svelte-si9tsq">25.36%</strong></span></div></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          class: "px-25",
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="wp-chart"><div class="parentContainer">`);
            Chartjs($$renderer4, {
              className: "totalLineChartsMonth",
              id: "totalLineChartsMonth",
              labels: totalChartData$2.labels,
              datasets: totalChartDataset,
              type: "line",
              tooltip,
              scales,
              layout,
              height: 196
            });
            $$renderer4.push(`<!----></div></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
const labels$1 = ["Sat", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri"];
const orders$1 = [38, 55, 42, 36, 60, 65, 50];
const totalChartData$1 = {
  labels: labels$1,
  orders: orders$1
};
function TotalLineChartDay($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let totalChartDataset, scales, layout;
    let primaryColor;
    let primaryColorRGB;
    const tooltip = {
      usePointStyle: true,
      callbacks: {
        label(context) {
          let label = context.dataset.label || "";
          if (label) {
            label += ": ";
          }
          if (context.parsed.y !== null) {
            label += new Intl.NumberFormat().format(context.parsed.y);
          }
          return `<span class="data-label">${label}k</span>`;
        }
      }
    };
    totalChartDataset = [
      {
        data: totalChartData$1.orders,
        backgroundColor: `rgba(${primaryColorRGB},0.5)`,
        hoverBackgroundColor: primaryColor,
        borderColor: primaryColor,
        label: "Current Period",
        total: "8,550",
        prefix: "$",
        growthRate: "25",
        growthStatus: "up",
        labelType: "primary",
        borderWidth: 3,
        hoverRadius: "6",
        pointBackgroundColor: primaryColor,
        pointRadius: 0,
        pointHoverRadius: 6,
        pointHitRadius: 30,
        pointStyle: "circle",
        pointHoverBorderWidth: 2
      }
    ];
    scales = {
      y: {
        border: { display: false },
        beginAtZero: true,
        grid: {
          color: "#485e9029",
          borderDash: [3, 3],
          zeroLineColor: "#485e9029",
          zeroLineWidth: 1,
          zeroLineBorderDash: [3, 3],
          drawTicks: false,
          drawBorder: false,
          zeroLineWidth: 3,
          borderWidth: 0
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474",
          padding: 15,
          max: 80,
          min: 0,
          stepSize: 20,
          callback(value) {
            return `${value}k`;
          }
        }
      },
      x: {
        border: { display: false },
        grid: {
          display: true,
          zeroLineWidth: 2,
          zeroLineColor: "transparent",
          color: "transparent",
          z: 1,
          tickMarkLength: 10,
          drawTicks: true,
          drawBorder: false
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474"
        }
      }
    };
    layout = { padding: { left: -13, right: -10, top: 0, bottom: 0 } };
    Card($$renderer2, {
      class: "border-0 chartLine-po-details",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "border-0 px-25 pt-25 pb-30",
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="chartLine-po-details__overview-content w-100 svelte-1epu1xy"><div class="chartLine-po-details__content d-flex flex-wrap justify-content-between"><div class="chartLine-po-details__titlebar svelte-1epu1xy"><h1 class="svelte-1epu1xy">Total Sales</h1> <p class="svelte-1epu1xy">(Last 10 Days)</p></div></div> <div class="chartLine-po-details__time svelte-1epu1xy"><h5>$8,550</h5> <span class="color-success svelte-1epu1xy"><i class="uil uil-arrow-up"></i> <strong class="svelte-1epu1xy">25.36%</strong></span></div></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          class: "px-25",
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="wp-chart"><div class="parentContainer">`);
            Chartjs($$renderer4, {
              className: "totalLineChartsDay",
              id: "totalLineChartsDay",
              labels: totalChartData$1.labels,
              datasets: totalChartDataset,
              type: "line",
              tooltip,
              scales,
              layout,
              height: 196
            });
            $$renderer4.push(`<!----></div></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
const labels = ["2014", "2015", "2016", "2017", "2018", "2019", "2020", "2021"];
const orders = [40, 48, 40, 46, 38, 65, 58, 59];
const totalChartData = {
  labels,
  orders
};
function TotalLineChartYear($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let totalChartDataset, scales, layout;
    let primaryColor;
    let primaryColorRGB;
    const tooltip = {
      usePointStyle: true,
      callbacks: {
        label(context) {
          let label = context.dataset.label || "";
          if (label) {
            label += ": ";
          }
          if (context.parsed.y !== null) {
            label += new Intl.NumberFormat().format(context.parsed.y);
          }
          return `<span class="data-label">${label}k</span>`;
        }
      }
    };
    totalChartDataset = [
      {
        data: totalChartData.orders,
        backgroundColor: `rgba(${primaryColorRGB},0.5)`,
        hoverBackgroundColor: primaryColor,
        borderColor: primaryColor,
        label: "Current Period",
        total: "8,550",
        prefix: "$",
        growthRate: "25",
        growthStatus: "up",
        labelType: "primary",
        borderWidth: 3,
        hoverRadius: "6",
        pointBackgroundColor: primaryColor,
        pointRadius: 0,
        pointHoverRadius: 6,
        pointHitRadius: 30,
        pointStyle: "circle",
        pointHoverBorderWidth: 2
      }
    ];
    scales = {
      y: {
        border: { display: false },
        grid: {
          color: "#485e9029",
          borderDash: [3, 3],
          zeroLineColor: "#485e9029",
          zeroLineWidth: 1,
          zeroLineBorderDash: [3, 3],
          drawTicks: false,
          drawBorder: false,
          zeroLineWidth: 3,
          borderWidth: 0
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474",
          padding: 15,
          max: 80,
          min: 0,
          stepSize: 20,
          callback(value) {
            return `${value}k`;
          }
        }
      },
      x: {
        border: { display: false },
        grid: {
          display: true,
          zeroLineWidth: 2,
          zeroLineColor: "transparent",
          color: "transparent",
          z: 1,
          tickMarkLength: 10,
          drawTicks: true,
          drawBorder: false
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474"
        }
      }
    };
    layout = { padding: { left: -13, right: -10, top: 0, bottom: 0 } };
    Card($$renderer2, {
      class: "border-0 chartLine-po-details",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "border-0 px-25 pt-25 pb-30",
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="chartLine-po-details__overview-content w-100 svelte-wm6d4j"><div class="chartLine-po-details__content d-flex flex-wrap justify-content-between"><div class="chartLine-po-details__titlebar svelte-wm6d4j"><h1 class="svelte-wm6d4j">Total Sales</h1> <p class="svelte-wm6d4j">(Last 10 year)</p></div></div> <div class="chartLine-po-details__time svelte-wm6d4j"><h5>$8,550</h5> <span class="color-success svelte-wm6d4j"><i class="uil uil-arrow-up"></i> <strong class="svelte-wm6d4j">25.36%</strong></span></div></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          class: "px-25",
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="wp-chart"><div class="parentContainer">`);
            Chartjs($$renderer4, {
              className: "totalLineChartsYear",
              id: "totalLineChartsYear",
              labels: totalChartData.labels,
              datasets: totalChartDataset,
              type: "line",
              tooltip,
              scales,
              layout,
              height: 196
            });
            $$renderer4.push(`<!----></div></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
function SalesByLocationOld($$renderer, $$props) {
  let salesData2;
  let period = "today";
  let dataPeriod = fallback($$props["dataPeriod"], () => salesData2[period], true);
  $$renderer.push(`<div class="table-responsive table-top-regions svelte-1nbok55"><table class="table table--default table-borderless svelte-1nbok55"><thead class="svelte-1nbok55"><tr><th class="svelte-1nbok55">Top region</th><th class="svelte-1nbok55">order</th><th class="svelte-1nbok55">Revenue</th></tr></thead><tbody class="svelte-1nbok55"><!--[-->`);
  const each_array = ensure_array_like(dataPeriod);
  for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
    let data = each_array[$$index];
    $$renderer.push(`<tr class="svelte-1nbok55"><td class="svelte-1nbok55">${escape_html(data.location)}</td><td class="svelte-1nbok55">${escape_html(data.order)}</td><td class="svelte-1nbok55">${escape_html(data.revenue)}</td></tr>`);
  }
  $$renderer.push(`<!--]--></tbody></table></div>`);
  bind_props($$props, { dataPeriod });
}
function SalesByLocation_1($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let dataPeriod;
    let currentTab = "today";
    function changeData(data) {
      dataPeriod = salesData$1[data];
      currentTab = data;
    }
    changeData("today");
    Card($$renderer2, {
      class: "border-0 sales-location h-100",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>Sales by Location</h6> <div class="card-extra"><ul class="card-tab-links nav"><li><a href="#"${attr_class(clsx(currentTab === "today" ? "active" : ""))}>Today</a></li> <li><a href="#"${attr_class(clsx(currentTab === "week" ? "active" : ""))}>Week</a></li> <li><a href="#"${attr_class(clsx(currentTab === "month" ? "active" : ""))}>Month</a></li> <li><a href="#"${attr_class(clsx(currentTab === "year" ? "active" : ""))}>Year</a></li></ul> `);
            CardExtra($$renderer4);
            $$renderer4.push(`<!----></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          children: ($$renderer4) => {
            Row($$renderer4, {
              children: ($$renderer5) => {
                Col($$renderer5, {
                  md: 6,
                  children: ($$renderer6) => {
                    SalesByLocationOld($$renderer6, { dataPeriod });
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                Col($$renderer5, {
                  md: 6,
                  class: "d-flex align-items-center justify-content-center",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<div class="regions-svg">`);
                    VectorMap($$renderer6, {});
                    $$renderer6.push(`<!----></div>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!---->`);
              },
              $$slots: { default: true }
            });
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
function TopSellingProduct_1($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const topSales = doughnutData.topSale;
    let period = "today";
    let dataPeriod = topSales[period];
    Card($$renderer2, {
      class: "border-0 px-25 top-selling-product",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "px-0 border-0",
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>Top Selling Products</h6> <div class="card-extra"><ul class="card-tab-links nav"><li><a href="#"${attr_class(clsx("active"))}>Today</a></li> <li><a href="#"${attr_class(clsx(""))}>Week</a></li> <li><a href="#"${attr_class(clsx(""))}>Month</a></li></ul></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          class: "",
          children: ($$renderer4) => {
            TopSellingProduct($$renderer4, { dataPeriod });
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
function BrowserState_1($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const browserStateData = doughnutData.browserState;
    let period = "today";
    let dataPeriod = browserStateData[period];
    Card($$renderer2, {
      class: "border-0 px-25 browser-states",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "px-0 border-0",
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>Browser States</h6> <div class="card-extra"><ul class="card-tab-links nav"><li><a href="#"${attr_class(clsx("active"))}>Today</a></li> <li><a href="#"${attr_class(clsx(""))}>Week</a></li> <li><a href="#"${attr_class(clsx(""))}>Month</a></li></ul></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          children: ($$renderer4) => {
            BrowserState($$renderer4, { dataPeriod });
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
const salesData = [
  {
    id: 1,
    salesCount: "123,456",
    status: "Completed"
  },
  {
    id: 2,
    salesCount: "12,498",
    status: "In Progress"
  }
];
function ProgressCircle($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    $$renderer2.push(`<div><div class="storage color-primary"><div class="storage"><div></div></div></div></div>`);
  });
}
function SalesOverview($$renderer) {
  Card($$renderer, {
    class: "revenueChartTwo border-0",
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        children: ($$renderer3) => {
          $$renderer3.push(`<h6>Sales Overview</h6> `);
          CardExtra($$renderer3);
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        class: "px-sm-50 pb-sm-30 pt-sm-25 px-30 pb-30 pt-25",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="d-flex justify-content-center">`);
          ProgressCircle($$renderer3);
          $$renderer3.push(`<!----></div> <div class="sales-target d-flex justify-content-around"><!--[-->`);
          const each_array = ensure_array_like(salesData);
          for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
            let item = each_array[$$index];
            $$renderer3.push(`<div class="sales-target__single svelte-1vqwu6j"><span>${escape_html(item.status)}</span> <h3 class="svelte-1vqwu6j">${escape_html(item.salesCount)}</h3></div>`);
          }
          $$renderer3.push(`<!--]--></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
}
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const overviewDataSorted = overviewCardData.slice(0, 4);
    const breadcrumbData = {
      pageTitle: "Demo six",
      bcItem: "Dashboard",
      bcItemActive: "Demo six"
    };
    let cardStyle = "ap-po-details--two";
    head("12qblvx", $$renderer2, ($$renderer3) => {
      $$renderer3.title(($$renderer4) => {
        $$renderer4.push(`<title>Home Six</title>`);
      });
    });
    $$renderer2.push(`<div class="crm mb-25">`);
    Container($$renderer2, {
      fluid: true,
      children: ($$renderer3) => {
        Row($$renderer3, {
          children: ($$renderer4) => {
            Col($$renderer4, {
              xxl: 12,
              children: ($$renderer5) => {
                BreadcrumbOne($$renderer5, spread_props([breadcrumbData]));
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 12,
              children: ($$renderer5) => {
                Row($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!--[-->`);
                    const each_array = ensure_array_like(overviewDataSorted);
                    for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
                      let item = each_array[$$index];
                      Col($$renderer6, {
                        xxl: 3,
                        sm: 6,
                        class: "mb-25",
                        children: ($$renderer7) => {
                          OverviewCards($$renderer7, spread_props([item, { cardStyle }]));
                        },
                        $$slots: { default: true }
                      });
                    }
                    $$renderer6.push(`<!--]-->`);
                  },
                  $$slots: { default: true }
                });
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 4,
              lg: 6,
              class: "mb-25",
              children: ($$renderer5) => {
                TotalLineChartMonth($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 4,
              lg: 6,
              class: "mb-25",
              children: ($$renderer5) => {
                TotalLineChartDay($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 4,
              lg: 6,
              class: "mb-25",
              children: ($$renderer5) => {
                TotalLineChartYear($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 4,
              lg: 6,
              class: "mb-25",
              children: ($$renderer5) => {
                SalesOverview($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 8,
              class: "mb-25",
              children: ($$renderer5) => {
                SalesByLocation_1($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              lg: 6,
              class: "mb-25",
              children: ($$renderer5) => {
                TopSellingProduct_1($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              lg: 6,
              class: "mb-25",
              children: ($$renderer5) => {
                BrowserState_1($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></div>`);
  });
}
export {
  _page as default
};
