import { ad as attr_class, a8 as clsx, ag as ensure_array_like, ae as stringify, aa as escape_html, a9 as bind_props, a2 as head, af as spread_props } from "../../../../../chunks/index2.js";
import "clsx";
import { C as Container, R as Row, a as Col } from "../../../../../chunks/Row.js";
import "../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbOne } from "../../../../../chunks/BreadcrumbOne.js";
import { O as OverviewCards } from "../../../../../chunks/OverviewCards.js";
import { o as overviewCardData } from "../../../../../chunks/overviewCardOld.js";
import { C as Card } from "../../../../../chunks/Card.js";
import { C as CardBody } from "../../../../../chunks/CardBody.js";
import { C as CardHeader } from "../../../../../chunks/CardHeader.js";
import { C as Chartjs } from "../../../../../chunks/Chartjs.js";
import { c as chartLinearGradient } from "../../../../../chunks/utilities.js";
import { b as bestSellersData } from "../../../../../chunks/table-data.js";
import { N as NewProducts } from "../../../../../chunks/NewProducts.js";
import { S as Sellers } from "../../../../../chunks/Sellers.js";
import { P as Progress } from "../../../../../chunks/Progress.js";
function SalesRevenue($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let salesRevenueDatasets;
    let revenue = "today";
    let primaryColor;
    let primaryColorRGB;
    let salesRevenue = {
      today: {
        users: [20, 36, 25, 50, 40, 55, 40, 75, 35, 40, 35, 58],
        labels: [
          "2h",
          "4h",
          "6h",
          "8h",
          "10h",
          "12h",
          "14h",
          "16h",
          "18h",
          "20h",
          "22h",
          "24h"
        ]
      },
      week: {
        users: [40, 30, 35, 20, 25, 40, 35],
        labels: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]
      },
      months: {
        users: [45, 20, 35, 32, 50, 45, 55, 71, 36, 65, 55, 75],
        labels: [
          "Jan",
          "Feb",
          "Mar",
          "App",
          "May",
          "Jun",
          "Jul",
          "Aug",
          "Sep",
          "Nov",
          "Oct",
          "Dec"
        ]
      }
    };
    const scales = {
      y: {
        border: { display: false },
        beginAtZero: true,
        grid: {
          color: "#485e9029",
          borderDash: [3, 3],
          zeroLineColor: "#485e9029",
          zeroLineWidth: 1,
          zeroLineBorderDash: [3, 3],
          drawTicks: false,
          drawBorder: false,
          zeroLineWidth: 3,
          borderWidth: 0
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474",
          Min: 0,
          Max: 80,
          stepSize: 20,
          padding: 15,
          callback(label) {
            return `${label}k`;
          }
        }
      },
      x: {
        border: { display: false },
        grid: {
          display: true,
          zeroLineWidth: 2,
          zeroLineColor: "transparent",
          color: "transparent",
          z: 1,
          tickMarkLength: 10,
          drawTicks: true,
          drawBorder: false
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474"
        }
      }
    };
    salesRevenueDatasets = [
      {
        data: salesRevenue[revenue].users,
        borderColor: primaryColor,
        borderWidth: 3,
        fill: true,
        backgroundColor: () => chartLinearGradient(document.getElementById("ninjadash-sales-revenue"), 300, {
          start: `rgba(${primaryColorRGB},0.4)`,
          end: "rgba(255,255,255,0.05)"
        }),
        label: "Current period",
        pointStyle: "circle",
        pointRadius: "0",
        hoverRadius: "6",
        pointBorderColor: "#fff",
        pointBackgroundColor: primaryColor,
        hoverBorderWidth: 2,
        amount: "$7,596",
        amountClass: "current-amount",
        lineTension: 0.5
      }
    ];
    Card($$renderer2, {
      class: "sales-revenue border-0",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "border-0",
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>Sales Revenue</h6> <div class="card-extra"><ul class="card-tab-links nav"><li><a href="#"${attr_class(clsx("active"))}>Today</a></li> <li><a href="#"${attr_class(clsx(""))}>Week</a></li> <li><a href="#"${attr_class(clsx(""))}>Month</a></li></ul></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="wp-chart">`);
            {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<div class="parentContainer">`);
              Chartjs($$renderer4, {
                type: "line",
                id: "ninjadash-sales-revenue",
                className: "ninjadash-sales-revenue",
                labels: salesRevenue[revenue].labels,
                datasets: salesRevenueDatasets,
                scales,
                height: 120
              });
              $$renderer4.push(`<!----></div>`);
            }
            $$renderer4.push(`<!--]--></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
function NewProducts_1($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const products = bestSellersData.newProduct;
    let period = "today";
    let dataPeriod = products[period];
    Card($$renderer2, {
      class: "border-0 px-25 new-products",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "px-0 border-0",
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>New Products</h6> <div class="card-extra"><ul class="card-tab-links nav"><li><a href="#"${attr_class(clsx("active"))}>Today</a></li> <li><a href="#"${attr_class(clsx(""))}>Week</a></li> <li><a href="#"${attr_class(clsx(""))}>year</a></li></ul></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          class: "p-0",
          children: ($$renderer4) => {
            NewProducts($$renderer4, { dataPeriod });
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
function BestSellers($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const sellers = bestSellersData.bestSellerOld;
    let period = "today";
    let dataPeriod = sellers[period];
    Card($$renderer2, {
      class: "border-0 px-25 best-sellers",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "px-0 border-0",
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>Best Sellers</h6> <div class="card-extra"><ul class="card-tab-links nav"><li><a href="#"${attr_class(clsx("active"))}>Today</a></li> <li><a href="#"${attr_class(clsx(""))}>Week</a></li> <li><a href="#"${attr_class(clsx(""))}>Year</a></li></ul></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          class: "p-0",
          children: ($$renderer4) => {
            Sellers($$renderer4, { dataPeriod });
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
function MembersProgressOld($$renderer, $$props) {
  let dataPeriod = $$props["dataPeriod"];
  $$renderer.push(`<div class="selling-table-wrap selling-table-wrap--source table-responsive svelte-1jwsad7"><table class="table table--default table-borderless svelte-1jwsad7"><thead class="svelte-1jwsad7"><tr class="svelte-1jwsad7"><th class="svelte-1jwsad7">Source</th><th class="svelte-1jwsad7">Visitors</th><th class="svelte-1jwsad7">Page View</th><th class="svelte-1jwsad7">Revenue</th><th class="text-start svelte-1jwsad7">Trend</th></tr></thead><tbody class="svelte-1jwsad7"><!--[-->`);
  const each_array = ensure_array_like(dataPeriod);
  for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
    let data = each_array[$$index];
    $$renderer.push(`<tr class="svelte-1jwsad7"><td class="svelte-1jwsad7"><div class="selling-product-img d-flex align-items-center svelte-1jwsad7"><div${attr_class(`selling-product-img-wrapper order-bg-opacity-${stringify(data.progress)}`, "svelte-1jwsad7")}><i${attr_class(`uil uil-${stringify(data.userImg)}`, "svelte-1jwsad7")}></i></div> <span class="svelte-1jwsad7">${escape_html(data.title)}</span></div></td><td class="svelte-1jwsad7">${escape_html(data.visitors)}</td><td class="svelte-1jwsad7">${escape_html(data.pageView)}</td><td class="svelte-1jwsad7">$${escape_html(data.revenue)}</td><td class="svelte-1jwsad7"><div class="d-flex align-center justify-content-end"><div class="ratio-percentage me-15">${escape_html(data.status)}%</div> <div class="progress-wrap mb-0"><div class="progress svelte-1jwsad7">`);
    Progress($$renderer, { bar: true, color: data.progress, value: data.status });
    $$renderer.push(`<!----></div></div></div></td></tr>`);
  }
  $$renderer.push(`<!--]--></tbody></table></div>`);
  bind_props($$props, { dataPeriod });
}
function MemberProgressOld($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const membersProgress = bestSellersData.memberProgressDataOld;
    let period = "today";
    let dataPeriod = membersProgress[period];
    Card($$renderer2, {
      class: "border-0 px-25 pb-15 h-100",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "px-0 border-0",
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>Source Of Revenue Generated</h6> <div class="card-extra"><ul class="card-tab-links nav"><li><a href="#"${attr_class(clsx("active"))}>Today</a></li> <li><a href="#"${attr_class(clsx(""))}>Week</a></li> <li><a href="#"${attr_class(clsx(""))}>Year</a></li></ul></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          class: "p-0",
          children: ($$renderer4) => {
            MembersProgressOld($$renderer4, { dataPeriod });
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const overviewDataSorted = overviewCardData.slice(0, 4);
    const breadcrumbData = {
      pageTitle: "Demo Seven",
      bcItem: "Dashboard",
      bcItemActive: "Demo Seven"
    };
    let cardStyle = "ap-po-details--two";
    head("1pu6ree", $$renderer2, ($$renderer3) => {
      $$renderer3.title(($$renderer4) => {
        $$renderer4.push(`<title>Home Seven</title>`);
      });
    });
    $$renderer2.push(`<div class="demo2 mb-25">`);
    Container($$renderer2, {
      fluid: true,
      children: ($$renderer3) => {
        Row($$renderer3, {
          children: ($$renderer4) => {
            Col($$renderer4, {
              lg: 12,
              children: ($$renderer5) => {
                BreadcrumbOne($$renderer5, spread_props([breadcrumbData]));
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> <!--[-->`);
            const each_array = ensure_array_like(overviewDataSorted);
            for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
              let item = each_array[$$index];
              Col($$renderer4, {
                xxl: 3,
                sm: 6,
                class: "mb-25",
                children: ($$renderer5) => {
                  OverviewCards($$renderer5, spread_props([item, { cardStyle }]));
                },
                $$slots: { default: true }
              });
            }
            $$renderer4.push(`<!--]--> `);
            Col($$renderer4, {
              xxl: 6,
              class: "mb-25",
              children: ($$renderer5) => {
                SalesRevenue($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 6,
              class: "mb-25",
              children: ($$renderer5) => {
                MemberProgressOld($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 4,
              class: "mb-25",
              children: ($$renderer5) => {
                NewProducts_1($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 8,
              class: "mb-25",
              children: ($$renderer5) => {
                BestSellers($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></div>`);
  });
}
export {
  _page as default
};
