import { ae as stringify, ag as ensure_array_like, ad as attr_class, aa as escape_html, a6 as fallback, a9 as bind_props, ac as attr, a8 as clsx, a1 as store_get, a3 as unsubscribe_stores, a2 as head, af as spread_props } from "../../../../../chunks/index2.js";
import "clsx";
import { C as Container, R as Row, a as Col } from "../../../../../chunks/Row.js";
import "../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbOne } from "../../../../../chunks/BreadcrumbOne.js";
import { C as Card } from "../../../../../chunks/Card.js";
import { C as CardBody } from "../../../../../chunks/CardBody.js";
import { C as CardHeader } from "../../../../../chunks/CardHeader.js";
import { C as CardExtra } from "../../../../../chunks/CardExtra.js";
import { S as Svroller } from "../../../../../chunks/Svroller.js";
import moment from "moment";
import { T as TaskApp } from "../../../../../chunks/TaskApp.js";
import { M as MarketingCampaigns, t as teamList } from "../../../../../chunks/teamList2.js";
import { w as writable } from "../../../../../chunks/index.js";
import { P as Progress } from "../../../../../chunks/Progress.js";
import { b as bestSellersData } from "../../../../../chunks/table-data.js";
import { S as Sellers } from "../../../../../chunks/Sellers.js";
import { c as chatData } from "../../../../../chunks/chatData.js";
function PerformanceOverview($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let border = "border-0";
    const labels = ["Target", "Completed", "In Progress"];
    Card($$renderer2, {
      class: "border-0 h-100 perfomance-o",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: `pb-0 ${stringify(border)}`,
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>Sales Overview</h6> `);
            CardExtra($$renderer4);
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          class: "pt-sm-25 pb-25 pt-15",
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="performance-chart-wrap flex-column svelte-3wq215"><div class="performance-chart"><div></div></div> <div class="performance-chart-labels svelte-3wq215"><ul class="svelte-3wq215"><!--[-->`);
            const each_array = ensure_array_like(labels);
            for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
              let label = each_array[$$index];
              $$renderer4.push(`<li${attr_class(`label-${stringify(label.replace(/\s+/g, "-").toLowerCase())}`, "svelte-3wq215")}>${escape_html(label)}</li>`);
            }
            $$renderer4.push(`<!--]--></ul></div></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
function InfoCard_2($$renderer, $$props) {
  let counter = fallback($$props["counter"], "21k");
  let text = fallback($$props["text"], "Total Products");
  let icon = fallback($$props["icon"], "briefcase-alt");
  let type = fallback($$props["type"], "primary");
  $$renderer.push(`<div class="overview-content overview-content4 text-center radius-xl rony svelte-w3k02f"><div class="d-inline-flex flex-column align-items-center justify-content-center"><div${attr_class(`revenue-chart-box__Icon order-bg-opacity-${stringify(type)}`, "svelte-w3k02f")}><i${attr_class(`uil uil-${stringify(icon)}`, "svelte-w3k02f")}></i></div> <div class="d-flex align-items-start flex-wrap"><div class="mt-3"><p class="mb-1 mb-0 color-gray fs-15">${escape_html(text)}</p> <h2>${escape_html(counter)}</h2></div></div></div></div>`);
  bind_props($$props, { counter, text, icon, type });
}
function NewsLetter_2($$renderer) {
  Card($$renderer, {
    class: "banner-feature banner-feature--20 border-0 mb-0",
    children: ($$renderer2) => {
      $$renderer2.push(`<div class="d-flex justify-content-center">`);
      CardBody($$renderer2, {
        class: "py-sm-45 py-30 px-30",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="banner-feature__shape me-20"><img class="svg" alt="" src="/img/svg/subscribe-message.svg"/></div> <div><h2 class="banner-feature__heading">Subscribe To Our Newsletter</h2> <p class="banner-feature__para">Lorem ipsum dolor sit amet, consetetur</p></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----></div>`);
    },
    $$slots: { default: true }
  });
}
function SingleChat($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const author = "author@mail.com";
    let singleContent = $$props["singleContent"];
    let userNames = $$props["userNames"];
    let singleComponent = fallback($$props["singleComponent"], false);
    let groupChat = fallback($$props["groupChat"], false);
    Card($$renderer2, {
      class: "border-0 h-100",
      children: ($$renderer3) => {
        if (!singleComponent) {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<div class="chat-header"><div class="media chat-name align-items-center"><div class="media-body align-self-center"><h5 class="mb-0 fw-500 mb-2">${escape_html(userNames)}</h5> `);
          if (!groupChat) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<div class="media-body__content d-flex align-items-center"><span class="badge-dot dot-success me-1"></span> <small class="d-flex color-light fs-12 text-capitalize">active now</small></div>`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--></div></div> `);
          if (groupChat) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<div class="image-group"><ul class="d-flex"><li><img src="/img/author/1.jpg" alt="img" class="wh-30 rounded-circle"/></li> <li><img src="/img/author/2.jpg" alt="img" class="wh-30 rounded-circle"/></li> <li><img src="/img/author/3.jpg" alt="img" class="wh-30 rounded-circle"/></li> <li><img src="/img/author/4.jpg" alt="img" class="wh-30 rounded-circle"/></li> <li><img src="/img/author/1.jpg" alt="img" class="wh-30 rounded-circle"/></li> <li><a href="#" class="bg-primary rounded-circle wh-30 color-white content-center fs-10 fw-500">20+</a></li> <li><a href="#" class="border rounded-circle wh-30 color-extra-light content-center"><img class="svg" alt="" src="/img/svg/plus.svg"/></a></li></ul></div>`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--> `);
          CardExtra($$renderer3);
          $$renderer3.push(`<!----></div>`);
        } else {
          $$renderer3.push("<!--[!-->");
          CardHeader($$renderer3, {
            class: "border-0",
            children: ($$renderer4) => {
              $$renderer4.push(`<h6>Chat</h6> `);
              CardExtra($$renderer4);
              $$renderer4.push(`<!---->`);
            },
            $$slots: { default: true }
          });
        }
        $$renderer3.push(`<!--]--> `);
        CardBody($$renderer3, {
          class: "p-0",
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="chat mini-chat"><div class="chat-body bg-white radius-xl">`);
            Svroller($$renderer4, {
              width: "100%",
              height: "100%",
              initiallyVisible: true,
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="chat-box chat-box--big"><!--[-->`);
                const each_array = ensure_array_like(singleContent);
                for (let i = 0, $$length = each_array.length; i < $$length; i++) {
                  let item = each_array[i];
                  $$renderer5.push(`<div${attr_class(`flex-1 mb-15 ${stringify(author !== item.email ? "incoming-chat" : "justify-content-end d-flex outgoing-chat")}`)}><div class="chat-text-box"><div class="media">`);
                  if (author !== item.email) {
                    $$renderer5.push("<!--[-->");
                    $$renderer5.push(`<div class="chat-text-box__photo"><img${attr("src", `/img/${stringify(item.img)}`)} class="align-self-start me-15 wh-46" alt="img"/></div>`);
                  } else {
                    $$renderer5.push("<!--[!-->");
                  }
                  $$renderer5.push(`<!--]--> <div class="media-body"><div class="chat-text-box__content"><div${attr_class(`chat-text-box__title d-flex align-items-center ${stringify(author === item.email ? "justify-content-end" : "")}`)}>`);
                  if (author !== item.email) {
                    $$renderer5.push("<!--[-->");
                    $$renderer5.push(`<h6 class="fs-14 fw-500">${escape_html(typeof item.userName === "undefined" ? userNames : item.userName)}</h6>`);
                  } else {
                    $$renderer5.push("<!--[!-->");
                  }
                  $$renderer5.push(`<!--]--> <span${attr_class(`chat-text-box__time fs-12 color-light fw-400 ${stringify(author !== item.email ? "ms-sm-25 " : "")}`)}>${escape_html(moment(item.time).format("MM-DD-YYYY") === moment().format("MM-DD-YYYY") ? moment(i).format("hh:mm A") : moment(i).format("LL"))}</span></div> <div${attr_class(`d-flex align-items-center ${stringify(author !== item.email ? "mt-10" : "justify-content-end")}`)}><div${attr_class(`chat-text-box__subtitle p-20 ${stringify(author !== item.email ? "bg-secondary" : "bg-deep")}`)}><p${attr_class(clsx(author !== item.email ? "color-white" : "color-dark"))}>${escape_html(item.content)}</p></div></div></div></div></div></div></div>`);
                }
                $$renderer5.push(`<!--]--></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> <div class="chat-footer"><div class="chat-type-text"><div class="pt-0 outline-0 pb-0 pe-0 ps-0 rounded-0 position-relative d-flex align-items-center" tabindex="-1"><div class="d-flex justify-content-between align-items-center w-100 flex-wrap"><div class="bg-lighters flex-1 d-flex align-items-center chat-type-text__write ms-0"><a href="#"><img class="svg" src="/img/svg/smile.svg" alt="smile"/></a> <input class="form-control border-0 bg-transparent box-shadow-none" placeholder="Type your message..."/></div> <div class="chat-type-text__btn">`);
            if (!singleComponent) {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<button type="button" class="border-0 btn-deep color-light wh-50 p-10 rounded-circle"><img class="svg" alt="" src="/img/svg/image.svg"/></button> <button type="button" class="border-0 btn-deep color-light wh-50 p-10 rounded-circle"><img class="svg" alt="" src="/img/svg/paperclip.svg"/></button>`);
            } else {
              $$renderer4.push("<!--[!-->");
            }
            $$renderer4.push(`<!--]--> <button type="button" class="border-0 bg-secondary wh-50 p-10 rounded-circle color-svgDF-white"><img class="svg" alt="" src="/img/svg/send.svg"/></button></div></div></div></div></div></div></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
    bind_props($$props, { singleContent, userNames, singleComponent, groupChat });
  });
}
function BannersOne($$renderer) {
  Card($$renderer, {
    class: "banner-feature banner-feature--19 mb-0 h-100",
    children: ($$renderer2) => {
      $$renderer2.push(`<div class="banner-feature__shape"><img src="/img/trophy-2.png" alt="img" class="svg"/></div> <div class="d-flex justify-content-center">`);
      CardBody($$renderer2, {
        children: ($$renderer3) => {
          $$renderer3.push(`<h1 class="banner-feature__heading fw-700 color-white">Congratulations Jhon!</h1> <p class="banner-feature__para">Best Seller on the last month.</p> <button class="banner-feature__btn btn btn-lg px-20 radius-xs fs-15 color-primary" type="button">Learn More</button>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----></div>`);
    },
    $$slots: { default: true }
  });
}
function Tasks($$renderer) {
  let taskTab = "all";
  Card($$renderer, {
    class: "border-0 px-25 task-list h-100",
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        class: "px-0 border-0",
        children: ($$renderer3) => {
          $$renderer3.push(`<h6>Task List</h6> <div class="card-extra"><ul class="card-tab-links nav"><li><a href="#"${attr_class(clsx("active"))}>Today</a></li> <li><a href="#"${attr_class(clsx(""))}>Week</a></li> <li><a href="#"${attr_class(clsx(""))}>Month</a></li></ul></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        children: ($$renderer3) => {
          TaskApp($$renderer3, {
            header: "",
            description: false,
            taskStatus: taskTab,
            taskLimit: "5"
          });
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
}
function MarketingCampaigns_1($$renderer) {
  const campaignData = {
    today: [
      {
        id: 1,
        title: "Microsoft Company",
        amount: "1045,520",
        percent: 84,
        icon: "internet-explorer.png"
      },
      {
        id: 2,
        title: "WordPress",
        amount: "2000,520",
        percent: 62,
        icon: "wordpress.png"
      },
      {
        id: 3,
        title: "Adidas Brand",
        amount: "1520,950",
        percent: 47,
        icon: "adidas.png"
      },
      {
        id: 4,
        title: "Slack",
        amount: "7045,154",
        percent: 69,
        icon: "slack.png"
      },
      {
        id: 5,
        title: "Adobe CC",
        amount: "1252,220",
        percent: 54,
        icon: "adobe.png"
      }
    ],
    week: [
      {
        id: 2,
        title: "WordPress",
        amount: "2000,520",
        percent: 90,
        icon: "wordpress.png"
      },
      {
        id: 1,
        title: "Microsoft Company",
        amount: "1045,520",
        percent: 80,
        icon: "internet-explorer.png"
      },
      {
        id: 4,
        title: "Slack",
        amount: "7045,154",
        percent: 60,
        icon: "slack.png"
      },
      {
        id: 3,
        title: "Adidas Brand",
        amount: "1520,950",
        percent: 50,
        icon: "adidas.png"
      },
      {
        id: 5,
        title: "Adobe CC",
        amount: "1252,220",
        percent: 60,
        icon: "adobe.png"
      }
    ],
    month: [
      {
        id: 4,
        title: "Slack",
        amount: "7045,154",
        percent: 80,
        icon: "slack.png"
      },
      {
        id: 5,
        title: "Adobe CC",
        amount: "1252,220",
        percent: 70,
        icon: "adobe.png"
      },
      {
        id: 2,
        title: "WordPress",
        amount: "2000,520",
        percent: 60,
        icon: "wordpress.png"
      },
      {
        id: 1,
        title: "Microsoft Company",
        amount: "1045,520",
        percent: 80,
        icon: "internet-explorer.png"
      },
      {
        id: 3,
        title: "Adidas Brand",
        amount: "1520,950",
        percent: 50,
        icon: "adidas.png"
      }
    ]
  };
  let period = "today";
  let dataPeriod = campaignData[period];
  Card($$renderer, {
    class: "border-0 px-25 merketing-campaigns h-100",
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        class: "px-0 border-0",
        children: ($$renderer3) => {
          $$renderer3.push(`<h6>Marketing Campaigns</h6> <div class="card-extra"><ul class="card-tab-links nav"><li><a href="#"${attr_class(clsx("active"))}>Today</a></li> <li><a href="#"${attr_class(clsx(""))}>Week</a></li> <li><a href="#"${attr_class(clsx(""))}>year</a></li></ul></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        children: ($$renderer3) => {
          MarketingCampaigns($$renderer3, { dataPeriod });
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
}
function TeamList($$renderer) {
  const data = teamList;
  Card($$renderer, {
    class: "border-0 teams h-100",
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        class: "border-0",
        children: ($$renderer3) => {
          $$renderer3.push(`<h6>Team Members</h6> `);
          CardExtra($$renderer3);
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="team-members svelte-1qcstg3"><ul class="svelte-1qcstg3"><!--[-->`);
          const each_array = ensure_array_like(data);
          for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
            let team = each_array[$$index];
            $$renderer3.push(`<li class="svelte-1qcstg3"><div class="team-members__left svelte-1qcstg3"><img${attr("src", `/img/team/${stringify(team.avatar)}`)} alt="" class="svelte-1qcstg3"/> <div class="team-members__title svelte-1qcstg3"><h6 class="svelte-1qcstg3">${escape_html(team.title)}</h6></div></div> <div class="team-members__middle svelte-1qcstg3"><div class="team-members__title--online d-flex align-items-center svelte-1qcstg3"><span class="badge-dot dot-success svelte-1qcstg3"></span>Online</div></div> <div class="team-member__right svelte-1qcstg3"><div class="team-member__add svelte-1qcstg3"><button type="button" class="svelte-1qcstg3">add</button></div></div></li>`);
          }
          $$renderer3.push(`<!--]--></ul></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
}
function ProfileCard($$renderer, $$props) {
  let image = fallback($$props["image"], "profile_bg_2.png");
  let bgImage = fallback($$props["bgImage"], "profile_bg.png");
  let title = fallback($$props["title"], "Robert Clinton");
  let tagline = fallback($$props["tagline"], "Best Seller of the last month");
  let socialLinks = fallback($$props["socialLinks"], true);
  $$renderer.push(`<div class="feature-profile svelte-1hizl2z"><div class="feature-profile__bg svelte-1hizl2z"><img${attr("src", `/img/${stringify(bgImage)}`)} alt="" class="svelte-1hizl2z"/></div> <div class="feature-profile_content svelte-1hizl2z"><img${attr("src", `/img/${stringify(image)}`)} alt="" class="svelte-1hizl2z"/> <h6 class="svelte-1hizl2z">${escape_html(title)}</h6> <p class="svelte-1hizl2z">${escape_html(tagline)}</p> `);
  if (socialLinks) {
    $$renderer.push("<!--[-->");
    $$renderer.push(`<ul class="profile-feature__social svelte-1hizl2z"><li class="svelte-1hizl2z"><a href="#" class="bg-facebook svelte-1hizl2z"><i class="lab la-facebook-f"></i></a></li> <li class="svelte-1hizl2z"><a href="#" class="bg-twitter svelte-1hizl2z"><i class="lab la-twitter"></i></a></li> <li class="svelte-1hizl2z"><a href="#" class="bg-primary svelte-1hizl2z"><i class="lab la-dribbble"></i></a></li></ul>`);
  } else {
    $$renderer.push("<!--[!-->");
  }
  $$renderer.push(`<!--]--></div></div>`);
  bind_props($$props, { image, bgImage, title, tagline, socialLinks });
}
function createTodos(initialValue = []) {
  const { subscribe, update } = writable(initialValue);
  return {
    subscribe,
    add(input, id) {
      const todo = {
        id,
        title: input.value,
        description: input.value,
        trash: false,
        completed: false
      };
      update((prev) => {
        return [todo, ...prev];
      });
    },
    remove(todo) {
      update((prev) => {
        return prev.filter((item) => item !== todo);
      });
    },
    toggle(todo) {
      todo.completed = !todo.completed;
      setTimeout(() => {
        update((prev) => {
          return prev.filter((item) => item.completed !== item);
        });
      }, 0);
    },
    trash(todo) {
      todo.trash = !todo.trash;
      setTimeout(() => {
        update((prev) => {
          return prev.filter((item) => item.trash !== item);
        });
      }, 0);
    }
  };
}
const todoData = [
  {
    key: 1,
    title: "Dashboard Design Structure",
    time: "10:30 AM",
    favorite: true,
    status: "new",
    completed: false,
    trash: false
  },
  {
    key: 2,
    title: "Meeting with Team Members",
    time: "10:30 AM",
    favorite: true,
    status: "new",
    completed: false,
    trash: false
  },
  {
    key: 3,
    title: "Dark Mode Design",
    time: "10:30 AM",
    favorite: false,
    status: "new",
    completed: true,
    trash: false
  },
  {
    key: 4,
    title: "Support Ticket",
    time: "10:30 AM",
    favorite: false,
    status: "new",
    completed: true,
    trash: false
  },
  {
    key: 5,
    title: "Meeting with Design Team",
    time: "10:30 AM",
    favorite: true,
    status: "new",
    completed: false,
    trash: false
  },
  {
    key: 7,
    title: "Custom Field for Registration",
    time: "10:30 AM",
    favorite: false,
    status: "new",
    completed: true,
    trash: true
  }
];
function TodoApp($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let todos = createTodos(todoData);
    let header = $$props["header"];
    let todoStatus = $$props["todoStatus"];
    let description = $$props["description"];
    let todoLimit = $$props["todoLimit"];
    let trash = fallback($$props["trash"], () => store_get($$store_subs ??= {}, "$todos", todos).filter((item) => item.trash), true);
    let completed = fallback($$props["completed"], () => store_get($$store_subs ??= {}, "$todos", todos).filter((item) => item.completed), true);
    $$renderer2.push(`<div class="task-list-style"><div class="ninjadash-tassklist-wrap">`);
    if (header !== "") {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="ninjadash-tasklist-head"><h2 class="ninjadash-tasklist-head__title">${escape_html(header)}</h2></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <div class="ninjadash-tasklist-body">`);
    if (todoStatus === "trash") {
      $$renderer2.push("<!--[-->");
      if (trash.length) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<ul class="ninjadash-tasklist svelte-oa8ruk"><!--[-->`);
        const each_array = ensure_array_like(store_get($$store_subs ??= {}, "$todos", todos).filter((item) => item.trash));
        for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
          let todo = each_array[$$index];
          $$renderer2.push(`<li class="ninjadash-tasklist-item d-flex align-items-center justify-content-between svelte-oa8ruk"><div class="ninjadash-tasklist-item__content"><div class="ninjadash-tasklist-item__title"><div class="checkbox-theme-default custom-checkbox custom-checkbox--success checkbox-group__single d-flex p-0 form-check svelte-oa8ruk"><input placeholder="" class="form-check-input svelte-oa8ruk"${attr("id", todo.title)} type="checkbox" name="" value=""${attr("checked", !!todo.completed, true)} disabled=""/> <label${attr("for", todo.title)} class="form-check-label svelte-oa8ruk">${escape_html(todo.title)} <span class="svelte-oa8ruk">${escape_html(todo.time)}</span></label></div></div> `);
          if (description) {
            $$renderer2.push("<!--[-->");
            $$renderer2.push(`<div class="ninjadash-tasklist-item__text"><p>${escape_html(todo.description)}</p></div>`);
          } else {
            $$renderer2.push("<!--[!-->");
          }
          $$renderer2.push(`<!--]--></div> `);
          CardExtra($$renderer2);
          $$renderer2.push(`<!----></li>`);
        }
        $$renderer2.push(`<!--]--></ul>`);
      } else {
        $$renderer2.push("<!--[!-->");
        $$renderer2.push(`<div class="ninjadash-tasklist-empty"><span>Sorry !! No Trash Item Found :(</span></div>`);
      }
      $$renderer2.push(`<!--]-->`);
    } else if (todoStatus === "completed") {
      $$renderer2.push("<!--[1-->");
      if (completed.length) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<ul class="ninjadash-tasklist svelte-oa8ruk"><!--[-->`);
        const each_array_1 = ensure_array_like(store_get($$store_subs ??= {}, "$todos", todos).filter((item) => item.completed));
        for (let $$index_1 = 0, $$length = each_array_1.length; $$index_1 < $$length; $$index_1++) {
          let todo = each_array_1[$$index_1];
          if (!todo.trash) {
            $$renderer2.push("<!--[-->");
            $$renderer2.push(`<li class="ninjadash-tasklist-item d-flex align-items-center justify-content-between svelte-oa8ruk"><div class="ninjadash-tasklist-item__content"><div class="ninjadash-tasklist-item__title"><div class="checkbox-group d-flex"><div class="checkbox-theme-default custom-checkbox custom-checkbox--success checkbox-group__single d-flex svelte-oa8ruk"><input class="checkbox svelte-oa8ruk" type="checkbox"${attr("id", todo.title)}${attr("checked", !!todo.completed, true)}/> <label${attr("for", todo.title)} class="fs-14 color-light svelte-oa8ruk">${escape_html(todo.title)} <span class="svelte-oa8ruk">${escape_html(todo.time)}</span></label></div></div></div> `);
            if (description) {
              $$renderer2.push("<!--[-->");
              $$renderer2.push(`<div class="ninjadash-tasklist-item__text"><p>${escape_html(todo.description)}</p></div>`);
            } else {
              $$renderer2.push("<!--[!-->");
            }
            $$renderer2.push(`<!--]--></div> `);
            CardExtra($$renderer2);
            $$renderer2.push(`<!----></li>`);
          } else {
            $$renderer2.push("<!--[!-->");
          }
          $$renderer2.push(`<!--]-->`);
        }
        $$renderer2.push(`<!--]--></ul>`);
      } else {
        $$renderer2.push("<!--[!-->");
        $$renderer2.push(`<div class="ninjadash-tasklist-empty"><span>Sorry !! No Completed Todo Found :(</span></div>`);
      }
      $$renderer2.push(`<!--]-->`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<div>`);
      if (store_get($$store_subs ??= {}, "$todos", todos).length) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<ul class="ninjadash-tasklist svelte-oa8ruk"><!--[-->`);
        const each_array_2 = ensure_array_like(store_get($$store_subs ??= {}, "$todos", todos));
        for (let $$index_2 = 0, $$length = each_array_2.length; $$index_2 < $$length; $$index_2++) {
          let todo = each_array_2[$$index_2];
          if (!todo.trash) {
            $$renderer2.push("<!--[-->");
            $$renderer2.push(`<li class="ninjadash-tasklist-item d-flex align-items-center justify-content-between svelte-oa8ruk"><div class="ninjadash-tasklist-item__content"><div class="ninjadash-tasklist-item__title"><div class="checkbox-group d-flex"><div class="checkbox-theme-default custom-checkbox custom-checkbox--success checkbox-group__single d-flex svelte-oa8ruk"><input class="checkbox svelte-oa8ruk" type="checkbox"${attr("id", todo.title)}${attr("checked", !!todo.completed, true)}/> <label${attr("for", todo.title)} class="fs-14 color-light svelte-oa8ruk">${escape_html(todo.title)} <span class="svelte-oa8ruk">${escape_html(todo.time)}</span></label></div></div></div> `);
            if (description) {
              $$renderer2.push("<!--[-->");
              $$renderer2.push(`<div class="ninjadash-tasklist-item__text"><p>${escape_html(todo.description)}</p></div>`);
            } else {
              $$renderer2.push("<!--[!-->");
            }
            $$renderer2.push(`<!--]--></div> `);
            CardExtra($$renderer2);
            $$renderer2.push(`<!----></li>`);
          } else {
            $$renderer2.push("<!--[!-->");
          }
          $$renderer2.push(`<!--]-->`);
        }
        $$renderer2.push(`<!--]--></ul>`);
      } else {
        $$renderer2.push("<!--[!-->");
        $$renderer2.push(`<div class="ninjadash-tasklist-empty"><span>Sorry !! No Todo Found :(</span></div>`);
      }
      $$renderer2.push(`<!--]--></div>`);
    }
    $$renderer2.push(`<!--]--></div></div></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { header, todoStatus, description, todoLimit, trash, completed });
  });
}
function Todos($$renderer) {
  let todoTab = "new";
  Card($$renderer, {
    class: "border-0 px-25 pb-25 h-100",
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        class: "px-0 border-0",
        children: ($$renderer3) => {
          $$renderer3.push(`<h6>Todo List</h6> <div class="card-extra"><ul class="card-tab-links nav"><li><a href="#"${attr_class(clsx("active"))}>New</a></li> <li><a href="#"${attr_class(clsx(""))}>Deleted</a></li> <li><a href="#"${attr_class(clsx(""))}>Completed</a></li></ul></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        class: "p-0",
        children: ($$renderer3) => {
          TodoApp($$renderer3, {
            header: "",
            description: false,
            todoStatus: todoTab,
            todoLimit: "5"
          });
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
}
function MembersProgress_3($$renderer, $$props) {
  let dataPeriod = $$props["dataPeriod"];
  $$renderer.push(`<div class="selling-table-wrap selling-table-wrap--source selling-table-wrap--member table-responsive svelte-1il4dxu"><table class="table table--default table-borderless svelte-1il4dxu"><tbody class="svelte-1il4dxu"><!--[-->`);
  const each_array = ensure_array_like(dataPeriod);
  for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
    let data = each_array[$$index];
    $$renderer.push(`<tr class="svelte-1il4dxu"><td class="svelte-1il4dxu"><div class="selling-product-img d-flex align-items-center svelte-1il4dxu"><span class="svelte-1il4dxu">${escape_html(data.title)}</span></div></td><td class="svelte-1il4dxu">${escape_html(data.salary)}</td><td class="svelte-1il4dxu"><div class="d-flex align-center justify-content-end"><div class="progress-wrap mb-0 me-15"><div class="progress svelte-1il4dxu">`);
    Progress($$renderer, { bar: true, color: data.progress, value: data.status });
    $$renderer.push(`<!----></div></div></div></td></tr>`);
  }
  $$renderer.push(`<!--]--></tbody></table></div>`);
  bind_props($$props, { dataPeriod });
}
function MemberProgress($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const membersProgress = bestSellersData.memberProgressData_3;
    let period = "today";
    let dataPeriod = membersProgress[period];
    Card($$renderer2, {
      class: "border-0 px-25 pb-15 h-100",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "px-0 border-0",
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>Social Media Traffic</h6> `);
            CardExtra($$renderer4);
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          class: "p-0",
          children: ($$renderer4) => {
            MembersProgress_3($$renderer4, { dataPeriod });
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
function Locations($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const mapAPI = "AIzaSyBgYKHZB_QKKLWfIRaYPCadza3nhTAbv7c";
    head("1x8oq8u", $$renderer2, ($$renderer3) => {
      $$renderer3.push(`<script defer="" async=""${attr("src", `https://maps.googleapis.com/maps/api/js?key=${stringify(mapAPI)}&callback=initMap`)}>
	<\/script>`);
      $$renderer3.push(`<!---->`);
    });
    Card($$renderer2, {
      class: "border-0 px-25 h-100",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "px-0 border-0",
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>Location</h6> `);
            CardExtra($$renderer4);
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          class: "p-0 pb-30",
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="google-map svelte-1x8oq8u"></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
function BestSellers($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const sellers = bestSellersData.bestSeller;
    let tableHead = false;
    let period = "today";
    let dataPeriod = sellers[period];
    Card($$renderer2, {
      class: "border-0 px-25 best-sellers h-100",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "px-0 border-0",
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>Recent Seller</h6> <div class="card-extra"><ul class="card-tab-links nav"><li><a href="#"${attr_class(clsx("active"))}>Today</a></li> <li><a href="#"${attr_class(clsx(""))}>Week</a></li> <li><a href="#"${attr_class(clsx(""))}>Year</a></li></ul></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          class: "p-0 pb-3",
          children: ($$renderer4) => {
            Sellers($$renderer4, { dataPeriod, tableHead });
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const breadcrumbData = {
      pageTitle: "Demo Nine",
      bcItem: "Dashboard",
      bcItemActive: "Demo Nine"
    };
    let activeUser = 0;
    let singleContent = chatData[0].privateChat[activeUser].content;
    let userNames = chatData[0].privateChat[activeUser].userName;
    let singleComponent = true;
    head("7glxmr", $$renderer2, ($$renderer3) => {
      $$renderer3.title(($$renderer4) => {
        $$renderer4.push(`<title>Home Nine</title>`);
      });
    });
    $$renderer2.push(`<div class="demo4 mb-25">`);
    Container($$renderer2, {
      fluid: true,
      children: ($$renderer3) => {
        Row($$renderer3, {
          children: ($$renderer4) => {
            Col($$renderer4, {
              lg: 12,
              children: ($$renderer5) => {
                BreadcrumbOne($$renderer5, spread_props([breadcrumbData]));
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 4,
              lg: 6,
              class: "mb-25",
              children: ($$renderer5) => {
                BannersOne($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 4,
              lg: 6,
              class: "mb-25",
              children: ($$renderer5) => {
                PerformanceOverview($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 4,
              class: " mb-25",
              children: ($$renderer5) => {
                Row($$renderer5, {
                  children: ($$renderer6) => {
                    Col($$renderer6, {
                      md: 6,
                      class: "mb-25",
                      children: ($$renderer7) => {
                        InfoCard_2($$renderer7, {});
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Col($$renderer6, {
                      md: 6,
                      class: "mb-25",
                      children: ($$renderer7) => {
                        InfoCard_2($$renderer7, {
                          type: "secondary",
                          icon: "award",
                          text: "Total Awards",
                          counter: "15K"
                        });
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Col($$renderer6, {
                      xxl: 12,
                      children: ($$renderer7) => {
                        NewsLetter_2($$renderer7);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!---->`);
                  },
                  $$slots: { default: true }
                });
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 8,
              lg: 6,
              class: "mb-25",
              children: ($$renderer5) => {
                Tasks($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 4,
              xl: 6,
              class: "mb-25",
              children: ($$renderer5) => {
                MarketingCampaigns_1($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 4,
              md: 6,
              class: "mb-25",
              children: ($$renderer5) => {
                Todos($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 4,
              md: 6,
              class: "mb-25",
              children: ($$renderer5) => {
                TeamList($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 4,
              md: 6,
              class: "mb-25",
              children: ($$renderer5) => {
                ProfileCard($$renderer5, {});
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 4,
              class: "mb-25",
              children: ($$renderer5) => {
                SingleChat($$renderer5, { singleContent, userNames, singleComponent });
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 8,
              children: ($$renderer5) => {
                Row($$renderer5, {
                  children: ($$renderer6) => {
                    Col($$renderer6, {
                      md: 6,
                      class: "mb-25",
                      children: ($$renderer7) => {
                        MemberProgress($$renderer7);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Col($$renderer6, {
                      md: 6,
                      class: "mb-25",
                      children: ($$renderer7) => {
                        Locations($$renderer7);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Col($$renderer6, {
                      xxl: 12,
                      class: "mb-25",
                      children: ($$renderer7) => {
                        BestSellers($$renderer7);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!---->`);
                  },
                  $$slots: { default: true }
                });
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></div>`);
  });
}
export {
  _page as default
};
