import { a6 as fallback, ad as attr_class, aa as escape_html, a9 as bind_props, ae as stringify, a8 as clsx, ac as attr, ag as ensure_array_like, a2 as head, af as spread_props } from "../../../../../chunks/index2.js";
import "clsx";
import { C as Container, R as Row, a as Col } from "../../../../../chunks/Row.js";
import "../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbOne } from "../../../../../chunks/BreadcrumbOne.js";
import { C as Card } from "../../../../../chunks/Card.js";
import { C as CardBody } from "../../../../../chunks/CardBody.js";
import { P as PerformanceOverview } from "../../../../../chunks/PerformanceOverview.js";
import { S as SingleChat } from "../../../../../chunks/SingleChat.js";
import { C as CardHeader } from "../../../../../chunks/CardHeader.js";
import { T as TaskApp } from "../../../../../chunks/TaskApp.js";
import { M as MarketingCampaigns_1, T as TeamList } from "../../../../../chunks/TeamList.js";
import { C as CardExtra } from "../../../../../chunks/CardExtra.js";
import { c as chatData } from "../../../../../chunks/chatData.js";
function BannersOne($$renderer) {
  Card($$renderer, {
    class: "banner-feature banner-feature--5 mb-0 h-100",
    children: ($$renderer2) => {
      $$renderer2.push(`<div class="banner-feature__shape"><img src="/img/glass-trophy.png" alt="img" class="svg"/></div> <div class="d-flex justify-content-center">`);
      CardBody($$renderer2, {
        children: ($$renderer3) => {
          $$renderer3.push(`<h1 class="banner-feature__heading fw-700 color-white">Congratulations Danial!</h1> <p class="banner-feature__para">Best Seller on the last month.</p> <button class="banner-feature__btn btn btn-lg px-20 radius-xs fs-15" type="button">Learn More</button>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----></div>`);
    },
    $$slots: { default: true }
  });
}
function InfoCard($$renderer, $$props) {
  let counter = fallback($$props["counter"], "21k");
  let text = fallback($$props["text"], "Total Products");
  let icon = fallback($$props["icon"], "briefcase-alt");
  let type = fallback($$props["type"], "primary");
  $$renderer.push(`<div class="overview-content overview-content4 text-center radius-xl rony svelte-emkn4y"><div class="d-inline-flex flex-column align-items-center justify-content-center"><div${attr_class(`revenue-chart-box__Icon order-bg-opacity-${stringify(type)}`, "svelte-emkn4y")}><i${attr_class(`uil uil-${stringify(icon)}`, "svelte-emkn4y")}></i></div> <div class="d-flex align-items-start flex-wrap"><div class="mt-3"><p class="mb-1 mb-0 color-gray fs-15">${escape_html(text)}</p> <h1>${escape_html(counter)}</h1></div></div></div></div>`);
  bind_props($$props, { counter, text, icon, type });
}
function NewsLetter($$renderer) {
  Card($$renderer, {
    class: "banner-feature banner-feature--7 border-0 mb-0",
    children: ($$renderer2) => {
      $$renderer2.push(`<div class="d-flex justify-content-center">`);
      CardBody($$renderer2, {
        class: "p-0",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="div p-25"><h4 class="banner-feature__heading">Subscribe to our newsletter</h4> <p class="banner-feature__para">We notify you once any post is published</p> <button type="button" class="btn btn-primary mt-15 btn-md">Subscribe</button></div> <div class="banner-feature__shape"><img src="/img/new-message.png" alt="img" class="svg"/></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----></div>`);
    },
    $$slots: { default: true }
  });
}
function Tasks($$renderer) {
  let taskTab = "all";
  Card($$renderer, {
    class: "border-0 px-25 task-list",
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        class: "px-0 border-0",
        children: ($$renderer3) => {
          $$renderer3.push(`<h6>Task List</h6> <div class="card-extra"><ul class="card-tab-links nav"><li><a href="#"${attr_class(clsx("active"))}>Today</a></li> <li><a href="#"${attr_class(clsx(""))}>Week</a></li> <li><a href="#"${attr_class(clsx(""))}>Month</a></li></ul></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        children: ($$renderer3) => {
          TaskApp($$renderer3, {
            header: "",
            description: false,
            taskStatus: taskTab,
            taskLimit: "5"
          });
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
}
function ProfileCard($$renderer, $$props) {
  let image = fallback($$props["image"], "profile_bg_2.png");
  let bgImage = fallback($$props["bgImage"], "profile_bg.png");
  let title = fallback($$props["title"], "Robert Clinton");
  let tagline = fallback($$props["tagline"], "Best Seller of the last month");
  let socialLinks = fallback($$props["socialLinks"], true);
  $$renderer.push(`<div class="feature-profile svelte-1ax4oyj"><div class="feature-profile__bg svelte-1ax4oyj"><img${attr("src", `/img/${stringify(bgImage)}`)} alt="" class="svelte-1ax4oyj"/></div> <div class="feature-profile_content svelte-1ax4oyj"><img${attr("src", `/img/${stringify(image)}`)} alt="" class="svelte-1ax4oyj"/> <h6 class="svelte-1ax4oyj">${escape_html(title)}</h6> <p class="svelte-1ax4oyj">${escape_html(tagline)}</p> `);
  if (socialLinks) {
    $$renderer.push("<!--[-->");
    $$renderer.push(`<ul class="profile-feature__social svelte-1ax4oyj"><li class="svelte-1ax4oyj"><a href="#" class="bg-primary svelte-1ax4oyj"><i class="lab la-facebook-f"></i></a></li> <li class="svelte-1ax4oyj"><a href="#" class="bg-secondary svelte-1ax4oyj"><i class="lab la-twitter"></i></a></li> <li class="svelte-1ax4oyj"><a href="#" class="bg-info svelte-1ax4oyj"><i class="lab la-dribbble"></i></a></li></ul>`);
  } else {
    $$renderer.push("<!--[!-->");
  }
  $$renderer.push(`<!--]--></div></div>`);
  bind_props($$props, { image, bgImage, title, tagline, socialLinks });
}
function SocialTraffic($$renderer, $$props) {
  let trafficData = $$props["trafficData"];
  $$renderer.push(`<div class="selling-table-wrap selling-table-wrap--source selling-table-wrap--traffic table-responsive svelte-8isiti"><table class="table table--default table-borderless svelte-8isiti"><thead class="svelte-8isiti"><tr class="svelte-8isiti"><th class="svelte-8isiti">Social Media</th><th class="svelte-8isiti">User</th><th class="svelte-8isiti">Session</th><th class="svelte-8isiti">Bounce Rate</th><th class="svelte-8isiti">Avg. Session Duration</th></tr></thead><tbody class="svelte-8isiti"><!--[-->`);
  const each_array = ensure_array_like(trafficData);
  for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
    let data = each_array[$$index];
    $$renderer.push(`<tr class="svelte-8isiti"><td class="svelte-8isiti"><div class="selling-product-img d-flex align-items-center svelte-8isiti"><span${attr_class(`selling-product-img__img bg-${stringify(data.type)}-10 color-${stringify(data.type)}`, "svelte-8isiti")}><i${attr_class(`uil uil-${stringify(data.icon)}`, "svelte-8isiti")}></i></span> <span class="selling-product-img__title svelte-8isiti">${escape_html(data.channel)}</span></div></td><td class="svelte-8isiti">${escape_html(data.traffic)}</td><td class="svelte-8isiti">${escape_html(data.session)}</td><td class="svelte-8isiti">${escape_html(data.bounceRate)}</td><td class="svelte-8isiti">${escape_html(data.duration)}</td></tr>`);
  }
  $$renderer.push(`<!--]--></tbody></table></div>`);
  bind_props($$props, { trafficData });
}
function SocialTraffic_1($$renderer) {
  let trafficData = [
    {
      id: 1,
      channel: "Facebook",
      traffic: "38,536",
      type: "primary",
      icon: "facebook-f",
      session: "457",
      bounceRate: "60%",
      duration: "00:25:30"
    },
    {
      id: 2,
      channel: "Instragram",
      traffic: "28,536",
      type: "info",
      icon: "twitter",
      session: "254",
      bounceRate: "25%",
      duration: "00:14:35"
    },
    {
      id: 4,
      channel: "Twitter",
      traffic: "15,536",
      type: "secondary",
      icon: "instagram",
      session: "753",
      bounceRate: "58%",
      duration: "00:14:32"
    },
    {
      id: 5,
      channel: "YouTube",
      traffic: "10,536",
      type: "danger",
      icon: "youtube",
      session: "895",
      bounceRate: "17%",
      duration: "00:19:24"
    }
  ];
  Card($$renderer, {
    class: "border-0 h-100 social-media-traffic",
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        class: "px-25 border-0",
        children: ($$renderer3) => {
          $$renderer3.push(`<h6>Social Media Traffic</h6> `);
          CardExtra($$renderer3);
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        children: ($$renderer3) => {
          SocialTraffic($$renderer3, { trafficData });
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
}
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const breadcrumbData = {
      pageTitle: "Demo Four",
      bcItem: "Dashboard",
      bcItemActive: "Demo Four"
    };
    let activeUser = 0;
    let singleContent = chatData[0].privateChat[activeUser].content;
    let userNames = chatData[0].privateChat[activeUser].userName;
    let singleComponent = true;
    head("169mlrr", $$renderer2, ($$renderer3) => {
      $$renderer3.title(($$renderer4) => {
        $$renderer4.push(`<title>Home Four</title>`);
      });
    });
    $$renderer2.push(`<div class="demo4 mb-25">`);
    Container($$renderer2, {
      fluid: true,
      children: ($$renderer3) => {
        Row($$renderer3, {
          children: ($$renderer4) => {
            Col($$renderer4, {
              lg: 12,
              children: ($$renderer5) => {
                BreadcrumbOne($$renderer5, spread_props([breadcrumbData]));
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 4,
              lg: 6,
              class: "mb-25",
              children: ($$renderer5) => {
                BannersOne($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 4,
              lg: 6,
              class: "mb-25",
              children: ($$renderer5) => {
                PerformanceOverview($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 4,
              class: " mb-25",
              children: ($$renderer5) => {
                Row($$renderer5, {
                  children: ($$renderer6) => {
                    Col($$renderer6, {
                      md: 6,
                      class: "mb-25",
                      children: ($$renderer7) => {
                        InfoCard($$renderer7, {});
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Col($$renderer6, {
                      md: 6,
                      class: "mb-25",
                      children: ($$renderer7) => {
                        InfoCard($$renderer7, {
                          type: "info",
                          icon: "award",
                          text: "Total Awards",
                          counter: "15K"
                        });
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Col($$renderer6, {
                      xxl: 12,
                      children: ($$renderer7) => {
                        NewsLetter($$renderer7);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!---->`);
                  },
                  $$slots: { default: true }
                });
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xl: 6,
              class: "mb-25",
              children: ($$renderer5) => {
                Tasks($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 6,
              xl: 6,
              class: "mb-25",
              children: ($$renderer5) => {
                MarketingCampaigns_1($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 8,
              children: ($$renderer5) => {
                Row($$renderer5, {
                  children: ($$renderer6) => {
                    Col($$renderer6, {
                      xxl: 6,
                      md: 6,
                      class: "mb-25",
                      children: ($$renderer7) => {
                        ProfileCard($$renderer7, {});
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Col($$renderer6, {
                      xxl: 6,
                      md: 6,
                      class: "mb-25",
                      children: ($$renderer7) => {
                        TeamList($$renderer7);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Col($$renderer6, {
                      xxl: 12,
                      class: "mb-25",
                      children: ($$renderer7) => {
                        SocialTraffic_1($$renderer7);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!---->`);
                  },
                  $$slots: { default: true }
                });
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 4,
              class: "mb-25",
              children: ($$renderer5) => {
                SingleChat($$renderer5, { singleContent, userNames, singleComponent });
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></div>`);
  });
}
export {
  _page as default
};
