import { ad as attr_class, a8 as clsx, ag as ensure_array_like, ac as attr, aa as escape_html, a2 as head } from "../../../../../chunks/index2.js";
import "clsx";
import { R as Row, a as Col, C as Container } from "../../../../../chunks/Row.js";
import "../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { M as MembersProgress, E as Events, e as eventData, B as BlogCard, P as PageHeaderBanner, C as Calendar, K as KnowledgeBase } from "../../../../../chunks/BlogCard.js";
import { U as UserOverview } from "../../../../../chunks/UserOverview.js";
import { C as Card } from "../../../../../chunks/Card.js";
import { C as CardBody } from "../../../../../chunks/CardBody.js";
import { C as CardHeader } from "../../../../../chunks/CardHeader.js";
import { b as bestSellersData } from "../../../../../chunks/table-data.js";
import { C as CardExtra } from "../../../../../chunks/CardExtra.js";
import { T as Timeline } from "../../../../../chunks/Timeline.js";
function MemberProgress($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const membersProgress = bestSellersData.memberProgressData;
    let period = "today";
    let dataPeriod = membersProgress[period];
    Card($$renderer2, {
      class: "border-0 px-25 pb-15 h-100",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "px-0 border-0",
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>Members Progress</h6> <div class="card-extra"><ul class="card-tab-links nav"><li><a href="#"${attr_class(clsx("active"))}>Today</a></li> <li><a href="#"${attr_class(clsx(""))}>Week</a></li> <li><a href="#"${attr_class(clsx(""))}>Year</a></li></ul></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          class: "p-0",
          children: ($$renderer4) => {
            MembersProgress($$renderer4, { dataPeriod });
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
function UpcomingEvents($$renderer) {
  const upcomingEvents = eventData;
  let period = "today";
  let dataPeriod = upcomingEvents[period];
  Card($$renderer, {
    class: "border-0 px-25 pb-10 project-task-list--event",
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        class: "px-0 border-0",
        children: ($$renderer3) => {
          $$renderer3.push(`<h6>Upcoming Events</h6> <div class="card-extra"><ul class="card-tab-links nav"><li><a href="#"${attr_class(clsx("active"))}>Today</a></li> <li><a href="#"${attr_class(clsx(""))}>Week</a></li> <li><a href="#"${attr_class(clsx(""))}>Year</a></li></ul></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        class: "p-0",
        children: ($$renderer3) => {
          Events($$renderer3, { dataPeriod });
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
}
function Inbox($$renderer) {
  const inboxData = [
    {
      id: 1,
      user: {
        fName: "Shane",
        lName: "Watson",
        msg: "We are looking a full stack developer",
        img: "/img/inbox-1.png"
      },
      time: "9:00 AM"
    },
    {
      id: 2,
      user: {
        fName: "Chris",
        lName: "Dohan",
        msg: "Well done, great work ",
        img: "/img/inbox-2.png"
      },
      time: "9:30 AM"
    },
    {
      id: 3,
      user: {
        fName: "Robert",
        lName: "Clinton",
        msg: "Tonight we are going to submit new...",
        img: "/img/inbox-3.png"
      },
      time: "9:30 AM"
    },
    {
      id: 4,
      user: {
        fName: "Daniel",
        lName: "White",
        msg: "Please send me final file",
        img: "/img/inbox-1.png"
      },
      time: "9:30 AM"
    },
    {
      id: 5,
      user: {
        fName: "Black",
        lName: "Smith",
        msg: "Good luck Tom",
        img: "/img/inbox-2.png"
      },
      time: "9:30 AM"
    }
  ];
  Card($$renderer, {
    class: "border-0 card-inbox",
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        class: "border-0",
        children: ($$renderer3) => {
          $$renderer3.push(`<h6>Inbox</h6> `);
          CardExtra($$renderer3);
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        class: "pb-40 pt-0",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="card-inbox-members svelte-15fpwqi"><ul class="svelte-15fpwqi"><!--[-->`);
          const each_array = ensure_array_like(inboxData);
          for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
            let item = each_array[$$index];
            $$renderer3.push(`<li class="svelte-15fpwqi"><div class="card-inbox-members__left svelte-15fpwqi"><img class="rounded-circle svelte-15fpwqi"${attr("src", item.user.img)} alt=""/> <div class="card-inbox-members__title svelte-15fpwqi"><h6 class="svelte-15fpwqi">${escape_html(item.user.fName)} ${escape_html(item.user.lName)}</h6> <div class="card-inbox-members__title--online svelte-15fpwqi">${escape_html(item.user.msg)}</div></div></div> <div class="card-inbox-member__right"><div class="card-inbox-member__time svelte-15fpwqi"><span class="svelte-15fpwqi">${escape_html(item.time)}</span></div></div></li>`);
          }
          $$renderer3.push(`<!--]--></ul></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
}
function Blogs($$renderer) {
  let blogData = [
    {
      thumbnail: "/img/bg2.png",
      postedOn: "15 March 2021",
      title: "The Ultimate Glossary of Terms",
      excerpt: "There are many variations of passages of majority have suffered alteration in some form",
      authorImg: "/img/alex-suprun.png",
      authorName: "Machel Bold",
      likes: "15 K",
      comments: "75"
    },
    {
      thumbnail: "/img/bg3.png",
      postedOn: "12 February 2021",
      title: "Multiple Dashboard Design Idea",
      excerpt: "There are many variations of passages of majority have suffered alteration in some form",
      authorImg: "/img/alex-suprun.png",
      authorName: "Alex Kery",
      likes: "11 K",
      comments: "85"
    },
    {
      thumbnail: "/img/bg4.png",
      postedOn: "23 January 2021",
      title: "How to Create a Niche Based",
      excerpt: "There are many variations of passages of majority have suffered alteration in some form",
      authorImg: "/img/alex-suprun.png",
      authorName: "Jordan Smeth",
      likes: "21 K",
      comments: "67"
    }
  ];
  Row($$renderer, {
    children: ($$renderer2) => {
      $$renderer2.push(`<!--[-->`);
      const each_array = ensure_array_like(blogData);
      for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
        let content = each_array[$$index];
        Col($$renderer2, {
          xxl: 4,
          md: 6,
          class: "mb-25",
          children: ($$renderer3) => {
            BlogCard($$renderer3, { content });
          },
          $$slots: { default: true }
        });
      }
      $$renderer2.push(`<!--]-->`);
    },
    $$slots: { default: true }
  });
}
function _page($$renderer) {
  let imgPath = "/img/banner-img.png";
  let title = "Hey Danial! Welcome to the Dashboard";
  head("1821bf7", $$renderer, ($$renderer2) => {
    $$renderer2.title(($$renderer3) => {
      $$renderer3.push(`<title>Home Five</title>`);
    });
  });
  $$renderer.push(`<div class="demo5">`);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            xxl: 12,
            class: "mt-25 mb-25",
            children: ($$renderer4) => {
              PageHeaderBanner($$renderer4, { imgPath, title });
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            xxl: 8,
            class: "mb-25",
            children: ($$renderer4) => {
              UserOverview($$renderer4);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            xxl: 4,
            class: "mb-25",
            children: ($$renderer4) => {
              Calendar($$renderer4, {});
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            xl: 6,
            class: "mb-25",
            children: ($$renderer4) => {
              MemberProgress($$renderer4);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            xl: 6,
            class: "mb-25",
            children: ($$renderer4) => {
              UpcomingEvents($$renderer4);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            xxl: 4,
            lg: 6,
            class: "mb-25",
            children: ($$renderer4) => {
              KnowledgeBase($$renderer4);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            xxl: 4,
            lg: 6,
            class: "mb-25",
            children: ($$renderer4) => {
              Timeline($$renderer4);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            xxl: 4,
            class: "mb-25",
            children: ($$renderer4) => {
              Inbox($$renderer4);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            xxl: 12,
            class: "mb-25",
            children: ($$renderer4) => {
              Blogs($$renderer4);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
export {
  _page as default
};
