import { ad as attr_class, ac as attr, aa as escape_html, a9 as bind_props, ae as stringify, a8 as clsx, ag as ensure_array_like, a2 as head, af as spread_props } from "../../../../../chunks/index2.js";
import "clsx";
import { C as Container, R as Row, a as Col } from "../../../../../chunks/Row.js";
import "../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbOne } from "../../../../../chunks/BreadcrumbOne.js";
import { o as overviewCardData } from "../../../../../chunks/overviewCardOld.js";
import { C as Card } from "../../../../../chunks/Card.js";
import { C as CardBody } from "../../../../../chunks/CardBody.js";
import { C as CardHeader } from "../../../../../chunks/CardHeader.js";
import { C as Chartjs } from "../../../../../chunks/Chartjs.js";
import { a as customTooltips, c as chartLinearGradient } from "../../../../../chunks/utilities.js";
import { d as doughnutData } from "../../../../../chunks/dashboardChartContent.js";
import { t as totalChartData } from "../../../../../chunks/totalCurrentPeriodMonth.js";
import { b as bestSellersData } from "../../../../../chunks/table-data.js";
import { A as ActiveUsers } from "../../../../../chunks/ActiveUsers.js";
/* empty css                                                                */
import { T as TopProducts } from "../../../../../chunks/TopProducts.js";
function OverviewCards($$renderer, $$props) {
  let type = $$props["type"];
  let icon = $$props["icon"];
  let total = $$props["total"];
  let prefix = $$props["prefix"];
  let suffix = $$props["suffix"];
  let label = $$props["label"];
  let growth = $$props["growth"];
  let growthRate = $$props["growthRate"];
  $$renderer.push(`<div class="overview-content overview-content3 bg-none"><div class="d-flex"><div${attr_class(`revenue-chart-box__Icon me-20 order-bg-opacity-${stringify(type)} color-${stringify(type)}`)}><img class="svg" alt=""${attr("src", `/img/svg/${icon}`)}/></div> <div class="d-flex align-items-start flex-wrap"><div class="me-20"><h2>${escape_html(prefix + total + suffix)}</h2> <p class="mt-1 mb-0">${escape_html(label)}</p></div> <div class="ap-po-details bg-none"><span${attr_class(`growth-status ${stringify(growth === "upward" ? "color-success" : "color-danger")}`)}>`);
  if (growth === "upward") {
    $$renderer.push("<!--[-->");
    $$renderer.push(`<span class="uil uil-arrow-up"></span>`);
  } else {
    $$renderer.push("<!--[!-->");
    $$renderer.push(`<span class="uil uil-arrow-down"></span>`);
  }
  $$renderer.push(`<!--]--> <strong>${escape_html(growthRate)}%</strong></span></div></div></div></div>`);
  bind_props($$props, { type, icon, total, prefix, suffix, label, growth, growthRate });
}
function MonthlyEarning($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let salesRevenueDatasets;
    let primaryColor;
    let primaryColorRGB;
    let revenue = "months";
    const tooltip = {
      callbacks: {
        label(context) {
          let label = context.dataset.label || "";
          if (label) {
            label += ": ";
          }
          if (context.parsed.y !== null) {
            label += new Intl.NumberFormat().format(context.parsed.y);
          }
          return `<span class="data-label">${label}K</span>`;
        }
      }
    };
    let salesRevenue = {
      today: {
        users: [0, 10, 36, 25, 50, 40, 55, 40, 75, 35, 40, 35],
        labels: [
          "2hr",
          "4hr",
          "6hr",
          "8hr",
          "10hr",
          "12hr",
          "14hr",
          "16hr",
          "18hr",
          "20hr",
          "22hr",
          "24hr"
        ]
      },
      week: {
        users: [40, 30, 35, 20, 25, 40, 35],
        labels: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]
      },
      months: {
        users: [45, 20, 35, 32, 50, 45, 55, 71, 36, 65, 55, 75],
        labels: [
          "Jan",
          "Feb",
          "Mar",
          "App",
          "May",
          "Jun",
          "Jul",
          "Aug",
          "Sep",
          "Nov",
          "Oct",
          "Dec"
        ]
      }
    };
    const scales = {
      y: {
        beginAtZero: true,
        border: { display: false },
        grid: {
          color: "#485e9029",
          borderDash: [3, 3],
          zeroLineColor: "#485e9029",
          zeroLineWidth: 1,
          zeroLineBorderDash: [3, 3],
          drawTicks: false,
          drawBorder: false,
          zeroLineWidth: 3,
          borderWidth: 0
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474",
          Min: 50,
          Max: 80,
          stepSize: 20,
          padding: 15,
          callback(label) {
            return `${label}k`;
          }
        }
      },
      x: {
        border: { display: false },
        grid: {
          display: true,
          zeroLineWidth: 0,
          drawTicks: true,
          drawBorder: false,
          zeroLineColor: "#E3E6EF",
          color: "transparent",
          z: 1
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474"
        }
      }
    };
    let tooltips = { custom: customTooltips, ...tooltip };
    salesRevenueDatasets = [
      {
        data: salesRevenue[revenue].users,
        borderColor: primaryColor,
        borderWidth: 3,
        fill: true,
        backgroundColor: () => chartLinearGradient(document.getElementById("ninjadash-sales-revenue"), 300, {
          start: `rgba(${primaryColorRGB},0.5)`,
          end: "rgba(255,255,255,0.4)"
        }),
        label: "Current period",
        pointStyle: "circle",
        pointRadius: "0",
        hoverRadius: "6",
        pointBorderColor: "#fff",
        pointBackgroundColor: primaryColor,
        hoverBorderWidth: 2,
        amount: "$7,596",
        amountClass: "current-amount",
        lineTension: 0.5
      }
    ];
    Card($$renderer2, {
      class: "monthly-earning border-0 h-100",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "border-0",
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>Monthly Earning</h6> <div class="card-extra"><ul class="card-tab-links nav"><li><a href="#"${attr_class(clsx(""))}>Today</a></li> <li><a href="#"${attr_class(clsx(""))}>Week</a></li> <li><a href="#"${attr_class(clsx("active"))}>Month</a></li></ul></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="wp-chart">`);
            {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<div class="parentContainer">`);
              Chartjs($$renderer4, {
                type: "line",
                id: "ninjadash-sales-revenue",
                className: "ninjadash-sales-revenue",
                labels: salesRevenue[revenue].labels,
                datasets: salesRevenueDatasets,
                scales,
                tooltip: tooltips,
                height: 108
              });
              $$renderer4.push(`<!----></div>`);
            }
            $$renderer4.push(`<!--]--></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
function ProfitGrowth($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let profitGrowthDataset;
    let profitGrowthData = doughnutData.profitGrowth;
    let primaryColor;
    let primaryColorRGB;
    let infoColor;
    let infoColorRGB;
    const tooltip = {
      callbacks: {
        label(context) {
          let label = context.dataset.label || "";
          if (label) {
            label += ": ";
          }
          if (context.parsed.y !== null) {
            label += new Intl.NumberFormat().format(context.parsed.y);
          }
          return `<span class="data-label">${label}K</span>`;
        }
      }
    };
    const scales = {
      y: {
        beginAtZero: true,
        border: { display: false },
        grid: {
          color: "#485e9029",
          borderDash: [3, 3],
          zeroLineColor: "#485e9029",
          zeroLineWidth: 1,
          zeroLineBorderDash: [3, 3],
          drawTicks: false,
          drawBorder: false,
          zeroLineWidth: 3,
          borderWidth: 0
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474",
          max: Math.max(...profitGrowthData.orders),
          max: 80,
          min: 0,
          stepSize: 20,
          padding: 20,
          callback(value, index, ticks) {
            return value + "k";
          }
        }
      },
      x: {
        border: { display: false },
        grid: {
          display: true,
          zeroLineWidth: 2,
          zeroLineColor: "transparent",
          color: "transparent",
          z: 1,
          tickMarkLength: 10,
          drawTicks: true,
          drawBorder: false
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474"
        }
      }
    };
    profitGrowthDataset = [
      {
        data: profitGrowthData.orders,
        backgroundColor: `rgba(${primaryColorRGB},0.5)`,
        hoverBackgroundColor: primaryColor,
        label: "Orders",
        average: "50.8",
        maxBarThickness: 10,
        borderRadius: 2,
        barThickness: 16,
        percent: 49
      },
      {
        data: profitGrowthData.sales,
        backgroundColor: `rgba(${infoColorRGB},0.5)`,
        hoverBackgroundColor: infoColor,
        label: "Sales",
        average: "$28k",
        maxBarThickness: 10,
        borderRadius: 2,
        barThickness: 16,
        percent: 60
      }
    ];
    Card($$renderer2, {
      class: "border-0 profit-growth h-100",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "border-0",
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="chartLine-po-details__overview-content w-100"><div class="chartLine-po-details__content d-flex flex-wrap justify-content-between"><div class="chartLine-po-details__titlebar"><h1>Profit Growth</h1></div></div> <div class="chartLine-po-details__time"><h5>$8,550</h5> <span class="color-success"><i class="uil uil-arrow-up"></i> <strong>25.36%</strong></span></div></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="cashflow-chart"><ul class="legend-static mt-1 d-flex justify-content-center"><li class="custom-label"><span class="bg-primary"></span>Order</li> <li class="custom-label"><span class="bg-info"></span>Sale</li></ul> `);
            {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<div class="parentContainer">`);
              Chartjs($$renderer4, {
                className: "ninjadash-profit-growth",
                id: "ninjadash-profit-growth",
                labels: profitGrowthData.labels,
                datasets: profitGrowthDataset,
                type: "bar",
                tooltip,
                scales,
                height: 147
              });
              $$renderer4.push(`<!----></div>`);
            }
            $$renderer4.push(`<!--]--></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
function TotalLineChartMonth($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let totalChartDataset, scales, layout;
    let primaryColor;
    let primaryColorRGB;
    const tooltip = {
      usePointStyle: true,
      callbacks: {
        label(context) {
          let label = context.dataset.label || "";
          if (label) {
            label += ": ";
          }
          if (context.parsed.y !== null) {
            label += new Intl.NumberFormat().format(context.parsed.y);
          }
          return `<span class="data-label">${label}k</span>`;
        }
      }
    };
    totalChartDataset = [
      {
        data: totalChartData.orders,
        backgroundColor: `rgba(${primaryColorRGB},0.5)`,
        hoverBackgroundColor: primaryColor,
        borderColor: primaryColor,
        label: "Current Period",
        total: "8,550",
        prefix: "$",
        growthRate: "25",
        growthStatus: "up",
        labelType: "primary",
        borderWidth: 3,
        hoverRadius: "6",
        pointBackgroundColor: primaryColor,
        pointRadius: 0,
        pointHoverRadius: 6,
        pointHitRadius: 30,
        pointStyle: "circle",
        pointHoverBorderWidth: 2
      }
    ];
    scales = {
      y: {
        beginAtZero: true,
        border: { display: false },
        grid: {
          color: "#485e9029",
          borderDash: [3, 3],
          zeroLineColor: "#485e9029",
          zeroLineWidth: 1,
          zeroLineBorderDash: [3, 3],
          drawTicks: false,
          drawBorder: false,
          zeroLineWidth: 3,
          borderWidth: 0
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474",
          padding: 15,
          max: 80,
          min: 0,
          stepSize: 20,
          callback(value) {
            return `${value}k`;
          }
        }
      },
      x: {
        border: { display: false },
        grid: {
          display: true,
          zeroLineWidth: 2,
          zeroLineColor: "transparent",
          color: "transparent",
          z: 1,
          tickMarkLength: 10,
          drawTicks: true,
          drawBorder: false
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474"
        }
      }
    };
    layout = { padding: { left: -13, right: -10, top: 0, bottom: 0 } };
    Card($$renderer2, {
      class: "border-0 chartLine-po-details",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "border-0 px-25 pt-25 pb-30",
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="chartLine-po-details__overview-content w-100 svelte-1r0uuh9"><div class="chartLine-po-details__content d-flex flex-wrap justify-content-between"><div class="chartLine-po-details__titlebar svelte-1r0uuh9"><h1 class="svelte-1r0uuh9">Total Sales</h1> <p class="svelte-1r0uuh9">(Last 10 months)</p></div></div> <div class="chartLine-po-details__time svelte-1r0uuh9"><h5>$8,550</h5> <span class="color-success svelte-1r0uuh9"><i class="uil uil-arrow-up"></i> <strong class="svelte-1r0uuh9">25.36%</strong></span></div></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          class: "px-25",
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="wp-chart"><div class="parentContainer">`);
            Chartjs($$renderer4, {
              className: "totalLineChartsMonth",
              id: "totalLineChartsMonth",
              labels: totalChartData.labels,
              datasets: totalChartDataset,
              type: "line",
              tooltip,
              scales,
              layout,
              height: 192
            });
            $$renderer4.push(`<!----></div></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
function ActiveUsers_1($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let users = bestSellersData.activeUserDataOld;
    let period = "today";
    let dataPeriod = users[period];
    Card($$renderer2, {
      class: "border-0 px-25 total-active-user h-100",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "px-0 border-0",
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>Active Users</h6> <div class="card-extra"><ul class="card-tab-links nav"><li><a href="#"${attr_class(clsx("active"))}>Today</a></li> <li><a href="#"${attr_class(clsx(""))}>Week</a></li> <li><a href="#"${attr_class(clsx(""))}>Month</a></li></ul></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          class: "p-0",
          children: ($$renderer4) => {
            ActiveUsers($$renderer4, { dataPeriod });
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
function SalesOverview($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    Card($$renderer2, {
      class: "border-0 h-100",
      children: ($$renderer3) => {
        {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]-->`);
      },
      $$slots: { default: true }
    });
  });
}
function TopProducts_1($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const products = bestSellersData.topProduct;
    let period = "today";
    let dataPeriod = products[period];
    Card($$renderer2, {
      class: "border-0 px-25 pb-15 h-100",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "px-0 border-0",
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>Top Products</h6> <div class="card-extra"><ul class="card-tab-links nav"><li><a href="#"${attr_class(clsx("active"))}>Today</a></li> <li><a href="#"${attr_class(clsx(""))}>Week</a></li> <li><a href="#"${attr_class(clsx(""))}>year</a></li></ul></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          class: "p-0",
          children: ($$renderer4) => {
            TopProducts($$renderer4, { dataPeriod });
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
function NewProductsOld($$renderer, $$props) {
  let dataPeriod = $$props["dataPeriod"];
  $$renderer.push(`<div class="selling-table-wrap table-responsive svelte-1menol5"><table class="table table--default table-borderless svelte-1menol5"><thead class="svelte-1menol5"><tr class="svelte-1menol5"><th class="svelte-1menol5">Products Name</th><th class="svelte-1menol5">Price</th></tr></thead><tbody class="svelte-1menol5"><!--[-->`);
  const each_array = ensure_array_like(dataPeriod);
  for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
    let data = each_array[$$index];
    $$renderer.push(`<tr class="svelte-1menol5"><td class="svelte-1menol5"><div class="selling-product-img d-flex align-items-center svelte-1menol5"><img class="radius-xs img-fluid order-bg-opacity-primary svelte-1menol5"${attr("src", `/img/products/electronics/${stringify(data.img)}`)} alt="img"/> <span class="svelte-1menol5">${escape_html(data.name)}</span></div></td><td class="svelte-1menol5">${escape_html(data.price)}</td></tr>`);
  }
  $$renderer.push(`<!--]--></tbody></table></div>`);
  bind_props($$props, { dataPeriod });
}
function NewProducts_1($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const products = bestSellersData.newProductOld;
    let period = "today";
    let dataPeriod = products[period];
    Card($$renderer2, {
      class: "border-0 px-25 new-products h-100",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "px-0 border-0",
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>New Products</h6> <div class="card-extra"><ul class="card-tab-links nav"><li><a href="#"${attr_class(clsx("active"))}>Today</a></li> <li><a href="#"${attr_class(clsx(""))}>Week</a></li> <li><a href="#"${attr_class(clsx(""))}>year</a></li></ul></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          class: "p-0",
          children: ($$renderer4) => {
            NewProductsOld($$renderer4, { dataPeriod });
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const overviewDataSorted = overviewCardData.slice(4, 8);
    const breadcrumbData = {
      pageTitle: "Demo Eight",
      bcItem: "Dashboard",
      bcItemActive: "Demo Eight"
    };
    head("6165y4", $$renderer2, ($$renderer3) => {
      $$renderer3.title(($$renderer4) => {
        $$renderer4.push(`<title>Home Eight</title>`);
      });
    });
    $$renderer2.push(`<div class="demo3 mb-25">`);
    Container($$renderer2, {
      fluid: true,
      children: ($$renderer3) => {
        Row($$renderer3, {
          children: ($$renderer4) => {
            Col($$renderer4, {
              lg: 12,
              children: ($$renderer5) => {
                BreadcrumbOne($$renderer5, spread_props([breadcrumbData]));
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 12,
              lg: 6,
              class: "mb-25",
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="ap-po-details ap-po-details--3 new h-100 radius-xl d-flex"><!--[-->`);
                const each_array = ensure_array_like(overviewDataSorted);
                for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
                  let item = each_array[$$index];
                  OverviewCards($$renderer5, spread_props([item]));
                }
                $$renderer5.push(`<!--]--></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 7,
              class: "mb-25",
              children: ($$renderer5) => {
                MonthlyEarning($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 5,
              class: "mb-25",
              children: ($$renderer5) => {
                ProfitGrowth($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 4,
              class: "mb-25",
              children: ($$renderer5) => {
                TotalLineChartMonth($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 8,
              class: "mb-25",
              children: ($$renderer5) => {
                ActiveUsers_1($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 4,
              lg: 6,
              class: "mb-25",
              children: ($$renderer5) => {
                SalesOverview($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 4,
              class: "mb-25",
              children: ($$renderer5) => {
                TopProducts_1($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 4,
              class: "mb-25",
              children: ($$renderer5) => {
                NewProducts_1($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></div>`);
  });
}
export {
  _page as default
};
