import { ag as ensure_array_like, ac as attr, ae as stringify, aa as escape_html, ad as attr_class, a2 as head, af as spread_props } from "../../../../../../chunks/index2.js";
import "clsx";
import { R as Row, C as Container, a as Col } from "../../../../../../chunks/Row.js";
import "../../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbTwo } from "../../../../../../chunks/BreadcrumbTwo.js";
import { C as Card } from "../../../../../../chunks/Card.js";
import { C as CardBody } from "../../../../../../chunks/CardBody.js";
import { C as CardExtra } from "../../../../../../chunks/CardExtra.js";
import { t as teamData } from "../../../../../../chunks/teamData.js";
function Team($$renderer) {
  const socialIcons = [
    { icon: "facebook-f", color: "facebook" },
    { icon: "twitter", color: "twitter" },
    { icon: "dribbble", color: "ruby" },
    { icon: "instagram", color: "instagram" }
  ];
  Row($$renderer, {
    class: "mb-20",
    children: ($$renderer2) => {
      $$renderer2.push(`<!--[-->`);
      const each_array = ensure_array_like(teamData);
      for (let $$index_1 = 0, $$length = each_array.length; $$index_1 < $$length; $$index_1++) {
        let item = each_array[$$index_1];
        $$renderer2.push(`<div class="cos-xl-2 mb-30 col-sm-6">`);
        Card($$renderer2, {
          class: "position-relative user-member-card",
          children: ($$renderer3) => {
            CardBody($$renderer3, {
              class: "text-center p-30",
              children: ($$renderer4) => {
                $$renderer4.push(`<div class="account-profile"><div class="ap-img d-flex justify-content-center"><img class="ap-img__main rounded-circle mb-20 bg-opacity-primary wh-150"${attr("src", `/img/${stringify(item.img)}`)} alt="profile"/></div> <div class="ap-nameAddress pb-3"><h6 class="ap-nameAddress__title">${escape_html(item.name)}</h6> <p class="ap-nameAddress__subTitle fs-13 pt-1 m-0">${escape_html(item.designation)}</p></div> <ul class="db-social-parent mb-0 justify-content-center"><!--[-->`);
                const each_array_1 = ensure_array_like(socialIcons);
                for (let $$index = 0, $$length2 = each_array_1.length; $$index < $$length2; $$index++) {
                  let icon = each_array_1[$$index];
                  $$renderer4.push(`<li class="db-social-parent__item"><a${attr_class(`color-${stringify(icon.color)} hover-${stringify(icon.color)} wh-38 fs-16 rounded-circle`)} href="#"><i${attr_class(`uil uil-${stringify(icon.icon)}`)}></i></a></li>`);
                }
                $$renderer4.push(`<!--]--></ul></div> <div class="tm-card-overlay position-absolute">`);
                CardExtra($$renderer4);
                $$renderer4.push(`<!----></div>`);
              },
              $$slots: { default: true }
            });
          },
          $$slots: { default: true }
        });
        $$renderer2.push(`<!----></div>`);
      }
      $$renderer2.push(`<!--]-->`);
    },
    $$slots: { default: true }
  });
}
function _page($$renderer) {
  const breadcrumbData = { pageTitle: "Team Members", pageLabel: "Home" };
  head("h0x3dx", $$renderer, ($$renderer2) => {
    $$renderer2.title(($$renderer3) => {
      $$renderer3.push(`<title>Team Members</title>`);
    });
  });
  $$renderer.push(`<div class="component-page mb-25">`);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              BreadcrumbTwo($$renderer4, spread_props([breadcrumbData]));
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            xxl: 12,
            children: ($$renderer4) => {
              Team($$renderer4);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
export {
  _page as default
};
