import { ag as ensure_array_like, ac as attr, ae as stringify, aa as escape_html, ad as attr_class, a2 as head, af as spread_props } from "../../../../../../chunks/index2.js";
import "clsx";
import { C as Container, R as Row, a as Col } from "../../../../../../chunks/Row.js";
import "../../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbTwo } from "../../../../../../chunks/BreadcrumbTwo.js";
import { P as PaginationBasic } from "../../../../../../chunks/PaginationBasic2.js";
const usersData = [
  {
    id: 1,
    time: 1587041636455,
    name: "Duran Clayton",
    designation: "CEO & Founder",
    stared: false,
    country: "San Fransisco, CA",
    company: "Supertech ltd",
    email: "duran@example.com",
    img: "tm1.png",
    joining: "11 Jun 2020",
    status: "active"
  },
  {
    id: 2,
    time: 1587041711525,
    name: "David Milar",
    designation: "Lead Developer",
    stared: true,
    country: "San Fransisco, CA",
    company: "Realestate Solution",
    email: "davdid@example.com",
    img: "tm2.png",
    joining: "31 May 2021",
    status: "deactive"
  },
  {
    id: 3,
    time: 1587041758255,
    name: "Tom Curan",
    designation: "UI/UX Designer",
    stared: true,
    country: "San Fransisco, CA",
    company: "Business Insider",
    email: "tomcuran@example.com",
    img: "tm3.png",
    joining: "01 Apr 2021",
    status: "blocked"
  },
  {
    id: 4,
    time: 1587041856695,
    name: "Stuard Broad",
    designation: "Frontend Architect",
    stared: false,
    country: "San Fransisco, CA",
    company: "Tech Development",
    email: "stuardb@example.com",
    img: "tm4.png",
    joining: "31 May 2021",
    status: "active"
  },
  {
    id: 5,
    time: 1587041880519,
    name: "Crish Moris",
    designation: "Backend Developer",
    stared: false,
    country: "San Fransisco, CA",
    company: "Akaz Manufacturer",
    email: "chrismoric@example.com",
    img: "tm5.png",
    joining: "15 Feb 2021",
    status: "active"
  },
  {
    id: 6,
    time: 1587041932783,
    name: "Salman But",
    designation: "Software Engineer",
    stared: false,
    country: "San Fransisco, CA",
    company: "Business GOI",
    email: "salmanbett@example.com",
    img: "tm6.png",
    joining: "21 Dec 2017",
    status: "active"
  },
  {
    id: 7,
    time: 1587041957926,
    name: "Mohammad Amir",
    designation: "Graphics Developer",
    stared: false,
    country: "San Fransisco, CA",
    company: "Aircnc Limited",
    email: "mohaamir@example.com",
    img: "tm7.png",
    joining: "31 May 2021",
    status: "active"
  },
  {
    id: 8,
    time: 1587041979566,
    name: "Musfiqur Rohim",
    designation: "Support Engineer",
    stared: false,
    country: "San Fransisco, CA",
    company: "Sovware Incorporate",
    email: "mushiro@example.com",
    img: "tm8.png",
    joining: "11 May 2018",
    status: "active"
  }
];
function UserTable($$renderer) {
  let checked;
  checked = false;
  $$renderer.push(`<div class="userDatatable global-shadow border-light-0 p-30 bg-white radius-xl w-100 mb-30"><div class="table-responsive"><table class="table mb-0 table-borderless"><thead><tr class="userDatatable-header"><th><div class="d-flex align-items-center"><div class="custom-checkbox check-all"><input class="checkbox" type="checkbox" id="check-all"/> <label for="check-all">User</label></div></div></th><th><span class="userDatatable-title">emaill</span></th><th><span class="userDatatable-title">company</span></th><th><span class="userDatatable-title">position</span></th><th><span class="userDatatable-title">join date</span></th><th><span class="userDatatable-title">status</span></th><th><span class="userDatatable-title float-end">action</span></th></tr></thead><tbody><!--[-->`);
  const each_array = ensure_array_like(usersData);
  for (let i = 0, $$length = each_array.length; i < $$length; i++) {
    let data = each_array[i];
    $$renderer.push(`<tr><td><div class="d-flex"><div class="userDatatable__imgWrapper d-flex align-items-center"><div class="checkbox-group-wrapper"><div class="checkbox-group d-flex"><div class="checkbox-theme-default custom-checkbox checkbox-group__single d-flex"><input class="checkbox" type="checkbox"${attr("id", `check-grp-content-${stringify(i)}`)}${attr("checked", checked, true)}/> <label${attr("for", `check-grp-content-${stringify(i)}`)}></label></div></div></div> <a href="#" class="profile-image rounded-circle d-block m-0 wh-38"><img${attr("src", `/img/${stringify(data.img)}`)} alt="user" class="img-fluid"/></a></div> <div class="userDatatable-inline-title"><a href="#" class="text-dark fw-500"><h6>${escape_html(data.name)}</h6></a> <p class="d-block mb-0">${escape_html(data.country)}</p></div></div></td><td><div class="userDatatable-content">${escape_html(data.email)}</div></td><td><div class="userDatatable-content">${escape_html(data.company)}</div></td><td><div class="userDatatable-content">${escape_html(data.designation)}</div></td><td><div class="userDatatable-content">${escape_html(data.joining)}</div></td><td><div class="userDatatable-content d-inline-block"><span${attr_class(`bg-opacity-${stringify(data.status === "active" ? "success" : data.status === "deactive" ? "warning" : "danger")} color-${stringify(data.status === "active" ? "success" : data.status === "deactive" ? "warning" : "danger")} rounded-pill userDatatable-content-status ${stringify(data.status)}`)}>${escape_html(data.status)}</span></div></td><td><ul class="orderDatatable_actions mb-0 d-flex flex-wrap"><li><a href="#" class="view"><i class="uil uil-eye"></i></a></li> <li><a href="#" class="edit"><i class="uil uil-edit"></i></a></li> <li><a href="#" class="remove"><i class="uil uil-trash-alt"></i></a></li></ul></td></tr>`);
  }
  $$renderer.push(`<!--]--></tbody></table></div></div>`);
}
function _page($$renderer) {
  const breadcrumbData = { pageTitle: "Users Datatable", pageLabel: "Home" };
  head("1xg0v9i", $$renderer, ($$renderer2) => {
    $$renderer2.title(($$renderer3) => {
      $$renderer3.push(`<title>Users Datatable</title>`);
    });
  });
  $$renderer.push(`<div class="component-page mb-25">`);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              BreadcrumbTwo($$renderer4, spread_props([breadcrumbData]));
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              UserTable($$renderer4);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              $$renderer4.push(`<div class="user-pagination">`);
              PaginationBasic($$renderer4);
              $$renderer4.push(`<!----></div>`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
export {
  _page as default
};
