import { ag as ensure_array_like, ac as attr, ae as stringify, aa as escape_html, a2 as head, af as spread_props } from "../../../../../../chunks/index2.js";
import "clsx";
import { a as Col, C as Container, R as Row } from "../../../../../../chunks/Row.js";
import "../../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbTwo } from "../../../../../../chunks/BreadcrumbTwo.js";
import { B as Button } from "../../../../../../chunks/Button.js";
import { t as teamData } from "../../../../../../chunks/teamData.js";
import { P as PaginationBasic } from "../../../../../../chunks/PaginationBasic2.js";
function UserList($$renderer) {
  $$renderer.push(`<!--[-->`);
  const each_array = ensure_array_like(teamData);
  for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
    let item = each_array[$$index];
    Col($$renderer, {
      md: 6,
      class: "mb-25",
      children: ($$renderer2) => {
        $$renderer2.push(`<div class="media py-30 ps-sm-30 ps-20 pe-20 bg-white radius-xl users-list"><img class="me-20 rounded-circle wh-80 bg-opacity-primary"${attr("src", `/img/${stringify(item.img)}`)} alt="GenericImage"/> <div class="media-body d-xl-flex users-list-body"><div class="flex-1 pe-xl-30 users-list-body__title"><h6 class="mt-0 fw-500">${escape_html(item.name)}</h6> <span>${escape_html(item.designation)}</span> <p class="mb-0">Lorem ipsum dolor amet, consetetur sadipscing elitr sed diam nonumy eirmod.</p> <div class="users-list-body__bottom"><span><span class="fw-600">$25/</span>hr</span> <span class="ms-15"><span class="fw-600">$88K</span>earned</span></div></div> <div class="users-list__button mt-xl-0 mt-15">`);
        Button($$renderer2, {
          color: "primary",
          size: "default",
          class: "btn-squared text-capitalize px-20 mb-10 global-shadow",
          children: ($$renderer3) => {
            $$renderer3.push(`<!---->view profile`);
          },
          $$slots: { default: true }
        });
        $$renderer2.push(`<!----> `);
        Button($$renderer2, {
          color: "light",
          outline: true,
          class: "border text-capitalize px-25 color-gray transparent shadow2 follow my-xl-0 radius-md",
          children: ($$renderer3) => {
            $$renderer3.push(`<!---->message`);
          },
          $$slots: { default: true }
        });
        $$renderer2.push(`<!----></div></div></div>`);
      },
      $$slots: { default: true }
    });
  }
  $$renderer.push(`<!--]-->`);
}
function _page($$renderer) {
  const breadcrumbData = { pageTitle: "Users List", pageLabel: "Home" };
  head("15bj0ns", $$renderer, ($$renderer2) => {
    $$renderer2.title(($$renderer3) => {
      $$renderer3.push(`<title>Users List</title>`);
    });
  });
  $$renderer.push(`<div class="component-page mb-25">`);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              BreadcrumbTwo($$renderer4, spread_props([breadcrumbData]));
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          UserList($$renderer3);
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              $$renderer4.push(`<div class="user-pagination">`);
              PaginationBasic($$renderer4);
              $$renderer4.push(`<!----></div>`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
export {
  _page as default
};
