import { ag as ensure_array_like, ac as attr, ae as stringify, aa as escape_html, a2 as head, af as spread_props } from "../../../../../../chunks/index2.js";
import "clsx";
import { a as Col, C as Container, R as Row } from "../../../../../../chunks/Row.js";
import "../../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbTwo } from "../../../../../../chunks/BreadcrumbTwo.js";
import { P as PaginationBasic } from "../../../../../../chunks/PaginationBasic2.js";
import { P as Progress } from "../../../../../../chunks/Progress.js";
import { C as CardExtra } from "../../../../../../chunks/CardExtra.js";
const groupData = [
  {
    id: 1,
    time: 1587041636455,
    title: "Dashboard UI",
    company: "San Francisco, CA",
    status: "active",
    content: "Lorem ipsum dolor amet, consetetur sadipscing elitr sed diam",
    groupImg: "ugl1.png",
    members: [
      "tm1.png",
      "tm2.png",
      "tm3.png",
      "tm4.png",
      "tm5.png"
    ],
    projectName: "Plugin Development",
    progress: 67
  },
  {
    id: 2,
    time: 1587041711525,
    title: "Component Library",
    company: "San Francisco, CA",
    status: "active",
    content: "Lorem ipsum dolor amet, consetetur sadipscing elitr sed diam",
    groupImg: "ugl2.png",
    members: [
      "tm1.png",
      "tm2.png",
      "tm3.png",
      "tm4.png",
      "tm5.png",
      "tm6.png",
      "tm7.png"
    ],
    projectName: "Theme Development",
    progress: 34
  },
  {
    id: 3,
    time: 1587041758255,
    title: "Component Library",
    company: "San Francisco, CA",
    status: "active",
    content: "Lorem ipsum dolor amet, consetetur sadipscing elitr sed diam",
    groupImg: "ugl3.png",
    members: [
      "tm1.png",
      "tm2.png",
      "tm3.png",
      "tm4.png"
    ],
    projectName: "Dashboard Template UI",
    progress: 92
  },
  {
    id: 4,
    time: 1587041856695,
    title: "Dashboard UI",
    company: "San Francisco, CA",
    status: "active",
    content: "Lorem ipsum dolor amet, consetetur sadipscing elitr sed diam",
    groupImg: "ugl4.png",
    members: [
      "tm1.png",
      "tm2.png",
      "tm3.png",
      "tm4.png",
      "tm5.png",
      "tm6.png"
    ],
    projectName: "Plugin Third-party Integration",
    progress: 55
  },
  {
    id: 5,
    time: 1587041880519,
    title: "Dashboard UI",
    company: "San Francisco, CA",
    status: "active",
    content: "Lorem ipsum dolor amet, consetetur sadipscing elitr sed diam",
    groupImg: "ugl5.png",
    members: [
      "tm1.png",
      "tm2.png",
      "tm3.png",
      "tm4.png",
      "tm5.png"
    ],
    projectName: "Develop New UI/UX",
    progress: 71
  },
  {
    id: 6,
    time: 1587041932783,
    title: "Dashboard UI",
    company: "San Francisco, CA",
    status: "active",
    content: "Lorem ipsum dolor amet, consetetur sadipscing elitr sed diam",
    groupImg: "ugl6.png",
    members: [
      "tm1.png",
      "tm2.png",
      "tm3.png",
      "tm4.png",
      "tm5.png",
      "tm6.png",
      "tm7.png"
    ],
    projectName: "Client Support Forum",
    progress: 34
  },
  {
    id: 7,
    time: 1587041957926,
    title: "Dashboard UI",
    company: "San Francisco, CA",
    status: "active",
    content: "Lorem ipsum dolor amet, consetetur sadipscing elitr sed diam",
    groupImg: "ugl1.png",
    members: [
      "tm1.png",
      "tm2.png",
      "tm3.png",
      "tm4.png",
      "tm5.png",
      "tm6.png"
    ],
    projectName: "AI Data Analysis",
    progress: 60
  },
  {
    id: 8,
    time: 1587041979566,
    title: "Dashboard UI",
    company: "San Francisco, CA",
    status: "active",
    content: "Lorem ipsum dolor amet, consetetur sadipscing elitr sed diam",
    groupImg: "ugl2.png",
    members: [
      "tm1.png",
      "tm2.png",
      "tm3.png",
      "tm4.png",
      "tm5.png"
    ],
    projectName: "Visual Effect Editing",
    progress: 82
  },
  {
    id: 9,
    time: 1587041979569,
    title: "Dashboard UI",
    company: "San Francisco, CA",
    status: "active",
    content: "Lorem ipsum dolor amet, consetetur sadipscing elitr sed diam",
    groupImg: "ugl3.png",
    members: [
      "tm1.png",
      "tm2.png",
      "tm3.png",
      "tm4.png",
      "tm5.png",
      "tm6.png",
      "tm7.png"
    ],
    projectName: "Generating Custom Leads",
    progress: 43
  }
];
function UserGroup($$renderer) {
  $$renderer.push(`<!--[-->`);
  const each_array = ensure_array_like(groupData);
  for (let $$index_1 = 0, $$length = each_array.length; $$index_1 < $$length; $$index_1++) {
    let item = each_array[$$index_1];
    Col($$renderer, {
      xl: 4,
      md: 6,
      class: "mb-25",
      children: ($$renderer2) => {
        $$renderer2.push(`<div class="user-group px-30 pt-30 pb-25 radius-xl"><div class="border-bottom"><div class="media user-group-media d-flex justify-content-between"><div class="media-body d-flex align-items-center"><img class="me-20 wh-70 rounded-circle bg-opacity-primary"${attr("src", `/img/users-group/${stringify(item.groupImg)}`)} alt="author"/> <div><a href="#"><h6 class="mt-0 fw-500">${escape_html(item.title)}</h6></a> <p class="fs-13 color-light mb-0">${escape_html(item.company)}</p></div></div> <div class="mt-n15">`);
        CardExtra($$renderer2);
        $$renderer2.push(`<!----></div></div> <div class="user-group-people"><p class="mt-15">${escape_html(item.content)}</p> <ul class="d-flex flex-wrap mb-20 user-group-people__parent"><!--[-->`);
        const each_array_1 = ensure_array_like(item.members);
        for (let $$index = 0, $$length2 = each_array_1.length; $$index < $$length2; $$index++) {
          let member = each_array_1[$$index];
          $$renderer2.push(`<li><a href="#"><img class="rounded-circle wh-34 bg-opacity-secondary"${attr("src", `/img/${stringify(member)}`)} alt="author"/></a></li>`);
        }
        $$renderer2.push(`<!--]--></ul></div></div> <div class="user-group-project"><div class="d-flex justify-content-between user-group-progress-top"><div><span class="color-light fs-12">Current project</span> <p class="fs-14 fw-500 color-dark mb-0">${escape_html(item.projectName)}</p></div> <div><span class="color-light fs-12">Project Completed</span> <p class="fs-16 fw-500 color-success mb-0 text-end">${escape_html(item.progress)}</p></div></div> <div class="user-group-progress-bar"><div class="progress-wrap d-flex align-items-center mb-0">`);
        Progress($$renderer2, { color: "primary", value: item.progress });
        $$renderer2.push(`<!----> <span class="ratio-percentage">${escape_html(item.progress)}%</span></div> <p class="color-light fs-12 mb-0">12 / 15 tasks completed</p></div></div></div>`);
      },
      $$slots: { default: true }
    });
  }
  $$renderer.push(`<!--]-->`);
}
function _page($$renderer) {
  const breadcrumbData = { pageTitle: "Users Group", pageLabel: "Home" };
  head("8lxryz", $$renderer, ($$renderer2) => {
    $$renderer2.title(($$renderer3) => {
      $$renderer3.push(`<title>Users Group</title>`);
    });
  });
  $$renderer.push(`<div class="component-page mb-25">`);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              BreadcrumbTwo($$renderer4, spread_props([breadcrumbData]));
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          UserGroup($$renderer3);
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              $$renderer4.push(`<div class="user-pagination">`);
              PaginationBasic($$renderer4);
              $$renderer4.push(`<!----></div>`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
export {
  _page as default
};
