import { ag as ensure_array_like, ac as attr, ae as stringify, aa as escape_html, a2 as head, af as spread_props } from "../../../../../../chunks/index2.js";
import "clsx";
import { a as Col, C as Container, R as Row } from "../../../../../../chunks/Row.js";
import "../../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbTwo } from "../../../../../../chunks/BreadcrumbTwo.js";
import { B as Button } from "../../../../../../chunks/Button.js";
import { C as Card } from "../../../../../../chunks/Card.js";
import { C as CardBody } from "../../../../../../chunks/CardBody.js";
import { C as CardFooter } from "../../../../../../chunks/CardFooter.js";
import { t as teamData } from "../../../../../../chunks/teamData.js";
function UserGrid($$renderer) {
  $$renderer.push(`<!--[-->`);
  const each_array = ensure_array_like(teamData);
  for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
    let item = each_array[$$index];
    Col($$renderer, {
      xxl: 3,
      md: 6,
      class: "mb-25",
      children: ($$renderer2) => {
        Card($$renderer2, {
          children: ($$renderer3) => {
            CardBody($$renderer3, {
              class: "text-center pt-30 px-25 pb-0",
              children: ($$renderer4) => {
                $$renderer4.push(`<div class="account-profile-cards"><div class="ap-img d-flex justify-content-center"><img class="ap-img__main bg-opacity-primary wh-120 rounded-circle mb-3"${attr("src", `/img/${stringify(item.img)}`)} alt="profile"/></div> <div class="ap-nameAddress"><h6 class="ap-nameAddress__title">${escape_html(item.name)}</h6> <p class="ap-nameAddress__subTitle fs-14 pt-1 m-0">${escape_html(item.designation)}</p></div> <div class="ap-button account-profile-cards__button button-group d-flex justify-content-center flex-wrap pt-20">`);
                Button($$renderer4, {
                  color: "transparent",
                  class: "border text-capitalize px-25 color-gray transparent radius-md",
                  children: ($$renderer5) => {
                    $$renderer5.push(`<img class="svg" alt="" src="/img/svg/mail.svg"/> message`);
                  },
                  $$slots: { default: true }
                });
                $$renderer4.push(`<!----> `);
                Button($$renderer4, {
                  color: "transparent",
                  class: "border text-capitalize px-25 color-gray transparent follow radius-md",
                  children: ($$renderer5) => {
                    $$renderer5.push(`<span class="uil uil-user-plus follow-icon"></span>follow`);
                  },
                  $$slots: { default: true }
                });
                $$renderer4.push(`<!----></div></div> `);
                CardFooter($$renderer4, {
                  class: "mt-20 pt-20 pb-20 px-0 bg-transparent",
                  children: ($$renderer5) => {
                    $$renderer5.push(`<div class="profile-overview d-flex justify-content-between flex-wrap"><div class="po-details"><h6 class="po-details__title">$72,572</h6> <span class="po-details__sTitle">Total Revenue</span></div> <div class="po-details"><h6 class="po-details__title">3,257</h6> <span class="po-details__sTitle">order</span></div> <div class="po-details"><h6 class="po-details__title">74</h6> <span class="po-details__sTitle">Products</span></div></div>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer4.push(`<!---->`);
              },
              $$slots: { default: true }
            });
          },
          $$slots: { default: true }
        });
      },
      $$slots: { default: true }
    });
  }
  $$renderer.push(`<!--]-->`);
}
function _page($$renderer) {
  const breadcrumbData = { pageTitle: "User Cards", pageLabel: "Home" };
  head("kj1vl8", $$renderer, ($$renderer2) => {
    $$renderer2.title(($$renderer3) => {
      $$renderer3.push(`<title>User Cards</title>`);
    });
  });
  $$renderer.push(`<div class="component-page mb-25">`);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              BreadcrumbTwo($$renderer4, spread_props([breadcrumbData]));
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          UserGrid($$renderer3);
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
export {
  _page as default
};
