import { ag as ensure_array_like, aa as escape_html, ad as attr_class, ae as stringify, a2 as head, af as spread_props } from "../../../../../../chunks/index2.js";
import "clsx";
import { R as Row, a as Col, C as Container } from "../../../../../../chunks/Row.js";
import "../../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbOne } from "../../../../../../chunks/BreadcrumbOne.js";
import { B as Button } from "../../../../../../chunks/Button.js";
import { F as Form } from "../../../../../../chunks/Form.js";
import { F as FormGroup } from "../../../../../../chunks/FormGroup.js";
import { I as Input } from "../../../../../../chunks/Input.js";
import { L as Label } from "../../../../../../chunks/Label.js";
import { D as DatePicker } from "../../../../../../chunks/DatePicker.js";
function PersonalInfo($$renderer) {
  Row($$renderer, {
    class: "justify-content-center",
    children: ($$renderer2) => {
      Col($$renderer2, {
        xxl: 4,
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="mt-sm-40 mb-sm-50 mt-20 mb-20 px-xxl-0 px-30"><div class="user-tab-info-title mb-sm-40 mb-20 text-capitalize"><h5 class="fw-500">Personal Information</h5></div> <div class="account-profile d-flex align-items-center mb-4"><div class="ap-img pro_img_wrapper">`);
          Input($$renderer3, {
            id: "file-upload",
            type: "file",
            name: "fileUpload",
            class: "d-none"
          });
          $$renderer3.push(`<!----> `);
          Label($$renderer3, {
            for: "file-upload",
            children: ($$renderer4) => {
              $$renderer4.push(`<img class="ap-img__main rounded-circle wh-120 bg-lighter d-flex" src="/img/author/profile.png" alt="profile"/> <span class="cross" id="remove_pro_pic"><img class="svg" alt="" src="/img/svg/camera.svg"/></span>`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----></div> <div class="account-profile__title"><h6 class="fs-15 ms-20 fw-500 text-capitalize">profile photo</h6></div></div> <div class="edit-profile__body">`);
          Form($$renderer3, {
            children: ($$renderer4) => {
              FormGroup($$renderer4, {
                class: "mb-25 form-group",
                children: ($$renderer5) => {
                  Label($$renderer5, {
                    for: "name1",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->name`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----> `);
                  Input($$renderer5, {
                    type: "text",
                    class: "form-control",
                    id: "name1",
                    placeholder: "Duran Clayton"
                  });
                  $$renderer5.push(`<!---->`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              FormGroup($$renderer4, {
                class: "mb-25 form-group",
                children: ($$renderer5) => {
                  Label($$renderer5, {
                    for: "name2",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->Email`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----> `);
                  Input($$renderer5, {
                    type: "email",
                    class: "form-control",
                    id: "name2",
                    placeholder: "sample@email.com"
                  });
                  $$renderer5.push(`<!---->`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              FormGroup($$renderer4, {
                class: "mb-25 form-group",
                children: ($$renderer5) => {
                  Label($$renderer5, {
                    for: "phoneNumber5",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->phone number`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----> `);
                  Input($$renderer5, {
                    type: "tel",
                    class: "form-control",
                    id: "phoneNumber5",
                    placeholder: "+440 2546 5236"
                  });
                  $$renderer5.push(`<!---->`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              FormGroup($$renderer4, {
                class: "mb-25 form-group",
                children: ($$renderer5) => {
                  $$renderer5.push(`<div class="countryOption">`);
                  Label($$renderer5, {
                    for: "countryOption",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->country`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----> <select class="form-select form-control" id="countryOption">`);
                  $$renderer5.option({ value: "JAN" }, ($$renderer6) => {
                    $$renderer6.push(`event`);
                  });
                  $$renderer5.option({ value: "FBR" }, ($$renderer6) => {
                    $$renderer6.push(`Venues`);
                  });
                  $$renderer5.push(`</select></div>`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              FormGroup($$renderer4, {
                class: "mb-25 form-group",
                children: ($$renderer5) => {
                  $$renderer5.push(`<div class="cityOption">`);
                  Label($$renderer5, {
                    for: "cityOption",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->city`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----> <select class="form-select form-control" id="cityOption">`);
                  $$renderer5.option({ value: "JAN" }, ($$renderer6) => {
                    $$renderer6.push(`event`);
                  });
                  $$renderer5.option({ value: "FBR" }, ($$renderer6) => {
                    $$renderer6.push(`Venues`);
                  });
                  $$renderer5.push(`</select></div>`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              FormGroup($$renderer4, {
                class: "mb-25 form-group",
                children: ($$renderer5) => {
                  Label($$renderer5, {
                    for: "name3",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->company name`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----> `);
                  Input($$renderer5, {
                    type: "text",
                    class: "form-control",
                    id: "name3",
                    placeholder: "Example"
                  });
                  $$renderer5.push(`<!---->`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              FormGroup($$renderer4, {
                class: "mb-25 form-group",
                children: ($$renderer5) => {
                  Label($$renderer5, {
                    for: "phoneNumber2",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->website`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----> `);
                  Input($$renderer5, {
                    type: "email",
                    class: "form-control",
                    id: "phoneNumber2",
                    placeholder: "www.example.com"
                  });
                  $$renderer5.push(`<!---->`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> <div class="button-group d-flex pt-sm-25 justify-content-md-end flex-wrap justify-content-start">`);
              Button($$renderer4, {
                color: "light",
                size: "default",
                class: "btn-squared fw-400 text-capitalize radius-md",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->cancel`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              Button($$renderer4, {
                color: "primary",
                size: "default",
                class: "btn-squared text-capitalize radius-md shadow2",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->Save &amp; Next`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----></div>`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----></div></div>`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
}
function WorkInfo($$renderer) {
  Row($$renderer, {
    class: "justify-content-center",
    children: ($$renderer2) => {
      Col($$renderer2, {
        xxl: 4,
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="mt-40 mb-50 px-xxl-0 px-30"><div class="user-tab-info-title mb-35 text-capitalize"><h5 class="fw-500">work Information</h5></div> <div class="edit-profile__body">`);
          Form($$renderer3, {
            children: ($$renderer4) => {
              FormGroup($$renderer4, {
                class: "mb-25 form-group",
                children: ($$renderer5) => {
                  Label($$renderer5, {
                    for: "name4",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->company name`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----> `);
                  Input($$renderer5, {
                    type: "text",
                    class: "form-control",
                    id: "name4",
                    placeholder: "Duran Clayton"
                  });
                  $$renderer5.push(`<!---->`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              FormGroup($$renderer4, {
                class: "mb-25 form-group",
                children: ($$renderer5) => {
                  Label($$renderer5, {
                    for: "phoneNumber1",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->Department`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----> `);
                  Input($$renderer5, {
                    type: "text",
                    class: "form-control",
                    id: "phoneNumber1",
                    placeholder: "Design"
                  });
                  $$renderer5.push(`<!---->`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              FormGroup($$renderer4, {
                class: "mb-25 form-group",
                children: ($$renderer5) => {
                  Label($$renderer5, {
                    for: "phoneNumber",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->Designation`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----> `);
                  Input($$renderer5, {
                    type: "text",
                    class: "form-control",
                    id: "phoneNumber",
                    placeholder: "UI Designrt"
                  });
                  $$renderer5.push(`<!---->`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              FormGroup($$renderer4, {
                class: "mb-25 form-group form-group-calender",
                children: ($$renderer5) => {
                  Label($$renderer5, {
                    for: "datepicker",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->Hiring Date`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----> <div class="custom-date-picker"><div class="form-group mb-0 form-group-calender"><div class="position-relative">`);
                  DatePicker($$renderer5, { format: "MMMM DD, YYYY" });
                  $$renderer5.push(`<!----> <a href="#"><img class="svg" alt="" src="/img/svg/calendar.svg"/></a></div></div></div>`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              FormGroup($$renderer4, {
                class: "mb-25 form-group status-radio",
                children: ($$renderer5) => {
                  Label($$renderer5, {
                    class: "mb-15",
                    for: "phoneNumber2",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->status`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----> <div class="d-flex"><div class="radio-horizontal-list d-flex flex-wrap"><div class="radio-theme-default custom-radio">`);
                  Input($$renderer5, {
                    class: "radio",
                    type: "radio",
                    name: "radio-optional",
                    value: "0",
                    id: "radio-hl1",
                    label: "Active"
                  });
                  $$renderer5.push(`<!----></div> <div class="radio-theme-default custom-radio">`);
                  Input($$renderer5, {
                    class: "radio",
                    type: "radio",
                    name: "radio-optional",
                    value: "0",
                    id: "radio-hl2",
                    label: "Deactive"
                  });
                  $$renderer5.push(`<!----></div> <div class="radio-theme-default custom-radio">`);
                  Input($$renderer5, {
                    class: "radio",
                    type: "radio",
                    name: "radio-optional",
                    value: "0",
                    id: "radio-hl3",
                    label: "Block"
                  });
                  $$renderer5.push(`<!----></div></div></div>`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> <div class="button-group d-flex pt-20 justify-content-md-end justify-content-start flex-wrap">`);
              Button($$renderer4, {
                color: "light",
                size: "default",
                class: "btn-squared fw-400 text-capitalize radius-md",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->cancel`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              Button($$renderer4, {
                color: "primary",
                size: "default",
                class: "btn-squared text-capitalize radius-md shadow2",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->Save &amp; Next`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----></div>`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----></div></div>`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
}
function SocialInfo($$renderer) {
  const socialProfiles = [
    {
      name: "Facebook",
      icon: "facebook-f",
      color: "facebook",
      placeholder: "URL"
    },
    {
      name: "Twitter",
      icon: "twitter",
      color: "twitter",
      placeholder: "@Username"
    },
    {
      name: "Instagram",
      icon: "instagram",
      color: "instagram",
      placeholder: "URL"
    },
    {
      name: "Github",
      icon: "github",
      color: "dark",
      placeholder: "Username"
    },
    {
      name: "Medium",
      icon: "medium-m",
      color: "dark",
      placeholder: "Username"
    },
    {
      name: "Website",
      icon: "globe",
      color: "ruby",
      placeholder: "URL"
    }
  ];
  Row($$renderer, {
    class: "justify-content-center",
    children: ($$renderer2) => {
      Col($$renderer2, {
        xxl: 4,
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="user-social-profile mt-40 mb-50 px-xxl-0 px-30"><div class="user-tab-info-title mb-40 text-capitalize"><h5>social profiles</h5></div> <div class="edit-profile__body">`);
          Form($$renderer3, {
            children: ($$renderer4) => {
              $$renderer4.push(`<!--[-->`);
              const each_array = ensure_array_like(socialProfiles);
              for (let i = 0, $$length = each_array.length; i < $$length; i++) {
                let profile = each_array[i];
                $$renderer4.push(`<div class="mb-30">`);
                Label($$renderer4, {
                  for: "socialUrl",
                  children: ($$renderer5) => {
                    $$renderer5.push(`<!---->${escape_html(profile.name)}`);
                  },
                  $$slots: { default: true }
                });
                $$renderer4.push(`<!----> <div class="input-group flex-nowrap"><div class="input-group-prepend"><span${attr_class(`input-group-text bg-${stringify(profile.color)} border-${stringify(profile.color)} text-white wh-44 radius-xs justify-content-center`)} id="addon-wrapping1"><i${attr_class(`uil uil-${stringify(profile.icon)} fs-18`)}></i></span></div> `);
                Input($$renderer4, {
                  type: "text",
                  class: "form-control form-control--social",
                  placeholder: profile.placeholder,
                  "aria-label": profile.placeholder,
                  "aria-describedby": `addon-wrapping-${stringify(i)}`,
                  id: `socialUrl-${stringify(i)}`
                });
                $$renderer4.push(`<!----></div></div>`);
              }
              $$renderer4.push(`<!--]--> <div class="button-group d-flex pt-20 justify-content-md-end justify-content-start flex-wrap">`);
              Button($$renderer4, {
                color: "light",
                size: "default",
                class: "btn-squared fw-400 text-capitalize radius-md",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->back`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              Button($$renderer4, {
                color: "primary",
                size: "default",
                class: "btn-squared text-capitalize radius-md shadow2",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->Save profile`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----></div>`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----></div></div>`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
}
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const breadcrumbData = {
      pageTitle: "Add User",
      bcItem: "Home",
      bcItem2: "Apps",
      bcItemActive: "Users"
    };
    const addUserTabs = [PersonalInfo, WorkInfo, SocialInfo];
    let activeTab = addUserTabs.indexOf(PersonalInfo);
    head("y3bi35", $$renderer2, ($$renderer3) => {
      $$renderer3.title(($$renderer4) => {
        $$renderer4.push(`<title>Add User</title>`);
      });
    });
    $$renderer2.push(`<div class="component-page mb-25">`);
    Container($$renderer2, {
      fluid: true,
      children: ($$renderer3) => {
        Row($$renderer3, {
          children: ($$renderer4) => {
            Col($$renderer4, {
              lg: 12,
              children: ($$renderer5) => {
                BreadcrumbOne($$renderer5, spread_props([breadcrumbData]));
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              lg: 12,
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="user-info-tab w-100 bg-white global-shadow radius-xl mb-50"><div class="ap-tab-wrapper border-bottom"><ul class="nav px-30 ap-tab-main text-capitalize" role="tablist" aria-orientation="vertical"><li class="nav-item"><a class="nav-link active" href="#" role="tab" data-type="personalInfo"><img class="svg" alt="" src="/img/svg/user.svg"/> personal info</a></li> <li class="nav-item"><a class="nav-link" href="#" role="tab" data-type="workInfo"><img class="svg" alt="" src="/img/svg/briefcase.svg"/> work info</a></li> <li class="nav-item"><a class="nav-link" href="#" role="tab" data-type="socialInfo"><img class="svg" alt="" src="/img/svg/share-2.svg"/> Social</a></li></ul></div> `);
                $$renderer5.push("<!---->");
                addUserTabs[activeTab]?.($$renderer5, {});
                $$renderer5.push(`<!----></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></div>`);
  });
}
export {
  _page as default
};
