import { ad as attr_class, a9 as bind_props, ae as stringify, ac as attr, aa as escape_html, a6 as fallback, a1 as store_get, ag as ensure_array_like, a3 as unsubscribe_stores, a2 as head, af as spread_props } from "../../../../../chunks/index2.js";
import "clsx";
import { C as Container, R as Row, a as Col } from "../../../../../chunks/Row.js";
import "../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbOne } from "../../../../../chunks/BreadcrumbOne.js";
import { B as Button } from "../../../../../chunks/Button.js";
import { C as Card } from "../../../../../chunks/Card.js";
import { C as CardBody } from "../../../../../chunks/CardBody.js";
import { M as Modal, a as ModalBody } from "../../../../../chunks/Modal.js";
import { M as ModalFooter } from "../../../../../chunks/ModalFooter.js";
import { M as ModalHeader } from "../../../../../chunks/ModalHeader.js";
import { C as CardHeader } from "../../../../../chunks/CardHeader.js";
import { t as taskData, c as createTasks } from "../../../../../chunks/task.js";
function Sidebar($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let taskActiveTab = $$props["taskActiveTab"];
    let handleTabActivation = $$props["handleTabActivation"];
    let addTask = $$props["addTask"];
    let showModal = $$props["showModal"];
    let toggleModal = $$props["toggleModal"];
    $$renderer2.push(`<div class="task-sidebar-wrapper mb-30"><div class="task-sidebar">`);
    Card($$renderer2, {
      class: "border-0 shadow-none",
      children: ($$renderer3) => {
        CardBody($$renderer3, {
          class: "px-15 pt-30",
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="px-3">`);
            Button($$renderer4, {
              color: "primary",
              size: "default",
              class: "btn-default btn-block btn-rounded fs-14",
              children: ($$renderer5) => {
                $$renderer5.push(`<img class="svg" alt="" src="/img/svg/plus.svg"/> Add Tasks`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----></div> <div class="task-types"><ul class="mb-3" id="pills-tab"><li class="nav-item"><a${attr_class(`nav-link ${stringify(taskActiveTab === "all" ? "active" : "")}`)} id="pills-home-tab" href="#"><img class="svg" alt="" src="/img/svg/edit.svg"/> All</a></li> <li class="nav-item"><a${attr_class(`nav-link ${stringify(taskActiveTab === "favorite" ? "active" : "")}`)} id="pills-profile-tab" href="#"><img class="svg" alt="" src="/img/svg/star.svg"/> Favorite</a></li> <li class="nav-item"><a${attr_class(`nav-link ${stringify(taskActiveTab === "completed" ? "active" : "")}`)} id="pills-contact-tab" href="#"><img class="svg" alt="" src="/img/svg/check.svg"/> Completed</a></li></ul></div>`);
          },
          $$slots: { default: true }
        });
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></div></div> `);
    Modal($$renderer2, {
      isOpen: showModal,
      toggleModal,
      class: "task-modal",
      children: ($$renderer3) => {
        ModalHeader($$renderer3, {
          toggleModal,
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->Add Task `);
            Button($$renderer4, {
              size: "default",
              class: "close",
              children: ($$renderer5) => {
                $$renderer5.push(`<i class="uil uil-times"></i>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        ModalBody($$renderer3, {
          children: ($$renderer4) => {
            $$renderer4.push(`<form action="/"><div class="form-group mb-20"><input type="text" class="form-control" id="add-task-input" placeholder="Title"/></div> <div class="form-group"><textarea class="form-control" id="add-task-textarea" placeholder="Add description"></textarea></div></form>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        ModalFooter($$renderer3, {
          children: ($$renderer4) => {
            Button($$renderer4, {
              color: "outline-light",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->Cancel`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Button($$renderer4, {
              color: "primary",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->Add Task`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!---->`);
    bind_props($$props, {
      taskActiveTab,
      handleTabActivation,
      addTask,
      showModal,
      toggleModal
    });
  });
}
function TaskSingle($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let tasks = $$props["tasks"];
    let task = $$props["task"];
    $$renderer2.push(`<div class="task-single"><div class="task-card__content d-flex justify-content-between align-items-center"><div class="task-card__header"><div class="checkbox-group d-flex"><div class="checkbox-theme-default custom-checkbox checkbox-group__single d-flex"><input type="checkbox"${attr("checked", !!task.completed, true)}${attr("id", task.id)} class="checkbox"/> <label${attr("for", task.id)}>${escape_html(task.title)}</label></div></div> <span>${escape_html(task.description)}</span></div> <div class="table-actions"><a href="#"><img class="svg" alt="" src="/img/svg/edit.svg"/></a> <a href="#" class="fav-icon">`);
    if (task.favorite) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<img alt="" src="/img/svg/star-solid.svg"/>`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<img alt="" src="/img/svg/star.svg"/>`);
    }
    $$renderer2.push(`<!--]--></a> <a href="#"><img class="svg" alt="" src="/img/svg/trash-2.svg"/></a></div></div></div>`);
    bind_props($$props, { tasks, task });
  });
}
function TaskList($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let tasks;
    let slicedData = taskData;
    let taskDataSorted = fallback($$props["taskDataSorted"], slicedData);
    let taskStatus = $$props["taskStatus"];
    let favorite = taskDataSorted.filter((item) => item.favorite);
    let completed = taskDataSorted.filter((item) => item.completed);
    tasks = createTasks(taskDataSorted);
    $$renderer2.push(`<div class="task-grid-wrapper mb-30"><div class="task-wrapper">`);
    Card($$renderer2, {
      class: "task-card",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->Task Lists`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          class: "task-card__body",
          children: ($$renderer4) => {
            if (taskStatus === "favorite") {
              $$renderer4.push("<!--[-->");
              if (favorite.length) {
                $$renderer4.push("<!--[-->");
                $$renderer4.push(`<!--[-->`);
                const each_array = ensure_array_like(store_get($$store_subs ??= {}, "$tasks", tasks).filter((item) => item.favorite));
                for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
                  let task = each_array[$$index];
                  TaskSingle($$renderer4, { tasks, task });
                }
                $$renderer4.push(`<!--]-->`);
              } else {
                $$renderer4.push("<!--[!-->");
                $$renderer4.push(`<div class="task-single"><div class="task-card__content d-flex justify-content-between align-items-center"><div class="tasklist-empty"><span>Sorry !! No Favorite Task Found :(</span></div></div></div>`);
              }
              $$renderer4.push(`<!--]-->`);
            } else if (taskStatus === "completed") {
              $$renderer4.push("<!--[1-->");
              if (completed.length) {
                $$renderer4.push("<!--[-->");
                $$renderer4.push(`<!--[-->`);
                const each_array_1 = ensure_array_like(store_get($$store_subs ??= {}, "$tasks", tasks).filter((item) => item.completed));
                for (let $$index_1 = 0, $$length = each_array_1.length; $$index_1 < $$length; $$index_1++) {
                  let task = each_array_1[$$index_1];
                  TaskSingle($$renderer4, { tasks, task });
                }
                $$renderer4.push(`<!--]-->`);
              } else {
                $$renderer4.push("<!--[!-->");
                $$renderer4.push(`<div class="task-single"><div class="task-card__content d-flex justify-content-between align-items-center"><div class="tasklist-empty"><span>Sorry !! No Completed Task Found.</span></div></div></div>`);
              }
              $$renderer4.push(`<!--]-->`);
            } else if (store_get($$store_subs ??= {}, "$tasks", tasks).length) {
              $$renderer4.push("<!--[2-->");
              $$renderer4.push(`<!--[-->`);
              const each_array_2 = ensure_array_like(store_get($$store_subs ??= {}, "$tasks", tasks));
              for (let $$index_2 = 0, $$length = each_array_2.length; $$index_2 < $$length; $$index_2++) {
                let task = each_array_2[$$index_2];
                TaskSingle($$renderer4, { tasks, task });
              }
              $$renderer4.push(`<!--]-->`);
            } else {
              $$renderer4.push("<!--[!-->");
              $$renderer4.push(`<div class="task-single"><div class="task-card__content d-flex justify-content-between align-items-center"><div class="ninjadash-tasklist-empty"><span>Sorry! No Task Found.</span></div></div></div>`);
            }
            $$renderer4.push(`<!--]-->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></div></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { taskDataSorted, taskStatus });
  });
}
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let tasks;
    const breadcrumbData = {
      pageTitle: "Task",
      bcItem: "Home",
      bcItem2: "App",
      bcItemActive: "Task"
    };
    let taskActiveTab = "all";
    const handleTabActivation = (value) => {
      taskActiveTab = value;
    };
    let showModal = false;
    let toggleModal = () => showModal = !showModal;
    let slicedData = taskData;
    let taskDataSorted = slicedData;
    let newTask = [];
    let defaultId = 8;
    let addTask = (e) => {
      e.preventDefault();
      const id = defaultId++;
      const title = document.querySelector("#add-task-input").value;
      const description = document.querySelector("#add-task-textarea").value;
      newTask.push({ id, title, description, favorite: false, completed: false });
      taskDataSorted = [...slicedData, ...newTask];
      toggleModal();
    };
    tasks = taskDataSorted;
    head("unyqh4", $$renderer2, ($$renderer3) => {
      $$renderer3.title(($$renderer4) => {
        $$renderer4.push(`<title>Task</title>`);
      });
    });
    $$renderer2.push(`<div class="component-page mb-25">`);
    Container($$renderer2, {
      fluid: true,
      children: ($$renderer3) => {
        Row($$renderer3, {
          children: ($$renderer4) => {
            Col($$renderer4, {
              lg: 12,
              children: ($$renderer5) => {
                BreadcrumbOne($$renderer5, spread_props([breadcrumbData]));
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              lg: 12,
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="task-contents">`);
                Sidebar($$renderer5, {
                  taskActiveTab,
                  handleTabActivation,
                  addTask,
                  showModal,
                  toggleModal
                });
                $$renderer5.push(`<!----> `);
                TaskList($$renderer5, {
                  taskStatus: taskActiveTab,
                  taskDataSorted: tasks,
                  taskLimit: "5"
                });
                $$renderer5.push(`<!----></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></div>`);
  });
}
export {
  _page as default
};
