import { ag as ensure_array_like, aa as escape_html, ac as attr, ae as stringify, ad as attr_class, a2 as head, af as spread_props } from "../../../../../../chunks/index2.js";
import "clsx";
import { C as Container, R as Row, a as Col } from "../../../../../../chunks/Row.js";
import "../../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbOne } from "../../../../../../chunks/BreadcrumbOne.js";
import { B as Button } from "../../../../../../chunks/Button.js";
import { F as Form } from "../../../../../../chunks/Form.js";
import { F as FormGroup } from "../../../../../../chunks/FormGroup.js";
import { I as Input } from "../../../../../../chunks/Input.js";
import { L as Label } from "../../../../../../chunks/Label.js";
import { M as Modal, a as ModalBody } from "../../../../../../chunks/Modal.js";
import { M as ModalHeader } from "../../../../../../chunks/ModalHeader.js";
import { P as PaginationBasic } from "../../../../../../chunks/PaginationBasic2.js";
const tickets = [
  {
    from: "Duran Claton",
    img: "tm1.png",
    subject: "Verify your new email address",
    priority: "High",
    status: "open",
    date: "January 20, 2022"
  },
  {
    from: "Van Daiek",
    img: "tm2.png",
    subject: "Request new feature developent",
    priority: "Low",
    status: "pending",
    date: "February 21, 2022"
  },
  {
    from: "Chris Morris",
    img: "tm3.png",
    subject: "Verify new payment method",
    priority: "High",
    status: "open",
    date: "February 23, 2022"
  },
  {
    from: "Clint Estod",
    img: "tm4.png",
    subject: "Verify your new email address",
    priority: "High",
    status: "open",
    date: "February 25, 2022"
  },
  {
    from: "Harry Maguire",
    img: "tm5.png",
    subject: "Request for undo purchase",
    priority: "Low",
    status: "closed",
    date: "February 26, 2022"
  },
  {
    from: "Neil Wagner",
    img: "tm6.png",
    subject: "Request to change password",
    priority: "Medium",
    status: "closed",
    date: "March 02, 2022"
  },
  {
    from: "Jason Barn",
    img: "tm7.png",
    subject: "Can't download the product",
    priority: "Medium",
    status: "open",
    date: "March 02, 2022"
  },
  {
    from: "Wesly Snider",
    img: "tm8.png",
    subject: "Redesign the about us page",
    priority: "Low",
    status: "closed",
    date: "March 03, 2022"
  },
  {
    from: "Louis Tellas",
    img: "tm9.png",
    subject: "Update the latest issue tracker",
    priority: "High",
    status: "open",
    date: "March 07, 2022"
  },
  {
    from: "Green Murphy",
    img: "tm10.png",
    subject: "Issue on checkout page",
    priority: "Low",
    status: "pending",
    date: "March 12, 2022"
  },
  {
    from: "Aston Aghar",
    img: "tm11.png",
    subject: "New update crush the app",
    priority: "High",
    status: "closed",
    date: "March 24, 2022"
  }
];
function Tickets($$renderer) {
  let open = false;
  const toggle = () => open = !open;
  $$renderer.push(`<div class="support-ticket-system"><div class="breadcrumb-main breadcrumb-main--ticket justify-content-sm-between"><div class="d-flex flex-wrap justify-content-center breadcrumb-main__wrapper"><div class="d-flex align-items-center ticket__title justify-content-center me-md-25 mb-md-0 mb-20"><h4 class="text-capitalize fw-500 breadcrumb-title">All Support Ticket</h4></div></div> <div class="action-btn">`);
  Button($$renderer, {
    color: "primary",
    children: ($$renderer2) => {
      $$renderer2.push(`<i class="uil uil-plus"></i>Add Ticket`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----> `);
  Modal($$renderer, {
    class: "ticket_modal",
    isOpen: open,
    toggle,
    children: ($$renderer2) => {
      ModalBody($$renderer2, {
        class: " pb-sm-50 pb-30",
        children: ($$renderer3) => {
          ModalHeader($$renderer3, {
            children: ($$renderer4) => {
              $$renderer4.push(`<h1>Submit your Ticket</h1> `);
              Button($$renderer4, {
                size: "default",
                children: ($$renderer5) => {
                  $$renderer5.push(`<i class="uil uil-times"></i>`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!---->`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> <div class="ticket_modal-modal">`);
          Form($$renderer3, {
            children: ($$renderer4) => {
              FormGroup($$renderer4, {
                class: "form-group",
                children: ($$renderer5) => {
                  Label($$renderer5, {
                    for: "email",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->Email`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----> `);
                  Input($$renderer5, { id: "email", type: "text", class: "form-control" });
                  $$renderer5.push(`<!---->`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              FormGroup($$renderer4, {
                class: "form-group",
                children: ($$renderer5) => {
                  Label($$renderer5, {
                    for: "subject",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->Subject`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----> `);
                  Input($$renderer5, { id: "subject", type: "text", class: "form-control" });
                  $$renderer5.push(`<!---->`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              FormGroup($$renderer4, {
                class: "form-group",
                children: ($$renderer5) => {
                  Label($$renderer5, {
                    for: "priority",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->Priority`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----> `);
                  Input($$renderer5, {
                    id: "priority",
                    type: "text",
                    class: "form-control",
                    placeholder: "High"
                  });
                  $$renderer5.push(`<!---->`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              FormGroup($$renderer4, {
                class: "form-group",
                children: ($$renderer5) => {
                  Label($$renderer5, {
                    for: "status",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->Status`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----> `);
                  Input($$renderer5, {
                    id: "status",
                    type: "text",
                    class: "form-control",
                    placeholder: "Open"
                  });
                  $$renderer5.push(`<!---->`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              FormGroup($$renderer4, {
                class: "form-group",
                children: ($$renderer5) => {
                  Label($$renderer5, {
                    for: "description",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->Description`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----> `);
                  Input($$renderer5, { id: "description", type: "textarea", class: "form-control" });
                  $$renderer5.push(`<!---->`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> <div class="button-group d-flex pt-15">`);
              Button($$renderer4, {
                color: "primary",
                size: "default",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->Submit ticket`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----></div>`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----></div>`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div></div> <div class="support-form d-flex justify-content-between align-items-center flex-wrap"><div class="support-form__input"><div class="d-flex flex-wrap"><div class="support-form__input-id">`);
  Label($$renderer, {
    children: ($$renderer2) => {
      $$renderer2.push(`<!---->Id:`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----> <div class="dm-select"><select name="select-search" class="select-search form-control">`);
  $$renderer.option({ value: "01" }, ($$renderer2) => {
    $$renderer2.push(`All`);
  });
  $$renderer.option({ value: "02" }, ($$renderer2) => {
    $$renderer2.push(`Option 2`);
  });
  $$renderer.option({ value: "03" }, ($$renderer2) => {
    $$renderer2.push(`Option 3`);
  });
  $$renderer.option({ value: "04" }, ($$renderer2) => {
    $$renderer2.push(`Option 4`);
  });
  $$renderer.option({ value: "05" }, ($$renderer2) => {
    $$renderer2.push(`Option 5`);
  });
  $$renderer.push(`</select></div></div> <div class="support-form__input-status">`);
  Label($$renderer, {
    children: ($$renderer2) => {
      $$renderer2.push(`<!---->status:`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----> <div class="dm-select"><select name="select-search" class="select-search form-control">`);
  $$renderer.option({ value: "01" }, ($$renderer2) => {
    $$renderer2.push(`All`);
  });
  $$renderer.option({ value: "02" }, ($$renderer2) => {
    $$renderer2.push(`Option 2`);
  });
  $$renderer.option({ value: "03" }, ($$renderer2) => {
    $$renderer2.push(`Option 3`);
  });
  $$renderer.option({ value: "04" }, ($$renderer2) => {
    $$renderer2.push(`Option 4`);
  });
  $$renderer.option({ value: "05" }, ($$renderer2) => {
    $$renderer2.push(`Option 5`);
  });
  $$renderer.push(`</select></div></div></div></div> <div class="support-form__search"><div class="support-order-search">`);
  Form($$renderer, {
    action: "/",
    class: "support-order-search__form",
    children: ($$renderer2) => {
      $$renderer2.push(`<img class="svg" alt="" src="/img/svg/search.svg" height="16"/> `);
      Input($$renderer2, {
        class: "form-control border-0 box-shadow-none",
        type: "search",
        placeholder: "Search",
        "aria-label": "Search"
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div></div></div> <div class="userDatatable userDatatable--ticket mt-1"><div class="table-responsive"><table class="table mb-0 table-borderless"><thead><tr class="userDatatable-header"><th><span class="userDatatable-title">ID</span></th><th><span class="userDatatable-title">Requested By</span></th><th><span class="userDatatable-title">Subject</span></th><th><span class="userDatatable-title">Priority</span></th><th><span class="userDatatable-title">Status</span></th><th><span class="userDatatable-title">Created Date</span></th><th class="actions"><span class="userDatatable-title">Actions</span></th></tr></thead><tbody><!--[-->`);
  const each_array = ensure_array_like(tickets);
  for (let i = 0, $$length = each_array.length; i < $$length; i++) {
    let ticket = each_array[i];
    $$renderer.push(`<tr><td>#${escape_html(i + 1)}</td><td><div class="d-flex"><div class="userDatatable__imgWrapper d-flex align-items-center"><img${attr("src", `/img/${stringify(ticket.img)}`)} alt=""/></div> <div class="userDatatable-inline-title"><a href="#" class="text-dark fw-500"><h6>${escape_html(ticket.from)}</h6></a></div></div></td><td><div class="userDatatable-content--subject">${escape_html(ticket.subject)}</div></td><td><div class="userDatatable-content--priority">${escape_html(ticket.priority)}</div></td><td><div class="userDatatable-content d-inline-block"><span${attr_class(`status-${stringify(ticket.status)} userDatatable-content-status`)}>${escape_html(ticket.status)}</span></div></td><td><div class="userDatatable-content--date">${escape_html(ticket.date)}</div></td><td><ul class="orderDatatable_actions mb-0 d-flex flex-wrap"><li><a href="#" class="view"><i class="uil uil-setting"></i></a></li> <li><a href="#" class="edit"><i class="uil uil-edit"></i></a></li> <li><a href="#" class="remove"><i class="uil uil-trash-alt"></i></a></li></ul></td></tr>`);
  }
  $$renderer.push(`<!--]--></tbody></table></div> <div class="d-flex justify-content-end pt-30">`);
  PaginationBasic($$renderer);
  $$renderer.push(`<!----></div></div></div>`);
}
function _page($$renderer) {
  const breadcrumbData = {
    pageTitle: "Supprot Tickets",
    bcItem: "Home",
    bcItem2: "Apps",
    bcItemActive: "Support"
  };
  const cardContents = [
    {
      total: "30,124",
      label: "Total Tickets",
      icon: "ticket",
      type: "primary"
    },
    {
      total: "825",
      label: "New Tickets",
      icon: "ticket",
      type: "secondary"
    },
    {
      total: "350",
      label: "Pending Tickets",
      icon: "clock",
      type: "warning"
    },
    {
      total: "23,145",
      label: "Completed Tickets",
      icon: "check-circle",
      type: "success"
    }
  ];
  head("12w5xkk", $$renderer, ($$renderer2) => {
    $$renderer2.title(($$renderer3) => {
      $$renderer3.push(`<title>Support Tickets</title>`);
    });
  });
  $$renderer.push(`<div class="component-page mb-25">`);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              BreadcrumbOne($$renderer4, spread_props([breadcrumbData]));
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> <!--[-->`);
          const each_array = ensure_array_like(cardContents);
          for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
            let content = each_array[$$index];
            Col($$renderer3, {
              xxl: 3,
              md: "6",
              class: "mb-30",
              children: ($$renderer4) => {
                $$renderer4.push(`<div class="ap-po-details ap-po-details--ticket radius-xl d-flex justify-content-between"><div class="overview-content w-100"><div class="ap-po-details-content d-flex flex-wrap justify-content-between"><div class="ap-po-details__titlebar"><h1>${escape_html(content.total)}</h1> <p>${escape_html(content.label)}</p></div> <div class="ap-po-details__icon-area"><div${attr_class(`svg-icon order-bg-opacity-${stringify(content.type)}`)}><i${attr_class(`uil uil-${stringify(content.icon)}`)}></i></div></div></div></div></div>`);
              },
              $$slots: { default: true }
            });
          }
          $$renderer3.push(`<!--]--> `);
          Tickets($$renderer3);
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
export {
  _page as default
};
