import { ag as ensure_array_like, aa as escape_html, ad as attr_class, ae as stringify, a2 as head, af as spread_props } from "../../../../../../chunks/index2.js";
import "clsx";
import { B as Button } from "../../../../../../chunks/Button.js";
import { C as Card } from "../../../../../../chunks/Card.js";
import { C as CardBody } from "../../../../../../chunks/CardBody.js";
import { R as Row, a as Col, C as Container } from "../../../../../../chunks/Row.js";
import "../../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbOne } from "../../../../../../chunks/BreadcrumbOne.js";
import { C as CardHeader } from "../../../../../../chunks/CardHeader.js";
import { F as Form } from "../../../../../../chunks/Form.js";
import { F as FormGroup } from "../../../../../../chunks/FormGroup.js";
import { I as Input } from "../../../../../../chunks/Input.js";
import { L as Label } from "../../../../../../chunks/Label.js";
import { C as CardFooter } from "../../../../../../chunks/CardFooter.js";
function EditProfile($$renderer) {
  $$renderer.push(`<div class="edit-profile mt-25">`);
  Card($$renderer, {
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        class: "px-sm-25 px-3",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="edit-profile__title"><h6>Edit Profile</h6> <span class="fs-13 color-light fw-400">Set up your personal information</span></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        children: ($$renderer3) => {
          Row($$renderer3, {
            class: "justify-content-center",
            children: ($$renderer4) => {
              Col($$renderer4, {
                xxl: 6,
                children: ($$renderer5) => {
                  $$renderer5.push(`<div class="edit-profile__body mx-xl-20">`);
                  Form($$renderer5, {
                    children: ($$renderer6) => {
                      FormGroup($$renderer6, {
                        class: "mb-20 form-group",
                        children: ($$renderer7) => {
                          Label($$renderer7, {
                            for: "names",
                            children: ($$renderer8) => {
                              $$renderer8.push(`<!---->name`);
                            },
                            $$slots: { default: true }
                          });
                          $$renderer7.push(`<!----> `);
                          Input($$renderer7, {
                            type: "text",
                            class: "form-control",
                            id: "names",
                            placeholder: "Duran Clayton"
                          });
                          $$renderer7.push(`<!---->`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!----> `);
                      FormGroup($$renderer6, {
                        class: "mb-20 form-group",
                        children: ($$renderer7) => {
                          Label($$renderer7, {
                            for: "phoneNumber1",
                            children: ($$renderer8) => {
                              $$renderer8.push(`<!---->phone number`);
                            },
                            $$slots: { default: true }
                          });
                          $$renderer7.push(`<!----> `);
                          Input($$renderer7, {
                            type: "tel",
                            class: "form-control",
                            id: "phoneNumber1",
                            placeholder: "+440 2546 5236"
                          });
                          $$renderer7.push(`<!---->`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!----> `);
                      FormGroup($$renderer6, {
                        class: "mb-20 form-group",
                        children: ($$renderer7) => {
                          $$renderer7.push(`<div class="countryOption">`);
                          Label($$renderer7, {
                            for: "countryOption",
                            children: ($$renderer8) => {
                              $$renderer8.push(`<!---->country`);
                            },
                            $$slots: { default: true }
                          });
                          $$renderer7.push(`<!----> <select class="form-select form-control" id="countryOption">`);
                          $$renderer7.option({ value: "JAN" }, ($$renderer8) => {
                            $$renderer8.push(`UK`);
                          });
                          $$renderer7.option({ value: "FBR" }, ($$renderer8) => {
                            $$renderer8.push(`US`);
                          });
                          $$renderer7.push(`</select></div>`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!----> `);
                      FormGroup($$renderer6, {
                        class: "mb-20 form-group",
                        children: ($$renderer7) => {
                          $$renderer7.push(`<div class="cityOption">`);
                          Label($$renderer7, {
                            for: "cityOption",
                            children: ($$renderer8) => {
                              $$renderer8.push(`<!---->city`);
                            },
                            $$slots: { default: true }
                          });
                          $$renderer7.push(`<!----> <select class="form-select form-control" id="cityOption">`);
                          $$renderer7.option({ value: "JAN" }, ($$renderer8) => {
                            $$renderer8.push(`Parkcity`);
                          });
                          $$renderer7.option({ value: "FBR" }, ($$renderer8) => {
                            $$renderer8.push(`Venues`);
                          });
                          $$renderer7.push(`</select></div>`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!----> `);
                      FormGroup($$renderer6, {
                        class: "mb-20 form-group",
                        children: ($$renderer7) => {
                          Label($$renderer7, {
                            for: "company1",
                            children: ($$renderer8) => {
                              $$renderer8.push(`<!---->company name`);
                            },
                            $$slots: { default: true }
                          });
                          $$renderer7.push(`<!----> <input type="text" class="form-control" id="company1" placeholder="Example"/>`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!----> `);
                      FormGroup($$renderer6, {
                        class: "mb-20 form-group",
                        children: ($$renderer7) => {
                          Label($$renderer7, {
                            for: "website",
                            children: ($$renderer8) => {
                              $$renderer8.push(`<!---->website`);
                            },
                            $$slots: { default: true }
                          });
                          $$renderer7.push(`<!----> `);
                          Input($$renderer7, {
                            type: "email",
                            class: "form-control",
                            id: "website",
                            placeholder: "www.example.com"
                          });
                          $$renderer7.push(`<!---->`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!----> `);
                      FormGroup($$renderer6, {
                        class: "mb-20 form-group",
                        children: ($$renderer7) => {
                          Label($$renderer7, {
                            for: "userBio",
                            children: ($$renderer8) => {
                              $$renderer8.push(`<!---->user bio`);
                            },
                            $$slots: { default: true }
                          });
                          $$renderer7.push(`<!----> `);
                          Input($$renderer7, {
                            type: "textarea",
                            class: "form-control",
                            id: "userBio",
                            rows: "5"
                          });
                          $$renderer7.push(`<!---->`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!----> `);
                      FormGroup($$renderer6, {
                        class: "mb-20 form-group",
                        children: ($$renderer7) => {
                          $$renderer7.push(`<div class="skillsOption">`);
                          Label($$renderer7, {
                            for: "skillsOption",
                            children: ($$renderer8) => {
                              $$renderer8.push(`<!---->skils`);
                            },
                            $$slots: { default: true }
                          });
                          $$renderer7.push(`<!----> <select class="form-select form-control" id="skillsOption">`);
                          $$renderer7.option({ value: "JAN" }, ($$renderer8) => {
                            $$renderer8.push(`event`);
                          });
                          $$renderer7.option({ value: "FBR" }, ($$renderer8) => {
                            $$renderer8.push(`Venues`);
                          });
                          $$renderer7.push(`</select></div>`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!----> <div class="button-group d-flex flex-wrap pt-30 mb-15">`);
                      Button($$renderer6, {
                        color: "primary",
                        size: "default",
                        class: "btn-squared me-15 text-capitalize btn-sm",
                        children: ($$renderer7) => {
                          $$renderer7.push(`<!---->update profile`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!----> `);
                      Button($$renderer6, {
                        color: "light",
                        default: "default",
                        class: "btn-squared fw-400 text-capitalize btn-sm btn-transparent-light",
                        children: ($$renderer7) => {
                          $$renderer7.push(`<!---->cancel`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!----></div>`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----></div>`);
                },
                $$slots: { default: true }
              });
            },
            $$slots: { default: true }
          });
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
function AccountSetting($$renderer) {
  $$renderer.push(`<div class="edit-profile mt-25">`);
  Card($$renderer, {
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        class: "px-sm-25 px-3",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="edit-profile__title"><h6>Account setting</h6> <span class="fs-13 color-light fw-400">Update your username and manage your account</span></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        children: ($$renderer3) => {
          Row($$renderer3, {
            class: "justify-content-center",
            children: ($$renderer4) => {
              Col($$renderer4, {
                xxl: 6,
                children: ($$renderer5) => {
                  $$renderer5.push(`<div class="edit-profile__body mx-xl-20">`);
                  Form($$renderer5, {
                    children: ($$renderer6) => {
                      FormGroup($$renderer6, {
                        class: "mb-20",
                        children: ($$renderer7) => {
                          Label($$renderer7, {
                            for: "name1",
                            children: ($$renderer8) => {
                              $$renderer8.push(`<!---->username`);
                            },
                            $$slots: { default: true }
                          });
                          $$renderer7.push(`<!----> `);
                          Input($$renderer7, {
                            type: "text",
                            class: "form-control",
                            id: "name1",
                            placeholder: "Duran Clayton"
                          });
                          $$renderer7.push(`<!----> <small id="passwordHelpInline2" class="text-light fs-13">Your Dashboard URL: https://dashboard.com/<span class="color-dark">clayton</span></small>`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!----> `);
                      FormGroup($$renderer6, {
                        class: "mb-1",
                        children: ($$renderer7) => {
                          Label($$renderer7, {
                            for: "email45",
                            children: ($$renderer8) => {
                              $$renderer8.push(`<!---->email`);
                            },
                            $$slots: { default: true }
                          });
                          $$renderer7.push(`<!----> `);
                          Input($$renderer7, {
                            type: "email",
                            class: "form-control",
                            id: "email45",
                            placeholder: "Contact@example.com"
                          });
                          $$renderer7.push(`<!---->`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!---->`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----></div>`);
                },
                $$slots: { default: true }
              });
            },
            $$slots: { default: true }
          });
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardFooter($$renderer2, {
        class: "bg-transparent",
        children: ($$renderer3) => {
          Row($$renderer3, {
            class: "justify-content-center align-items-center",
            children: ($$renderer4) => {
              Col($$renderer4, {
                xxl: 6,
                children: ($$renderer5) => {
                  $$renderer5.push(`<div class="d-flex justify-content-between mt-1 align-items-center flex-wrap"><div class="text-capitalize py-10"><h6>close account</h6> <span class="fs-13 color-light fw-400">Delete your account and account data</span></div> <div class="my-sm-0 my-10 py-10">`);
                  Button($$renderer5, {
                    color: "danger",
                    size: "default",
                    class: "btn-squared fw-400 text-capitalize",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->close account`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----></div></div> <div class="button-group d-flex flex-wrap pt-35 mb-35">`);
                  Button($$renderer5, {
                    color: "primary",
                    size: "default",
                    class: "fs-15 btn-squared me-15 text-capitalize",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->Save Changes`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----> `);
                  Button($$renderer5, {
                    color: "light",
                    size: "default",
                    class: "fs-15 btn-squared fw-400 text-capitalize btn-transparent-light",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->cancel`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----></div>`);
                },
                $$slots: { default: true }
              });
            },
            $$slots: { default: true }
          });
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
function ChangePassword($$renderer) {
  $$renderer.push(`<div class="edit-profile mt-25">`);
  Card($$renderer, {
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        class: "px-sm-25 px-3",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="edit-profile__title"><h6>change password</h6> <span class="fs-13 color-light fw-400">Change or reset your account password</span></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        children: ($$renderer3) => {
          Row($$renderer3, {
            class: "justify-content-center",
            children: ($$renderer4) => {
              Col($$renderer4, {
                xxl: 6,
                children: ($$renderer5) => {
                  $$renderer5.push(`<div class="edit-profile__body mx-xl-20">`);
                  Form($$renderer5, {
                    children: ($$renderer6) => {
                      FormGroup($$renderer6, {
                        class: "mb-20",
                        children: ($$renderer7) => {
                          Label($$renderer7, {
                            for: "name",
                            children: ($$renderer8) => {
                              $$renderer8.push(`<!---->old passowrd`);
                            },
                            $$slots: { default: true }
                          });
                          $$renderer7.push(`<!----> `);
                          Input($$renderer7, { type: "text", class: "form-control", id: "name" });
                          $$renderer7.push(`<!---->`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!----> `);
                      FormGroup($$renderer6, {
                        class: "mb-1",
                        children: ($$renderer7) => {
                          Label($$renderer7, {
                            for: "password-field",
                            children: ($$renderer8) => {
                              $$renderer8.push(`<!---->new password`);
                            },
                            $$slots: { default: true }
                          });
                          $$renderer7.push(`<!----> <div class="position-relative">`);
                          Input($$renderer7, {
                            id: "password-field",
                            type: "password",
                            class: "form-control",
                            name: "password",
                            placeholder: "Password"
                          });
                          $$renderer7.push(`<!----> <span class="uil uil-eye-slash text-lighten fs-15 field-icon toggle-password2"></span></div> <small id="passwordHelpInline" class="text-light fs-13">Minimum 6 characters</small> <div class="button-group d-flex flex-wrap pt-45 mb-35">`);
                          Button($$renderer7, {
                            color: "primary",
                            size: "default",
                            class: "fs-15 btn-squared me-15 text-capitalize",
                            children: ($$renderer8) => {
                              $$renderer8.push(`<!---->Save Changes`);
                            },
                            $$slots: { default: true }
                          });
                          $$renderer7.push(`<!----> `);
                          Button($$renderer7, {
                            class: "fs-15 btn-squared fw-400 text-capitalize btn btn-light btn-default btn-transparent-light",
                            children: ($$renderer8) => {
                              $$renderer8.push(`<!---->cancel`);
                            },
                            $$slots: { default: true }
                          });
                          $$renderer7.push(`<!----></div>`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!---->`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----></div>`);
                },
                $$slots: { default: true }
              });
            },
            $$slots: { default: true }
          });
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
function SocialProfiles($$renderer) {
  const socialProfiles = [
    {
      name: "Facebook",
      icon: "facebook-f",
      color: "facebook",
      placeholder: "URL"
    },
    {
      name: "Twitter",
      icon: "twitter",
      color: "twitter",
      placeholder: "@Username"
    },
    {
      name: "Instagram",
      icon: "instagram",
      color: "instagram",
      placeholder: "URL"
    },
    {
      name: "Github",
      icon: "github",
      color: "dark",
      placeholder: "Username"
    },
    {
      name: "Medium",
      icon: "medium-m",
      color: "dark",
      placeholder: "Username"
    },
    {
      name: "Website",
      icon: "globe",
      color: "ruby",
      placeholder: "URL"
    }
  ];
  $$renderer.push(`<div class="edit-profile edit-social mt-25">`);
  Card($$renderer, {
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        class: "px-sm-25 px-3",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="edit-profile__title"><h6>social profiles</h6> <span class="fs-13 color-light fw-400">Add elsewhere links to your profile</span></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        children: ($$renderer3) => {
          Row($$renderer3, {
            class: "justify-content-center",
            children: ($$renderer4) => {
              Col($$renderer4, {
                xxl: 6,
                children: ($$renderer5) => {
                  $$renderer5.push(`<div class="edit-profile__body mx-xl-20">`);
                  Form($$renderer5, {
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!--[-->`);
                      const each_array = ensure_array_like(socialProfiles);
                      for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
                        let item = each_array[$$index];
                        $$renderer6.push(`<div class="mb-30">`);
                        Label($$renderer6, {
                          for: "socialUrl",
                          children: ($$renderer7) => {
                            $$renderer7.push(`<!---->${escape_html(item.name)}`);
                          },
                          $$slots: { default: true }
                        });
                        $$renderer6.push(`<!----> <div class="input-group flex-nowrap"><div class="input-group-prepend"><span${attr_class(`input-group-text border-${stringify(item.color)} bg-${stringify(item.color)} text-white wh-44 radius-xs justify-content-center`)}><i${attr_class(`uil uil-${stringify(item.icon)} fs-18`)}></i></span></div> `);
                        Input($$renderer6, {
                          type: "text",
                          class: "form-control form-control--social",
                          placeholder: item.placeholder,
                          "aria-label": item.placeholder,
                          "aria-describedby": "addon-wrapping1"
                        });
                        $$renderer6.push(`<!----></div></div>`);
                      }
                      $$renderer6.push(`<!--]--> <div class="button-group d-flex flex-wrap pt-md-50 mb-15">`);
                      Button($$renderer6, {
                        color: "primary",
                        size: "default",
                        class: "fs-15 btn-squared me-15 text-capitalize",
                        children: ($$renderer7) => {
                          $$renderer7.push(`<!---->Update Social Profiles`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!----> `);
                      Button($$renderer6, {
                        color: "light",
                        size: "default",
                        class: "fs-15 btn-squared fw-400 text-capitalize btn-transparent-light",
                        children: ($$renderer7) => {
                          $$renderer7.push(`<!---->cancel`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!----></div>`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----></div>`);
                },
                $$slots: { default: true }
              });
            },
            $$slots: { default: true }
          });
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
function Notification($$renderer) {
  const notifications = [
    {
      name: "Company News",
      label: "Get company news, announcements, and product updates",
      enabled: false
    },
    {
      name: "Meetups near you",
      label: "Get company news, announcements, and product updates",
      enabled: true
    },
    {
      name: "Opportunities",
      label: "Get company news, announcements, and product updates",
      enabled: false
    },
    {
      name: "Weekly Newsletters",
      label: "Get company news, announcements, and product updates",
      enabled: false
    }
  ];
  const activities = [
    { name: "Anyone seeing my profile page", enabled: false },
    { name: "Anyone follow me", enabled: true },
    { name: "Someone mentioned me", enabled: false },
    { name: "Someone accepts my invitation", enabled: true },
    { name: "Anyone send me a message", enabled: false }
  ];
  $$renderer.push(`<div class="edit-profile edit-social mt-25">`);
  Card($$renderer, {
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        class: "px-sm-25 px-3",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="edit-profile__title"><h6>Notifications</h6> <span class="fs-13 color-light fw-400">Add elsewhere links to your profile</span></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="notification-content p-25 mb-25"><div class="notification-content__title d-flex justify-content-between flex-wrap pb-20 text-capitalize"><h6 class="fs-15 text-light fw-500 lh-normal">Notifications</h6> <a class="color-primary fs-13" href="#">toggle all</a></div> <div class="global-shadow radius-xl notification-content__body-wrapper"><!--[-->`);
          const each_array = ensure_array_like(notifications);
          for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
            let item = each_array[$$index];
            $$renderer3.push(`<div class="notification-content__body p-25 border-bottom"><div class="d-flex justify-content-between flex-wrap align-items-center"><div class="div"><h6>${escape_html(item.name)}</h6> <span>${escape_html(item.label)}</span></div> <div class="my-lg-0 my-10">`);
            Input($$renderer3, {
              type: "switch",
              class: "form-check-input border-0",
              id: "nc1",
              checked: item.enabled ? true : false
            });
            $$renderer3.push(`<!----></div></div></div>`);
          }
          $$renderer3.push(`<!--]--></div></div> <div class="notification-content p-25 mb-25"><div class="notification-content__title d-flex justify-content-between flex-wrap pb-20 text-capitalize"><h6 class="fs-15 text-light fw-500 lh-normal">Account Activity</h6> <a class="color-primary fs-13" href="#">toggle all</a></div> <div class="global-shadow radius-xl notification-content__body-wrapper"><!--[-->`);
          const each_array_1 = ensure_array_like(activities);
          for (let $$index_1 = 0, $$length = each_array_1.length; $$index_1 < $$length; $$index_1++) {
            let item = each_array_1[$$index_1];
            $$renderer3.push(`<div class="notification-content__body p-25 border-bottom"><div class="d-flex justify-content-between flex-wrap align-items-center"><div class="div"><h6>${escape_html(item.name)}</h6></div> <div class="my-lg-0 my-10">`);
            Input($$renderer3, {
              type: "switch",
              class: "form-check-input border-0",
              id: "nc5",
              checked: item.enabled ? true : false
            });
            $$renderer3.push(`<!----></div></div></div>`);
          }
          $$renderer3.push(`<!--]--></div></div> <div class="button-group d-flex flex-wrap pt-25 mb-25">`);
          Button($$renderer3, {
            color: "primary",
            size: "default",
            class: "btn-squared fs-15  me-15 text-capitalize",
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->Update notification Profiles`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Button($$renderer3, {
            color: "light",
            size: "default",
            class: "btn-squared fs-15 fw-400 text-capitalize btn-transparent-light",
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->cancel`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const breadcrumbData = {
      pageTitle: "Profile Settings",
      bcItem: "Home",
      bcItem2: "Apps",
      bcItemActive: "Social"
    };
    const settingsTabs = [
      EditProfile,
      AccountSetting,
      ChangePassword,
      SocialProfiles,
      Notification
    ];
    let activeTab = settingsTabs.indexOf(EditProfile);
    head("1ltt6w4", $$renderer2, ($$renderer3) => {
      $$renderer3.title(($$renderer4) => {
        $$renderer4.push(`<title>Profile Settings</title>`);
      });
    });
    $$renderer2.push(`<div class="profile-setting">`);
    Container($$renderer2, {
      fluid: true,
      children: ($$renderer3) => {
        Row($$renderer3, {
          class: "mb-50",
          children: ($$renderer4) => {
            Col($$renderer4, {
              lg: 12,
              children: ($$renderer5) => {
                BreadcrumbOne($$renderer5, spread_props([breadcrumbData]));
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 3,
              lg: 4,
              sm: 5,
              children: ($$renderer5) => {
                Card($$renderer5, {
                  class: "mb-25",
                  children: ($$renderer6) => {
                    CardBody($$renderer6, {
                      class: "text-center p-0",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<div class="account-profile border-bottom pt-25 px-25 pb-0 flex-column d-flex align-items-center"><div class="ap-img mb-20 pro_img_wrapper"><input id="file-upload" type="file" name="fileUpload" class="d-none"/> <label for="file-upload"><img class="ap-img__main rounded-circle wh-120" src="/img/author/profile.png" alt="profile"/> <span class="cross" id="remove_pro_pic"><img class="svg" alt="" src="/img/svg/camera.svg"/></span></label></div> <div class="ap-nameAddress pb-3"><h5 class="ap-nameAddress__title">Duran Clayton</h5> <p class="ap-nameAddress__subTitle fs-14 m-0">UI/UX Designer</p></div></div> <div class="ps-tab p-20 pb-25"><div class="nav flex-column text-start profile-settings-js" role="tablist" aria-orientation="vertical"><a class="nav-link active" href="#" role="tab" data-type="edit-profile"><img class="svg" alt="" src="/img/svg/user.svg"/> Edit profile</a> <a class="nav-link" href="#" role="tab" data-type="account-settings"><img class="svg" alt="" src="/img/svg/settings.svg"/> Account setting</a> <a class="nav-link" href="#" role="tab" data-type="change-password"><img class="svg" alt="" src="/img/svg/key.svg"/>change password</a> <a class="nav-link" href="#" role="tab" data-type="social-profiles"><img class="svg" alt="" src="/img/svg/users.svg"/> social profiles</a> <a class="nav-link" href="#" role="tab" data-type="notification"><img class="svg" alt="" src="/img/svg/bell.svg"/> notification</a></div></div>`);
                      },
                      $$slots: { default: true }
                    });
                  },
                  $$slots: { default: true }
                });
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 9,
              lg: 8,
              sm: 7,
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="ap-tab ap-tab-header"><div class="ap-tab-header__img"><img src="/img/ap-header.png" alt="ap-header" class="img-fluid w-100"/> <div class="ap-cover__changeImgBtn">`);
                Button($$renderer5, {
                  color: "light",
                  outline: true,
                  class: "change-cover cover-btn",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<img class="svg" alt="" src="/img/svg/camera.svg"/> Change Cover`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----></div></div></div> `);
                $$renderer5.push("<!---->");
                settingsTabs[activeTab]?.($$renderer5, {});
                $$renderer5.push(`<!---->`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></div>`);
  });
}
export {
  _page as default
};
