import { ag as ensure_array_like, aa as escape_html, ac as attr, ad as attr_class, ae as stringify, al as attr_style, a2 as head, af as spread_props } from "../../../../../../chunks/index2.js";
import "clsx";
import { B as Button } from "../../../../../../chunks/Button.js";
import { R as Row, a as Col, C as Container } from "../../../../../../chunks/Row.js";
import "../../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbOne } from "../../../../../../chunks/BreadcrumbOne.js";
import { C as Card } from "../../../../../../chunks/Card.js";
import { C as CardBody } from "../../../../../../chunks/CardBody.js";
import { C as CardFooter } from "../../../../../../chunks/CardFooter.js";
import { C as CardHeader } from "../../../../../../chunks/CardHeader.js";
import { C as Chartjs } from "../../../../../../chunks/Chartjs.js";
import { c as chartLinearGradient } from "../../../../../../chunks/utilities.js";
import { C as CardExtra } from "../../../../../../chunks/CardExtra.js";
import { d as doughnutData } from "../../../../../../chunks/dashboardChartContent.js";
import { T as TopSellingProduct } from "../../../../../../chunks/TopSellingProduct.js";
import "../../../../../../chunks/stores2.js";
function ProfileCard($$renderer) {
  const overview = [
    { total: "$72,573", label: "Total Revenue" },
    { total: "3,257", label: "Order" },
    { total: "74", label: "Products" }
  ];
  Card($$renderer, {
    class: "mb-25",
    children: ($$renderer2) => {
      CardBody($$renderer2, {
        class: "text-center pt-sm-30 pb-sm-0  px-25 pb-0",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="account-profile"><div class="ap-img w-100 d-flex justify-content-center"><img class="ap-img__main rounded-circle mb-3 wh-120 d-flex bg-opacity-primary" src="/img/author/profile.png" alt="profile"/></div> <div class="ap-nameAddress pb-3 pt-1"><h5 class="ap-nameAddress__title">Duran Clayton</h5> <p class="ap-nameAddress__subTitle fs-14 m-0">UI/UX Designer</p> <p class="ap-nameAddress__subTitle fs-14 m-0"><img class="svg" alt="" src="/img/svg/map-pin.svg"/> London, England</p></div> <div class="ap-button button-group d-flex justify-content-center flex-wrap">`);
          Button($$renderer3, {
            color: "transparent",
            class: "border text-capitalize px-25 color-gray transparent radius-md",
            children: ($$renderer4) => {
              $$renderer4.push(`<img class="svg" alt="" src="/img/svg/mail.svg"/> message`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Button($$renderer3, {
            color: "primary",
            size: "default",
            class: "btn-squared text-capitalize px-25",
            children: ($$renderer4) => {
              $$renderer4.push(`<img class="svg" alt="" src="/img/svg/user-plus.svg"/> follow`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----></div></div> `);
          CardFooter($$renderer3, {
            class: "mt-20 pt-20 pb-20 px-0 bg-transparent",
            children: ($$renderer4) => {
              $$renderer4.push(`<div class="profile-overview d-flex justify-content-between flex-wrap"><!--[-->`);
              const each_array = ensure_array_like(overview);
              for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
                let data = each_array[$$index];
                $$renderer4.push(`<div class="po-details"><h6 class="po-details__title pb-1">${escape_html(data.total)}</h6> <span class="po-details__sTitle">${escape_html(data.label)}</span></div>`);
              }
              $$renderer4.push(`<!--]--></div>`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
}
function UserBio($$renderer) {
  const contactInfo = [
    { icon: "mail.svg", label: "Clayton@example.com" },
    { icon: "phone.svg", label: "+44 (0161) 347 8854" },
    { icon: "globe.svg", label: "www.example.com" }
  ];
  const tags = [
    "UI/UX",
    "Branding",
    "Product Design",
    "Application",
    "Web Design"
  ];
  const socials = ["facebook-f", "twitter", "dribbble", "instagram"];
  Card($$renderer, {
    class: "mb-25",
    children: ($$renderer2) => {
      $$renderer2.push(`<div class="user-bio border-bottom">`);
      CardHeader($$renderer2, {
        class: "border-bottom-0 pt-sm-30 pb-sm-0 px-md-25 px-3",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="profile-header-title">User Bio</div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        class: "pt-md-1 pt-0",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="user-bio__content"><p class="m-0">Nam malesuada dolor tellus pretium amet was hendrerit facilisi id vitae enim sed ornare
					there suspendisse sed orci neque ac sed aliquet risus faucibus in pretium molestie nisl
					tempor quis odio habitant.</p></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----></div> <div class="user-info border-bottom">`);
      CardHeader($$renderer2, {
        class: "border-bottom-0 pt-sm-25 pb-sm-0 px-md-25 px-3",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="profile-header-title">Contact info</div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        class: "pt-md-1 pt-0",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="user-content-info"><!--[-->`);
          const each_array = ensure_array_like(contactInfo);
          for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
            let info = each_array[$$index];
            $$renderer3.push(`<p class="user-content-info__item"><img class="svg" alt=""${attr("src", `/img/svg/${info.icon}`)}/> ${escape_html(info.label)}</p>`);
          }
          $$renderer3.push(`<!--]--></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----></div> <div class="user-skils border-bottom">`);
      CardHeader($$renderer2, {
        class: "border-bottom-0 pt-sm-25 pb-sm-0 px-md-25 px-3",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="profile-header-title">Skills</div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        class: "pt-md-1 pt-0",
        children: ($$renderer3) => {
          $$renderer3.push(`<ul class="user-skils-parent"><!--[-->`);
          const each_array_1 = ensure_array_like(tags);
          for (let $$index_1 = 0, $$length = each_array_1.length; $$index_1 < $$length; $$index_1++) {
            let tag = each_array_1[$$index_1];
            $$renderer3.push(`<li class="user-skils-parent__item"><a href="#">${escape_html(tag)}</a></li>`);
          }
          $$renderer3.push(`<!--]--></ul>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----></div> <div class="db-social">`);
      CardHeader($$renderer2, {
        class: "border-bottom-0 pt-sm-25 pb-sm-0 px-md-25 px-3",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="profile-header-title">Social Profiles</div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        class: "pt-md-1 pt-0",
        children: ($$renderer3) => {
          $$renderer3.push(`<ul class="db-social-parent mb-0"><!--[-->`);
          const each_array_2 = ensure_array_like(socials);
          for (let $$index_2 = 0, $$length = each_array_2.length; $$index_2 < $$length; $$index_2++) {
            let icon = each_array_2[$$index_2];
            $$renderer3.push(`<li class="db-social-parent__item"><a${attr_class(`color-${stringify(icon)} hover-${stringify(icon)} wh-44 fs-18`)} href="#"><i${attr_class(`lab la-${stringify(icon)}`)}></i></a></li>`);
          }
          $$renderer3.push(`<!--]--></ul>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----></div>`);
    },
    $$slots: { default: true }
  });
}
function OverviewCharts($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let contents, scales;
    let primaryColor;
    let primaryColorRGB;
    let secondaryColor;
    let secondaryColorRGB;
    let successColor;
    let successColorRGB;
    const tooltip = {
      callbacks: {
        label(t) {
          const dstLabel = t.dataset.label;
          const { formattedValue } = t;
          return `  ${formattedValue} ${dstLabel}`;
        },
        labelColor(t) {
          return {
            backgroundColor: t.dataset.hoverBackgroundColor,
            borderColor: "transparent"
          };
        }
      }
    };
    const labels = ["Sat", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri"];
    contents = [
      {
        id: 1,
        total: "3,245",
        label: "Orders",
        growthStatus: "up",
        growthRate: "25%",
        chartData: [
          {
            data: [35, 55, 25, 60, 42, 80, 35],
            backgroundColor: `rgba(${primaryColorRGB},0.1)`,
            hoverBackgroundColor: primaryColor,
            label: "Orders",
            barPercentage: 1,
            categoryPercentage: 1,
            maxBarThickness: 13,
            barThickness: 13
          }
        ]
      },
      {
        id: 2,
        total: "$72,482",
        label: "Total Revenue",
        growthStatus: "up",
        growthRate: "17%",
        chartData: [
          {
            data: [34, 64, 52, 80, 44, 58, 53],
            backgroundColor: `rgba(${secondaryColorRGB},0.1)`,
            hoverBackgroundColor: secondaryColor,
            label: "Total Revenue",
            barPercentage: 1,
            categoryPercentage: 1,
            maxBarThickness: 13,
            barThickness: 13
          }
        ]
      },
      {
        id: 3,
        total: "1,341",
        label: "Product Sold",
        growthStatus: "down",
        growthRate: "16%",
        chartData: [
          {
            data: [65, 44, 36, 55, 48, 78, 42],
            backgroundColor: `rgba(${successColorRGB},0.1)`,
            hoverBackgroundColor: successColor,
            label: "Product Sold",
            barPercentage: 1,
            categoryPercentage: 1,
            maxBarThickness: 13,
            barThickness: 13
          }
        ]
      }
    ];
    scales = {
      y: {
        beginAtZero: true,
        border: { display: false },
        grid: {
          drawTicks: false,
          drawBorder: false,
          borderWidth: 0,
          display: false
        },
        ticks: { display: false }
      },
      x: {
        beginAtZero: true,
        border: { display: false },
        grid: {
          drawTicks: false,
          drawBorder: false,
          borderWidth: 0,
          display: false
        },
        ticks: { display: false }
      }
    };
    Row($$renderer2, {
      children: ($$renderer3) => {
        $$renderer3.push(`<!--[-->`);
        const each_array = ensure_array_like(contents);
        for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
          let item = each_array[$$index];
          Col($$renderer3, {
            xxl: 4,
            md: 6,
            class: "mb-25",
            children: ($$renderer4) => {
              $$renderer4.push(`<div class="ap-po-details radius-xl d-flex justify-content-between"><div><div class="overview-content"><h1>${escape_html(item.total)}</h1> <p>${escape_html(item.label)}</p> <div class="ap-po-details-time"><span${attr_class(`color-${stringify(item.growthStatus === "up" ? "success" : "danger")}`)}><i${attr_class(`uil uil-arrow-${stringify(item.growthStatus === "up" ? "up" : "down")}`)}></i> <strong>${escape_html(item.growthRate)}</strong></span> <small>Since last week</small></div></div></div> <div class="ap-po-timeChart"><div class="overview-single__chart d-md-flex align-items-end"><div class="parentContainer">`);
              Chartjs($$renderer4, {
                className: "overviewChart",
                id: `overviewChart-${item.id}`,
                labels,
                datasets: item.chartData,
                type: "bar",
                tooltip,
                scales,
                height: 94
              });
              $$renderer4.push(`<!----></div></div></div></div>`);
            },
            $$slots: { default: true }
          });
        }
        $$renderer3.push(`<!--]-->`);
      },
      $$slots: { default: true }
    });
  });
}
function StatsChart($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let salesRevenueDatasets, lineChartLayout;
    let revenue = "today";
    let primaryColor;
    let primaryColorRGB;
    const tooltip = {
      callbacks: {
        title() {
          return `Total Revenue`;
        },
        label(t) {
          const { formattedValue, dataset } = t;
          return `${formattedValue}k ${dataset.label}`;
        }
      }
    };
    let salesRevenue = {
      today: {
        current: [65, 35, 45, 42, 65, 60, 42, 45, 35, 55, 40, 65],
        pervious: [45, 20, 35, 32, 50, 45, 32, 35, 25, 40, 30, 55],
        labels: [
          "Jan",
          "Feb",
          "Mar",
          "Apr",
          "May",
          "Jun",
          "Jul",
          "Aug",
          "Sep",
          "Oct",
          "Nov",
          "Dec"
        ]
      }
    };
    const scales = {
      y: {
        beginAtZero: true,
        border: { display: false },
        grid: {
          display: false,
          color: "#E3E6EF",
          borderDash: [3, 3],
          zeroLineColor: "#E3E6EF",
          zeroLineWidth: 1,
          zeroLineBorderDash: [3, 3],
          drawTicks: false,
          drawBorder: false
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474",
          Min: 0,
          Max: 80,
          stepSize: 20,
          padding: 15,
          callback(label) {
            return `${label}k`;
          }
        }
      },
      x: {
        border: { display: false },
        grid: {
          display: false,
          zeroLineWidth: 0,
          drawTicks: true,
          drawBorder: false,
          zeroLineColor: "#485e9029",
          color: "transparent",
          z: 1,
          tickMarkLength: 0
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474"
        }
      }
    };
    ({ ...tooltip });
    salesRevenueDatasets = [
      {
        data: salesRevenue[revenue].current,
        borderColor: primaryColor,
        borderWidth: 4,
        fill: true,
        backgroundColor: () => chartLinearGradient(document.getElementById("ninjadash-sales-revenue"), 300, {
          start: `rgba(${primaryColorRGB},0.3)`,
          end: "rgba(255,255,255,0.05)"
        }),
        label: "Current period",
        pointStyle: "circle",
        pointRadius: "0",
        hoverRadius: "6",
        pointBorderColor: "#fff",
        pointBackgroundColor: primaryColor,
        hoverBorderWidth: 2,
        lineTension: 0.5
      },
      {
        data: salesRevenue[revenue].pervious,
        borderColor: "#C6D0DC",
        borderWidth: 2,
        fill: false,
        backgroundColor: "#00173750",
        label: "Pervious period",
        pointStyle: "circle",
        pointRadius: "0",
        hoverRadius: "0",
        pointBorderColor: "#fff",
        pointBackgroundColor: "#C6D0DC",
        hoverBorderWidth: 2,
        lineTension: 0.4,
        borderDash: [3, 3]
      }
    ];
    lineChartLayout = { padding: { left: -15, right: 0, top: 0, bottom: 0 } };
    Card($$renderer2, {
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "text-capitalize px-md-25 px-3",
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>General Statistics</h6> `);
            CardExtra($$renderer4);
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="ap-statistics-charts">`);
            {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<div class="parentContainer">`);
              Chartjs($$renderer4, {
                type: "line",
                id: "ninjadash-sales-revenue",
                className: "ninjadash-sales-revenue",
                labels: salesRevenue[revenue].labels,
                datasets: salesRevenueDatasets,
                scales,
                layout: lineChartLayout,
                height: 67,
                tooltip
              });
              $$renderer4.push(`<!----></div>`);
            }
            $$renderer4.push(`<!--]--></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
function ProductsTable($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const topSales = doughnutData.topSale;
    let period = "today";
    let dataPeriod = topSales[period];
    let extraStyle = "";
    let defaultTable = "";
    Card($$renderer2, {
      class: "mt-25 mb-40",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "text-capitalize px-md-25 px-3",
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>Top Selling Products</h6> `);
            CardExtra($$renderer4);
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          class: "p-0",
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="ap-product">`);
            TopSellingProduct($$renderer4, { dataPeriod, extraStyle, defaultTable });
            $$renderer4.push(`<!----></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
function Overview($$renderer) {
  OverviewCharts($$renderer);
  $$renderer.push(`<!----> `);
  StatsChart($$renderer);
  $$renderer.push(`<!----> `);
  ProductsTable($$renderer);
  $$renderer.push(`<!---->`);
}
function PostForm($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    $$renderer2.push(`<div class="ap-post-form">`);
    Card($$renderer2, {
      class: "border-0 mb-25",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "px-md-25 px-3",
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>Post something</h6>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          class: "p-0 px-25",
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="d-flex flex-column"><div class="border-0 flex-1 position-relative"><div class="pt-20 outline-0 pb-2 pe-0 ps-0 rounded-0 position-relative border-bottom"><span class="ap-profile-image bg-opacity-secondary rounded-circle d-block position-absolute" style="background-image:url('/img/ap-author.png'); background-size: cover;"></span> <div class="ps-15 ms-50 pt-10"><textarea class="form-control border-0 p-0 fs-xl bg-transparent" rows="3" placeholder="Write something..."></textarea></div></div></div> <div class="ap-post-attach d-flex flex-row align-items-center flex-wrap flex-shrink-0"><a href="#" class="btn rounded-pill me-2"><img class="svg" alt="" src="/img/svg/image.svg"/> Photo/Video</a> <a href="#" class="btn rounded-pill ap-post-attach__drop"><img class="svg" alt="" src="/img/svg/more-horizontal.svg"/></a> `);
            Button($$renderer4, {
              color: "primary",
              size: "default",
              class: "btn-squared ms-auto ap-post-attach__btn",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->post <i class="uil uil-message"></i>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----></div></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></div>`);
  });
}
const postContent = [
  {
    postId: 1,
    from: "Alex Kerry",
    time: "12 mins ago",
    img: [
      "post-image.png"
    ],
    author: "1.jpg",
    text: "Nam malesuada dolor tellus pretium amet was hendrerit facilisi  tempor quis enim sed ornare there suspendisse sed orci neque ac sed aliquet risus faucibus in pretium molestee.",
    like: 231,
    comment: []
  },
  {
    postId: 2,
    from: "Tim Pain",
    time: "25 mins ago",
    img: [],
    author: "2.jpg",
    text: "Nam malesuada dolor tellus pretium amet was hendrerit facilisi  tempor quis enim sed ornare there suspendisse sed orci neque ac sed aliquet risus faucibus in pretium molestee.",
    like: 341,
    comment: []
  },
  {
    postId: 3,
    from: "Oliver Kan",
    time: "20 mins ago",
    img: [
      "506.png",
      "907.png",
      "brightland_3744.png",
      "room.png",
      "165.png"
    ],
    author: "3.jpg",
    text: "",
    like: 143,
    comment: [
      {
        time: "5 mins ago",
        from: "Alexender Arnold",
        author: "4.jpg",
        text: "It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.",
        reply: [
          {
            time: "5 mins ago",
            from: "Oliver Kan",
            author: "3.jpg",
            text: "It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout."
          }
        ]
      },
      {
        time: "34 mins ago",
        from: "Alex Kerry",
        author: "1.jpg",
        text: "It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout."
      }
    ]
  }
];
function Posts($$renderer) {
  $$renderer.push(`<div class="ap-main-post"><!--[-->`);
  const each_array = ensure_array_like(postContent);
  for (let $$index_4 = 0, $$length = each_array.length; $$index_4 < $$length; $$index_4++) {
    let content = each_array[$$index_4];
    Card($$renderer, {
      class: "mb-25",
      children: ($$renderer2) => {
        CardBody($$renderer2, {
          class: "pb-0 px-sm-25 ap-main-post__header",
          children: ($$renderer3) => {
            $$renderer3.push(`<div class="d-flex flex-row pb-20 border-top-0 border-left-0 border-right-0 ap-post-content__title align-items-center"><div class="d-inline-block align-middle me-15"><span class="profile-image bg-opacity-secondary rounded-circle d-block avatar avatar-md m-0"${attr_style(`background-image:url('/img/author/${stringify(content.author)}'); background-size: cover;`)}></span></div> <h6 class="mb-0 flex-1 text-dark">${escape_html(content.from)} <small class="m-0 d-block">${escape_html(content.time)}</small></h6> `);
            CardExtra($$renderer3);
            $$renderer3.push(`<!----></div> `);
            if (content.img.length < 2 && content.img.length !== 0) {
              $$renderer3.push("<!--[-->");
              $$renderer3.push(`<div class="mb-15"><!--[-->`);
              const each_array_1 = ensure_array_like(content.img);
              for (let $$index = 0, $$length2 = each_array_1.length; $$index < $$length2; $$index++) {
                let image = each_array_1[$$index];
                $$renderer3.push(`<img${attr("src", `/img/${stringify(image)}`)} alt="postImage" class="ap-post-attach__headImg w-100"/>`);
              }
              $$renderer3.push(`<!--]--></div>`);
            } else if (content.img.length >= 2) {
              $$renderer3.push("<!--[1-->");
              $$renderer3.push(`<div class="mb-15 ap-post-gallery"><!--[-->`);
              const each_array_2 = ensure_array_like(content.img);
              for (let i = 0, $$length2 = each_array_2.length; i < $$length2; i++) {
                let image = each_array_2[i];
                if (i !== content.img.length - 1) {
                  $$renderer3.push("<!--[-->");
                  $$renderer3.push(`<div class="ap-post-gallery__item"><a href="#"><img${attr("src", `/img/${stringify(image)}`)} alt="gallery" class="w-100 img-fluid"/></a></div>`);
                } else if (i === content.img.length - 1) {
                  $$renderer3.push("<!--[1-->");
                  $$renderer3.push(`<div class="ap-post-gallery__item"><a href="#"><img${attr("src", `/img/${stringify(image)}`)} alt="gallery" class="w-100 img-fluid"/> <div class="ap-post-gallery-overlay__content"><span>26<span class="las la-plus"></span></span></div></a></div>`);
                } else {
                  $$renderer3.push("<!--[!-->");
                }
                $$renderer3.push(`<!--]-->`);
              }
              $$renderer3.push(`<!--]--></div>`);
            } else {
              $$renderer3.push("<!--[!-->");
            }
            $$renderer3.push(`<!--]--> `);
            if (content.text) {
              $$renderer3.push("<!--[-->");
              $$renderer3.push(`<div class="pb-3 border-top-0 border-left-0 border-right-0 ap-post-content__p">${escape_html(content.text)}</div>`);
            } else {
              $$renderer3.push("<!--[!-->");
            }
            $$renderer3.push(`<!--]-->`);
          },
          $$slots: { default: true }
        });
        $$renderer2.push(`<!----> `);
        CardBody($$renderer2, {
          class: "border-top border-bottom py-0 ap-main-post__reaction",
          children: ($$renderer3) => {
            $$renderer3.push(`<div class="d-flex align-items-center demo-h-spacing ap-post-content__feedback"><a href="#" class="d-inline-flex align-items-center"><img class="svg" alt="" src="/img/svg/thumbs-up.svg"/> ${escape_html(content.like)}</a> <a href="#" class="d-inline-flex align-items-center"><img class="svg" alt="" src="/img/svg/message-square.svg"/> ${escape_html(content.comment.length)}</a> <a href="#" class="d-inline-flex align-items-center"><img class="svg" alt="" src="/img/svg/share-2.svg"/> Share</a></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer2.push(`<!----> `);
        CardBody($$renderer2, {
          class: "px-sm-25 py-20 ap-main-post__footer",
          children: ($$renderer3) => {
            $$renderer3.push(`<div class="ap-post-content-comment"><div class="pt-0 outline-0 pb-0 pe-0 ps-0 rounded-0 position-relative d-flex align-items-center" tabindex="-1"><span class="rounded-circle d-block position-absolute wh-36" style="background-image:url('/img/ap-author.png'); background-size: cover;"></span> <div class="d-flex justify-content-between align-items-center w-100"><div class="flex-1 d-flex align-items-center me-10 ap-post-content-comment__write"><input class="form-control border-0 p-0 bg-transparent pe-sm-0 pe-20" placeholder="This is my comment..."/> <div class="d-flex"><a href="#"><img class="svg" alt="" src="/img/svg/smile.svg"/></a> <a href="#"><img class="svg" alt="" src="/img/svg/image.svg"/></a> <a href="#"><img class="svg" alt="" src="/img/svg/paperclip.svg"/></a></div></div> `);
            Button($$renderer3, {
              color: "primary",
              class: "border-0 btn-primary wh-50 p-10 rounded-circle",
              children: ($$renderer4) => {
                $$renderer4.push(`<img class="svg" alt="" src="/img/svg/send.svg"/>`);
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!----></div></div></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer2.push(`<!----> `);
        if (content.comment.length > 0) {
          $$renderer2.push("<!--[-->");
          CardBody($$renderer2, {
            class: "pt-20 ap-main-post__comment",
            children: ($$renderer3) => {
              $$renderer3.push(`<!--[-->`);
              const each_array_3 = ensure_array_like(content.comment);
              for (let $$index_3 = 0, $$length2 = each_array_3.length; $$index_3 < $$length2; $$index_3++) {
                let comment = each_array_3[$$index_3];
                $$renderer3.push(`<div class="ap-post-cc-reply d-flex flex-column align-items-center"><div class="d-flex flex-row w-100"><div class="d-inline-block align-middle status status-sm status-success"><span class="profile-image bg-opacity-secondary profile-image-md rounded-circle d-block ms-0 wh-36 me-10"${attr_style(`background-image:url('/img/author/${stringify(comment.author)}'); background-size: cover;`)}></span></div> <div class="mb-0 flex-1 text-dark"><div class="cbg-light radius-xl py-10 px-10"><div class="d-flex ap-post-content__title"><a href="#" class="fw-500"><h6>${escape_html(comment.from)}</h6></a></div> <p class="mb-0 mt-10 text-gray">${escape_html(comment.text)}</p></div> <ul class="mb-0 d-flex ap-post-cc-reply__reaction"><li class="#"><a href="#">Like</a></li> <li class="#"><a href="#">reply</a></li> <li class="#"><span>5 months ago</span></li></ul> `);
                if (comment.reply) {
                  $$renderer3.push("<!--[-->");
                  $$renderer3.push(`<!--[-->`);
                  const each_array_4 = ensure_array_like(comment.reply);
                  for (let $$index_2 = 0, $$length3 = each_array_4.length; $$index_2 < $$length3; $$index_2++) {
                    let reply = each_array_4[$$index_2];
                    $$renderer3.push(`<div class="ap-post-cc-reply__reply ps-0 d-flex flex-row w-100 pb-0"><div class="d-inline-block align-middle status status-sm status-success"><span class="profile-image bg-opacity-secondary profile-image-md rounded-circle d-block ms-0 wh-36 me-10"${attr_style(`background-image:url('/img/author/${stringify(reply.author)}'); background-size: cover;`)}></span></div> <div class="mb-0 flex-1 text-dark"><div class="cbg-light radius-xl py-10 px-10"><div class="d-flex ap-post-content__title"><a href="#" class="fw-500"><h6>${escape_html(reply.from)}</h6></a></div> <p class="mb-0 mt-10 text-gray">${escape_html(reply.text)}</p></div> <ul class="mb-0 d-flex ap-post-cc-reply__reaction"><li class="#"><a href="#">Like</a></li> <li class="#"><a href="#" class="color-primary">reply</a></li> <li class="#"><span>5 months ago</span></li></ul></div></div>`);
                  }
                  $$renderer3.push(`<!--]-->`);
                } else {
                  $$renderer3.push("<!--[!-->");
                }
                $$renderer3.push(`<!--]--></div></div></div>`);
              }
              $$renderer3.push(`<!--]--> <div class="ap-post-cc-reply mt-20"><div class="pt-0 outline-0 pb-0 pe-0 ps-0 rounded-0 position-relative d-flex align-items-center" tabindex="-1"><div class="d-flex justify-content-between align-items-center w-100"><div class="flex-1 d-flex align-items-center me-10 ap-post-content-comment__write"><input class="form-control border-0 p-0 bg-transparent pe-sm-0 pe-20" placeholder="This is my comment..."/> <div class="d-flex"><a href="#"><img class="svg" alt="" src="/img/svg/smile.svg"/></a> <a href="#"><img class="svg" alt="" src="/img/svg/image.svg"/></a> <a href="#"><img class="svg" alt="" src="/img/svg/paperclip.svg"/></a></div></div> `);
              Button($$renderer3, {
                color: "primary",
                class: "border-0 btn-primary wh-50 p-10 rounded-circle",
                children: ($$renderer4) => {
                  $$renderer4.push(`<img class="svg" alt="" src="/img/svg/send.svg"/>`);
                },
                $$slots: { default: true }
              });
              $$renderer3.push(`<!----></div></div></div> <a class="view-more-comment color-primary fs-13 fw-500" href="#">View 53 more comments</a>`);
            },
            $$slots: { default: true }
          });
        } else {
          $$renderer2.push("<!--[!-->");
        }
        $$renderer2.push(`<!--]-->`);
      },
      $$slots: { default: true }
    });
  }
  $$renderer.push(`<!--]--></div>`);
}
function Friends($$renderer) {
  const friends = [
    {
      img: "1.jpg",
      name: "Shawn Mare",
      label: "UI Designer",
      following: false
    },
    {
      img: "2.jpg",
      name: "Aron Ramsy",
      label: "Product Designer",
      following: false
    },
    {
      img: "3.jpg",
      name: "Phil Jones",
      label: "Executive Assistant",
      following: true
    },
    {
      img: "4.jpg",
      name: "Tony Stak",
      label: "Backend Developer",
      following: false
    },
    {
      img: "1.jpg",
      name: "Tohin Molla",
      label: "Support Engineer",
      following: true
    }
  ];
  Card($$renderer, {
    class: "global-shadow mb-25",
    children: ($$renderer2) => {
      $$renderer2.push(`<div class="friends-widget">`);
      CardHeader($$renderer2, {
        class: "px-md-25 px-3",
        children: ($$renderer3) => {
          $$renderer3.push(`<h6>Friends</h6>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        class: "p-0",
        children: ($$renderer3) => {
          $$renderer3.push(`<!--[-->`);
          const each_array = ensure_array_like(friends);
          for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
            let friend = each_array[$$index];
            $$renderer3.push(`<div class="ffw d-flex justify-content-between"><div class="d-flex flex-wrap"><div class="me-3 ffw__imgWrapper"><span class="profile-image bg-opacity-secondary rounded-circle d-block ap-profile-image"${attr_style(`background-image:url('/img/author/${stringify(friend.img)}'); background-size: cover;`)}></span></div> <div class="ffw__title"><a href="#" class="text-dark fw-500"><h6>${escape_html(friend.name)}</h6></a> <span class="d-block">${escape_html(friend.label)}</span></div></div> <div>`);
            Button($$renderer3, {
              color: friend.following ? "primary" : "light",
              size: "default",
              outline: !friend.following ? true : false,
              class: `btn-squared ${stringify(!friend.following ? "friends-follow" : "friends-unfollow")}`,
              children: ($$renderer4) => {
                $$renderer4.push(`<!---->${escape_html(friend.following ? "Unfollow" : "Follow")}`);
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!----></div></div>`);
          }
          $$renderer3.push(`<!--]--> <a class="view-more-comment color-primary fs-13 fw-500 px-25 pb-20" href="#">Load more friends</a>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----></div>`);
    },
    $$slots: { default: true }
  });
}
function Photos($$renderer) {
  const images = ["315.png", "325.png", "design.png", "99.png", "166.png"];
  Card($$renderer, {
    class: "global-shadow mb-25",
    children: ($$renderer2) => {
      $$renderer2.push(`<div class="photo-gallery-widget">`);
      CardHeader($$renderer2, {
        class: "justify-content-between d-flex flex-wrap px-md-25 px-3",
        children: ($$renderer3) => {
          $$renderer3.push(`<h6>photos</h6> <a class="color-primary fs-13 fw-500 mt-lg-0 mt-1" href="#">see all</a>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="wig"><!--[-->`);
          const each_array = ensure_array_like(images);
          for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
            let image = each_array[$$index];
            $$renderer3.push(`<div class="wig__item"><img${attr("src", `/img/${stringify(image)}`)} alt="gallery"/></div>`);
          }
          $$renderer3.push(`<!--]--></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----></div>`);
    },
    $$slots: { default: true }
  });
}
function Videos($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const videos = [
      { thumb: "juice-2.png" },
      { thumb: "cup-card.png" },
      { thumb: "round-box.png" },
      { thumb: "glass.png" },
      { thumb: "bottles.png" },
      { thumb: "325.png" }
    ];
    Card($$renderer2, {
      class: "global-shadow mb-25",
      children: ($$renderer3) => {
        $$renderer3.push(`<div class="video-gallery-widget">`);
        CardHeader($$renderer3, {
          class: "justify-content-between d-flex flex-wrap px-md-25 px-3",
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>videos</h6> <a class="color-primary fs-13 fw-500 mt-lg-0 mt-1" href="#">see all</a>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="wig"><!--[-->`);
            const each_array = ensure_array_like(videos);
            for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
              let video = each_array[$$index];
              $$renderer4.push(`<div class="wig__item wig-overlay"><img${attr("src", `/img/${stringify(video.thumb)}`)} alt="gallery"/> <div class="wig-overlay__content"><a class="wig-overlay__iconWrapper popup-youtube" href="https://www.youtube.com/embed/6gYk-3MEY1g"${attr("data-thumb", `/img/${stringify(video.thumb)}`)} data-iframe="https://www.youtube.com/embed/6gYk-3MEY1g?autoplay=1&amp;playsinline=1"><img class="svg" alt="" src="/img/svg/play.svg"/></a></div></div>`);
            }
            $$renderer4.push(`<!--]--></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----></div>`);
      },
      $$slots: { default: true }
    });
  });
}
function Timeline($$renderer) {
  Row($$renderer, {
    children: ($$renderer2) => {
      Col($$renderer2, {
        xxl: 8,
        children: ($$renderer3) => {
          PostForm($$renderer3);
          $$renderer3.push(`<!----> `);
          Posts($$renderer3);
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      Col($$renderer2, {
        xxl: 4,
        children: ($$renderer3) => {
          Friends($$renderer3);
          $$renderer3.push(`<!----> `);
          Photos($$renderer3);
          $$renderer3.push(`<!----> `);
          Videos($$renderer3);
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
}
function Activities($$renderer) {
  const activites = [
    {
      icon: "inbox.svg",
      type: "primary",
      author: "James",
      authorImg: "1.jpg",
      content: "sent you a message",
      time: "16 mins ago"
    },
    {
      icon: "upload.svg",
      type: "secondary",
      authorImg: "2.jpg",
      author: "Mumtahin",
      content: "has registered",
      time: "45 mins ago"
    },
    {
      icon: "log-in.svg",
      type: "info",
      authorImg: "3.jpg",
      author: "Adam",
      content: "upload website template for sale",
      time: "1 hours ago"
    },
    {
      icon: "at-sign.svg",
      type: "success",
      authorImg: "4.jpg",
      author: "James",
      content: "mentioned you in a post",
      time: "2 hours ago"
    },
    {
      icon: "heart.svg",
      type: "danger",
      authorImg: "1.jpg",
      author: "Kerry",
      content: "Liked your photos",
      time: "3 hours ago"
    },
    {
      icon: "message-square.svg",
      type: "warning",
      authorImg: "2.jpg",
      author: "Fizz",
      content: "sent you a message",
      time: "4 hours ago"
    },
    {
      icon: "upload.svg",
      type: "secondary",
      authorImg: "3.jpg",
      author: "Aron",
      content: "uploaded a photo",
      time: "6 hours ago"
    },
    {
      icon: "log-in.svg",
      type: "info",
      authorImg: "4.jpg",
      author: "Ramsy",
      content: "has registered",
      time: "7 hours ago"
    },
    {
      icon: "at-sign.svg",
      type: "success",
      authorImg: "1.jpg",
      author: "Tony",
      content: "mentioned you in a comment",
      time: "8 hours ago"
    },
    {
      icon: "heart.svg",
      type: "danger",
      authorImg: "2.jpg",
      author: "Steve",
      content: "Liked your comment",
      time: "8 hours ago"
    },
    {
      icon: "message-square.svg",
      type: "warning",
      authorImg: "3.jpg",
      author: "Bucky",
      content: "sent you a message",
      time: "9 hours ago"
    },
    {
      icon: "upload.svg",
      type: "secondary",
      authorImg: "4.jpg",
      author: "Morgan",
      content: "upload website template for sale",
      time: "10 hours ago"
    }
  ];
  Card($$renderer, {
    class: "global-shadow mb-25",
    children: ($$renderer2) => {
      $$renderer2.push(`<div class="friends-widget">`);
      CardHeader($$renderer2, {
        class: "px-md-25 px-3",
        children: ($$renderer3) => {
          $$renderer3.push(`<h6>Activities</h6>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        class: "p-0 py-10",
        children: ($$renderer3) => {
          $$renderer3.push(`<!--[-->`);
          const each_array = ensure_array_like(activites);
          for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
            let item = each_array[$$index];
            $$renderer3.push(`<div class="ffp d-flex ffp--hover justify-content-between align-items-center w-100"><div class="d-flex"><div class="me-3 ffp__imgWrapper d-flex align-items-center"><span${attr_class(`ffp__icon color-${stringify(item.type)} bg-opacity-${stringify(item.type)}`)}><img class="svg" alt=""${attr("src", `/img/svg/${item.icon}`)}/></span> <span${attr_class(`profile-image bg-opacity-${stringify(item.type)} rounded-circle d-block avatar avatar-md m-0 `)}${attr_style(`background-image:url('/img/author/${stringify(item.authorImg)}'); background-size: cover;`)}></span></div> <div class="ffp__title"><a href="#" class="text-dark fw-500"><h6><span class="color-primary">${escape_html(item.author)}</span> ${escape_html(item.content)}</h6></a> <p class="d-block">${escape_html(item.time)}</p></div></div> <div class="ffp__button">`);
            CardExtra($$renderer3);
            $$renderer3.push(`<!----></div></div>`);
          }
          $$renderer3.push(`<!--]-->`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----></div>`);
    },
    $$slots: { default: true }
  });
}
function Activity($$renderer) {
  Row($$renderer, {
    children: ($$renderer2) => {
      Col($$renderer2, {
        xl: 8,
        children: ($$renderer3) => {
          Activities($$renderer3);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      Col($$renderer2, {
        xl: 4,
        children: ($$renderer3) => {
          Friends($$renderer3);
          $$renderer3.push(`<!----> `);
          Photos($$renderer3);
          $$renderer3.push(`<!----> `);
          Videos($$renderer3);
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
}
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const breadcrumbData = {
      pageTitle: "My Profile",
      bcItem: "Home",
      bcItem2: "Apps",
      bcItemActive: "Social"
    };
    const socialTabs = [Overview, Timeline, Activity];
    let activeTab = socialTabs.indexOf(Overview);
    head("1hcqtyo", $$renderer2, ($$renderer3) => {
      $$renderer3.title(($$renderer4) => {
        $$renderer4.push(`<title>My Profile</title>`);
      });
    });
    $$renderer2.push(`<div class="component-page mb-25">`);
    Container($$renderer2, {
      fluid: true,
      children: ($$renderer3) => {
        Row($$renderer3, {
          children: ($$renderer4) => {
            Col($$renderer4, {
              lg: 12,
              children: ($$renderer5) => {
                BreadcrumbOne($$renderer5, spread_props([breadcrumbData]));
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 3,
              md: 4,
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="profile-sider">`);
                ProfileCard($$renderer5);
                $$renderer5.push(`<!----> `);
                UserBio($$renderer5);
                $$renderer5.push(`<!----></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              xxl: 9,
              md: 8,
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="ap-tab ap-tab-header mb-25"><div class="ap-tab-header__img"><img src="/img/ap-header.png" alt="ap-header" class="img-fluid w-100"/> <div class="ap-cover__changeImgBtn">`);
                Button($$renderer5, {
                  color: "light",
                  outline: true,
                  class: "change-cover cover-btn",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<img class="svg" alt="" src="/img/svg/camera.svg"/> Change Cover`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----></div></div> <div class="ap-tab-wrapper"><ul class="nav px-25 ap-tab-main"><li class="nav-item"><a class="nav-link active" data-type="overview" href="#">Overview</a></li> <li class="nav-item"><a class="nav-link" data-type="timeline" href="#">Timeline</a></li> <li class="nav-item"><a class="nav-link" data-type="activity" href="#">Activity</a></li></ul></div></div> `);
                $$renderer5.push("<!---->");
                socialTabs[activeTab]?.($$renderer5, {});
                $$renderer5.push(`<!---->`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></div>`);
  });
}
export {
  _page as default
};
