import { ag as ensure_array_like, aa as escape_html, ad as attr_class, ae as stringify, ac as attr, a2 as head } from "../../../../../../chunks/index2.js";
import "clsx";
import { B as Button } from "../../../../../../chunks/Button.js";
import { R as Row, a as Col, C as Container } from "../../../../../../chunks/Row.js";
import "../../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { C as Card } from "../../../../../../chunks/Card.js";
import { C as CardBody } from "../../../../../../chunks/CardBody.js";
import { C as CardHeader } from "../../../../../../chunks/CardHeader.js";
import { P as Progress } from "../../../../../../chunks/Progress.js";
import { D as Dropdown, a as DropdownToggle, b as DropdownMenu } from "../../../../../../chunks/DropdownToggle.js";
import { D as DropdownItem } from "../../../../../../chunks/DropdownItem.js";
import { T as TaskApp } from "../../../../../../chunks/TaskApp.js";
function Activities($$renderer) {
  const activities = [
    {
      day: "22",
      month: "December",
      tasks: [
        {
          icon: "plus",
          style: "primary",
          userImg: "tm1.png",
          userName: "Mumtahin",
          taskType: "added new task",
          taskLink: "Dashboard Project",
          time: "3:30 PM"
        },
        {
          icon: "arrow",
          style: "secondary",
          userImg: "tm2.png",
          userName: "Mike Green",
          taskType: "pushed commit",
          taskLink: "#656723",
          time: "9:30 PM"
        },
        {
          icon: "check",
          style: "success",
          userImg: "tm3.png",
          userName: "L. Tomlinson",
          taskType: "completed task",
          taskLink: "Invoice template",
          time: "10:00 PM"
        }
      ]
    },
    {
      day: "21",
      month: "December",
      tasks: [
        {
          icon: "user-plus",
          style: "primary",
          userImg: "tm4.png",
          userName: "Andrew Tat",
          taskType: "added new task",
          taskLink: "Plugin Development",
          time: "4:16 PM"
        },
        {
          icon: "arrow",
          style: "warning",
          userImg: "tm5.png",
          userName: "Mark Hessen",
          taskType: "created an event",
          taskLink: "Yearly Meetup",
          time: "5:01 PM"
        },
        {
          icon: "upload",
          style: "info",
          userImg: "tm6.png",
          userName: "Erik Englas",
          taskType: "uploded a file",
          taskLink: "Project Files",
          time: "5:46 PM"
        }
      ]
    }
  ];
  $$renderer.push(`<div id="project-timeline"><!--[-->`);
  const each_array = ensure_array_like(activities);
  for (let $$index_1 = 0, $$length = each_array.length; $$index_1 < $$length; $$index_1++) {
    let activity = each_array[$$index_1];
    CardBody($$renderer, {
      class: "px-0 mx-25 activity-card",
      children: ($$renderer2) => {
        $$renderer2.push(`<div class="task-activities d-flex align-items-center"><div class="task-activities__left d-flex"><div class="content-center border bg-normal radius-xl me-sm-20 me-0 task-activities__month"><div class="px-20 text-center"><h5>${escape_html(activity.day)}</h5> <span class="fs-13 color-gray">${escape_html(activity.month)}</span></div></div> <div class="task-activities__right"><ul><!--[-->`);
        const each_array_1 = ensure_array_like(activity.tasks);
        for (let $$index = 0, $$length2 = each_array_1.length; $$index < $$length2; $$index++) {
          let task = each_array_1[$$index];
          $$renderer2.push(`<li><div class="ffp d-flex justify-content-between align-items-center w-100"><div class="d-flex"><div class="me-3 ffp__imgWrapper d-flex align-items-center"><span${attr_class(`wh-24 me-15 rounded-circle content-center color-${stringify(task.style)} bg-opacity-${stringify(task.style)}`)}><i${attr_class(`uil uil-${stringify(task.icon)}`)}></i></span> <span class="profile-image rounded-circle d-block wh-34 m-0"><img${attr("src", `/img/${stringify(task.userImg)}`)} alt="" class="img-fluid"/></span></div> <div><a href="#"><p class="fw-500 fs-14 text-dark mb-0">${escape_html(task.userName)} <span class="color-light mx-1 fw-400">${escape_html(task.taskType)}</span>${escape_html(task.taskLink)}</p></a> <span class="pt-1 d-block color-extra-light fs-12">${escape_html(task.time)}</span></div></div></div></li>`);
        }
        $$renderer2.push(`<!--]--></ul></div></div></div>`);
      },
      $$slots: { default: true }
    });
  }
  $$renderer.push(`<!--]--></div>`);
}
function Summary($$renderer) {
  const summaryCard = [
    {
      icon: "at.svg",
      total: "47",
      label: "Total Task",
      type: "primary"
    },
    {
      icon: "at2.svg",
      total: "34",
      label: "Task Completed",
      type: "secondary"
    },
    {
      icon: "at4.svg",
      total: "$27,500",
      label: "Spendings",
      type: "success"
    },
    {
      icon: "at3.svg",
      total: "250",
      label: "Hours Spent",
      type: "warning"
    }
  ];
  Card($$renderer, {
    class: "mt-25",
    children: ($$renderer2) => {
      CardBody($$renderer2, {
        children: ($$renderer3) => {
          $$renderer3.push(`<!--[-->`);
          const each_array = ensure_array_like(summaryCard);
          for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
            let item = each_array[$$index];
            $$renderer3.push(`<div class="application-task d-flex align-items-center mb-25"><div${attr_class(`application-task-icon wh-60 bg-opacity-${stringify(item.type)} content-center`)}><img${attr_class(`svg wh-25 text-${stringify(item.type)}`)} alt=""${attr("src", `/img/svg/${item.icon}`)}/></div> <div class="application-task-content"><h4>${escape_html(item.total)}</h4> <span class="text-light fs-14 mt-1 text-capitalize">${escape_html(item.label)}</span></div></div>`);
          }
          $$renderer3.push(`<!--]-->`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
}
function Users($$renderer) {
  const users = [
    { img: "tm1.png", name: "Jhon Meyer", role: "App Developer" },
    {
      img: "tm2.png",
      name: "Trent Bolt",
      role: "Software Engineer"
    },
    { img: "tm3.png", name: "Neil Nam", role: "UI/UX Developer" },
    {
      img: "tm4.png",
      name: "Orlando Floom",
      role: "Forntend Engineer"
    },
    { img: "tm5.png", name: "Erik Herz", role: "Project Manager" }
  ];
  Card($$renderer, {
    class: "h-100",
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        class: "d-flex justify-content-between align-items-center py-10 px-sm-25 px-3",
        children: ($$renderer3) => {
          $$renderer3.push(`<h6 class="fw-500">users</h6> `);
          Button($$renderer3, {
            color: "transparent",
            class: "border radius-lg color-primary fw-500 fs-12 bg-transparent acButton",
            children: ($$renderer4) => {
              $$renderer4.push(`<img class="svg" alt="" src="/img/svg/user-plus.svg"/> add user`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        children: ($$renderer3) => {
          $$renderer3.push(`<!--[-->`);
          const each_array = ensure_array_like(users);
          for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
            let user = each_array[$$index];
            $$renderer3.push(`<div class="d-flex align-items-center mb-25"><img${attr("src", `/img/${stringify(user.img)}`)} class="wh-46 me-15" alt="img"/> <div><p class="fs-14 fw-600 color-dark mb-0">${escape_html(user.name)}</p> <span class="mt-1 fs-14 color-light">${escape_html(user.role)}</span></div></div>`);
          }
          $$renderer3.push(`<!--]-->`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
}
function Files($$renderer) {
  const files = [
    {
      icon: "zip@2x.png",
      name: "Main-Admin-Design.Zip",
      size: "7.09 MB"
    },
    {
      icon: "pdf@2x.png",
      name: "Product-Guidelines.Pdf",
      size: "1.29 MB"
    },
    {
      icon: "psd@2x.png",
      name: "Admin-Wireframe.Psd",
      size: "7.01 MB"
    },
    {
      icon: "jpg@2x.png",
      name: "Wirefram-Escreenshots.Jpg",
      size: "1.67 MB"
    },
    { icon: "png@2x.png", name: "Logo.Png", size: "145 KB" }
  ];
  Card($$renderer, {
    class: "pb-10 border-0 h-100",
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        class: "py-20 px-sm-25 px-3 ",
        children: ($$renderer3) => {
          $$renderer3.push(`<h6>Files</h6>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        children: ($$renderer3) => {
          $$renderer3.push(`<!--[-->`);
          const each_array = ensure_array_like(files);
          for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
            let file = each_array[$$index];
            $$renderer3.push(`<div class="mb-20"><div class="files-area d-flex justify-content-between align-items-center"><div class="files-area__left d-flex align-items-center"><div class="files-area__img"><img${attr("src", `/img/${stringify(file.icon)}`)} alt="img" class="wh-42"/></div> <div class="files-area__title"><p class="mb-0 fs-14 fw-500 color-dark text-capitalize">${escape_html(file.name)}</p> <span class="color-light fs-12 d-flex">${escape_html(file.size)}</span> <div class="d-flex text-capitalize"><a href="#" class="fs-12 fw-500 color-primary">View</a> <a href="#" class="fs-12 fw-500 color-primary ms-10">Download</a></div></div></div> <div class="files-area__right">`);
            Dropdown($$renderer3, {
              children: ($$renderer4) => {
                DropdownToggle($$renderer4, {
                  color: "white m-0 p-0 shadow-none bg-transparent",
                  children: ($$renderer5) => {
                    $$renderer5.push(`<img data-inlinesvg="" class="m-0" src="/img/svg/more-horizontal.svg"/>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer4.push(`<!----> `);
                DropdownMenu($$renderer4, {
                  children: ($$renderer5) => {
                    DropdownItem($$renderer5, {
                      children: ($$renderer6) => {
                        $$renderer6.push(`<!---->View`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer5.push(`<!----> `);
                    DropdownItem($$renderer5, {
                      children: ($$renderer6) => {
                        $$renderer6.push(`<!---->Edit`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer5.push(`<!----> `);
                    DropdownItem($$renderer5, {
                      children: ($$renderer6) => {
                        $$renderer6.push(`<!---->Delete`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer5.push(`<!---->`);
                  },
                  $$slots: { default: true }
                });
                $$renderer4.push(`<!---->`);
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!----></div></div></div>`);
          }
          $$renderer3.push(`<!--]-->`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
}
function Task($$renderer) {
  let taskTab = "all";
  let actionBtn = true;
  TaskApp($$renderer, {
    header: "",
    description: false,
    taskStatus: taskTab,
    taskLimit: "8",
    actionBtn
  });
}
function ProjectSingle($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const projectTabs = [Task, Activities];
    let activeTab = projectTabs.indexOf(Task);
    $$renderer2.push(`<div class="projects-tab-content mb-30">`);
    Row($$renderer2, {
      children: ($$renderer3) => {
        Col($$renderer3, {
          xxl: 3,
          xl: 6,
          class: "mb-25",
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="progress-box px-25 pt-25 pb-10 bg-success radius-xl"><div class="d-flex justify-content-between mb-3"><h6 class="text-white fw-500 fs-16 text-capitalize">progress</h6> <span class="progress-percentage text-white fw-500 fs-16 text-capitalize">64%</span></div> <div class="progress-wrap d-flex align-items-center mb-15"><div class="progress progress-height" style="width: 100%; height: 6px;">`);
            Progress($$renderer4, { bar: true, color: "white", value: 64 });
            $$renderer4.push(`<!----></div></div></div> `);
            Summary($$renderer4);
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        Col($$renderer3, {
          xxl: 6,
          class: "mb-25",
          children: ($$renderer4) => {
            Card($$renderer4, {
              class: "border-0 pb-md-50 pb-15 h-100",
              children: ($$renderer5) => {
                CardHeader($$renderer5, {
                  class: "py-sm-20 py-3 px-sm-25 px-3",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<h6>About Project</h6>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                CardBody($$renderer5, {
                  children: ($$renderer6) => {
                    $$renderer6.push(`<div class="about-projects"><div class="about-projects__details"><p class="fs-15 mb-25">Many support queries and technical questions will already be answered in supporting
								documentation such as FAQ's and comments from previous buyers. Anim pariatur cliche
								reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf
								moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt
								laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid
								single-origin coffee nulla assumenda shoreditch.</p> <p class="fs-15">Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry
								richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor
								brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor</p></div> <ul class="d-flex text-capitalize"><li><span class="color-light fs-13">Project owner</span> <p class="color-dark fs-14 mt-1 mb-0 fw-500">Peter Jackson</p></li> <li><span class="color-light fs-13">Budget</span> <p class="color-dark fs-14 mt-1 mb-0 fw-500">$56,700</p></li> <li><span class="color-light fs-13">Start Date</span> <p class="color-primary fs-14 mt-1 mb-0 fw-500">26 Dec 2019</p></li> <li><span class="color-light fs-13">Deadline</span> <p class="color-danger fs-14 mt-1 mb-0 fw-500">18 Mar 2020</p></li></ul></div>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!---->`);
              },
              $$slots: { default: true }
            });
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        Col($$renderer3, {
          xxl: 3,
          xl: 5,
          class: "mb-25",
          children: ($$renderer4) => {
            Users($$renderer4);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        Col($$renderer3, {
          xxl: 8,
          xl: 7,
          class: "mb-25",
          children: ($$renderer4) => {
            Card($$renderer4, {
              children: ($$renderer5) => {
                CardHeader($$renderer5, {
                  class: "p-0",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<ul class="nav px-25 ap-tab-main app-ui-tab" id="project-ap-tab"><li class="nav-item"><a class="nav-link active" id="project-overview-tab" href="#" data-type="task-app">task list</a></li> <li class="nav-item"><a class="nav-link" id="project-timeline-tab" href="#" data-type="activities">Activities</a></li></ul>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> <div class="w-100" id="projectContent">`);
                $$renderer5.push("<!---->");
                projectTabs[activeTab]?.($$renderer5, {});
                $$renderer5.push(`<!----></div>`);
              },
              $$slots: { default: true }
            });
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        Col($$renderer3, {
          xxl: 4,
          xl: 6,
          class: "mb-25 files-order-n1",
          children: ($$renderer4) => {
            Files($$renderer4);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></div>`);
  });
}
function _page($$renderer) {
  head("9fvxxm", $$renderer, ($$renderer2) => {
    $$renderer2.title(($$renderer3) => {
      $$renderer3.push(`<title>Projects Details</title>`);
    });
  });
  $$renderer.push(`<div class="component-page mb-25">`);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              $$renderer4.push(`<div class="breadcrumb-main application-ui mb-30"><div class="breadcrumb-action d-flex"><div class="d-flex align-items-center user-member__title me-sm-25 me-0"><h4 class="text-capitalize fw-500 breadcrumb-title">Application UI Design</h4></div> <div class="action-btn me-10 my-sm-0">`);
              Button($$renderer4, {
                color: "primary",
                class: "fs-12 fw-500",
                children: ($$renderer5) => {
                  $$renderer5.push(`<img class="svg" alt="" src="/img/svg/plus.svg"/> Add task`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----></div> <div class="btn-group-toggle" data-bs-toggle="buttons"><input type="checkbox" class="btn-check" id="btn-check-2-outlined"/> <label class="btn btn-outline-secondary" for="btn-check-2-outlined"><img class="svg" alt="" src="/img/svg/check.svg"/> Mark as Complete</label></div></div> <div class="d-flex text-capitalize">`);
              Button($$renderer4, {
                color: "white",
                class: "breadcrumb-edit border-0 color-primary content-center fs-12 fw-500 radius-md",
                children: ($$renderer5) => {
                  $$renderer5.push(`<img class="svg" alt="" src="/img/svg/edit-3.svg"/>edit`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              Button($$renderer4, {
                class: "breadcrumb-remove border-0 color-danger content-center bg-white fs-12 fw-500 ms-10 radius-md",
                children: ($$renderer5) => {
                  $$renderer5.push(`<img class="svg" alt="" src="/img/svg/trash-2.svg"/>remove`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----></div></div>`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              ProjectSingle($$renderer4);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
export {
  _page as default
};
