import { a6 as fallback, ag as ensure_array_like, aa as escape_html, ad as attr_class, ae as stringify, ac as attr, a9 as bind_props, a2 as head } from "../../../../../../chunks/index2.js";
import { B as Button } from "../../../../../../chunks/Button.js";
import { a as Col, R as Row, C as Container } from "../../../../../../chunks/Row.js";
import { F as Form } from "../../../../../../chunks/Form.js";
import { F as FormGroup } from "../../../../../../chunks/FormGroup.js";
import { I as Input } from "../../../../../../chunks/Input.js";
import { L as Label } from "../../../../../../chunks/Label.js";
import { M as Modal, a as ModalBody } from "../../../../../../chunks/Modal.js";
import { M as ModalHeader } from "../../../../../../chunks/ModalHeader.js";
import "../../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { D as DatePicker } from "../../../../../../chunks/DatePicker.js";
import { D as Dropdown, a as DropdownToggle, b as DropdownMenu } from "../../../../../../chunks/DropdownToggle.js";
import { D as DropdownItem } from "../../../../../../chunks/DropdownItem.js";
import { P as Progress } from "../../../../../../chunks/Progress.js";
import { P as PaginationBasic } from "../../../../../../chunks/PaginationBasic2.js";
const projects = [
  {
    progress: [
      {
        title: "Custom Software Project",
        status: "progress",
        content: "Lorem Ipsum Dolor Amet, Consetetur Sadipscing Elitr Sed Diam Nonumy Eirmod Dolor Ame.",
        category: "Web Development",
        badge: "warning",
        assignedTo: [
          "tm1.png",
          "tm2.png",
          "tm3.png"
        ],
        percentage: 38
      },
      {
        title: "Develop Component Library",
        status: "progress",
        content: "Lorem Ipsum Dolor Amet, Consetetur Sadipscing Elitr Sed Diam Nonumy Eirmod Dolor Ame.",
        category: "Web Development",
        badge: "warning",
        assignedTo: [
          "tm4.png",
          "tm5.png",
          "tm6.png",
          "tm7.png",
          "tm8.png"
        ],
        percentage: 96
      },
      {
        title: "R&D on Application UI/UX",
        status: "progress",
        content: "Lorem Ipsum Dolor Amet, Consetetur Sadipscing Elitr Sed Diam Nonumy Eirmod Dolor Ame.",
        category: "Web Development",
        badge: "warning",
        assignedTo: [
          "tm1.png",
          "tm6.png"
        ],
        percentage: 42
      },
      {
        title: "Dashboard UI Project",
        status: "progress",
        content: "Lorem Ipsum Dolor Amet, Consetetur Sadipscing Elitr Sed Diam Nonumy Eirmod Dolor Ame.",
        category: "Web Development",
        badge: "warning",
        assignedTo: [
          "tm1.png",
          "tm2.png",
          "tm3.png",
          "tm4.png",
          "tm5.png"
        ],
        percentage: 63
      }
    ],
    completed: [
      {
        title: "Realtime Test API Develop",
        status: "completed",
        content: "Lorem Ipsum Dolor Amet, Consetetur Sadipscing Elitr Sed Diam Nonumy Eirmod Dolor Ame.",
        category: "Graphic Design",
        badge: "success",
        assignedTo: [
          "tm5.png",
          "tm6.png",
          "tm7.png",
          "tm8.png"
        ],
        percentage: 73
      },
      {
        title: "Support Dashboard Task",
        status: "completed",
        content: "Lorem Ipsum Dolor Amet, Consetetur Sadipscing Elitr Sed Diam Nonumy Eirmod Dolor Ame.",
        category: "Graphic Design",
        badge: "success",
        assignedTo: [
          "tm1.png",
          "tm2.png"
        ],
        percentage: 53
      }
    ],
    late: [
      {
        title: "Develop Website Builder",
        status: "late",
        content: "Lorem Ipsum Dolor Amet, Consetetur Sadipscing Elitr Sed Diam Nonumy Eirmod Dolor Ame.",
        category: "Web Development",
        badge: "danger",
        assignedTo: [
          "tm1.png",
          "tm2.png",
          "tm7.png",
          "tm8.png"
        ],
        percentage: 29
      },
      {
        title: "Create App for Client",
        status: "late",
        content: "Lorem Ipsum Dolor Amet, Consetetur Sadipscing Elitr Sed Diam Nonumy Eirmod Dolor Ame.",
        category: "Web Development",
        badge: "danger",
        assignedTo: [
          "tm1.png",
          "tm2.png",
          "tm3.png"
        ],
        percentage: 82
      }
    ],
    early: [
      {
        title: "Run Prmotion Campaign",
        status: "early",
        content: "Lorem Ipsum Dolor Amet, Consetetur Sadipscing Elitr Sed Diam Nonumy Eirmod Dolor Ame.",
        category: "Web Design",
        badge: "primary",
        assignedTo: [
          "tm1.png",
          "tm2.png",
          "tm3.png",
          "tm4.png"
        ],
        percentage: 85
      },
      {
        title: "New Application Architechture",
        status: "early",
        content: "Lorem Ipsum Dolor Amet, Consetetur Sadipscing Elitr Sed Diam Nonumy Eirmod Dolor Ame.",
        category: "Graphic Design",
        badge: "primary",
        assignedTo: [
          "tm7.png",
          "tm8.png"
        ],
        percentage: 46
      },
      {
        title: "Fix end-to-end Encryption",
        status: "early",
        content: "Lorem Ipsum Dolor Amet, Consetetur Sadipscing Elitr Sed Diam Nonumy Eirmod Dolor Ame.",
        category: "Graphic Design",
        badge: "primary",
        assignedTo: [
          "tm1.png",
          "tm2.png",
          "tm3.png"
        ],
        percentage: 36
      },
      {
        title: "Thirdparty Plugin Development",
        status: "early",
        content: "Lorem Ipsum Dolor Amet, Consetetur Sadipscing Elitr Sed Diam Nonumy Eirmod Dolor Ame.",
        category: "Web Design",
        badge: "primary",
        assignedTo: [
          "tm1.png",
          "tm5.png",
          "tm6.png",
          "tm7.png",
          "tm8.png"
        ],
        percentage: 33
      }
    ]
  }
];
function ProjectGrid($$renderer, $$props) {
  const projectsArr = Object.assign([], ...projects);
  const allProjects = [
    ...projectsArr.progress,
    ...projectsArr.completed,
    ...projectsArr.late,
    ...projectsArr.early
  ];
  let projectType = fallback($$props["projectType"], allProjects);
  Col($$renderer, {
    lg: 12,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          $$renderer3.push(`<!--[-->`);
          const each_array = ensure_array_like(projectType);
          for (let $$index_1 = 0, $$length = each_array.length; $$index_1 < $$length; $$index_1++) {
            let card = each_array[$$index_1];
            Col($$renderer3, {
              lg: 4,
              md: 6,
              class: "mb-25 project-card",
              "data-type": card.status,
              children: ($$renderer4) => {
                $$renderer4.push(`<div class="user-group radius-xl media-ui media-ui--early pt-30 pb-25"><div class="border-bottom px-30"><div class="media user-group-media d-flex justify-content-between"><div class="media-body d-flex align-items-center flex-wrap text-capitalize my-sm-0 my-n2"><a href="#"><h6 class="mt-0 fw-500 user-group media-ui__title bg-transparent">${escape_html(card.title)}</h6></a> <span${attr_class(`my-sm-0 my-2 media-badge text-uppercase color-white bg-${stringify(card.badge)}`)}>${escape_html(card.status)}</span></div> <div class="mt-n15">`);
                Dropdown($$renderer4, {
                  children: ($$renderer5) => {
                    DropdownToggle($$renderer5, {
                      color: "trasnparent p-0",
                      children: ($$renderer6) => {
                        $$renderer6.push(`<img class="svg" alt="" src="/img/svg/more-horizontal.svg"/>`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer5.push(`<!----> `);
                    DropdownMenu($$renderer5, {
                      children: ($$renderer6) => {
                        DropdownItem($$renderer6, {
                          children: ($$renderer7) => {
                            $$renderer7.push(`<!---->View`);
                          },
                          $$slots: { default: true }
                        });
                        $$renderer6.push(`<!----> `);
                        DropdownItem($$renderer6, {
                          children: ($$renderer7) => {
                            $$renderer7.push(`<!---->Edit`);
                          },
                          $$slots: { default: true }
                        });
                        $$renderer6.push(`<!----> `);
                        DropdownItem($$renderer6, {
                          children: ($$renderer7) => {
                            $$renderer7.push(`<!---->Delete`);
                          },
                          $$slots: { default: true }
                        });
                        $$renderer6.push(`<!---->`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer5.push(`<!---->`);
                  },
                  $$slots: { default: true }
                });
                $$renderer4.push(`<!----></div></div> <div class="user-group-people mt-15 text-capitalize"><p>${escape_html(card.content)}</p> <div class="user-group-project"><div class="d-flex align-items-center user-group-progress-top"><div class="media-ui__start"><span class="color-light fs-12">Start Date</span> <p class="fs-14 fw-500 color-dark mb-0">26 Dec 2019</p></div> <div class="media-ui__end"><span class="color-light fs-12">end date</span> <p class="fs-16 fw-500 color-success mb-0">18 Mar 2020</p></div></div></div></div> <div class="user-group-progress-bar"><div class="progress-wrap mb-0"><div class="progress-wrap d-flex align-items-center"><div class="progress" style="width: 100%; height: 6px;">`);
                Progress($$renderer4, { bar: true, color: card.badge, value: card.percentage });
                $$renderer4.push(`<!----></div> <span class="ratio-percentage">${escape_html(card.percentage)}%</span></div></div> <p class="color-light fs-12 mb-20">12 / 15 Tasks Completed</p></div></div> <div class="mt-20 px-30"><p class="fs-13 color-light mb-10">Assigned To</p> <ul class="d-flex flex-wrap user-group-people__parent"><!--[-->`);
                const each_array_1 = ensure_array_like(card.assignedTo);
                for (let $$index = 0, $$length2 = each_array_1.length; $$index < $$length2; $$index++) {
                  let user = each_array_1[$$index];
                  $$renderer4.push(`<li><a href="#"><img class="rounded-circle wh-34 bg-opacity-secondary"${attr("src", `/img/${stringify(user)}`)} alt="author"/></a></li>`);
                }
                $$renderer4.push(`<!--]--></ul></div></div>`);
              },
              $$slots: { default: true }
            });
          }
          $$renderer3.push(`<!--]-->`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  bind_props($$props, { projectType });
}
function ProjectList($$renderer, $$props) {
  const projectsArr = Object.assign([], ...projects);
  const allProjects = [
    ...projectsArr.progress,
    ...projectsArr.completed,
    ...projectsArr.late,
    ...projectsArr.early
  ];
  let projectType = fallback($$props["projectType"], allProjects);
  Col($$renderer, {
    lg: 12,
    children: ($$renderer2) => {
      $$renderer2.push(`<div class="projects-tab-content"><div class="tab-content mt-25" id="ap-tabContent"><div class="userDatatable projectDatatable project-table global-shadow border-0 p-30 bg-white radius-xl w-100"><div class="table-responsive"><table class="table mb-0"><thead><tr class="userDatatable-header"><th><span class="projectDatatable-title">project</span></th><th><span class="projectDatatable-title">start date</span></th><th><span class="projectDatatable-title">deadline</span></th><th><span class="projectDatatable-title">Assigned To</span></th><th><span class="projectDatatable-title">status</span></th><th><span class="projectDatatable-title">completion</span></th><th></th></tr></thead><tbody><!--[-->`);
      const each_array = ensure_array_like(projectType);
      for (let $$index_1 = 0, $$length = each_array.length; $$index_1 < $$length; $$index_1++) {
        let card = each_array[$$index_1];
        $$renderer2.push(`<tr><td><div class="d-flex"><div class="userDatatable-inline-title"><a href="#" class="text-dark fw-500"><h6>${escape_html(card.title)}</h6></a> <p class="pt-1 d-block mb-0">${escape_html(card.category)}</p></div></div></td><td><div class="userDatatable-content">26 Dec 2019</div></td><td><div class="userDatatable-content">18 Mar 2020</div></td><td><ul class="d-flex user-group-people__parent align-content-center"><!--[-->`);
        const each_array_1 = ensure_array_like(card.assignedTo);
        for (let $$index = 0, $$length2 = each_array_1.length; $$index < $$length2; $$index++) {
          let user = each_array_1[$$index];
          $$renderer2.push(`<li><a href="#"><img class="rounded-circle wh-34"${attr("src", `/img/${stringify(user)}`)} alt="author"/></a></li>`);
        }
        $$renderer2.push(`<!--]--></ul></td><td><div class="d-inline-block"><span${attr_class(`media-badge color-white bg-${stringify(card.badge)}`)}>${escape_html(card.status)}</span></div></td><td><div class="project-progress d-flex align-items-center"><div class="user-group-progress-bar"><div class="progress-wrap d-flex align-items-center mb-0"><div class="progress" style="width: 100%; height: 6px;">`);
        Progress($$renderer2, { bar: true, color: card.badge, value: card.percentage });
        $$renderer2.push(`<!----></div> <span class="progress-percentage">${escape_html(card.percentage)}%</span></div> <p class="color-light fs-12 mt-1 mb-0">12 / 15 tasks completed</p></div></div></td><td><div class="project-progress text-end">`);
        Dropdown($$renderer2, {
          children: ($$renderer3) => {
            DropdownToggle($$renderer3, {
              color: "transparent",
              children: ($$renderer4) => {
                $$renderer4.push(`<img data-inlinesvg="" src="/img/svg/more-horizontal.svg"/>`);
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!----> `);
            DropdownMenu($$renderer3, {
              children: ($$renderer4) => {
                DropdownItem($$renderer4, {
                  children: ($$renderer5) => {
                    $$renderer5.push(`<!---->View`);
                  },
                  $$slots: { default: true }
                });
                $$renderer4.push(`<!----> `);
                DropdownItem($$renderer4, {
                  children: ($$renderer5) => {
                    $$renderer5.push(`<!---->Edit`);
                  },
                  $$slots: { default: true }
                });
                $$renderer4.push(`<!----> `);
                DropdownItem($$renderer4, {
                  children: ($$renderer5) => {
                    $$renderer5.push(`<!---->Delete`);
                  },
                  $$slots: { default: true }
                });
                $$renderer4.push(`<!---->`);
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer2.push(`<!----></div></td></tr>`);
      }
      $$renderer2.push(`<!--]--></tbody></table></div></div></div></div>`);
    },
    $$slots: { default: true }
  });
  bind_props($$props, { projectType });
}
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let projectType;
    let open = false;
    const toggle = () => open = !open;
    const projectLayout = [ProjectGrid, ProjectList];
    let activeLayout = projectLayout.indexOf(ProjectGrid);
    const projectMembers = ["tm1.png", "tm2.png", "tm3.png", "tm4.png", "tm5.png"];
    const projectsArr = Object.assign([], ...projects);
    const allProjects = [
      ...projectsArr.progress,
      ...projectsArr.completed,
      ...projectsArr.late,
      ...projectsArr.early
    ];
    projectType = allProjects;
    head("ldzksu", $$renderer2, ($$renderer3) => {
      $$renderer3.title(($$renderer4) => {
        $$renderer4.push(`<title>Projects</title>`);
      });
    });
    $$renderer2.push(`<div class="component-page mb-25">`);
    Container($$renderer2, {
      fluid: true,
      children: ($$renderer3) => {
        Row($$renderer3, {
          children: ($$renderer4) => {
            Col($$renderer4, {
              lg: 12,
              class: "mb-25",
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="project-progree-breadcrumb"><div class="breadcrumb-main user-member justify-content-sm-between"><div class="d-flex flex-wrap justify-content-center breadcrumb-main__wrapper"><div class="d-flex align-items-center user-member__title justify-content-center me-sm-25"><h4 class="text-capitalize fw-500 breadcrumb-title">Projects</h4> <span class="sub-title ms-sm-25 ps-sm-25">12 Running projects</span></div></div> <div class="action-btn">`);
                Button($$renderer5, {
                  color: "primary",
                  class: "px-15",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<i class="las la-plus fs-16"></i>Create Project`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                Modal($$renderer5, {
                  isOpen: open,
                  toggle,
                  class: "new-member",
                  children: ($$renderer6) => {
                    ModalHeader($$renderer6, {
                      toggle,
                      children: ($$renderer7) => {
                        $$renderer7.push(`<h6 class="modal-title fw-500" id="staticBackdropLabel">Create project</h6>`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    ModalBody($$renderer6, {
                      children: ($$renderer7) => {
                        $$renderer7.push(`<div class="new-member-modal">`);
                        Form($$renderer7, {
                          children: ($$renderer8) => {
                            FormGroup($$renderer8, {
                              class: "mb-20",
                              children: ($$renderer9) => {
                                Input($$renderer9, {
                                  type: "text",
                                  class: "form-control",
                                  placeholder: "Duran Clayton"
                                });
                              },
                              $$slots: { default: true }
                            });
                            $$renderer8.push(`<!----> `);
                            FormGroup($$renderer8, {
                              class: "mb-20",
                              children: ($$renderer9) => {
                                $$renderer9.push(`<div class="category-member"><select class="form-select form-control" id="category-member">`);
                                $$renderer9.option({ value: "JAN" }, ($$renderer10) => {
                                  $$renderer10.push(`1`);
                                });
                                $$renderer9.option({ value: "FBR" }, ($$renderer10) => {
                                  $$renderer10.push(`2`);
                                });
                                $$renderer9.push(`</select></div>`);
                              },
                              $$slots: { default: true }
                            });
                            $$renderer8.push(`<!----> `);
                            FormGroup($$renderer8, {
                              class: "mb-20",
                              children: ($$renderer9) => {
                                Input($$renderer9, {
                                  type: "textarea",
                                  class: "form-control",
                                  id: "exampleFormControlTextarea1",
                                  rows: "3",
                                  placeholder: "Project description"
                                });
                              },
                              $$slots: { default: true }
                            });
                            $$renderer8.push(`<!----> `);
                            FormGroup($$renderer8, {
                              class: "textarea-group",
                              children: ($$renderer9) => {
                                Label($$renderer9, {
                                  class: "mb-15",
                                  children: ($$renderer10) => {
                                    $$renderer10.push(`<!---->status`);
                                  },
                                  $$slots: { default: true }
                                });
                                $$renderer9.push(`<!----> <div class="d-flex"><div class="project-task-list__left d-flex align-items-center"><div class="checkbox-group d-flex me-50 pe-10"><div class="checkbox-theme-default custom-checkbox checkbox-group__single d-flex">`);
                                Input($$renderer9, {
                                  class: "checkbox",
                                  type: "checkbox",
                                  id: "check-grp-1",
                                  checked: true,
                                  label: "status"
                                });
                                $$renderer9.push(`<!----></div></div> <div class="checkbox-group d-flex me-50 pe-10"><div class="checkbox-theme-default custom-checkbox checkbox-group__single d-flex">`);
                                Input($$renderer9, {
                                  class: "checkbox",
                                  type: "checkbox",
                                  id: "check-grp-2",
                                  label: "Deactivated"
                                });
                                $$renderer9.push(`<!----></div></div> <div class="checkbox-group d-flex"><div class="checkbox-theme-default custom-checkbox checkbox-group__single d-flex">`);
                                Input($$renderer9, {
                                  class: "checkbox",
                                  type: "checkbox",
                                  id: "check-grp-3",
                                  label: "blocked"
                                });
                                $$renderer9.push(`<!----></div></div></div></div>`);
                              },
                              $$slots: { default: true }
                            });
                            $$renderer8.push(`<!----> <div class="mb-25">`);
                            FormGroup($$renderer8, {
                              class: "mb-10",
                              children: ($$renderer9) => {
                                Label($$renderer9, {
                                  for: "name47",
                                  children: ($$renderer10) => {
                                    $$renderer10.push(`<!---->project member`);
                                  },
                                  $$slots: { default: true }
                                });
                                $$renderer9.push(`<!----> `);
                                Input($$renderer9, {
                                  type: "text",
                                  class: "form-control",
                                  id: "name47",
                                  placeholder: "Search members"
                                });
                                $$renderer9.push(`<!---->`);
                              },
                              $$slots: { default: true }
                            });
                            $$renderer8.push(`<!----> <ul class="d-flex flex-wrap mb-20 user-group-people__parent"><!--[-->`);
                            const each_array = ensure_array_like(projectMembers);
                            for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
                              let member = each_array[$$index];
                              $$renderer8.push(`<li><a href="#"><img class="rounded-circle wh-34"${attr("src", `/img/${stringify(member)}`)} alt="author"/></a></li>`);
                            }
                            $$renderer8.push(`<!--]--></ul></div> <div class="d-flex new-member-calendar custom-date-ranger custom-date-ranger__sm">`);
                            FormGroup($$renderer8, {
                              class: "w-100 me-sm-15 form-group-calender",
                              children: ($$renderer9) => {
                                Label($$renderer9, {
                                  for: "datepicker",
                                  children: ($$renderer10) => {
                                    $$renderer10.push(`<!---->start Date`);
                                  },
                                  $$slots: { default: true }
                                });
                                $$renderer9.push(`<!----> <div class="position-relative">`);
                                DatePicker($$renderer9, { format: "MMMM DD, YYYY" });
                                $$renderer9.push(`<!----> <a href="#"><img class="svg" alt="" src="/img/svg/chevron-right.svg"/></a></div>`);
                              },
                              $$slots: { default: true }
                            });
                            $$renderer8.push(`<!----> `);
                            FormGroup($$renderer8, {
                              class: "w-100 form-group-calender",
                              children: ($$renderer9) => {
                                Label($$renderer9, {
                                  for: "datepicker2",
                                  children: ($$renderer10) => {
                                    $$renderer10.push(`<!---->End Date`);
                                  },
                                  $$slots: { default: true }
                                });
                                $$renderer9.push(`<!----> <div class="position-relative">`);
                                DatePicker($$renderer9, { format: "MMMM DD, YYYY" });
                                $$renderer9.push(`<!----> <a href="#"><img class="svg" alt="" src="/img/svg/chevron-right.svg"/></a></div>`);
                              },
                              $$slots: { default: true }
                            });
                            $$renderer8.push(`<!----></div> <div class="button-group d-flex pt-25">`);
                            Button($$renderer8, {
                              color: "primary",
                              size: "default",
                              class: "fs-15 btn-squared text-capitalize",
                              children: ($$renderer9) => {
                                $$renderer9.push(`<!---->add new project`);
                              },
                              $$slots: { default: true }
                            });
                            $$renderer8.push(`<!----> `);
                            Button($$renderer8, {
                              color: "light",
                              size: "default",
                              type: "button",
                              class: "btn-squared fs-15 fw-400 text-capitalize b-light btn-transparent-light",
                              children: ($$renderer9) => {
                                $$renderer9.push(`<!---->cancel`);
                              },
                              $$slots: { default: true }
                            });
                            $$renderer8.push(`<!----></div>`);
                          },
                          $$slots: { default: true }
                        });
                        $$renderer7.push(`<!----></div>`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!---->`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----></div></div></div> <div class="project-top-wrapper project-top-progress d-flex justify-content-between flex-wrap"><div class="project-top-left d-flex flex-wrap justify-content-lg-between justify-content-center mt-n10"><div class="project-tab global-shadow order-lg-1 order-2 my-10"><ul class="nav px-1" id="project-tabs"><li class="nav-item"><a class="nav-link active" id="ap-overview-tab" href="#all" data-type="all">all projects</a></li> <li class="nav-item"><a class="nav-link" id="timeline-tab" href="#progress" data-type="progress">in progress</a></li> <li class="nav-item"><a class="nav-link" id="activity-tab" href="#completed" data-type="completed">completed</a></li> <li class="nav-item"><a class="nav-link" id="late-tab" href="#late" data-type="late">late</a></li> <li class="nav-item"><a class="nav-link" id="early-tab" href="#early" data-type="early">early</a></li></ul></div> <div class="project-search project-search--height global-shadow ms-md-20 my-10 order-md-2 order-1">`);
                Form($$renderer5, {
                  action: "/",
                  class: "d-flex align-items-center user-member__form",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<img class="svg" alt="" src="/img/svg/search.svg"/> `);
                    Input($$renderer6, {
                      class: "form-control me-sm-2 border-0 box-shadow-none",
                      type: "search",
                      placeholder: "Search by Name",
                      "aria-label": "Search"
                    });
                    $$renderer6.push(`<!---->`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----></div></div> <div class="project-top-right d-flex flex-wrap"><div class="project-category d-flex align-items-center"><div class="d-flex align-items-center"><p class="mb-0 me-10 fs-14 color-light">sort by:</p> <div class="project-category__select dm-select"><select class="form-control color-primary">`);
                $$renderer5.option({ value: "all", selected: "selected" }, ($$renderer6) => {
                  $$renderer6.push(`Project category`);
                });
                $$renderer5.option({ value: "JAN" }, ($$renderer6) => {
                  $$renderer6.push(`Event`);
                });
                $$renderer5.option({ value: "FBR" }, ($$renderer6) => {
                  $$renderer6.push(`Venues`);
                });
                $$renderer5.push(`</select></div></div></div> <div class="project-icon-selected content-center"><div class="listing-social-link"><div class="icon-list-social d-flex"><a class="icon-list-social__link rounded-circle me-15 icon-list-social__style justify-content-center active" href="#" data-type="project-grid"><img class="svg" alt="" src="/img/svg/grid.svg"/></a> <a class="icon-list-social__link rounded-circle icon-list-social__style justify-content-center" href="#" data-type="project-list"><img class="svg" alt="" src="/img/svg/list.svg"/></a></div></div></div></div></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            $$renderer4.push("<!---->");
            projectLayout[activeLayout]?.($$renderer4, { projectType });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              lg: 12,
              children: ($$renderer5) => {
                PaginationBasic($$renderer5);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></div>`);
  });
}
export {
  _page as default
};
