import { ag as ensure_array_like, ac as attr, aa as escape_html, ae as stringify, a2 as head, af as spread_props } from "../../../../../../chunks/index2.js";
import "clsx";
import { C as Container, R as Row, a as Col } from "../../../../../../chunks/Row.js";
import "../../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbOne } from "../../../../../../chunks/BreadcrumbOne.js";
import { B as Button } from "../../../../../../chunks/Button.js";
import { D as Dropdown, a as DropdownToggle, b as DropdownMenu } from "../../../../../../chunks/DropdownToggle.js";
import { F as Form } from "../../../../../../chunks/Form.js";
import { F as FormGroup } from "../../../../../../chunks/FormGroup.js";
import { I as Input } from "../../../../../../chunks/Input.js";
import { M as Modal, a as ModalBody } from "../../../../../../chunks/Modal.js";
import { M as ModalHeader } from "../../../../../../chunks/ModalHeader.js";
import "papaparse";
import "exceljs";
const contactData = [
  {
    id: "1",
    name: "Duran Clayton",
    email: "duran@example.com",
    company: "Business Development",
    position: "UI/UX Designer",
    date: "January 20, 2020",
    checked: false
  },
  {
    id: "2",
    name: "Mohammad Amir",
    email: "john@gmail.com",
    company: "Business Development",
    position: "UI/UX Designer",
    date: "January 20, 2020",
    checked: false
  },
  {
    id: "3",
    name: "Salman But",
    email: "duran@example.com",
    company: "Business Development",
    position: "UI/UX Designer",
    date: "January 20, 2020",
    checked: false
  },
  {
    id: "4",
    name: "Crish Moris",
    email: "duran@example.com",
    company: "Business Development",
    position: "UI/UX Designer",
    date: "January 20, 2020",
    checked: false
  },
  {
    id: "5",
    name: "Tom Curan",
    email: "duran@example.com",
    company: "Business Development",
    position: "UI/UX Designer",
    date: "January 20, 2020",
    checked: false
  },
  {
    id: "6",
    name: "David Milar",
    email: "duran@example.com",
    company: "Business Development",
    position: "UI/UX Designer",
    date: "January 20, 2020",
    checked: false
  }
];
function Export($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let open = false;
    const toggle = () => open = !open;
    $$renderer2.push(`<div class="row"><div class="col-12"><div class="contact-list-wrap mb-25"><div class="contact-list global-shadow border-0 py-30 bg-white radius-xl w-100 mb-30 px-30"><div class="contact-breadcrumb"><div class="add-contact d-flex flex-wrap justify-content-sm-between justify-content-center"><div class="add-contact-modal">`);
    Button($$renderer2, {
      color: "primary",
      class: "px-15",
      children: ($$renderer3) => {
        $$renderer3.push(`<!---->Export`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----> `);
    Modal($$renderer2, {
      isOpen: open,
      toggle,
      class: "add-contact-modal modal-dialog-centered",
      children: ($$renderer3) => {
        ModalHeader($$renderer3, {
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->Export File `);
            Button($$renderer4, {
              size: "default",
              children: ($$renderer5) => {
                $$renderer5.push(`<i class="uil uil-times"></i>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        ModalBody($$renderer3, {
          class: "pt-10",
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="add-new-contact">`);
            Form($$renderer4, {
              action: "/",
              children: ($$renderer5) => {
                FormGroup($$renderer5, {
                  class: "mb-20",
                  children: ($$renderer6) => {
                    Input($$renderer6, {
                      type: "text",
                      class: "form-control",
                      placeholder: "Enter File Name"
                    });
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                FormGroup($$renderer5, {
                  children: ($$renderer6) => {
                    Dropdown($$renderer6, {
                      class: "dropdown-click",
                      children: ($$renderer7) => {
                        DropdownToggle($$renderer7, {
                          class: "btn-link",
                          children: ($$renderer8) => {
                            $$renderer8.push(`<!---->Export File`);
                          },
                          $$slots: { default: true }
                        });
                        $$renderer7.push(`<!----> `);
                        DropdownMenu($$renderer7, {
                          class: "dropdown-default dropdown-menu--dynamic",
                          children: ($$renderer8) => {
                            $$renderer8.push(`<button type="submit" class="dropdown-item">Export to CSV</button> <button type="submit" class="dropdown-item">Export XLSX</button>`);
                          },
                          $$slots: { default: true }
                        });
                        $$renderer7.push(`<!---->`);
                      },
                      $$slots: { default: true }
                    });
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!---->`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> <div class="modal-footer m-n1"><button type="button" class="btn btn-light btn-default btn-squared fw-400 text-capitalize b-light text-light" data-bs-dismiss="modal">Cancel</button> <button type="button" class="btn btn-primary btn-default btn-squared text-capitalize">Create</button></div>`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></div> <div class="d-flex flex-wrap justify-content-center">`);
    Form($$renderer2, {
      action: "/",
      class: "d-flex align-items-center add-contact__form my-sm-0 my-2",
      children: ($$renderer3) => {
        $$renderer3.push(`<img class="svg" alt="" src="/img/svg/search.svg"/> `);
        Input($$renderer3, {
          class: "form-control me-sm-2 border-0 box-shadow-none",
          type: "search",
          placeholder: "Search by Name",
          "aria-label": "Search"
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></div></div></div> <div class="table-responsive"><table class="table mb-0 table-borderless table-rounded"><thead><tr><th><div class="d-flex align-items-center"><div class="custom-checkbox check-all"><input class="checkbox" type="checkbox" id="check-33"/> <label for="check-33"><span class="checkbox-text userDatatable-title">Name</span></label></div></div></th><th class="c-email"><span>email</span></th><th class="c-company"><span>company</span></th><th class="c-position"><span>position</span></th><th class="c-phone"><span class="float-end">Phone</span></th></tr></thead><tbody><!--[-->`);
    const each_array = ensure_array_like(contactData);
    for (let i = 0, $$length = each_array.length; i < $$length; i++) {
      let contact = each_array[i];
      $$renderer2.push(`<tr><td><div class="contact-item d-flex align-items-center"><div class="contact-personal-wrap"><div class="checkbox-group-wrapper"><div class="checkbox-group d-flex"><div class="checkbox-theme-default custom-checkbox checkbox-group__single d-flex"><input class="checkbox" type="checkbox"${attr("id", `check-grp-${stringify(i)}`)}/> <label${attr("for", `check-grp-${stringify(i)}`)}></label></div></div></div></div> <div class="contact-personal-info d-flex"><div class="contact_title"><h6>${escape_html(contact.name)}</h6></div></div></div></td><td><span class="email">${escape_html(contact.email)}</span></td><td><span class="company">${escape_html(contact.company)}</span></td><td><span class="position">${escape_html(contact.position)}</span></td><td><span class="float-end">${escape_html(contact.date)}</span></td></tr>`);
    }
    $$renderer2.push(`<!--]--></tbody></table></div></div></div></div></div>`);
  });
}
function _page($$renderer) {
  const breadcrumbData = {
    pageTitle: "Export",
    bcItem: "Home",
    bcItem2: "App",
    bcItemActive: "Export"
  };
  head("1j6zh6b", $$renderer, ($$renderer2) => {
    $$renderer2.title(($$renderer3) => {
      $$renderer3.push(`<title>Export</title>`);
    });
  });
  $$renderer.push(`<div class="component-page mb-25">`);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              BreadcrumbOne($$renderer4, spread_props([breadcrumbData]));
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              Export($$renderer4);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
export {
  _page as default
};
