import { ag as ensure_array_like, ac as attr, aa as escape_html, ae as stringify, af as spread_props } from "../../../../../../chunks/index2.js";
import { B as BreadcrumbOne } from "../../../../../../chunks/BreadcrumbOne.js";
import { P as PaginationBasic } from "../../../../../../chunks/PaginationBasic.js";
import "clsx";
import { C as Container, R as Row, a as Col } from "../../../../../../chunks/Row.js";
import "../../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { T as Table } from "../../../../../../chunks/Table.js";
import { T as TableToolbox } from "../../../../../../chunks/TableToolbox.js";
const sellers = [
  {
    id: "#02-0003",
    name: "Kellie Marquot",
    storeName: "Shipment Marquot",
    img: "/img/sellers/1.png",
    product: "397",
    amount: "$4,248.66",
    date: "January 20, 2020"
  },
  {
    id: "#02-0004",
    name: "Carroll Maharry",
    storeName: "Maharry Shipment",
    img: "/img/sellers/2.png",
    product: "397",
    amount: "$14,248.61",
    date: "January 28, 2020"
  },
  {
    id: "#02-0005",
    name: "Rosenbaum Reichel",
    storeName: "Reichel",
    img: "/img/sellers/3.png",
    product: "397",
    amount: "$24,248.90",
    date: "January 30, 2020"
  },
  {
    id: "#02-0006",
    name: "Ashley Briggs",
    storeName: "Ashley",
    img: "/img/sellers/4.png",
    product: "397",
    amount: "$6,248.87",
    date: "February 2, 2020"
  },
  {
    id: "#02-0007",
    name: "Carl Jenkins",
    storeName: "Jenkins",
    img: "/img/sellers/5.png",
    product: "397",
    amount: "$35,545.66",
    date: "February 12, 2020"
  },
  {
    id: "#02-0008",
    name: "Bertha Martin",
    storeName: "Martin",
    img: "/img/sellers/6.png",
    product: "397",
    amount: "$4,248.66",
    date: "February 8, 2020"
  },
  {
    id: "#02-0009",
    name: "Stacie Hall",
    storeName: "Hall Store",
    img: "/img/sellers/7.png",
    product: "397",
    amount: "$34,248.66",
    date: "February 2, 2020"
  },
  {
    id: "#02-0010",
    name: "Striker Marquot",
    storeName: "Striker",
    img: "/img/sellers/8.png",
    product: "397",
    amount: "$14,244.20",
    date: "January 20, 2020"
  },
  {
    id: "#02-0011",
    name: "Amanda Jones",
    storeName: "Jones Store",
    img: "/img/sellers/9.png",
    product: "397",
    amount: "$4,248.66",
    date: "January 20, 2020"
  },
  {
    id: "#02-0012",
    name: "Ashley Briggs",
    storeName: "Briggs",
    img: "/img/sellers/1.png",
    product: "397",
    amount: "$4,248.66",
    date: "January 20, 2020"
  }
];
function SellersTable($$renderer) {
  let checked;
  checked = false;
  $$renderer.push(`<div class="table-responsive">`);
  Table($$renderer, {
    class: "mb-0",
    borderless: true,
    children: ($$renderer2) => {
      $$renderer2.push(`<thead><tr class="userDatatable-header"><th><div class="d-flex align-items-center"><div class="custom-checkbox check-all"><input class="checkbox" type="checkbox" id="check-all"/> <label for="check-all">Sellers</label></div></div></th><th><span class="userDatatable-title">Store Name</span></th><th><span class="userDatatable-title">Products</span></th><th><span class="userDatatable-title">Wallet Balance</span></th><th><span class="userDatatable-title">Create Date</span></th><th><span class="userDatatable-title float-end">Actions</span></th></tr></thead> <tbody><!--[-->`);
      const each_array = ensure_array_like(sellers);
      for (let i = 0, $$length = each_array.length; i < $$length; i++) {
        let data = each_array[i];
        $$renderer2.push(`<tr><td><div class="d-flex align-items-center"><div class="userDatatable__imgWrapper d-flex align-items-center"><div class="checkbox-group-wrapper"><div class="checkbox-group d-flex"><div class="checkbox-theme-default custom-checkbox checkbox-group__single d-flex"><input class="checkbox" type="checkbox"${attr("id", `check-grp-content-${stringify(i)}`)}${attr("checked", checked, true)}/> <label${attr("for", `check-grp-content-${stringify(i)}`)}></label></div></div></div> <a href="#" class="profile-image rounded-circle d-block"><img${attr("src", data.img)} alt="user" class="img-fluid"/></a></div> <div class="userDatatable-inline-title"><a href="#" class="text-dark fw-500"><h6>${escape_html(data.name)}</h6></a></div></div></td><td><div class="userDatatable-title">${escape_html(data.storeName)}</div></td><td><div class="userDatatable-title">${escape_html(data.product)}</div></td><td><div class="userDatatable-title">${escape_html(data.amount)}</div></td><td><div class="userDatatable-title">${escape_html(data.date)}</div></td><td><ul class="orderDatatable_actions mb-0 d-flex flex-wrap"><li><a href="#" class="view"><i class="uil uil-eye"></i></a></li> <li><a href="#" class="remove"><i class="uil uil-trash-alt"></i></a></li></ul></td></tr>`);
      }
      $$renderer2.push(`<!--]--></tbody>`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
function _page($$renderer) {
  const breadcrumbData = {
    pageTitle: "Sellers",
    bcItem: "eCommerce",
    bcItemActive: "Sellers"
  };
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              BreadcrumbOne($$renderer4, spread_props([breadcrumbData]));
            },
            $$slots: { default: true }
          });
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----> `);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      $$renderer2.push(`<div class="orderPage">`);
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              $$renderer4.push(`<div class="orderDatatable global-shadow py-30 px-sm-30 px-20 radius-xl w-100 mb-30 border-0">`);
              TableToolbox($$renderer4, { filtering: false, buttonText: "Sellers" });
              $$renderer4.push(`<!----> `);
              SellersTable($$renderer4);
              $$renderer4.push(`<!----> `);
              PaginationBasic($$renderer4, { pageDropdown: true });
              $$renderer4.push(`<!----></div>`);
            },
            $$slots: { default: true }
          });
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----></div>`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!---->`);
}
export {
  _page as default
};
