import { a4 as sanitize_props, a5 as rest_props, a6 as fallback, a7 as attributes, a8 as clsx, a0 as slot, a9 as bind_props, ac as attr, ad as attr_class, ae as stringify, af as spread_props } from "../../../../../../chunks/index2.js";
import { B as BreadcrumbOne } from "../../../../../../chunks/BreadcrumbOne.js";
import "clsx";
import { B as Button } from "../../../../../../chunks/Button.js";
import { C as Card } from "../../../../../../chunks/Card.js";
import { C as CardBody } from "../../../../../../chunks/CardBody.js";
import { C as CardHeader } from "../../../../../../chunks/CardHeader.js";
import { C as Container, R as Row, a as Col } from "../../../../../../chunks/Row.js";
import { F as Form } from "../../../../../../chunks/Form.js";
import { F as FormGroup } from "../../../../../../chunks/FormGroup.js";
import { I as Input } from "../../../../../../chunks/Input.js";
import { I as InputGroup } from "../../../../../../chunks/InputGroup.js";
import { c as classnames } from "../../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { L as Label } from "../../../../../../chunks/Label.js";
function InputGroupText($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, ["class"]);
  $$renderer.component(($$renderer2) => {
    let classes;
    let className = fallback($$props["class"], "");
    classes = classnames(className, "input-group-text");
    $$renderer2.push(`<span${attributes({ ...$$restProps, class: clsx(classes) })}><!--[-->`);
    slot($$renderer2, $$props, "default", {}, null);
    $$renderer2.push(`<!--]--></span>`);
    bind_props($$props, { class: className });
  });
}
function Trash2Icon($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let size = fallback($$props["size"], "24");
    let strokeWidth = fallback($$props["strokeWidth"], 2);
    let customClass = fallback($$props["class"], "");
    if (size !== "100%") {
      size = size.slice(-1) === "x" ? size.slice(0, size.length - 1) + "em" : parseInt(size) + "px";
    }
    $$renderer2.push(`<svg xmlns="http://www.w3.org/2000/svg"${attr("width", size)}${attr("height", size)} fill="none" viewBox="0 0 24 24" stroke="currentColor"${attr("stroke-width", strokeWidth)} stroke-linecap="round" stroke-linejoin="round"${attr_class(`feather feather-trash-2 ${stringify(customClass)}`)}><polyline points="3 6 5 6 21 6"></polyline><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path><line x1="10" y1="11" x2="10" y2="17"></line><line x1="14" y1="11" x2="14" y2="17"></line></svg>`);
    bind_props($$props, { size, strokeWidth, class: customClass });
  });
}
function UploadIcon($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let size = fallback($$props["size"], "24");
    let strokeWidth = fallback($$props["strokeWidth"], 2);
    let customClass = fallback($$props["class"], "");
    if (size !== "100%") {
      size = size.slice(-1) === "x" ? size.slice(0, size.length - 1) + "em" : parseInt(size) + "px";
    }
    $$renderer2.push(`<svg xmlns="http://www.w3.org/2000/svg"${attr("width", size)}${attr("height", size)} fill="none" viewBox="0 0 24 24" stroke="currentColor"${attr("stroke-width", strokeWidth)} stroke-linecap="round" stroke-linejoin="round"${attr_class(`feather feather-upload ${stringify(customClass)}`)}><path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path><polyline points="17 8 12 3 7 8"></polyline><line x1="12" y1="3" x2="12" y2="15"></line></svg>`);
    bind_props($$props, { size, strokeWidth, class: customClass });
  });
}
function _page($$renderer) {
  const breadcrumbData = {
    pageTitle: "Add Product",
    bcItem: "Dashboard",
    bcItemActive: "Add Product"
  };
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              BreadcrumbOne($$renderer4, spread_props([breadcrumbData]));
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              $$renderer4.push(`<div class="product-add global-shadow border-light-light px-sm-30 py-sm-50 px-0 py-20 bg-white radius-xl w-100 mb-40">`);
              Row($$renderer4, {
                class: "justify-content-center",
                children: ($$renderer5) => {
                  Col($$renderer5, {
                    xxl: 7,
                    lg: 10,
                    children: ($$renderer6) => {
                      $$renderer6.push(`<div class="mx-sm-30 mx-20">`);
                      Form($$renderer6, {
                        children: ($$renderer7) => {
                          Card($$renderer7, {
                            class: "px-25 browser-states mb-30",
                            children: ($$renderer8) => {
                              CardHeader($$renderer8, {
                                children: ($$renderer9) => {
                                  $$renderer9.push(`<h6 class="fw-500">About Product</h6>`);
                                },
                                $$slots: { default: true }
                              });
                              $$renderer8.push(`<!----> `);
                              CardBody($$renderer8, {
                                class: "browser-states__body",
                                children: ($$renderer9) => {
                                  FormGroup($$renderer9, {
                                    class: "form-group",
                                    children: ($$renderer10) => {
                                      Label($$renderer10, {
                                        for: "product-name",
                                        children: ($$renderer11) => {
                                          $$renderer11.push(`<!---->Product Name`);
                                        },
                                        $$slots: { default: true }
                                      });
                                      $$renderer10.push(`<!----> `);
                                      Input($$renderer10, {
                                        type: "text",
                                        name: "name",
                                        id: "product-name",
                                        placeholder: "Ex: Gold Coin"
                                      });
                                      $$renderer10.push(`<!---->`);
                                    },
                                    $$slots: { default: true }
                                  });
                                  $$renderer9.push(`<!----> `);
                                  FormGroup($$renderer9, {
                                    class: "form-group",
                                    children: ($$renderer10) => {
                                      Label($$renderer10, {
                                        for: "product-sub-text",
                                        children: ($$renderer11) => {
                                          $$renderer11.push(`<!---->Sub Text`);
                                        },
                                        $$slots: { default: true }
                                      });
                                      $$renderer10.push(`<!----> `);
                                      Input($$renderer10, {
                                        type: "text",
                                        name: "name",
                                        id: "product-sub-text",
                                        placeholder: "Ex: Gold coin text"
                                      });
                                      $$renderer10.push(`<!---->`);
                                    },
                                    $$slots: { default: true }
                                  });
                                  $$renderer9.push(`<!----> `);
                                  FormGroup($$renderer9, {
                                    class: "form-group",
                                    children: ($$renderer10) => {
                                      Label($$renderer10, {
                                        for: "product-category",
                                        children: ($$renderer11) => {
                                          $$renderer11.push(`<!---->Category`);
                                        },
                                        $$slots: { default: true }
                                      });
                                      $$renderer10.push(`<!----> <select name="category" id="product-category" class="form-control form-select">`);
                                      $$renderer10.option({ value: "venu" }, ($$renderer11) => {
                                        $$renderer11.push(`Event`);
                                      });
                                      $$renderer10.option({ value: "event" }, ($$renderer11) => {
                                        $$renderer11.push(`Venues`);
                                      });
                                      $$renderer10.push(`</select>`);
                                    },
                                    $$slots: { default: true }
                                  });
                                  $$renderer9.push(`<!----> `);
                                  FormGroup($$renderer9, {
                                    class: "form-group quantity-appearance",
                                    children: ($$renderer10) => {
                                      Label($$renderer10, {
                                        for: "product-price",
                                        children: ($$renderer11) => {
                                          $$renderer11.push(`<!---->Price`);
                                        },
                                        $$slots: { default: true }
                                      });
                                      $$renderer10.push(`<!----> `);
                                      InputGroup($$renderer10, {
                                        children: ($$renderer11) => {
                                          InputGroupText($$renderer11, {
                                            children: ($$renderer12) => {
                                              $$renderer12.push(`<!---->$`);
                                            },
                                            $$slots: { default: true }
                                          });
                                          $$renderer11.push(`<!----> `);
                                          Input($$renderer11, {
                                            placeholder: "Price",
                                            min: 0,
                                            max: 100,
                                            type: "number",
                                            id: "product-price",
                                            step: "1"
                                          });
                                          $$renderer11.push(`<!---->`);
                                        },
                                        $$slots: { default: true }
                                      });
                                      $$renderer10.push(`<!---->`);
                                    },
                                    $$slots: { default: true }
                                  });
                                  $$renderer9.push(`<!----> `);
                                  FormGroup($$renderer9, {
                                    class: "form-group quantity-appearance",
                                    children: ($$renderer10) => {
                                      Label($$renderer10, {
                                        for: "product-discount",
                                        children: ($$renderer11) => {
                                          $$renderer11.push(`<!---->Discount`);
                                        },
                                        $$slots: { default: true }
                                      });
                                      $$renderer10.push(`<!----> `);
                                      InputGroup($$renderer10, {
                                        children: ($$renderer11) => {
                                          InputGroupText($$renderer11, {
                                            children: ($$renderer12) => {
                                              $$renderer12.push(`<!---->%`);
                                            },
                                            $$slots: { default: true }
                                          });
                                          $$renderer11.push(`<!----> `);
                                          Input($$renderer11, {
                                            placeholder: "Discount",
                                            min: 0,
                                            max: 100,
                                            type: "number",
                                            id: "product-discount",
                                            step: "1"
                                          });
                                          $$renderer11.push(`<!---->`);
                                        },
                                        $$slots: { default: true }
                                      });
                                      $$renderer10.push(`<!---->`);
                                    },
                                    $$slots: { default: true }
                                  });
                                  $$renderer9.push(`<!----> `);
                                  FormGroup($$renderer9, {
                                    class: "form-group status-radio browser-states-status-radio mb-20",
                                    children: ($$renderer10) => {
                                      Label($$renderer10, {
                                        for: "product-status mb-15",
                                        children: ($$renderer11) => {
                                          $$renderer11.push(`<!---->status`);
                                        },
                                        $$slots: { default: true }
                                      });
                                      $$renderer10.push(`<!----> <div class="radio-horizontal-list d-flex flex-wrap"><div class="radio-theme-default custom-radio"><input class="radio" type="radio" name="radio-optional" value="0" id="status-publish"/> <label for="status-publish"><span class="radio-text">Published</span></label></div> <div class="radio-theme-default custom-radio"><input class="radio" type="radio" name="radio-optional" value="0" id="status-draft"/> <label for="status-draft"><span class="radio-text">Draft</span></label></div></div>`);
                                    },
                                    $$slots: { default: true }
                                  });
                                  $$renderer9.push(`<!----> `);
                                  FormGroup($$renderer9, {
                                    class: "form-group",
                                    children: ($$renderer10) => {
                                      Label($$renderer10, {
                                        for: "meta-title",
                                        children: ($$renderer11) => {
                                          $$renderer11.push(`<!---->Product Description`);
                                        },
                                        $$slots: { default: true }
                                      });
                                      $$renderer10.push(`<!----> <textarea name="meta-title" class="form-control" placeholder="Ex: Product Description"></textarea>`);
                                    },
                                    $$slots: { default: true }
                                  });
                                  $$renderer9.push(`<!----> `);
                                  FormGroup($$renderer9, {
                                    class: "form-group",
                                    children: ($$renderer10) => {
                                      Label($$renderer10, {
                                        for: "meta-title",
                                        children: ($$renderer11) => {
                                          $$renderer11.push(`<!---->Meta Title`);
                                        },
                                        $$slots: { default: true }
                                      });
                                      $$renderer10.push(`<!----> `);
                                      Input($$renderer10, {
                                        type: "text",
                                        name: "name",
                                        id: "meta-title",
                                        placeholder: "Ex: Title"
                                      });
                                      $$renderer10.push(`<!---->`);
                                    },
                                    $$slots: { default: true }
                                  });
                                  $$renderer9.push(`<!----> `);
                                  FormGroup($$renderer9, {
                                    class: "form-group",
                                    children: ($$renderer10) => {
                                      Label($$renderer10, {
                                        for: "product-name",
                                        children: ($$renderer11) => {
                                          $$renderer11.push(`<!---->Meta Keyword`);
                                        },
                                        $$slots: { default: true }
                                      });
                                      $$renderer10.push(`<!----> `);
                                      Input($$renderer10, {
                                        type: "text",
                                        name: "name",
                                        id: "product-keyword",
                                        placeholder: "Ex: Keyword"
                                      });
                                      $$renderer10.push(`<!---->`);
                                    },
                                    $$slots: { default: true }
                                  });
                                  $$renderer9.push(`<!---->`);
                                },
                                $$slots: { default: true }
                              });
                              $$renderer8.push(`<!---->`);
                            },
                            $$slots: { default: true }
                          });
                          $$renderer7.push(`<!----> `);
                          Card($$renderer7, {
                            class: "px-25 browser-states",
                            children: ($$renderer8) => {
                              CardHeader($$renderer8, {
                                children: ($$renderer9) => {
                                  $$renderer9.push(`<h6 class="fw-500">Product Image</h6>`);
                                },
                                $$slots: { default: true }
                              });
                              $$renderer8.push(`<!----> `);
                              CardBody($$renderer8, {
                                class: "browser-states__body-img",
                                children: ($$renderer9) => {
                                  $$renderer9.push(`<label for="product-img-upload" class="file-upload__label"><span class="upload-product-img px-10 d-block"><span class="file-upload">`);
                                  UploadIcon($$renderer9, {});
                                  $$renderer9.push(`<!----></span> <input type="text" id="product-img-upload" name="product-img-upload" class="file-upload__input"/> <span class="upload-title">Drag and drop an image</span> <span>or <a href="#" class="color-secondary">Browse</a> to choose a file</span></span></label> <div class="upload-product-media d-flex justify-content-between align-items-center mt-25"><div class="upload-media-area d-flex"><img src="/img/food-restaurant-media.png" alt=""/> <div class="upload-media-area__title d-flex flex-wrap align-items-center ms-10"><span class="media-content"><p>Product_image.jpg</p> <span>68.8 KB</span></span> <div class="upload-media-area__btn"><button type="button" class="transparent rounded-circle wh-30 border-0 color-danger">`);
                                  Trash2Icon($$renderer9, {});
                                  $$renderer9.push(`<!----></button></div></div></div></div>`);
                                },
                                $$slots: { default: true }
                              });
                              $$renderer8.push(`<!---->`);
                            },
                            $$slots: { default: true }
                          });
                          $$renderer7.push(`<!----> <div class="button-group browser-states-btn d-flex justify-content-sm-end justify-content-center mt-40">`);
                          Button($$renderer7, {
                            color: "light",
                            class: "btn-squared fw-400 text-capitalize",
                            children: ($$renderer8) => {
                              $$renderer8.push(`<!---->Cancel`);
                            },
                            $$slots: { default: true }
                          });
                          $$renderer7.push(`<!----> `);
                          Button($$renderer7, {
                            color: "primary",
                            class: "btn-squared text-capitalize",
                            children: ($$renderer8) => {
                              $$renderer8.push(`<!---->save product`);
                            },
                            $$slots: { default: true }
                          });
                          $$renderer7.push(`<!----></div>`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!----></div>`);
                    },
                    $$slots: { default: true }
                  });
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----></div>`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
}
export {
  _page as default
};
