import { ag as ensure_array_like, ac as attr, aa as escape_html, ae as stringify, af as spread_props } from "../../../../../../chunks/index2.js";
import { B as BreadcrumbOne } from "../../../../../../chunks/BreadcrumbOne.js";
import { P as PaginationBasic } from "../../../../../../chunks/PaginationBasic.js";
import "clsx";
import { C as Container, R as Row, a as Col } from "../../../../../../chunks/Row.js";
import "../../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as Badge } from "../../../../../../chunks/Badge.js";
import { T as Table } from "../../../../../../chunks/Table.js";
import { T as TableToolbox } from "../../../../../../chunks/TableToolbox.js";
const orders = [
  {
    orderId: "#02-0003",
    customers: "Kellie Marquot",
    status: "Shipped",
    amount: "$4,248.66",
    date: "January 20, 2020"
  },
  {
    orderId: "#02-0004",
    customers: "Carroll Maharry",
    status: "Awaiting Shipment",
    amount: "$14,248.61",
    date: "January 28, 2020"
  },
  {
    orderId: "#02-0005",
    customers: "Rosenbaum Reichel",
    status: "Shipped",
    amount: "$24,248.90",
    date: "January 30, 2020"
  },
  {
    orderId: "#02-0006",
    customers: "Ashley Briggs",
    status: "Shipped",
    amount: "$6,248.87",
    date: "February 2, 2020"
  },
  {
    orderId: "#02-0007",
    customers: "Carl Jenkins",
    status: "Canceled",
    amount: "$35,545.66",
    date: "February 12, 2020"
  },
  {
    orderId: "#02-0008",
    customers: "Bertha Martin",
    status: "Shipped",
    amount: "$4,248.66",
    date: "February 8, 2020"
  },
  {
    orderId: "#02-0009",
    customers: "Stacie Hall",
    status: "Awaiting Shipment",
    amount: "$34,248.66",
    date: "February 2, 2020"
  },
  {
    orderId: "#02-0010",
    customers: "Kellie Marquot",
    status: "Canceled",
    amount: "$14,244.20",
    date: "January 20, 2020"
  },
  {
    orderId: "#02-0010",
    customers: "Kellie Marquot",
    status: "Canceled",
    amount: "$14,244.20",
    date: "January 20, 2020"
  },
  {
    orderId: "#02-0011",
    customers: "Amanda Jones",
    status: "Shipped",
    amount: "$4,248.66",
    date: "January 20, 2020"
  },
  {
    orderId: "#02-0012",
    customers: "Ashley Briggs",
    status: "Shipped",
    amount: "$4,248.66",
    date: "January 20, 2020"
  }
];
function OrdersTable($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let checked;
    let tableType = "All";
    checked = false;
    $$renderer2.push(`<div class="table-responsive">`);
    Table($$renderer2, {
      class: "mb-0",
      borderless: true,
      children: ($$renderer3) => {
        $$renderer3.push(`<thead><tr class="userDatatable-header"><th><div class="d-flex align-items-center"><div class="custom-checkbox check-all"><input class="checkbox" type="checkbox" id="check-all"/> <label for="check-all">Order Id</label></div></div></th><th><span class="userDatatable-title">Customers</span></th><th><span class="userDatatable-title">Status</span></th><th><span class="userDatatable-title">Amount</span></th><th><span class="userDatatable-title">Date</span></th><th><span class="userDatatable-title float-end">action</span></th></tr></thead> <tbody><!--[-->`);
        const each_array = ensure_array_like(orders);
        for (let i = 0, $$length = each_array.length; i < $$length; i++) {
          let data = each_array[i];
          if (data.status === tableType) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<tr><td><div class="d-flex align-items-center"><div class="me-3 d-flex align-items-center"><div class="checkbox-group-wrapper"><div class="checkbox-group d-flex"><div class="checkbox-theme-default custom-checkbox checkbox-group__single d-flex"><input class="checkbox" type="checkbox"${attr("id", `check-grp-content-${stringify(i)}`)}${attr("checked", checked, true)}/> <label${attr("for", `check-grp-content-${stringify(i)}`)}></label></div></div></div> <div class="orderDatatable-title"><p class="d-block mb-0">#02-0003</p></div></div></div></td><td><div class="orderDatatable-title">${escape_html(data.customers)}</div></td><td><div class="userDatatable-content d-inline-block">`);
            Badge($$renderer3, {
              pill: true,
              color: data.status === "Shipped" ? "success" : data.status === "Awaiting Shipment" ? "warning" : "danger",
              class: `bg-opacity-${stringify(data.status === "active" ? "success" : data.status === "deactive" ? "warning" : "danger")}`,
              children: ($$renderer4) => {
                $$renderer4.push(`<!---->${escape_html(data.status)}`);
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!----></div></td><td><div class="userDatatable-title">${escape_html(data.amount)}</div></td><td><div class="userDatatable-title">${escape_html(data.date)}</div></td><td><ul class="orderDatatable_actions mb-0 d-flex flex-wrap"><li><a href="#" class="view"><i class="uil uil-eye"></i></a></li> <li><a href="#" class="edit"><i class="uil uil-edit"></i></a></li> <li><a href="#" class="remove"><i class="uil uil-trash-alt"></i></a></li></ul></td></tr>`);
          } else {
            $$renderer3.push("<!--[1-->");
            $$renderer3.push(`<tr><td><div class="d-flex align-items-center"><div class="me-3 d-flex align-items-center"><div class="checkbox-group-wrapper"><div class="checkbox-group d-flex"><div class="checkbox-theme-default custom-checkbox checkbox-group__single d-flex"><input class="checkbox" type="checkbox"${attr("id", `check-grp-content-${stringify(i)}`)}${attr("checked", checked, true)}/> <label${attr("for", `check-grp-content-${stringify(i)}`)}></label></div></div></div> <div class="orderDatatable-title"><p class="d-block mb-0">#02-0003</p></div></div></div></td><td><div class="orderDatatable-title">${escape_html(data.customers)}</div></td><td><div class="userDatatable-content d-inline-block">`);
            Badge($$renderer3, {
              pill: true,
              color: data.status === "Shipped" ? "success" : data.status === "Awaiting Shipment" ? "warning" : "danger",
              class: `bg-opacity-${stringify(data.status === "active" ? "success" : data.status === "deactive" ? "warning" : "danger")}`,
              children: ($$renderer4) => {
                $$renderer4.push(`<!---->${escape_html(data.status)}`);
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!----></div></td><td><div class="userDatatable-title">${escape_html(data.amount)}</div></td><td><div class="userDatatable-title">${escape_html(data.date)}</div></td><td><ul class="orderDatatable_actions mb-0 d-flex flex-wrap"><li><a href="#" class="view"><i class="uil uil-eye"></i></a></li> <li><a href="#" class="edit"><i class="uil uil-edit"></i></a></li> <li><a href="#" class="remove"><i class="uil uil-trash-alt"></i></a></li></ul></td></tr>`);
          }
          $$renderer3.push(`<!--]-->`);
        }
        $$renderer3.push(`<!--]--></tbody>`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></div>`);
  });
}
function _page($$renderer) {
  const breadcrumbData = {
    pageTitle: "Order",
    bcItem: "eCommerce",
    bcItemActive: "Order"
  };
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              BreadcrumbOne($$renderer4, spread_props([breadcrumbData]));
            },
            $$slots: { default: true }
          });
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----> `);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      $$renderer2.push(`<div class="orderPage mb-30">`);
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              $$renderer4.push(`<div class="orderDatatable py-30 px-sm-30 px-20 radius-xl w-100 mb-30 border-0">`);
              TableToolbox($$renderer4, { filtering: true, buttonText: "Order" });
              $$renderer4.push(`<!----> `);
              OrdersTable($$renderer4);
              $$renderer4.push(`<!----> `);
              PaginationBasic($$renderer4, { pageDropdown: true });
              $$renderer4.push(`<!----></div>`);
            },
            $$slots: { default: true }
          });
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----></div>`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!---->`);
}
export {
  _page as default
};
