import { a6 as fallback, ac as attr, ad as attr_class, a9 as bind_props, ae as stringify, af as spread_props } from "../../../../../../chunks/index2.js";
import { B as BreadcrumbOne } from "../../../../../../chunks/BreadcrumbOne.js";
import "clsx";
import { C as Container, R as Row, a as Col } from "../../../../../../chunks/Row.js";
import "../../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { T as Table } from "../../../../../../chunks/Table.js";
function DownloadIcon($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let size = fallback($$props["size"], "24");
    let strokeWidth = fallback($$props["strokeWidth"], 2);
    let customClass = fallback($$props["class"], "");
    if (size !== "100%") {
      size = size.slice(-1) === "x" ? size.slice(0, size.length - 1) + "em" : parseInt(size) + "px";
    }
    $$renderer2.push(`<svg xmlns="http://www.w3.org/2000/svg"${attr("width", size)}${attr("height", size)} fill="none" viewBox="0 0 24 24" stroke="currentColor"${attr("stroke-width", strokeWidth)} stroke-linecap="round" stroke-linejoin="round"${attr_class(`feather feather-download ${stringify(customClass)}`)}><path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path><polyline points="7 10 12 15 17 10"></polyline><line x1="12" y1="15" x2="12" y2="3"></line></svg>`);
    bind_props($$props, { size, strokeWidth, class: customClass });
  });
}
function PrinterIcon($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let size = fallback($$props["size"], "24");
    let strokeWidth = fallback($$props["strokeWidth"], 2);
    let customClass = fallback($$props["class"], "");
    if (size !== "100%") {
      size = size.slice(-1) === "x" ? size.slice(0, size.length - 1) + "em" : parseInt(size) + "px";
    }
    $$renderer2.push(`<svg xmlns="http://www.w3.org/2000/svg"${attr("width", size)}${attr("height", size)} fill="none" viewBox="0 0 24 24" stroke="currentColor"${attr("stroke-width", strokeWidth)} stroke-linecap="round" stroke-linejoin="round"${attr_class(`feather feather-printer ${stringify(customClass)}`)}><polyline points="6 9 6 2 18 2 18 9"></polyline><path d="M6 18H4a2 2 0 0 1-2-2v-5a2 2 0 0 1 2-2h16a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-2"></path><rect x="6" y="14" width="12" height="8"></rect></svg>`);
    bind_props($$props, { size, strokeWidth, class: customClass });
  });
}
function SendIcon($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let size = fallback($$props["size"], "24");
    let strokeWidth = fallback($$props["strokeWidth"], 2);
    let customClass = fallback($$props["class"], "");
    if (size !== "100%") {
      size = size.slice(-1) === "x" ? size.slice(0, size.length - 1) + "em" : parseInt(size) + "px";
    }
    $$renderer2.push(`<svg xmlns="http://www.w3.org/2000/svg"${attr("width", size)}${attr("height", size)} fill="none" viewBox="0 0 24 24" stroke="currentColor"${attr("stroke-width", strokeWidth)} stroke-linecap="round" stroke-linejoin="round"${attr_class(`feather feather-send ${stringify(customClass)}`)}><line x1="22" y1="2" x2="11" y2="13"></line><polygon points="22 2 15 22 11 13 2 9 22 2"></polygon></svg>`);
    bind_props($$props, { size, strokeWidth, class: customClass });
  });
}
function _page($$renderer) {
  const breadcrumbData = {
    pageTitle: "Invoice",
    bcItem: "eCommerce",
    bcItemActive: "Invoice"
  };
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              BreadcrumbOne($$renderer4, spread_props([breadcrumbData]));
            },
            $$slots: { default: true }
          });
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----> `);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              $$renderer4.push(`<div class="payment-invoice global-shadow border-light-light radius-xl w-100 mb-30"><div class="payment-invoice__body"><div class="payment-invoice-address d-flex justify-content-sm-between"><div class="payment-invoice-logo"><a href="/"><img src="/img/logo-dark.svg" alt=""/></a></div> <div class="payment-invoice-address__area"><address>Admin Company<br/> 795 Folsom Ave, Suite 600<br/> San Francisco, CA 94107, USA<br/> Reg. number : 245000003513</address></div></div> <div class="payment-invoice-qr d-flex justify-content-between mb-40 px-xl-50 px-30 py-sm-30 py-20"><div class="d-flex justify-content-center mb-lg-0 mb-25"><div class="payment-invoice-qr__number"><div class="display-3">Invoice</div> <p>No : <span>#642678</span></p> <p>Date : <span>Jan 17, 2020</span></p></div></div> <div class="d-flex justify-content-center mb-lg-0 mb-25"><div class="payment-invoice-qr__code bg-white radius-xl p-20"><img src="/img/qr.png" alt=""/> <p>8364297359912267</p></div></div> <div class="d-flex justify-content-center"><div class="payment-invoice-qr__address"><p>Invoice To:</p> <span>Stanley Jones</span><br/> <span>795 Folsom Ave, Suite 600</span><br/> <span>San Francisco, CA 94107, USA</span></div></div></div> <div class="payment-invoice-table"><div class="table-responsive">`);
              Table($$renderer4, {
                borderless: true,
                id: "cart",
                children: ($$renderer5) => {
                  $$renderer5.push(`<thead><tr class="product-cart__header"><th scope="col">#</th><th scope="col">Product</th><th scope="col" class="text-end">Price Per Unit</th><th scope="col" class="text-end">Quantity</th><th scope="col" class="text-end">Order Total</th></tr></thead> <tbody><tr><td>1</td><td class="Product-cart-title"><div class="media align-items-center"><div class="media-body"><h5 class="mt-0">Fiber base chair</h5> <div class="d-flex"><p>Size:<span>large</span></p> <p>color:<span>brown</span></p></div></div></div></td><td class="unit text-end">$248.66</td><td class="invoice-quantity text-end">1</td><td class="text-end order">$5.11</td></tr><tr><td>2</td><td class="Product-cart-title"><div class="media align-items-center"><div class="media-body"><h5 class="mt-0">Plastic chair</h5> <div class="d-flex"><p>Size:<span>large</span></p> <p>color:<span>brown</span></p></div></div></div></td><td class="unit text-end">$248.66</td><td class="invoice-quantity text-end">2</td><td class="text-end order">$5.11</td></tr></tbody> <tfoot><tr><td colspan="3"></td><td class="order-summery float-right border-0"><div class="total"><div class="subtotalTotal mb-0 text-end">Subtotal :</div> <div class="taxes mb-0 text-end">discount :</div> <div class="shipping mb-0 text-end">Shipping charge :</div></div> <div class="total-money mt-2 text-end"><h6>Total :</h6></div></td><td><div class="total-order float-right text-end fs-14 fw-500"><p>$1,690.26</p> <p>-$126.30</p> <p>$46.30</p> <h5 class="color-primary">$1736.00</h5></div></td></tr></tfoot>`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----></div></div> <div class="payment-invoice__btn mt-xxl-50 pt-xxl-30"><button class="btn border rounded-pill bg-normal text-gray px-25 print-btn">`);
              PrinterIcon($$renderer4, {});
              $$renderer4.push(`<!----> Print</button> <button class="btn border rounded-pill bg-normal text-gray px-25 print-btn">`);
              SendIcon($$renderer4, {});
              $$renderer4.push(`<!----> Invoice</button> <button class="btn-primary btn rounded-pill px-25 text-white download">`);
              DownloadIcon($$renderer4, {});
              $$renderer4.push(`<!----> Download</button></div></div></div>`);
            },
            $$slots: { default: true }
          });
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!---->`);
}
export {
  _page as default
};
