import { ag as ensure_array_like, ac as attr, aa as escape_html, a6 as fallback, ad as attr_class, a9 as bind_props, ae as stringify, af as spread_props } from "../../../../../../chunks/index2.js";
import { B as BreadcrumbOne } from "../../../../../../chunks/BreadcrumbOne.js";
import "clsx";
import { C as Container, R as Row, a as Col } from "../../../../../../chunks/Row.js";
import "../../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { T as Table } from "../../../../../../chunks/Table.js";
import { C as Card } from "../../../../../../chunks/Card.js";
import { C as CardBody } from "../../../../../../chunks/CardBody.js";
import { C as CardHeader } from "../../../../../../chunks/CardHeader.js";
const Carts = [
  {
    id: "1",
    name: "Montes Scelerisque",
    size: "Large",
    color: "Brown",
    price: "248.66",
    quantity: "1",
    img: "/img/products/1.png",
    total: "248.66"
  },
  {
    id: "2",
    name: "Leo Sodales Varius",
    size: "Small",
    color: "Golden",
    price: "240",
    quantity: "1",
    img: "/img/products/2.png",
    total: "240"
  },
  {
    id: "2",
    name: "Leo Sodales Varius",
    size: "Small",
    color: "Golden",
    price: "240",
    quantity: "1",
    img: "/img/products/3.png",
    total: "240"
  }
];
function CartTable($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    $$renderer2.push(`<div class="product-cart mb-sm-0 mb-20"><div class="table-responsive">`);
    Table($$renderer2, {
      borderless: true,
      class: "table-hover",
      children: ($$renderer3) => {
        $$renderer3.push(`<thead><tr class="product-cart__header"><th>Product</th><th>Price</th><th>Quantity</th><th>total</th><th></th></tr></thead> <tbody><!--[-->`);
        const each_array = ensure_array_like(Carts);
        for (let i = 0, $$length = each_array.length; i < $$length; i++) {
          let { name, size, color, price, quantity, img, total } = each_array[i];
          $$renderer3.push(`<tr><td class="Product-cart-title"><div class="media align-items-center"><img${attr("src", img)} alt="" class="me-3 wh-80 align-self-center radius-xl"/> <div class="media-body"><h5 class="mt-0">${escape_html(name)}</h5> <div class="d-flex"><p>Size: <span>${escape_html(size)}</span></p> <p>color: <span>${escape_html(color)}</span></p></div></div></div></td><td class="price">${escape_html(price)}</td><td><div class="quantity product-cart__quantity"><input type="button" value="-" class="qty-minus bttn bttn-left wh-36"/> <input type="number"${attr("value", quantity)} class="qty qh-36 input"/> <input type="button" value="+" class="qty-plus bttn bttn-right wh-36"/></div></td><td><span class="text-center subtotal">$5.11</span></td><td class="actions"><button class="action-btn float-end"><i class="las la-trash-alt"></i></button></td></tr>`);
        }
        $$renderer3.push(`<!--]--></tbody>`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></div></div>`);
  });
}
function PercentIcon($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let size = fallback($$props["size"], "24");
    let strokeWidth = fallback($$props["strokeWidth"], 2);
    let customClass = fallback($$props["class"], "");
    if (size !== "100%") {
      size = size.slice(-1) === "x" ? size.slice(0, size.length - 1) + "em" : parseInt(size) + "px";
    }
    $$renderer2.push(`<svg xmlns="http://www.w3.org/2000/svg"${attr("width", size)}${attr("height", size)} fill="none" viewBox="0 0 24 24" stroke="currentColor"${attr("stroke-width", strokeWidth)} stroke-linecap="round" stroke-linejoin="round"${attr_class(`feather feather-percent ${stringify(customClass)}`)}><line x1="19" y1="5" x2="5" y2="19"></line><circle cx="6.5" cy="6.5" r="2.5"></circle><circle cx="17.5" cy="17.5" r="2.5"></circle></svg>`);
    bind_props($$props, { size, strokeWidth, class: customClass });
  });
}
function OrderSummery($$renderer) {
  Card($$renderer, {
    class: "order-summery p-sm-25 p-15 order-summery--width mt-lg-0 mt-20",
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        class: "border-bottom-0 p-0 pb-25",
        children: ($$renderer3) => {
          $$renderer3.push(`<h5 class="fw-500">Order Summary</h5>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        class: "px-sm-25 px-20",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="total"><div class="subtotalTotal">Subtotal: <span>$1,690.26</span></div> <div class="taxes">discount: <span>-$126.30</span></div> <div class="shipping">Shipping charge: <span>$46.30</span></div></div> <div class="select-coupon position-relative"><span class="percent">`);
          PercentIcon($$renderer3, {});
          $$renderer3.push(`<!----></span> <select name="sell-coupon" id="sell-coupon" class="form-control form-select border-0 px-1">`);
          $$renderer3.option({ value: "HROJSF" }, ($$renderer4) => {
            $$renderer4.push(`HROJSF`);
          });
          $$renderer3.option({ value: "RYZZWK" }, ($$renderer4) => {
            $$renderer4.push(`RYZZWK`);
          });
          $$renderer3.option({ value: "CLMVBG" }, ($$renderer4) => {
            $$renderer4.push(`CLMVBG`);
          });
          $$renderer3.option({ value: "RQAEAD" }, ($$renderer4) => {
            $$renderer4.push(`RQAEAD`);
          });
          $$renderer3.option({ value: "DFINSX" }, ($$renderer4) => {
            $$renderer4.push(`DFINSX`);
          });
          $$renderer3.push(`</select></div> <div class="promo-code"><form action="#"><label for="exampleInputEmail1">promo code</label> <div class="d-flex align-items-center"><input id="exampleInputEmail1" type="text" class="form-control"/> <a href="#" class="btn">apply</a></div></form></div> <div class="total-money d-flex justify-content-between"><h6>Total :</h6> <h5>$1738.60</h5></div> <a href="#" class="checkout btn-secondary content-center w-100 btn-lg mt-20">procdces to checkout <i class="las la-arrow-right"></i></a>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
}
function _page($$renderer) {
  const breadcrumbData = {
    pageTitle: "Product Cart",
    bcItem: "eCommerce",
    bcItemActive: "Product Cart"
  };
  $$renderer.push(`<div class="crm mb-25">`);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              BreadcrumbOne($$renderer4, spread_props([breadcrumbData]));
            },
            $$slots: { default: true }
          });
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----> `);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      $$renderer2.push(`<div class="cartPage global-shadow pe-sm-30 ps-sm-30 p-15 py-sm-30 radius-xl w-100 mb-30">`);
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            class: "cus-xl-9 mb-30",
            children: ($$renderer4) => {
              CartTable($$renderer4);
              $$renderer4.push(`<!----> <div class="product-cart__coupon"><input type="text" class="form-control col-xl-4 col-md-6" placeholder="Coupon code"/> <a href="#" class="btn btn-primary col-xl-3 col-lg-4 space-nowrap">Apply Coupon</a></div>`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            md: 12,
            class: "cus-xl-3",
            children: ($$renderer4) => {
              OrderSummery($$renderer4);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----></div>`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
export {
  _page as default
};
