import { ag as ensure_array_like, ac as attr, ae as stringify, aa as escape_html, a2 as head, af as spread_props } from "../../../../../chunks/index2.js";
import "clsx";
import { R as Row, a as Col, C as Container } from "../../../../../chunks/Row.js";
import "../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbOne } from "../../../../../chunks/BreadcrumbOne.js";
import { P as PaginationBasic } from "../../../../../chunks/PaginationBasic.js";
const courseData = [
  {
    id: 1,
    coverImg: "it1",
    title: "UI/UX Design Masters Course",
    authorImg: "ellipse1",
    authorName: "David Warner",
    price: "$250",
    totalLectureIcon: "book.svg",
    totalLecture: "35",
    totalHour: "15",
    totalHourIcon: "clock.svg"
  },
  {
    id: 2,
    coverImg: "it2",
    title: "React Development Course",
    authorImg: "ellipse2",
    authorName: "David Warner",
    price: "$30",
    totalLectureIcon: "book.svg",
    totalLecture: "35",
    totalHour: "5",
    totalHourIcon: "clock.svg"
  },
  {
    id: 3,
    coverImg: "it3",
    title: "Digital Marketing Course",
    authorImg: "ellipse3",
    authorName: "David Warner",
    price: "$550",
    totalLectureIcon: "book.svg",
    totalLecture: "35",
    totalHour: "50",
    totalHourIcon: "clock.svg"
  },
  {
    id: 4,
    coverImg: "it4",
    title: "Video Editing Basic Course",
    authorImg: "ellipse4",
    authorName: "David Warner",
    price: "$50",
    totalLectureIcon: "book.svg",
    totalLecture: "35",
    totalHour: "15",
    totalHourIcon: "clock.svg"
  },
  {
    id: 5,
    coverImg: "it5",
    title: "Basic Graphic Design Course",
    authorImg: "ellipse5",
    authorName: "David Warner",
    price: "$50",
    totalLectureIcon: "book.svg",
    totalLecture: "35",
    totalHour: "15",
    totalHourIcon: "clock.svg"
  },
  {
    id: 6,
    coverImg: "it6",
    title: "Advance User Experience Design",
    authorImg: "ellipse6",
    authorName: "David Warner",
    price: "$50",
    totalLectureIcon: "book.svg",
    totalLecture: "35",
    totalHour: "15",
    totalHourIcon: "clock.svg"
  },
  {
    id: 7,
    coverImg: "it7",
    title: "Video Editing Basic Course",
    authorImg: "ellipse7",
    authorName: "David Warner",
    price: "$50",
    totalLectureIcon: "book.svg",
    totalLecture: "35",
    totalHour: "15",
    totalHourIcon: "clock.svg"
  },
  {
    id: 8,
    coverImg: "it1",
    title: "UI/UX Design Masters Course",
    authorImg: "ellipse1",
    authorName: "David Warner",
    price: "$50",
    totalLectureIcon: "book.svg",
    totalLecture: "35",
    totalHour: "15",
    totalHourIcon: "clock.svg"
  },
  {
    id: 1,
    coverImg: "it1",
    title: "UI/UX Design Masters Course",
    authorImg: "ellipse1",
    authorName: "David Warner",
    price: "$250",
    totalLectureIcon: "book.svg",
    totalLecture: "35",
    totalHour: "15",
    totalHourIcon: "clock.svg"
  },
  {
    id: 2,
    coverImg: "it2",
    title: "React Development Course",
    authorImg: "ellipse2",
    authorName: "David Warner",
    price: "$30",
    totalLectureIcon: "book.svg",
    totalLecture: "35",
    totalHour: "5",
    totalHourIcon: "clock.svg"
  },
  {
    id: 3,
    coverImg: "it3",
    title: "Digital Marketing Course",
    authorImg: "ellipse3",
    authorName: "David Warner",
    price: "$550",
    totalLectureIcon: "book.svg",
    totalLecture: "35",
    totalHour: "50",
    totalHourIcon: "clock.svg"
  },
  {
    id: 4,
    coverImg: "it4",
    title: "Video Editing Basic Course",
    authorImg: "ellipse4",
    authorName: "David Warner",
    price: "$50",
    totalLectureIcon: "book.svg",
    totalLecture: "35",
    totalHour: "15",
    totalHourIcon: "clock.svg"
  }
];
function Course($$renderer) {
  Row($$renderer, {
    class: "mt-2",
    children: ($$renderer2) => {
      $$renderer2.push(`<!--[-->`);
      const each_array = ensure_array_like(courseData);
      for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
        let item = each_array[$$index];
        $$renderer2.push(`<div class="col-xxl-3 col-xl-4 col-sm-6 col-12 mb-25"><div class="course-card"><div class="course-card__img-area"><img class="big-img"${attr("src", `img/${stringify(item.coverImg)}.png`)}${attr("alt", item.coverImg)}/></div> <div class="course-card__body"><div class="course-card__title"><h4><a href="/course/details">${escape_html(item.title)}</a></h4></div> <div class="course-card__about"><img${attr("src", `img/${stringify(item.authorImg)}.png`)}${attr("alt", item.authorImg)}/> <span>${escape_html(item.authorName)}</span></div></div> <div class="course-card__footer"><div class="course-card__footer_left"><div class="total-money color-success">${escape_html(item.price)}</div></div> <div class="course-card__footer_right"><div class="total-lextures no-btn"><img class="svg" alt=""${attr("src", `/img/svg/${item.totalLectureIcon}`)}/> ${escape_html(item.totalLecture)} Lectures</div> <div class="total-hours no-btn"><img class="svg" alt=""${attr("src", `/img/svg/${item.totalHourIcon}`)}/> ${escape_html(item.totalHour)} Hrs</div></div></div></div></div>`);
      }
      $$renderer2.push(`<!--]-->`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----> `);
  Row($$renderer, {
    children: ($$renderer2) => {
      Col($$renderer2, {
        lg: 12,
        children: ($$renderer3) => {
          PaginationBasic($$renderer3, { pageDropdown: true });
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!---->`);
}
function _page($$renderer) {
  const breadcrumbData = { pageTitle: "Course", bcItem: "App", bcItemActive: "Course" };
  head("nh487k", $$renderer, ($$renderer2) => {
    $$renderer2.title(($$renderer3) => {
      $$renderer3.push(`<title>Course</title>`);
    });
  });
  $$renderer.push(`<div class="component-page mb-25">`);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              BreadcrumbOne($$renderer4, spread_props([breadcrumbData]));
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            xxl: 12,
            children: ($$renderer4) => {
              Course($$renderer4);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
export {
  _page as default
};
