import { ag as ensure_array_like, ac as attr, aa as escape_html, ad as attr_class, a8 as clsx, ae as stringify, a2 as head, af as spread_props } from "../../../../../../chunks/index2.js";
import "clsx";
import { C as Container, R as Row, a as Col } from "../../../../../../chunks/Row.js";
import "../../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbOne } from "../../../../../../chunks/BreadcrumbOne.js";
import { D as Dropdown, a as DropdownToggle, b as DropdownMenu } from "../../../../../../chunks/DropdownToggle.js";
import { c as contactData } from "../../../../../../chunks/contacts.js";
function List($$renderer) {
  $$renderer.push(`<div class="contact-list-wrap mb-25"><div class="contact-list radius-xl w-100"><div class="table-responsive table-responsive--dynamic"><table class="table mb-0 table-borderless table-rounded"><thead><tr><th><div class="d-flex align-items-center"><div class="custom-checkbox check-all"><input class="checkbox" type="checkbox" id="check-33"/> <label for="check-33"><span class="checkbox-text userDatatable-title">Name</span></label></div></div></th><th class="c-email"><span>email</span></th><th class="c-company"><span>company</span></th><th class="c-position"><span>position</span></th><th class="c-phone"><span>Phone</span></th><th class="c-action"><span class="float-end"></span></th></tr></thead><tbody><!--[-->`);
  const each_array = ensure_array_like(contactData);
  for (let i = 0, $$length = each_array.length; i < $$length; i++) {
    let contact = each_array[i];
    $$renderer.push(`<tr><td><div class="contact-item d-flex align-items-center"><div class="contact-personal-wrap"><div class="checkbox-group-wrapper"><div class="checkbox-group d-flex"><div class="checkbox-theme-default custom-checkbox checkbox-group__single d-flex"><input class="checkbox" type="checkbox"${attr("id", `check-grp-c-${stringify(i)}`)}/> <label${attr("for", `check-grp-c-${stringify(i)}`)}></label></div></div></div></div> <div class="contact-personal-info d-flex"><a href="#"><img${attr("src", `/img/${contact.img}`)} alt="" class="profile-image rounded-circle d-block m-0 wh-38"/></a> <div class="contact_title"><h6><a href="#">${escape_html(contact.name)}</a></h6> <span class="location">${escape_html(contact.country)}</span></div></div></div></td><td><span class="email">${escape_html(contact.email)}</span></td><td><span class="com-name">${escape_html(contact.company)}</span></td><td><span class="position">${escape_html(contact.designation)}</span></td><td><span class="email">${escape_html(contact.phone)}</span></td><td><div class="table-actions"><a href="#"${attr_class(clsx(contact.favoirte ? "active" : ""))}><img class="svg" alt="" src="/img/svg/star.svg"/></a> `);
    Dropdown($$renderer, {
      class: "dropdown-click",
      children: ($$renderer2) => {
        DropdownToggle($$renderer2, {
          class: "btn-link border-0 p-0 bg-transparent",
          children: ($$renderer3) => {
            $$renderer3.push(`<img class="svg" alt="" src="/img/svg/more-vertical.svg"/>`);
          },
          $$slots: { default: true }
        });
        $$renderer2.push(`<!----> `);
        DropdownMenu($$renderer2, {
          class: "dropdown-default dropdown-menu--dynamic",
          children: ($$renderer3) => {
            $$renderer3.push(`<a class="dropdown-item" href="#">view</a> <a class="dropdown-item" href="#">edit</a> <a class="dropdown-item" href="#">delete</a>`);
          },
          $$slots: { default: true }
        });
        $$renderer2.push(`<!---->`);
      },
      $$slots: { default: true }
    });
    $$renderer.push(`<!----></div></td></tr>`);
  }
  $$renderer.push(`<!--]--></tbody></table></div></div></div>`);
}
function _page($$renderer) {
  const breadcrumbData = {
    pageTitle: "Contacts",
    bcItem: "Dashboard",
    bcItemActive: "Contacts"
  };
  head("18cx4wl", $$renderer, ($$renderer2) => {
    $$renderer2.title(($$renderer3) => {
      $$renderer3.push(`<title>User Cards</title>`);
    });
  });
  $$renderer.push(`<div class="component-page mb-25">`);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              BreadcrumbOne($$renderer4, spread_props([breadcrumbData]));
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          List($$renderer3);
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
export {
  _page as default
};
