import { ag as ensure_array_like, ac as attr, ae as stringify, aa as escape_html, a2 as head, af as spread_props } from "../../../../../../chunks/index2.js";
import "clsx";
import { a as Col, C as Container, R as Row } from "../../../../../../chunks/Row.js";
import "../../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbOne } from "../../../../../../chunks/BreadcrumbOne.js";
import { C as Card } from "../../../../../../chunks/Card.js";
import { C as CardBody } from "../../../../../../chunks/CardBody.js";
import { C as CardFooter } from "../../../../../../chunks/CardFooter.js";
import { C as CardExtra } from "../../../../../../chunks/CardExtra.js";
import { c as contactData } from "../../../../../../chunks/contacts.js";
function Grid($$renderer) {
  $$renderer.push(`<!--[-->`);
  const each_array = ensure_array_like(contactData);
  for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
    let contact = each_array[$$index];
    Col($$renderer, {
      xxl: 3,
      lg: 4,
      md: 6,
      class: "mb-25",
      children: ($$renderer2) => {
        Card($$renderer2, {
          class: "contact-card",
          children: ($$renderer3) => {
            CardBody($$renderer3, {
              class: "text-center pt-30 px-25 pb-0",
              children: ($$renderer4) => {
                $$renderer4.push(`<div class="card__more-action">`);
                CardExtra($$renderer4);
                $$renderer4.push(`<!----></div> <div class="contact-profile-card text-center"><div class="cp-img d-flex justify-content-center"><img class="cp-img__main"${attr("src", `/img/${stringify(contact.img)}`)} alt="ninjadash Contact"/></div> <div class="cp-info"><h6 class="cp-info__title">${escape_html(contact.name)}</h6> <span class="cp-info__designation">${escape_html(contact.designation)}</span></div></div> `);
                CardFooter($$renderer4, {
                  class: "mt-20 pt-20 pb-20 px-0 bg-transparent",
                  children: ($$renderer5) => {
                    $$renderer5.push(`<ul class="c-info-list"><li class="c-info-list__item d-flex"><div class="c-info-item-icon"><img class="svg" alt="" src="/img/svg/phone.svg"/></div> <p class="c-info-item-text">${escape_html(contact.phone)}</p></li> <li class="c-info-list__item d-flex"><div class="c-info-item-icon"><img class="svg" alt="" src="/img/svg/mail.svg"/></div> <p class="c-info-item-text">${escape_html(contact.email)}</p></li> <li class="c-info-list__item d-flex"><div class="c-info-item-icon"><img class="svg" alt="" src="/img/svg/map-pin.svg"/></div> <p class="c-info-item-text">${escape_html(contact.country)}</p></li></ul>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer4.push(`<!---->`);
              },
              $$slots: { default: true }
            });
          },
          $$slots: { default: true }
        });
      },
      $$slots: { default: true }
    });
  }
  $$renderer.push(`<!--]-->`);
}
function _page($$renderer) {
  const breadcrumbData = {
    pageTitle: "Contacts",
    bcItem: "Dashboard",
    bcItemActive: "Contacts"
  };
  head("13rur4x", $$renderer, ($$renderer2) => {
    $$renderer2.title(($$renderer3) => {
      $$renderer3.push(`<title>User Cards</title>`);
    });
  });
  $$renderer.push(`<div class="component-page mb-25">`);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              BreadcrumbOne($$renderer4, spread_props([breadcrumbData]));
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Grid($$renderer3);
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
export {
  _page as default
};
