import { ag as ensure_array_like, ac as attr, ae as stringify, aa as escape_html, a9 as bind_props, a1 as store_get, a3 as unsubscribe_stores, a2 as head, af as spread_props } from "../../../../../chunks/index2.js";
import "clsx";
import { B as Button } from "../../../../../chunks/Button.js";
import { C as Container, R as Row, a as Col } from "../../../../../chunks/Row.js";
import { F as Form } from "../../../../../chunks/Form.js";
import { I as Input } from "../../../../../chunks/Input.js";
import "../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbOne } from "../../../../../chunks/BreadcrumbOne.js";
import { w as writable } from "../../../../../chunks/index.js";
import { c as chatData } from "../../../../../chunks/chatData.js";
import moment from "moment";
import { S as SingleChat } from "../../../../../chunks/SingleChat.js";
const chatContent = writable(chatData);
function UserList($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let allUsers = $$props["allUsers"];
    $$renderer2.push(`<!--[-->`);
    const each_array = ensure_array_like(allUsers);
    for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
      let user = each_array[$$index];
      $$renderer2.push(`<li class="user-list-item"><a href="#" class="user-list-item__wrapper active"${attr("data-user", user.email || user.id)}><div class="avatar avatar-circle ms-0"><img${attr("src", `/img/${stringify(user.img)}`)} class="rounded-circle wh-46 d-flex bg-opacity-primary" alt="user-img"/> <div class="badge-direction-bottom"><span class="chat-badge-dot avatar-online"></span></div></div> <div class="users-list-body"><div class="users-list-body-title"><h6>${escape_html(user.userName || user.groupName)}</h6> <div class="text-limit"><p class="mb-0"><span class="text-truncate" style="max-width: 225px;">${escape_html(user.content[0].content.split(" ").slice(0, 5).join(" "))}...</span></p></div></div> <div class="last-chat-time unread"><small>${escape_html(moment(user.time).format("hh:mm A"))}</small> `);
      if (user.unread !== 0) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<div class="total-message mt-1 d-flex justify-content-end"><span class="badge badge-success">${escape_html(user.unread)}</span></div>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--></div></div></a></li>`);
    }
    $$renderer2.push(`<!--]-->`);
    bind_props($$props, { allUsers });
  });
}
function PrivateChat($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const privateChats = store_get($$store_subs ??= {}, "$chatContent", chatContent)[0].privateChat;
    let allUsers = privateChats;
    UserList($$renderer2, { allUsers });
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function GroupChat($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const groupChats = store_get($$store_subs ??= {}, "$chatContent", chatContent)[0].groupChat;
    let allUsers = groupChats;
    UserList($$renderer2, { allUsers });
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function AllContacts($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const privateChats = store_get($$store_subs ??= {}, "$chatContent", chatContent)[0].privateChat;
    let allUsers = privateChats;
    UserList($$renderer2, { allUsers });
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    store_get($$store_subs ??= {}, "$chatContent", chatContent)[0].privateChat;
    store_get($$store_subs ??= {}, "$chatContent", chatContent)[0].groupChat;
    const breadcrumbData = { pageTitle: "Chat", bcItem: "Apps", bcItemActive: "Chat" };
    const chatTabs = [PrivateChat, GroupChat, AllContacts];
    let activeTab = chatTabs.indexOf(PrivateChat);
    let activeUser = 0;
    let groupChat = false;
    let singleContent = chatData[0].privateChat[activeUser].content;
    let userNames = chatData[0].privateChat[activeUser].userName;
    head("10az8r7", $$renderer2, ($$renderer3) => {
      $$renderer3.title(($$renderer4) => {
        $$renderer4.push(`<title>Chat</title>`);
      });
    });
    $$renderer2.push(`<div class="component-page mb-25">`);
    Container($$renderer2, {
      fluid: true,
      children: ($$renderer3) => {
        Row($$renderer3, {
          children: ($$renderer4) => {
            Col($$renderer4, {
              lg: 12,
              children: ($$renderer5) => {
                BreadcrumbOne($$renderer5, spread_props([breadcrumbData]));
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Col($$renderer4, {
              lg: 12,
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="chat-area d-flex"><div class="mb-lg-0 mb-40 chat-sidebar"><div class="sidebar-group left-sidebar chat_sidebar"><div id="chat" class="left-sidebar-wrap radius-xl active"><div class="chat-wrapper py-25"><div class="search-header">`);
                Form($$renderer5, {
                  class: "d-flex align-items-center",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<img class="svg" alt="" src="/img/svg/search.svg"/> `);
                    Input($$renderer6, {
                      class: "form-control me-sm-2 border-0 box-shadow-none",
                      type: "search",
                      placeholder: "Search",
                      "aria-label": "Search"
                    });
                    $$renderer6.push(`<!---->`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----></div> <div class="search-tab"><ul class="nav ap-tab-main border-bottom text-capitalize chat-nav-js"><li class="nav-item me-0"><a href="#" class="active nav-link" data-type="private">private chat</a></li> <li class="nav-item me-0"><a class="nav-link" href="#" data-type="group">group chat <span class="total-message ms-1"><span class="badge badge-danger">5</span></span></a></li> <li class="nav-item me-0"><a class="nav-link" href="#" data-type="all">all contact</a></li></ul></div> <div class="search-body"><div>`);
                if (activeTab === chatTabs.indexOf(GroupChat)) {
                  $$renderer5.push("<!--[-->");
                  $$renderer5.push(`<div class="user-button-top">`);
                  Button($$renderer5, {
                    class: "border bg-normal color-gray rounded-pill content-center",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<img class="svg" alt="" src="/img/svg/edit.svg"/> create a new group`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----></div>`);
                } else {
                  $$renderer5.push("<!--[!-->");
                }
                $$renderer5.push(`<!--]--> `);
                if (activeTab === chatTabs.indexOf(AllContacts)) {
                  $$renderer5.push("<!--[-->");
                  $$renderer5.push(`<div class="user-button-top">`);
                  Button($$renderer5, {
                    class: "border bg-normal color-gray rounded-pill content-center",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<img class="svg" alt="" src="/img/svg/edit.svg"/> Add New Contact`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----></div>`);
                } else {
                  $$renderer5.push("<!--[!-->");
                }
                $$renderer5.push(`<!--]--> <ul class="user-list">`);
                $$renderer5.push("<!---->");
                chatTabs[activeTab]?.($$renderer5, {});
                $$renderer5.push(`<!----></ul></div></div></div></div></div></div> <div class="chat-content"><div class="chat"><div class="chat-body bg-white radius-xl">`);
                SingleChat($$renderer5, { singleContent, userNames, groupChat });
                $$renderer5.push(`<!----></div></div></div></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
