import { a2 as head, af as spread_props } from "../../../../../../chunks/index2.js";
import "clsx";
import { C as Container, R as Row, a as Col } from "../../../../../../chunks/Row.js";
import "../../../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import { B as BreadcrumbOne } from "../../../../../../chunks/BreadcrumbOne.js";
import { D as DatePicker } from "../../../../../../chunks/DatePicker.js";
import daygridPlugin from "@fullcalendar/daygrid";
import interactionPlugin from "@fullcalendar/interaction";
import timegridPlugin from "@fullcalendar/timegrid";
import { B as Button } from "../../../../../../chunks/Button.js";
import { F as Form } from "../../../../../../chunks/Form.js";
import { I as Input } from "../../../../../../chunks/Input.js";
import { L as Label } from "../../../../../../chunks/Label.js";
import { M as Modal, a as ModalBody } from "../../../../../../chunks/Modal.js";
import { M as ModalHeader } from "../../../../../../chunks/ModalHeader.js";
import { F as FullCalendar } from "../../../../../../chunks/FullCalendar.js";
function Uidate($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const dayNames = ["Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"];
    let options = {
      plugins: [daygridPlugin, timegridPlugin, interactionPlugin],
      initialView: "dayGridMonth",
      selectable: true,
      dayNamesShort: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
      headerToolbar: { left: "prev", center: "title", right: "next" },
      height: "100%",
      weekends: true,
      showNonCurrentDates: false,
      contentHeight: "auto",
      dateClick: (info) => {
        let daySiblings = info.dayEl.closest("tbody").querySelectorAll(".fc-daygrid-day");
        daySiblings.forEach((el) => {
          el.classList.remove("fc-day_selected");
        });
        info.dayEl.classList.add("fc-day_selected");
      },
      dayHeaderContent(arg) {
        return dayNames[arg.date.getDay()];
      }
    };
    FullCalendar($$renderer2, { options, class: "date-picker__calendar" });
  });
}
function CalendarDay($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const dayNames = [
      "Sunday",
      "Monday",
      "Tuesday",
      "Wednesday",
      "Tuesday",
      "Friday",
      "Saturday"
    ];
    let options = {
      droppable: true,
      editable: true,
      initialView: "timeGridDay",
      selectable: true,
      plugins: [daygridPlugin, timegridPlugin, interactionPlugin],
      headerToolbar: {
        left: "today prev,title,next",
        right: "timeGridDay,timeGridWeek,dayGridMonth"
      },
      weekends: true,
      showNonCurrentDates: false,
      dateClick: (info) => {
        let daySiblings = info.dayEl.closest("tbody").querySelectorAll(".fc-daygrid-day");
        daySiblings.forEach((el) => {
          el.classList.remove("fc-day_selected");
        });
        info.dayEl.classList.add("fc-day_selected");
      },
      dayHeaderContent(arg) {
        return dayNames[arg.date.getDay()];
      }
    };
    let open = false;
    const toggle = () => open = !open;
    $$renderer2.push(`<div class="row calendar-grid justify-content-center"><div class="col-xxl-3 col-xl-5 col-md-6 col-sm-8"><div class="dm-calendar-left">`);
    Button($$renderer2, {
      color: "primary",
      class: "btn-create-event",
      children: ($$renderer3) => {
        $$renderer3.push(`<i class="las la-plus fs-16"></i>Create New Event`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----> `);
    Modal($$renderer2, {
      isOpen: open,
      toggle,
      class: "c-event-modal ",
      children: ($$renderer3) => {
        ModalHeader($$renderer3, {
          toggle,
          children: ($$renderer4) => {
            $$renderer4.push(`<h6 class="modal-title fw-500" id="staticBackdropLabel">Create Event</h6>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        ModalBody($$renderer3, {
          children: ($$renderer4) => {
            Form($$renderer4, {
              class: "c-event-form",
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="e-form-row d-flex"><div class="e-form-row__left">`);
                Label($$renderer5, {
                  for: "name47",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->Title`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----></div> <div class="e-form-row__right">`);
                Input($$renderer5, {
                  type: "text",
                  id: "name47",
                  placeholder: "Weekly report meeting",
                  class: "form-control-md"
                });
                $$renderer5.push(`<!----></div></div> <div class="e-form-row d-flex"><div class="e-form-row__left">`);
                Label($$renderer5, {
                  class: "mb-15",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->Event type`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----></div> <div class="e-form-row__right"><div class="radio-horizontal-list d-flex"><div class="radio-theme-default custom-radio"><input class="radio" type="radio" name="radio-optional" value="0" id="radio-hl1"/> <label for="radio-hl1"><span class="radio-text">Event</span></label></div> <div class="radio-theme-default custom-radio"><input class="radio" type="radio" name="radio-optional" value="0" id="radio-hl2"/> <label for="radio-hl2"><span class="radio-text">Remainder</span></label></div> <div class="radio-theme-default custom-radio"><input class="radio" type="radio" name="radio-optional" value="0" id="radio-hl3"/> <label for="radio-hl3"><span class="radio-text">Task</span></label></div></div></div></div> <div class="e-form-row d-flex"><div class="e-form-row__left">`);
                Label($$renderer5, {
                  class: "mb-15",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->Start`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----></div> <div class="e-form-row__right"><div class="w-100 d-flex custom-date-ranger mb-0"><div class="input-container icon-left position-relative me-2">`);
                DatePicker($$renderer5, { format: "MMMM DD, YYYY" });
                $$renderer5.push(`<!----> <span class="input-icon icon-left"><img class="svg" src="/img/svg/chevron-right.svg" alt=""/></span></div> <div class="input-container icon-left position-relative"><span class="input-icon icon-left"><img class="svg" src="/img/svg/clock.svg" alt=""/></span> <input type="text" class="form-control form-control-md" name="s-time" placeholder="Select Time"/></div></div></div></div> <div class="e-form-row d-flex"><div class="e-form-row__left">`);
                Label($$renderer5, {
                  class: "mb-15",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->End`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----></div> <div class="e-form-row__right"><div class="w-100 d-flex custom-date-ranger mb-0"><div class="input-container icon-left position-relative me-2">`);
                DatePicker($$renderer5, { format: "MMMM DD, YYYY" });
                $$renderer5.push(`<!----> <span class="input-icon icon-left"><img class="svg" src="/img/svg/chevron-right.svg" alt=""/></span></div> <div class="input-container icon-left position-relative"><span class="input-icon icon-left"><img class="svg" src="/img/svg/clock.svg" alt=""/></span> <input type="text" class="form-control form-control-md" name="s-time" placeholder="Select Time"/></div></div></div></div> <div class="e-form-row d-flex"><div class="e-form-row__left">`);
                Label($$renderer5, {
                  for: "exampleFormControlTextarea1",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->Description`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----></div> <div class="e-form-row__right d-flex">`);
                Input($$renderer5, {
                  type: "textarea",
                  id: "exampleFormControlTextarea1",
                  rows: "3",
                  placeholder: "Add description"
                });
                $$renderer5.push(`<!----></div></div> <div class="button-group d-flex justify-content-end pt-25">`);
                Button($$renderer5, {
                  color: "light",
                  size: "default",
                  type: "button",
                  class: "btn-squared fs-15 fw-400 text-capitalize b-light btn-transparent-light",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->cancel`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                Button($$renderer5, {
                  color: "primary",
                  size: "default",
                  class: "fs-15 btn-squared text-capitalize",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->save`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----></div>`);
              },
              $$slots: { default: true }
            });
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----> <div class="card card-md mb-4"><div class="card-body px-10"><div class="date-picker"><div class="date-picker__calendar">`);
    Uidate($$renderer2);
    $$renderer2.push(`<!----></div></div></div></div> <div class="card card-md mb-4"><div class="card-body"><div class="draggable-events" id="draggable-events"><div class="draggable-events__top d-flex justify-content-between"><h6>My Calendars</h6> <a href="#"><img class="svg" src="/img/svg/plus.svg" alt=""/></a></div> <ul class="draggable-event-list"><li class="draggable-event-list__single d-flex align-items-center" data-class="primary"><span class="badge-dot badge-primary"></span> <span class="event-text">Family Events</span></li> <li class="draggable-event-list__single d-flex align-items-center" data-class="secondary"><span class="badge-dot badge-secondary"></span> <span class="event-text">Product Launch</span></li> <li class="draggable-event-list__single d-flex align-items-center" data-class="success"><span class="badge-dot badge-success"></span> <span class="event-text">Team Meeting</span></li> <li class="draggable-event-list__single d-flex align-items-center" data-class="primary"><span class="badge-dot badge-primary"></span> <span class="event-text">UI/UX Tasks</span></li> <li class="draggable-event-list__single d-flex align-items-center" data-class="warning"><span class="badge-dot badge-warning"></span> <span class="event-text">Project Update</span></li></ul></div></div></div></div></div> <div class="col-xxl-9 col-xl-7"><div class="card card-default card-md mb-4"><div class="card-body">`);
    FullCalendar($$renderer2, { options, class: "date-picker__calendar" });
    $$renderer2.push(`<!----></div></div></div></div>`);
  });
}
function _page($$renderer) {
  const breadcrumbData = { pageTitle: "Day", bcItem: "Apps", bcItemActive: "Day" };
  head("1x5si0y", $$renderer, ($$renderer2) => {
    $$renderer2.title(($$renderer3) => {
      $$renderer3.push(`<title>Calendar</title>`);
    });
  });
  $$renderer.push(`<div class="component-page mb-25">`);
  Container($$renderer, {
    fluid: true,
    children: ($$renderer2) => {
      Row($$renderer2, {
        children: ($$renderer3) => {
          Col($$renderer3, {
            lg: 12,
            children: ($$renderer4) => {
              BreadcrumbOne($$renderer4, spread_props([breadcrumbData]));
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Col($$renderer3, {
            children: ($$renderer4) => {
              CalendarDay($$renderer4);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div>`);
}
export {
  _page as default
};
