import { aa as escape_html, ab as store_mutate, a1 as store_get, ac as attr, a3 as unsubscribe_stores, a2 as head } from "../../../../chunks/index2.js";
import { c as createForm, D as DataService, C as Checkbox } from "../../../../chunks/dataService.js";
import { A as Alert } from "../../../../chunks/Alert.js";
import { B as Button } from "../../../../chunks/Button.js";
import { B as ButtonGroup } from "../../../../chunks/ButtonGroup.js";
import { C as Card } from "../../../../chunks/Card.js";
import { C as CardBody } from "../../../../chunks/CardBody.js";
import { C as CardHeader } from "../../../../chunks/CardHeader.js";
import { C as Container, R as Row, a as Col } from "../../../../chunks/Row.js";
import { F as FormGroup } from "../../../../chunks/FormGroup.js";
import { I as Input } from "../../../../chunks/Input.js";
import { L as Label } from "../../../../chunks/Label.js";
import "../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import * as yup from "yup";
function Signup($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let visible = true;
    let loader = false;
    let notification = {};
    const regiterSchema = yup.object().shape({
      fullname: yup.string().required(),
      username: yup.string().required(),
      email: yup.string().email().required(),
      password: yup.string().required().min(8)
    });
    const { form, errors } = createForm({
      validationSchema: regiterSchema,
      onSubmit: async (values) => {
        loader = true;
        await DataService.post("/register", values).then((response) => {
          if (response.data.errors) {
            notification = response.data;
          } else {
            notification = response;
          }
        }).catch((error) => {
          console.log(error);
        });
        loader = false;
        visible = true;
      }
    });
    const handleCheckBox = () => {
    };
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<main class="main-content"><div class="admin">`);
      Container($$renderer3, {
        fluid: true,
        children: ($$renderer4) => {
          Row($$renderer4, {
            class: "justify-content-center",
            children: ($$renderer5) => {
              Col($$renderer5, {
                xxl: 4,
                xl: 4,
                md: 6,
                sm: 8,
                children: ($$renderer6) => {
                  $$renderer6.push(`<div class="edit-profile"><div class="edit-profile__logos"><img class="svg" alt="" src="/img/logo-dark.svg"/></div> `);
                  Card($$renderer6, {
                    class: loader ? "border-0 ninjadash-loader-active" : "border-0",
                    children: ($$renderer7) => {
                      CardHeader($$renderer7, {
                        children: ($$renderer8) => {
                          $$renderer8.push(`<div class="edit-profile__title"><h6>Sign in HexaDash</h6></div>`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer7.push(`<!----> `);
                      CardBody($$renderer7, {
                        children: ($$renderer8) => {
                          if (notification.errors) {
                            $$renderer8.push("<!--[-->");
                            Alert($$renderer8, {
                              color: "danger",
                              isOpen: visible,
                              toggle: () => visible = false,
                              fade: false,
                              children: ($$renderer9) => {
                                $$renderer9.push(`<!---->${escape_html(notification.errors[Object.keys(notification.errors)[0]])}`);
                              },
                              $$slots: { default: true }
                            });
                          } else {
                            $$renderer8.push("<!--[!-->");
                          }
                          $$renderer8.push(`<!--]--> `);
                          if (notification.status === 200) {
                            $$renderer8.push("<!--[-->");
                            Alert($$renderer8, {
                              color: "success",
                              isOpen: visible,
                              toggle: () => visible = false,
                              fade: false,
                              children: ($$renderer9) => {
                                $$renderer9.push(`<!---->${escape_html(notification.data.success)}`);
                              },
                              $$slots: { default: true }
                            });
                          } else {
                            $$renderer8.push("<!--[!-->");
                          }
                          $$renderer8.push(`<!--]--> <form><div class="edit-profile__body"><div class="edit-profile__body">`);
                          FormGroup($$renderer8, {
                            class: "form-group mb-20",
                            children: ($$renderer9) => {
                              Label($$renderer9, {
                                for: "full-name",
                                children: ($$renderer10) => {
                                  $$renderer10.push(`<!---->name`);
                                },
                                $$slots: { default: true }
                              });
                              $$renderer9.push(`<!----> `);
                              Input($$renderer9, {
                                invalid: store_get($$store_subs ??= {}, "$errors", errors).fullname.length > 0,
                                type: "text",
                                class: "form-control",
                                id: "full-name",
                                name: "fullname",
                                placeholder: "Full Name",
                                get value() {
                                  return store_get($$store_subs ??= {}, "$form", form).name;
                                },
                                set value($$value) {
                                  store_mutate($$store_subs ??= {}, "$form", form, store_get($$store_subs ??= {}, "$form", form).name = $$value);
                                  $$settled = false;
                                }
                              });
                              $$renderer9.push(`<!----> `);
                              if (store_get($$store_subs ??= {}, "$errors", errors).fullname) {
                                $$renderer9.push("<!--[-->");
                                $$renderer9.push(`<div class="invalid-feedback">${escape_html(store_get($$store_subs ??= {}, "$errors", errors).fullname)}</div>`);
                              } else {
                                $$renderer9.push("<!--[!-->");
                              }
                              $$renderer9.push(`<!--]-->`);
                            },
                            $$slots: { default: true }
                          });
                          $$renderer8.push(`<!----> `);
                          FormGroup($$renderer8, {
                            class: "form-group mb-20",
                            children: ($$renderer9) => {
                              Label($$renderer9, {
                                for: "suer-name",
                                children: ($$renderer10) => {
                                  $$renderer10.push(`<!---->username`);
                                },
                                $$slots: { default: true }
                              });
                              $$renderer9.push(`<!----> `);
                              Input($$renderer9, {
                                invalid: store_get($$store_subs ??= {}, "$errors", errors).username.length > 0,
                                type: "text",
                                class: "form-control",
                                id: "username",
                                name: "username",
                                placeholder: "Username",
                                get value() {
                                  return store_get($$store_subs ??= {}, "$form", form).username;
                                },
                                set value($$value) {
                                  store_mutate($$store_subs ??= {}, "$form", form, store_get($$store_subs ??= {}, "$form", form).username = $$value);
                                  $$settled = false;
                                }
                              });
                              $$renderer9.push(`<!----> `);
                              if (store_get($$store_subs ??= {}, "$errors", errors).username) {
                                $$renderer9.push("<!--[-->");
                                $$renderer9.push(`<div class="invalid-feedback">${escape_html(store_get($$store_subs ??= {}, "$errors", errors).username)}</div>`);
                              } else {
                                $$renderer9.push("<!--[!-->");
                              }
                              $$renderer9.push(`<!--]-->`);
                            },
                            $$slots: { default: true }
                          });
                          $$renderer8.push(`<!----> `);
                          FormGroup($$renderer8, {
                            class: "form-group mb-20",
                            children: ($$renderer9) => {
                              Label($$renderer9, {
                                for: "user-email",
                                children: ($$renderer10) => {
                                  $$renderer10.push(`<!---->Email Adress`);
                                },
                                $$slots: { default: true }
                              });
                              $$renderer9.push(`<!----> `);
                              Input($$renderer9, {
                                invalid: store_get($$store_subs ??= {}, "$errors", errors).email.length > 0,
                                type: "text",
                                class: "form-control",
                                id: "user-email",
                                name: "email",
                                placeholder: "name@example.com",
                                get value() {
                                  return store_get($$store_subs ??= {}, "$form", form).email;
                                },
                                set value($$value) {
                                  store_mutate($$store_subs ??= {}, "$form", form, store_get($$store_subs ??= {}, "$form", form).email = $$value);
                                  $$settled = false;
                                }
                              });
                              $$renderer9.push(`<!----> `);
                              if (store_get($$store_subs ??= {}, "$errors", errors).email) {
                                $$renderer9.push("<!--[-->");
                                $$renderer9.push(`<div class="invalid-feedback">${escape_html(store_get($$store_subs ??= {}, "$errors", errors).email)}</div>`);
                              } else {
                                $$renderer9.push("<!--[!-->");
                              }
                              $$renderer9.push(`<!--]-->`);
                            },
                            $$slots: { default: true }
                          });
                          $$renderer8.push(`<!----> `);
                          FormGroup($$renderer8, {
                            class: "form-group mb-15",
                            children: ($$renderer9) => {
                              Label($$renderer9, {
                                for: "user-password",
                                children: ($$renderer10) => {
                                  $$renderer10.push(`<!---->password`);
                                },
                                $$slots: { default: true }
                              });
                              $$renderer9.push(`<!----> <div class="position-relative">`);
                              Input($$renderer9, {
                                invalid: store_get($$store_subs ??= {}, "$errors", errors).password.length > 0,
                                id: "user-password",
                                type: "password",
                                class: "form-control",
                                name: "password",
                                placeholder: "Password",
                                get value() {
                                  return store_get($$store_subs ??= {}, "$form", form).password;
                                },
                                set value($$value) {
                                  store_mutate($$store_subs ??= {}, "$form", form, store_get($$store_subs ??= {}, "$form", form).password = $$value);
                                  $$settled = false;
                                }
                              });
                              $$renderer9.push(`<!----> `);
                              if (store_get($$store_subs ??= {}, "$errors", errors).password) {
                                $$renderer9.push("<!--[-->");
                                $$renderer9.push(`<div class="invalid-feedback">${escape_html(store_get($$store_subs ??= {}, "$errors", errors).password)}</div>`);
                              } else {
                                $$renderer9.push("<!--[!-->");
                              }
                              $$renderer9.push(`<!--]--></div> <div class="admin-condition"><div class="checkbox-theme-default custom-checkbox">`);
                              Checkbox($$renderer9, {
                                type: "default",
                                id: "check-1",
                                onChange: handleCheckBox,
                                children: ($$renderer10) => {
                                  $$renderer10.push(`<!---->Creating an account means you’re okay with our <a href="#" class="color-primary">Terms of Service</a> and <a href="#" class="color-primary">Privacy Policy</a> my preference`);
                                },
                                $$slots: { default: true }
                              });
                              $$renderer9.push(`<!----></div></div> <div class="admin__button-group button-group d-flex pt-1 justify-content-md-start justify-content-center">`);
                              Button($$renderer9, {
                                color: "primary",
                                class: "w-100 btn-squared text-capitalize lh-normal px-50 signIn-createBtn ",
                                children: ($$renderer10) => {
                                  $$renderer10.push(`<!---->${escape_html(loader ? "Loading..." : "Create Account")}`);
                                },
                                $$slots: { default: true }
                              });
                              $$renderer9.push(`<!----></div>`);
                            },
                            $$slots: { default: true }
                          });
                          $$renderer8.push(`<!----></div></div></form>`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer7.push(`<!----> <div class="px-20"><p class="social-connector social-connector__admin text-center"><span>Or</span></p> `);
                      ButtonGroup($$renderer7, {
                        class: "d-flex align-items-center justify-content-center",
                        children: ($$renderer8) => {
                          $$renderer8.push(`<ul class="admin-socialBtn"><li>`);
                          Button($$renderer8, {
                            class: "text-dark google",
                            children: ($$renderer9) => {
                              $$renderer9.push(`<img class="svg" alt=""${attr("src", googleIcon)}/>`);
                            },
                            $$slots: { default: true }
                          });
                          $$renderer8.push(`<!----></li> <li>`);
                          Button($$renderer8, {
                            class: "radius-md wh-48 content-center facebook",
                            children: ($$renderer9) => {
                              $$renderer9.push(`<i class="uil uil-facebook-f"></i>`);
                            },
                            $$slots: { default: true }
                          });
                          $$renderer8.push(`<!----></li> <li>`);
                          Button($$renderer8, {
                            class: "radius-md wh-48 content-center twitter",
                            children: ($$renderer9) => {
                              $$renderer9.push(`<i class="uil uil-twitter"></i>`);
                            },
                            $$slots: { default: true }
                          });
                          $$renderer8.push(`<!----></li> <li>`);
                          Button($$renderer8, {
                            class: "radius-md wh-48 content-center github",
                            children: ($$renderer9) => {
                              $$renderer9.push(`<i class="uil uil-github"></i>`);
                            },
                            $$slots: { default: true }
                          });
                          $$renderer8.push(`<!----></li></ul>`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer7.push(`<!----></div> <div class="admin-bottom"><p class="mb-0">Don't have an account? <a href="/signin" class="color-primary">Sign In</a></p></div>`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer6.push(`<!----></div>`);
                },
                $$slots: { default: true }
              });
            },
            $$slots: { default: true }
          });
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----></div></main>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function _page($$renderer) {
  head("z5wozd", $$renderer, ($$renderer2) => {
    $$renderer2.title(($$renderer3) => {
      $$renderer3.push(`<title>Signup</title>`);
    });
  });
  $$renderer.push(`<section>`);
  Signup($$renderer);
  $$renderer.push(`<!----></section>`);
}
export {
  _page as default
};
