import { aa as escape_html, ab as store_mutate, a1 as store_get, ac as attr, a3 as unsubscribe_stores, a2 as head } from "../../../../chunks/index2.js";
import "clsx";
import "@sveltejs/kit/internal";
import "../../../../chunks/exports.js";
import "../../../../chunks/utils.js";
import "@sveltejs/kit/internal/server";
import "../../../../chunks/state.svelte.js";
import { c as createForm, C as Checkbox, D as DataService } from "../../../../chunks/dataService.js";
import { A as Alert } from "../../../../chunks/Alert.js";
import { B as Button } from "../../../../chunks/Button.js";
import { C as Card } from "../../../../chunks/Card.js";
import { C as CardBody } from "../../../../chunks/CardBody.js";
import { C as CardHeader } from "../../../../chunks/CardHeader.js";
import { C as Container, R as Row, a as Col } from "../../../../chunks/Row.js";
import { F as FormGroup } from "../../../../chunks/FormGroup.js";
import { I as Input } from "../../../../chunks/Input.js";
import { L as Label } from "../../../../chunks/Label.js";
import "../../../../chunks/Theme.svelte_svelte_type_style_lang.js";
import * as yup from "yup";
import { s as setItem } from "../../../../chunks/localStorageController.js";
function goto(url, opts = {}) {
  {
    throw new Error("Cannot call goto(...) on the server");
  }
}
function Signin($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const googleIcon = "/img/svg/google-Icon.svg";
    let visible = true;
    let loader = false;
    let notification = {};
    const loginSchema = yup.object().shape({
      email: yup.string().email().required(),
      password: yup.string().required()
    });
    const { form, errors } = createForm({
      initialValues: { email: "hexadash@dm.com", password: "12345678" },
      validationSchema: loginSchema,
      onSubmit: async (values) => {
        loader = true;
        await DataService.post("/login", values).then((response) => {
          console.log(response);
          if (response.data.errors) {
            console.log(response);
            notification = response.data;
          } else if (response.data.success) {
            setItem("user", response.data.data);
            setItem("loggedin", response.data.loggedin);
            setItem("access_token", response.data.data.token);
            goto();
          }
          loader = false;
        }).catch((error) => {
          console.log(error);
          setItem("user", "response.data.data");
          setItem("loggedin", true);
          setItem("access_token", "response.data.data.token");
          goto();
          loader = false;
        });
        visible = true;
      }
    });
    const handleCheckBox = () => {
    };
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<div class="main-content"><div class="admin">`);
      Container($$renderer3, {
        fluid: true,
        children: ($$renderer4) => {
          Row($$renderer4, {
            class: "justify-content-center",
            children: ($$renderer5) => {
              Col($$renderer5, {
                xxl: "4",
                md: "6",
                sm: "8",
                children: ($$renderer6) => {
                  $$renderer6.push(`<div class="edit-profile"><div class="edit-profile__logos"><img src="/img/logo-dark.svg" class="svg" alt=""/></div> `);
                  Card($$renderer6, {
                    class: "border-0",
                    children: ($$renderer7) => {
                      CardHeader($$renderer7, {
                        children: ($$renderer8) => {
                          $$renderer8.push(`<div class="edit-profile__title"><h6>Sign in HexaDash</h6></div>`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer7.push(`<!----> `);
                      CardBody($$renderer7, {
                        children: ($$renderer8) => {
                          if (notification.errors) {
                            $$renderer8.push("<!--[-->");
                            Alert($$renderer8, {
                              color: "danger",
                              isOpen: visible,
                              toggle: () => visible = false,
                              fade: false,
                              children: ($$renderer9) => {
                                $$renderer9.push(`<!---->${escape_html(notification.errors)}`);
                              },
                              $$slots: { default: true }
                            });
                          } else {
                            $$renderer8.push("<!--[!-->");
                          }
                          $$renderer8.push(`<!--]--> <form><div class="edit-profile__body">`);
                          FormGroup($$renderer8, {
                            class: "form-group mb-25",
                            children: ($$renderer9) => {
                              Label($$renderer9, {
                                for: "username",
                                children: ($$renderer10) => {
                                  $$renderer10.push(`<!---->Email Address`);
                                },
                                $$slots: { default: true }
                              });
                              $$renderer9.push(`<!----> `);
                              Input($$renderer9, {
                                invalid: store_get($$store_subs ??= {}, "$errors", errors).email.length > 0,
                                type: "email",
                                class: "form-control",
                                id: "email",
                                name: "email",
                                placeholder: "hexadash@dm.com",
                                get value() {
                                  return store_get($$store_subs ??= {}, "$form", form).email;
                                },
                                set value($$value) {
                                  store_mutate($$store_subs ??= {}, "$form", form, store_get($$store_subs ??= {}, "$form", form).email = $$value);
                                  $$settled = false;
                                }
                              });
                              $$renderer9.push(`<!----> `);
                              if (store_get($$store_subs ??= {}, "$errors", errors).email) {
                                $$renderer9.push("<!--[-->");
                                $$renderer9.push(`<div class="invalid-feedback">${escape_html(store_get($$store_subs ??= {}, "$errors", errors).email)}</div>`);
                              } else {
                                $$renderer9.push("<!--[!-->");
                              }
                              $$renderer9.push(`<!--]-->`);
                            },
                            $$slots: { default: true }
                          });
                          $$renderer8.push(`<!----> `);
                          FormGroup($$renderer8, {
                            class: "form-group mb-15",
                            children: ($$renderer9) => {
                              Label($$renderer9, {
                                for: "password",
                                children: ($$renderer10) => {
                                  $$renderer10.push(`<!---->password`);
                                },
                                $$slots: { default: true }
                              });
                              $$renderer9.push(`<!----> <div class="position-relative">`);
                              Input($$renderer9, {
                                invalid: store_get($$store_subs ??= {}, "$errors", errors).password.length > 0,
                                type: "password",
                                class: "form-control",
                                id: "password",
                                name: "password",
                                placeholder: "Password",
                                get value() {
                                  return store_get($$store_subs ??= {}, "$form", form).password;
                                },
                                set value($$value) {
                                  store_mutate($$store_subs ??= {}, "$form", form, store_get($$store_subs ??= {}, "$form", form).password = $$value);
                                  $$settled = false;
                                }
                              });
                              $$renderer9.push(`<!----> `);
                              if (store_get($$store_subs ??= {}, "$errors", errors).password) {
                                $$renderer9.push("<!--[-->");
                                $$renderer9.push(`<div class="invalid-feedback">${escape_html(store_get($$store_subs ??= {}, "$errors", errors).password)}</div>`);
                              } else {
                                $$renderer9.push("<!--[!-->");
                              }
                              $$renderer9.push(`<!--]--></div>`);
                            },
                            $$slots: { default: true }
                          });
                          $$renderer8.push(`<!----> <div class="admin-condition">`);
                          Checkbox($$renderer8, {
                            type: "default",
                            id: "check-1",
                            onChange: handleCheckBox,
                            children: ($$renderer9) => {
                              $$renderer9.push(`<!---->Keep Me Logged In`);
                            },
                            $$slots: { default: true }
                          });
                          $$renderer8.push(`<!----> <a href="/forgotPass">Forget password?</a></div> <div class="admin__button-group button-group d-flex pt-1 justify-content-md-start justify-content-center">`);
                          Button($$renderer8, {
                            type: "submit",
                            color: "primary",
                            class: "btn btn-primary btn-default w-100 btn-squared text-capitalize lh-normal px-50 signIn-createBtn ",
                            children: ($$renderer9) => {
                              $$renderer9.push(`<!---->${escape_html(loader ? "Loading..." : "sign in")}`);
                            },
                            $$slots: { default: true }
                          });
                          $$renderer8.push(`<!----></div></div></form>`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer7.push(`<!----> <div class="px-20"><p class="social-connector social-connector__admin text-center"><span>Or</span></p> <div class="button-group d-flex align-items-center justify-content-center"><ul class="admin-socialBtn"><li>`);
                      Button($$renderer7, {
                        class: "btn text-dark google",
                        children: ($$renderer8) => {
                          $$renderer8.push(`<img${attr("src", googleIcon)} class="svg" alt=""/>`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer7.push(`<!----></li> <li>`);
                      Button($$renderer7, {
                        class: " radius-md wh-48 content-center facebook",
                        children: ($$renderer8) => {
                          $$renderer8.push(`<i class="uil uil-facebook-f"></i>`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer7.push(`<!----></li> <li>`);
                      Button($$renderer7, {
                        class: "radius-md wh-48 content-center twitter",
                        children: ($$renderer8) => {
                          $$renderer8.push(`<i class="uil uil-twitter"></i>`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer7.push(`<!----></li> <li>`);
                      Button($$renderer7, {
                        class: "radius-md wh-48 content-center github",
                        children: ($$renderer8) => {
                          $$renderer8.push(`<i class="uil uil-github"></i>`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer7.push(`<!----></li></ul></div></div> <div class="admin-bottom"><p class="mb-0">Don't have an account? <a href="/signup" class="color-primary">Sign up</a></p></div>`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer6.push(`<!----></div>`);
                },
                $$slots: { default: true }
              });
            },
            $$slots: { default: true }
          });
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----></div></div>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function _page($$renderer) {
  head("qlq18b", $$renderer, ($$renderer2) => {
    $$renderer2.title(($$renderer3) => {
      $$renderer3.push(`<title>Signin</title>`);
    });
  });
  $$renderer.push(`<section>`);
  Signin($$renderer);
  $$renderer.push(`<!----></section>`);
}
export {
  _page as default
};
