import { ag as ensure_array_like, ac as attr, ae as stringify, aa as escape_html, al as attr_style, a9 as bind_props } from "./index2.js";
function MarketingCampaigns($$renderer, $$props) {
  let dataPeriod = $$props["dataPeriod"];
  $$renderer.push(`<div class="selling-table-wrap selling-table-wrap--2 table-responsive svelte-1cw164d"><table class="table-borderless w-100 svelte-1cw164d"><tbody class="svelte-1cw164d"><!--[-->`);
  const each_array = ensure_array_like(dataPeriod);
  for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
    let data = each_array[$$index];
    $$renderer.push(`<tr class="svelte-1cw164d"><td class="svelte-1cw164d"><div class="selling-product-img selling-product-img--2 d-flex align-items-center svelte-1cw164d"><img class="radius-xs img-fluid svelte-1cw164d"${attr("src", `/img/browser/${stringify(data.icon)}`)} alt="img"/> <span class="svelte-1cw164d">${escape_html(data.title)}</span></div></td><td class="svelte-1cw164d">$${escape_html(data.amount)}</td><td class="svelte-1cw164d">${escape_html(data.percent)}%</td><td class="svelte-1cw164d"><div class="progress-cicle-wrap svelte-1cw164d"${attr_style(`--data-percent:${stringify(data.percent)}%`)}><div class="progress-circle svelte-1cw164d"></div></div></td></tr>`);
  }
  $$renderer.push(`<!--]--></tbody></table></div>`);
  bind_props($$props, { dataPeriod });
}
const teamList = [
  {
    title: "Hoira More",
    avatar: "team01.png"
  },
  {
    title: "Mads Nikelsen",
    avatar: "team02.png"
  },
  {
    title: "Stephen Strange",
    avatar: "team03.png"
  },
  {
    title: "Mesta Fizz",
    avatar: "team04.png"
  },
  {
    title: "Adrein Nick",
    avatar: "team01.png"
  }
];
export {
  MarketingCampaigns as M,
  teamList as t
};
