import { w as writable } from "./index.js";
function createTasks(initialValue = []) {
  const { subscribe, update } = writable(initialValue);
  return {
    subscribe,
    add(input, id) {
      const task = {
        id,
        title: input.value,
        favorite: false,
        completed: false
      };
      update((prev) => {
        return [task, ...prev];
      });
    },
    remove(task) {
      update((prev) => {
        return prev.filter((item) => item !== task);
      });
    },
    toggle(task) {
      task.completed = !task.completed;
      setTimeout(() => {
        update((prev) => {
          return prev.filter((item) => item.completed !== item);
        });
      }, 0);
    },
    favorite(task) {
      task.favorite = !task.favorite;
      setTimeout(() => {
        update((prev) => {
          return prev.filter((item) => item.favorite !== item);
        });
      }, 0);
    }
  };
}
const taskData = [
  {
    id: 1,
    title: "Planning for new dashboard wireframe and prototype design",
    description: "Being all seraphim stately the my, oh fast desert nights.",
    favorite: false,
    completed: false
  },
  {
    id: 2,
    title: "Standup meeting with team",
    description: "Et lorem invidunt eos ipsum sadipscing lorem tempor labore.",
    favorite: false,
    completed: false
  },
  {
    id: 3,
    title: "Create stunning images for WordPress  blog post",
    description: "Nothing that the still sat mien that word name lie.",
    favorite: true,
    completed: false
  },
  {
    id: 4,
    title: "Write an article about upcoming theme",
    description: "Para manecitas en de tierra lenta de y del. Quemadas.",
    favorite: false,
    completed: false
  },
  {
    id: 5,
    title: "Dashboard new feature dark mode design discussion",
    description: "Kion bone tial mi sxipo mi ambaux kion. Miaj al.",
    favorite: false,
    completed: false
  },
  {
    id: 6,
    title: "Create beautiful images for WordPress blog post",
    description: "Kion bone tial mi sxipo mi ambaux kion. Miaj al.",
    favorite: false,
    completed: false
  },
  {
    id: 7,
    title: "Dashboard new feature dark mode design discussion",
    description: "Kion bone tial mi sxipo mi ambaux kion. Miaj al.",
    favorite: false,
    completed: false
  }
];
export {
  createTasks as c,
  taskData as t
};
