import { aa as escape_html, ad as attr_class, a8 as clsx, ac as attr, a9 as bind_props, ae as stringify } from "./index2.js";
import "clsx";
import { S as Slider } from "./Slider.js";
import { I as Input } from "./Input.js";
import "./Theme.svelte_svelte_type_style_lang.js";
import { G as GridIcon, L as ListIcon } from "./ListIcon.js";
import { S as SearchIcon } from "./SearchIcon.js";
import { w as writable } from "./index.js";
function EcomerceSidebar($$renderer) {
  let range2 = [30, 90];
  let $$settled = true;
  let $$inner_renderer;
  function $$render_inner($$renderer2) {
    $$renderer2.push(`<aside class="dm-product-sidebar mb-lg-30"><div class="dm-product-sidebar__header"><h6 class="d-flex align-content-center fw-500">Filters</h6></div> <div class="dm-product-sidebar__content"><div class="dm-product-sidebar__widget mb-30"><div class="dm-product-sidebar__widget--title no-collapse"><h6>Price Range</h6></div> <div class="dm-product-sidebar__widget-card border-0 shadow-none mt-10"><div class="dm-product-price-ranges"><div class="custom-range-slider dm-price-range mb-0"><div class="section price">`);
    Slider($$renderer2, {
      max: "200",
      step: "10",
      range: true,
      order: true,
      get value() {
        return range2;
      },
      set value($$value) {
        range2 = $$value;
        $$settled = false;
      }
    });
    $$renderer2.push(`<!----> <p class="price-value"><span>${escape_html(range2[0])}</span> - <span>${escape_html(range2[1])}</span></p></div></div></div></div></div> <div class="dm-product-sidebar__widget mb-30"><div class="dm-product-sidebar__widget--title no-collapse"><h6>Category</h6></div> <div class="dm-product-sidebar__widget-card border-0 shadow-none mt-10"><ul class="product-category limit-list-item"><li><span class="fs-14 color-gray">Accessories</span> <span class="item-number">25</span></li> <li><span class="fs-14 color-gray">Appliances</span> <span class="item-number">25</span></li> <li><span class="fs-14 color-gray">Electronic</span> <span class="item-number">25</span></li> <li><span class="fs-14 color-gray">Entertainment</span> <span class="item-number">25</span></li> <li class="mt-2 more">See more</li></ul></div></div> <div class="dm-product-sidebar__widget mb-30"><div class="dm-product-sidebar__widget--title no-collapse"><h6>Brands</h6></div> <div class="dm-product-sidebar__widget-card border-0 shadow-none mt-10"><ul class="product-brands limit-list-item"><li><div class="checkbox-theme-default custom-checkbox">`);
    Input($$renderer2, {
      class: "checkbox",
      type: "checkbox",
      id: "check-1",
      label: "Cup"
    });
    $$renderer2.push(`<!----></div> <span class="item-numbers">25</span></li> <li><div class="checkbox-theme-default custom-checkbox">`);
    Input($$renderer2, {
      class: "checkbox",
      type: "checkbox",
      id: "check-2",
      label: "Plate"
    });
    $$renderer2.push(`<!----></div> <span class="item-numbers">25</span></li> <li><div class="checkbox-theme-default custom-checkbox">`);
    Input($$renderer2, {
      class: "checkbox",
      type: "checkbox",
      id: "check-3",
      label: "Coffee"
    });
    $$renderer2.push(`<!----></div> <span class="item-numbers">25</span></li> <li><div class="checkbox-theme-default custom-checkbox">`);
    Input($$renderer2, {
      class: "checkbox",
      type: "checkbox",
      id: "check-4",
      label: "Burger"
    });
    $$renderer2.push(`<!----></div> <span class="item-numbers">25</span></li> <li><div class="checkbox-theme-default custom-checkbox">`);
    Input($$renderer2, {
      class: "checkbox",
      type: "checkbox",
      id: "check-5",
      label: "Rice"
    });
    $$renderer2.push(`<!----></div> <span class="item-numbers">25</span></li> <li class="mt-2 more">See more</li></ul></div></div> <div class="dm-product-sidebar__widget"><div class="dm-product-sidebar__widget--title no-collapse"><h6>Ratings</h6></div> <div class="dm-product-sidebar__widget-card border-0 shadow-none mt-10"><ul class="product-ratings"><li><div class="checkbox-theme-default custom-checkbox"><input type="checkbox" class="checkbox" id="rating-1"/> <label for="rating-1"><span class="stars-rating d-flex align-items-center"><span class="star-icon las la-star active"></span> <span class="star-icon las la-star active"></span> <span class="star-icon las la-star active"></span> <span class="star-icon las la-star active"></span> <span class="star-icon las la-star active"></span> <span class="checkbox-text">and up <span class="item-numbers">42</span></span></span></label></div></li> <li><div class="checkbox-theme-default custom-checkbox"><input type="checkbox" class="checkbox" id="rating-2"/> <label for="rating-2"><span class="stars-rating d-flex align-items-center"><span class="star-icon las la-star active"></span> <span class="star-icon las la-star active"></span> <span class="star-icon las la-star active"></span> <span class="star-icon las la-star active"></span> <span class="star-icon las la-star active"></span> <span class="checkbox-text">and up <span class="item-numbers">12</span></span></span></label></div></li> <li><div class="checkbox-theme-default custom-checkbox"><input type="checkbox" class="checkbox" id="rating-3"/> <label for="rating-3"><span class="stars-rating d-flex align-items-center"><span class="star-icon las la-star active"></span> <span class="star-icon las la-star active"></span> <span class="star-icon las la-star active"></span> <span class="star-icon las la-star active"></span> <span class="star-icon las la-star active"></span> <span class="checkbox-text">and up <span class="item-numbers">20</span></span></span></label></div></li> <li><div class="checkbox-theme-default custom-checkbox"><input type="checkbox" class="checkbox" id="rating-4"/> <label for="rating-4"><span class="stars-rating d-flex align-items-center"><span class="star-icon las la-star active"></span> <span class="star-icon las la-star active"></span> <span class="star-icon las la-star active"></span> <span class="star-icon las la-star active"></span> <span class="star-icon las la-star active"></span> <span class="checkbox-text">and up <span class="item-numbers">42</span></span></span></label></div></li> <li><div class="checkbox-theme-default custom-checkbox"><input type="checkbox" class="checkbox" id="rating-5"/> <label for="rating-5"><span class="stars-rating d-flex align-items-center"><span class="star-icon las la-star active"></span> <span class="star-icon las la-star active"></span> <span class="star-icon las la-star active"></span> <span class="star-icon las la-star active"></span> <span class="star-icon las la-star active"></span> <span class="checkbox-text">and up <span class="item-numbers">35</span></span></span></label></div></li></ul></div></div></div></aside>`);
  }
  do {
    $$settled = true;
    $$inner_renderer = $$renderer.copy();
    $$render_inner($$inner_renderer);
  } while (!$$settled);
  $$renderer.subsume($$inner_renderer);
}
function ProductCard($$renderer, $$props) {
  let type = $$props["type"];
  let name = $$props["name"];
  let image = $$props["image"];
  let rating = $$props["rating"];
  $$renderer.push(`<div${attr_class(clsx(type === "card" ? "card product product--grid" : "card product product--list"))}>`);
  if (type === "card") {
    $$renderer.push("<!--[-->");
    $$renderer.push(`<div class="product-item"><div class="product-item__image"><span class="like-icon"><button class="content-center" type="button"><i class="lar la-heart icon"></i></button></span> <img class="card-img-top img-fluid"${attr("src", image)} alt="Digital Chair"/></div> <div class="card-body px-20 pb-25 pt-25"><div class="product-item__body text-capitalize"><a href="/job/job-details"><h6 class="card-title">${escape_html(name)}</h6></a> <div class="stars-rating d-flex align-items-center flex-wrap mb-10"><span class="star-icon las la-star active"></span> <span class="star-icon las la-star active"></span> <span class="star-icon las la-star active"></span> <span class="star-icon las la-star active"></span> <span class="star-icon las la-star-half-alt active"></span> <span class="stars-rating__point">${escape_html(rating)}</span> <span class="stars-rating__review"><span>778</span> Reviews</span></div></div> <div class="product-item__footer"><div class="d-flex align-items-center flex-wrap"><span class="product-desc-price">$2000.00</span> <span class="product-price">$100.00</span> <span class="product-discount">50% Off</span></div></div> <div class="product-item__button d-flex mt-20 flex-wrap"><button class="btn btn-default btn-squared color-light btn-outline-light px-20"><i class="las la-shopping-cart"></i> Add to Cart</button> <button class="btn btn-primary btn-default btn-squared border-0 px-20">buy now</button></div></div></div>`);
  } else {
    $$renderer.push("<!--[!-->");
    $$renderer.push(`<div class="product-item"><div class="product-item__image"><img class="card-img-top img-fluid"${attr("src", image)} alt="Digital Chair"/></div> <div class="product-item__body mt-xl-20 mt-0 position-relative"><span class="like-icon"><button type="button" class="content-center"><i class="lar la-heart icon"></i></button></span> <div class="product-item__title"><a href="/ecommerce/productDetails"><h6 class="card-title">${escape_html(name)}</h6></a> <p class="mb-0">Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor
							invidunt ut labore et dolore magna.</p></div> <div class="product-item__content text-capitalize"><div class="d-flex align-items-center flex-wrap"><span class="product-desc-price">$2000.00</span> <span class="product-price">$100.00</span> <span class="product-discount">50% Off</span></div> <div class="stars-rating d-flex align-items-center flex-wrap mb-10"><span class="star-icon las la-star active"></span> <span class="star-icon las la-star active"></span> <span class="star-icon las la-star active"></span> <span class="star-icon las la-star active"></span> <span class="star-icon las la-star-half-alt active"></span> <span class="stars-rating__point">${escape_html(rating)}</span> <span class="stars-rating__review"><span>778</span> Reviews</span></div> <div class="product-item__button d-flex mt-20 flex-wrap"><button class="btn btn-default btn-squared color-light btn-outline-light px-20"><i class="las la-shopping-cart"></i> Add to Cart</button> <button class="btn btn-primary btn-default btn-squared border-0 px-20">buy now</button></div></div></div></div>`);
  }
  $$renderer.push(`<!--]--></div>`);
  bind_props($$props, { type, name, image, rating });
}
function EcomerceToolBox($$renderer, $$props) {
  let cardType = $$props["cardType"];
  $$renderer.push(`<div class="shop_products_top_filter"><div class="project-top-wrapper d-flex flex-wrap align-items-center"><div class="project-top-left d-flex flex-wrap align-items-center"><div class="project-search shop-search global-shadow"><form action="/" class="d-flex align-items-center user-member__form">`);
  SearchIcon($$renderer, {});
  $$renderer.push(`<!----> <input type="text" class="form-control mr-sm-2 border-0 box-shadow-none" placeholder="Search" aria-label="Search"/></form></div> <span class="project-result-showing">Showing <span>1-8</span> of <span>86</span> results</span></div> <div class="project-top-right d-flex flex-wrap align-items-center"><div class="project-category flex-wrap d-flex align-items-center"><p class="fs-14 color-gray text-capitalize">sort by:</p> <div class="project-tab"><ul class="nav px-1"><li class="nav-item"><a href="#" class="nav-link acive">Top Rated</a></li> <li class="nav-item"><a href="#" class="nav-link">Popular</a></li> <li class="nav-item"><a href="#" class="nav-link">Newest</a></li> <li class="nav-item"><a href="#" class="nav-link">Price</a></li></ul></div></div> <div class="project-icon-selected content-center"><div class="listing-social-link"><div class="icon-list-social d-flex"><a href="/ecommerce/product-grid"${attr_class(`icon-list-social__link rounded-circle icon-list-social__style justify-content-center ${stringify(cardType === "card" ? "active" : "")}`)}>`);
  GridIcon($$renderer, {});
  $$renderer.push(`<!----></a> <a href="/ecommerce/product-list"${attr_class(`icon-list-social__link rounded-circle icon-list-social__style justify-content-center ${stringify(cardType === "list" ? "active" : "")}`)}>`);
  ListIcon($$renderer, {});
  $$renderer.push(`<!----></a></div></div></div></div></div></div>`);
  bind_props($$props, { cardType });
}
const products = [
  {
    id: 1,
    name: "Montes Scelerisque",
    rate: 5,
    time: 1586372610052,
    price: 250,
    oldPrice: 650,
    popular: 105,
    brand: "chair",
    category: "furniture",
    img: "/img/products/1.png",
    description: "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna."
  },
  {
    id: 2,
    name: "Leo Sodales Varius",
    rate: 4,
    time: 1586372643764,
    price: 320,
    oldPrice: 780,
    popular: false,
    brand: "chair",
    category: "furniture",
    img: "/img/products/2.png",
    description: "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna."
  },
  {
    id: 3,
    name: "Hanging Lamp Berlingo",
    rate: 4.5,
    time: 1586372866083,
    price: 150,
    oldPrice: false,
    brand: "chair",
    popular: 102,
    category: "furniture",
    img: "/img/products/3.png",
    description: "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna."
  },
  {
    id: 4,
    name: "Commodo Adipiscing",
    rate: 5,
    time: 1586372670340,
    price: 80,
    oldPrice: 120,
    popular: false,
    brand: "cup",
    category: "accessories",
    img: "/img/products/4.png",
    description: "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna."
  },
  {
    id: 5,
    name: "Leo Sodales Varius",
    rate: 4,
    time: 1586372885459,
    price: 220,
    oldPrice: 180,
    popular: false,
    brand: "chair",
    category: "furniture",
    img: "/img/products/5.png",
    description: "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna."
  },
  {
    id: 6,
    name: "Leo Sodales Varius",
    rate: 3,
    time: 1586372699556,
    price: 1010,
    oldPrice: false,
    popular: false,
    brand: "plate",
    category: "accessories",
    img: "/img/products/6.png",
    description: "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna."
  },
  {
    id: 7,
    name: "Hanging Lamp Berlingo",
    rate: 5,
    time: 1586372908316,
    price: 920,
    oldPrice: false,
    popular: false,
    brand: "chair",
    category: "furniture",
    img: "/img/products/7.png",
    description: "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna."
  },
  {
    id: 8,
    name: "Commodo Adipiscing",
    rate: 3,
    time: 1586372724883,
    price: 240,
    oldPrice: 650,
    popular: false,
    brand: "juice",
    category: "drinks",
    img: "/img/products/8.png",
    description: "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna."
  },
  {
    id: 9,
    name: "Montes Scelerisque",
    rate: 3,
    time: 1586372815027,
    price: 250,
    oldPrice: false,
    popular: false,
    brand: "chair",
    category: "furniture",
    img: "/img/products/9.png",
    description: "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna."
  },
  {
    id: 10,
    name: "Montes Scelerisque",
    rate: 4,
    time: 1586372815027,
    price: 90,
    oldPrice: 110,
    popular: false,
    brand: "chair",
    category: "furniture",
    img: "/img/products/10.png",
    description: "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna."
  },
  {
    id: 11,
    name: "Montes Scelerisque",
    rate: 4.5,
    time: 1586372791516,
    price: 1280,
    oldPrice: 1590,
    popular: false,
    brand: "juice",
    category: "drinks",
    img: "/img/products/11.png",
    description: "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna."
  },
  {
    id: 12,
    name: "Montes Scelerisque",
    rate: 3.5,
    time: 1586372754820,
    price: 450,
    oldPrice: false,
    popular: false,
    brand: "chair",
    category: "furniture",
    img: "/img/products/12.png",
    description: "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna."
  }
];
const allProducts = writable(products);
export {
  EcomerceSidebar as E,
  ProductCard as P,
  allProducts as a,
  EcomerceToolBox as b
};
